/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointFilterListener;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageFilterListener;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.AdaptorNonBlockingMessenger;
import net.jxta.impl.endpoint.CrossGroupMessenger;
import net.jxta.impl.endpoint.EndpointServiceInterface;
import net.jxta.impl.endpoint.MessengerPool;
import net.jxta.impl.endpoint.QuotaIncomingMessageListener;
import net.jxta.impl.endpoint.endpointMeter.EndpointMeter;
import net.jxta.impl.endpoint.endpointMeter.EndpointServiceMonitor;
import net.jxta.impl.endpoint.endpointMeter.InboundMeter;
import net.jxta.impl.endpoint.endpointMeter.OutboundMeter;
import net.jxta.impl.endpoint.endpointMeter.PropagationMeter;
import net.jxta.impl.endpoint.relay.RelayClient;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.util.FastHashMap;
import net.jxta.impl.util.SequenceIterator;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EndpointServiceImpl
implements EndpointService,
MessengerEventListener {
    EndpointServiceMonitor endpointServiceMonitor;
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$EndpointServiceImpl == null ? (class$net$jxta$impl$endpoint$EndpointServiceImpl = EndpointServiceImpl.class$("net.jxta.impl.endpoint.EndpointServiceImpl")) : class$net$jxta$impl$endpoint$EndpointServiceImpl).getName());
    public static final MimeMediaType DEFAULT_MESSAGE_TYPE = new MimeMediaType("application/x-jxta-msg");
    public static final String ENDPOINTSERVICE_NAME = "EndpointService";
    public static final String ENDPOINTSERVICE_PREFIX = "EndpointService:";
    public static final String MESSAGE_EMPTY_NS = "";
    public static final String MESSAGE_JXTA_NS = "jxta";
    public static final String MESSAGE_SOURCE_NS = "jxta";
    public static final String MESSAGE_SOURCE_NAME = "EndpointSourceAddress";
    public static final String MESSAGE_DESTINATION_NS = "jxta";
    public static final String MESSAGE_DESTINATION_NAME = "EndpointDestinationAddress";
    public static final String MESSAGE_SRCPEERHDR_NS = "jxta";
    public static final String MESSAGE_SRCPEERHDR_NAME = "EndpointHeaderSrcPeer";
    private static final int MAXSIMULASYNCMESSENGERWORKERS = 20;
    private volatile boolean initialized = false;
    private EndpointMeter endpointMeter;
    private PropagationMeter propagationMeter;
    private int vmQueueSize = 20;
    private int maxWorkerThreads = 20;
    private ModuleImplAdvertisement implAdv = null;
    private ID assignedID = null;
    private PeerGroup group = null;
    private String localPeerId = null;
    private EndpointService myInterface = null;
    private EndpointService parentEndpoint = null;
    private String myServiceName = null;
    private PeerGroup parentGroup = null;
    private ArrayList messageTransports = new ArrayList();
    private List[] passiveMessengerListeners = new List[]{new Vector(), new Vector(), new Vector()};
    private Map incomingMessageListeners = new FastHashMap(16);
    private MessengerPool messengerPool;
    private List incomingFilterListeners = new ArrayList();
    private List outgoingFilterListeners = new ArrayList();
    private UnbiasedQueue asyncMessengerNeedsWorkList = new UnbiasedQueue(Integer.MAX_VALUE, false);
    private List asyncMessengerWorkers = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$EndpointServiceImpl;

    public synchronized void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        block15: {
            if (this.initialized) {
                throw new PeerGroupException("Cannot initialize service more than once");
            }
            this.implAdv = (ModuleImplAdvertisement)impl;
            this.assignedID = assignedID;
            this.group = group;
            this.localPeerId = group.getPeerID().toString();
            this.myServiceName = ENDPOINTSERVICE_PREFIX + group.getPeerGroupID().getUniqueValue().toString();
            ConfigParams confAdv = group.getConfigAdvertisement();
            StructuredDocument paramBlock = null;
            if (confAdv != null) {
                paramBlock = confAdv.getServiceParam(assignedID);
            }
            if (paramBlock != null) {
                Enumeration param;
                block14: {
                    param = paramBlock.getChildren("MessengerQueueSize");
                    if (param.hasMoreElements()) {
                        String textQSz = ((TextElement)param.nextElement()).getTextValue();
                        try {
                            this.vmQueueSize = Integer.parseInt(textQSz);
                        }
                        catch (NumberFormatException e) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block14;
                            LOG.warn((Object)"could not parse MessengerQueueSize string", (Throwable)e);
                        }
                    }
                }
                if ((param = paramBlock.getChildren("MaxWorkerThreads")).hasMoreElements()) {
                    String textMWT = ((TextElement)param.nextElement()).getTextValue();
                    try {
                        this.maxWorkerThreads = Integer.parseInt(textMWT);
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block15;
                        LOG.warn((Object)"could not parse MaxWorkerThreads string", (Throwable)e);
                    }
                }
            }
        }
        this.asyncMessengerWorkers = new ArrayList(this.maxWorkerThreads);
        this.messengerPool = new EndpointMessengerPool(this);
        this.parentGroup = ((RefPeerGroup)group).getParentGroup();
        if (this.parentGroup != null) {
            this.parentEndpoint = this.parentGroup.getEndpointService();
            this.parentEndpoint.addIncomingMessageListener(new LocalReDemuxListener(), this.myServiceName, null);
            this.parentEndpoint.addMessengerEventListener(this, 0);
        }
        this.initialized = true;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Endpoint Service : " + assignedID);
            configInfo.append("\n\tImplementation :");
            configInfo.append("\n\t\tImpl Description : " + this.implAdv.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdv.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdv.getCode());
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            if (null == this.parentGroup) {
                configInfo.append("\n\t\tHome Group : (none)");
            } else {
                configInfo.append("\n\t\tHome Group : \"" + this.parentGroup.getPeerGroupName() + "\" / " + this.parentGroup.getPeerGroupID());
            }
            configInfo.append("\n\t\tVirtual Messenger Queue Size : " + this.vmQueueSize);
            configInfo.append("\n\t\tMax Worker Threads : " + this.maxWorkerThreads);
            if (group.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID)) {
                configInfo.append("\n\tQuota Incoming Message Params :");
                configInfo.append("\n\t\tMax message size : " + QuotaIncomingMessageListener.GmaxMsgSize);
                configInfo.append("\n\t\tMax message senders : " + QuotaIncomingMessageListener.GmaxSenders);
            }
            LOG.info((Object)configInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startApp(String[] args) {
        if (this.parentGroup != null) {
            Iterator parentMTs = this.parentEndpoint.getAllMessageTransports();
            EndpointServiceImpl endpointServiceImpl = this;
            synchronized (endpointServiceImpl) {
                while (parentMTs.hasNext()) {
                    this.addProtoToAdv((MessageTransport)parentMTs.next());
                }
            }
        }
        return 0;
    }

    public void stopApp() {
        if (this.parentEndpoint != null) {
            this.parentEndpoint.removeIncomingMessageListener(this.myServiceName, null);
            this.parentEndpoint.removeMessengerEventListener(this, 0);
        }
        if (this.messengerPool != null) {
            this.messengerPool.close();
            this.messengerPool = null;
        }
        int i = 0;
        while (i < 3) {
            List list = this.passiveMessengerListeners[i];
            if (list != null) {
                list.clear();
            }
            ++i;
        }
        if (this.incomingMessageListeners != null) {
            try {
                this.incomingMessageListeners.clear();
            }
            catch (Exception ez) {
                // empty catch block
            }
        }
        this.asyncMessengerNeedsWorkList.close();
        this.group = null;
        this.myInterface = null;
        this.parentEndpoint = null;
        this.parentGroup = null;
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public Service getInterface() {
        if (null == this.myInterface) {
            this.myInterface = new EndpointServiceInterface(this);
        }
        return this.myInterface;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdv;
    }

    public Message newMessage() {
        LOG.warn((Object)"Obsoleted, call through the interface object if you want to use this API");
        throw new UnsupportedOperationException("Obsoleted, call through the interface object if you want to use this API");
    }

    public EndpointAddress newEndpointAddress(String Uri) {
        LOG.warn((Object)"Obsoleted, call through the interface object if you want to use this API");
        throw new UnsupportedOperationException("Obsoleted, call through the interface object if you want to use this API");
    }

    public boolean setTransportControl(Object operation, Object Value2) {
        return false;
    }

    public Object getTransportControl(Object operation) {
        return null;
    }

    public void propagate(Message srcMsg, String serviceName, String serviceParam) throws IOException {
        long startPropagationTime = 0L;
        boolean numPropagatedTo = false;
        boolean numErrorsPropagated = false;
        boolean numFilteredOut = false;
        Message myMsg = (Message)srcMsg.clone();
        StringMessageElement srcHdrElement = new StringMessageElement(MESSAGE_SRCPEERHDR_NAME, this.localPeerId, (MessageElement)null);
        myMsg.replaceMessageElement("jxta", srcHdrElement);
        Iterator eachProto = this.getAllMessageTransports();
        while (eachProto.hasNext()) {
            try {
                MessageTransport aTransport = (MessageTransport)eachProto.next();
                if (!(aTransport instanceof MessageSender)) continue;
                MessageSender sender = (MessageSender)aTransport;
                Message m = this.processFilters(myMsg, sender.getPublicAddress(), new EndpointAddress(this.group.getPeerGroupID(), serviceName, serviceParam), false);
                if (m == null) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"   message discarded upon filter decision");
                    continue;
                }
                EndpointService itsEndpoint = sender.getEndpointService();
                String useServiceName = serviceName;
                String useServiceParam = serviceParam;
                if (itsEndpoint != this.getInterface()) {
                    useServiceName = this.myServiceName;
                    useServiceParam = serviceName + "/" + serviceParam;
                }
                m = (Message)m.clone();
                sender.propagate(m, useServiceName, useServiceParam, null);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)"Failed to send on endpoint protocol. ", (Throwable)e);
            }
        }
    }

    public void addListener(String address, EndpointListener listener) {
        boolean added = this.addIncomingMessageListener(listener, address, null);
        if (!added) {
            throw new IllegalArgumentException("listener already registered for address");
        }
    }

    public boolean removeListener(String address, EndpointListener listener) {
        return null != this.removeIncomingMessageListener(address, null);
    }

    public void addFilterListener(String name, EndpointFilterListener listener, boolean incoming) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Obsoleted, call through the interface object if you want to use this API");
    }

    public void removeFilterListener(String elementName, EndpointFilterListener listener, boolean incoming) {
        throw new UnsupportedOperationException("Obsoleted, call through the interface object if you want to use this API");
    }

    private Message processFilters(Message message, EndpointAddress srcAddress, EndpointAddress dstAddress, boolean incoming) {
        Iterator eachFilter = incoming ? this.incomingFilterListeners.iterator() : this.outgoingFilterListeners.iterator();
        while (eachFilter.hasNext()) {
            FilterListenerAndMask aFilter = (FilterListenerAndMask)eachFilter.next();
            Message.ElementIterator eachElement = message.getMessageElements();
            while (eachElement.hasNext()) {
                MessageElement anElement = (MessageElement)eachElement.next();
                if (null != aFilter.namespace && !aFilter.namespace.equals(eachElement.getNamespace()) || null != aFilter.name && !aFilter.name.equals(anElement.getElementName()) || null != (message = aFilter.listener.filterMessage(message, srcAddress, dstAddress))) continue;
                return null;
            }
        }
        return message;
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddress, EndpointAddress dstAddress) {
        block16: {
            EndpointListener h;
            MessageElement srcPeerElement = msg.getMessageElement("jxta", MESSAGE_SRCPEERHDR_NAME);
            if (null != srcPeerElement) {
                msg.removeMessageElement(srcPeerElement);
                String srcPeer = srcPeerElement.toString();
                if (this.localPeerId.equals(srcPeer)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("processIncomingMessage : " + msg.toString() + " is a propagate loopback. Discarded"));
                    }
                    return;
                }
            }
            Message origMessage = msg;
            String serviceName = dstAddress != null ? dstAddress.getServiceName() : null;
            if ((msg = this.processFilters(msg, srcAddress, dstAddress, true)) == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"demux : message discarded during filter processing");
                }
                return;
            }
            String serviceParam = dstAddress.getServiceParameter();
            if (null == serviceName || 0 == serviceName.length()) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("demux : dest serviceName must not be null, discarding message " + msg.toString()));
                }
                return;
            }
            String address = serviceName;
            if (null != serviceParam) {
                address = address + "/" + serviceParam;
            }
            if ((h = (EndpointListener)this.incomingMessageListeners.get(address)) == null) {
                address = serviceName;
                h = (EndpointListener)this.incomingMessageListeners.get(address);
            }
            if (h == null) {
                address = serviceName;
                if (null != serviceParam) {
                    address = address + serviceParam;
                }
                h = (EndpointListener)this.incomingMessageListeners.get(address);
            }
            if (h == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("demux: no listener for '" + address + "'"));
                }
                return;
            }
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("demux: calling listener '" + address + "' for " + msg.toString()));
                }
                long beginProcessing = 0L;
                h.processIncomingMessage(msg, srcAddress, dstAddress);
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block16;
                LOG.warn((Object)("demux : Uncaught throwable from listener for " + address), all);
            }
        }
    }

    public void demux(Message msg) {
        MessageElement dstAddressElement = msg.getMessageElement("jxta", MESSAGE_DESTINATION_NAME);
        if (null == dstAddressElement) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("demux : " + msg.toString() + " has no destination address. Discarded"));
            }
            return;
        }
        msg.removeMessageElement(dstAddressElement);
        EndpointAddress dstAddress = new EndpointAddress(dstAddressElement.toString());
        Object srcAddress = null;
        MessageElement srcAddressElement = msg.getMessageElement("jxta", MESSAGE_SOURCE_NAME);
        if (null == srcAddressElement) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("demux : " + msg.toString() + " has no source address. Discarded"));
            }
            return;
        }
        msg.removeMessageElement(srcAddressElement);
        EndpointAddress msgScrAddress = new EndpointAddress(srcAddressElement.toString());
        this.processIncomingMessage(msg, msgScrAddress, dstAddress);
    }

    public boolean ping(EndpointAddress addr) {
        Messenger m = this.messengerPool.snoop(addr);
        if (m != null) {
            return true;
        }
        m = this.messengerPool.get(addr, null);
        if (m != null) {
            this.messengerPool.release(m, m.getDestinationAddress());
            return true;
        }
        if (this.parentEndpoint == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("ping : Couldn't ping : '" + addr + "'"));
            }
            return false;
        }
        Iterator allTransports = this.parentEndpoint.getAllMessageTransports();
        while (allTransports.hasNext()) {
            MessageSender sender;
            EndpointService itsEndpoint;
            MessageTransport transpt = (MessageTransport)allTransports.next();
            if (!transpt.getProtocolName().equals(addr.getProtocolName()) || !(transpt instanceof MessageSender) || !(itsEndpoint = (sender = (MessageSender)transpt).getEndpointService()).ping(addr)) continue;
            return true;
        }
        if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("ping : Couldn't ping : '" + addr + "'"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessageTransport(MessageTransport transpt) {
        ArrayList arrayList = this.messageTransports;
        synchronized (arrayList) {
            if (!this.messageTransports.contains(transpt)) {
                this.clearProtoFromAdv(transpt);
                this.messageTransports.add(transpt);
                this.addProtoToAdv(transpt);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessageTransport(MessageTransport transpt) {
        boolean removed = false;
        ArrayList arrayList = this.messageTransports;
        synchronized (arrayList) {
            removed = this.messageTransports.remove(transpt);
        }
        if (removed) {
            this.clearProtoFromAdv(transpt);
        }
        return removed;
    }

    public Iterator getAllMessageTransports() {
        if (null != this.parentEndpoint) {
            return new SequenceIterator(this.getAllLocalTransports(), this.parentEndpoint.getAllMessageTransports());
        }
        return this.getAllLocalTransports();
    }

    public MessageTransport getMessageTransport(String name) {
        if (null != this.parentEndpoint) {
            SequenceIterator allTransports = new SequenceIterator(this.getAllLocalTransports(), this.parentEndpoint.getAllMessageTransports());
            while (allTransports.hasNext()) {
                MessageTransport transpt = (MessageTransport)allTransports.next();
                if (!transpt.getProtocolName().equals(name)) continue;
                return transpt;
            }
        } else {
            return null;
        }
        return null;
    }

    private void addProtoToAdv(MessageTransport proto) {
        block13: {
            boolean relay = false;
            try {
                if (!(proto instanceof MessageReceiver)) {
                    return;
                }
                if (proto instanceof EndpointRouter) {
                    this.addActiveRelayListener(this.group);
                    return;
                }
                if (proto instanceof RelayClient) {
                    relay = true;
                    ((RelayClient)proto).addActiveRelayListener(this.group);
                }
                PeerAdvertisement padv = this.group.getPeerAdvertisement();
                StructuredDocument myParam = padv.getServiceParam(this.assignedID);
                Iterator allAddresses = ((MessageReceiver)proto).getPublicAddresses();
                Vector<String> ea = new Vector<String>();
                while (allAddresses.hasNext()) {
                    EndpointAddress anEndpointAddress = (EndpointAddress)allAddresses.next();
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Adding endpoint address to route advertisement : " + anEndpointAddress));
                    }
                    ea.addElement(anEndpointAddress.toString());
                }
                RouteAdvertisement route = null;
                if (myParam == null) {
                    Vector hops;
                    AccessPointAdvertisement destAP = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
                    destAP.setEndpointAddresses(ea);
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                    route.setDest(destAP);
                    if (relay && (hops = ((RelayClient)proto).getActiveRelays(this.group)) != null) {
                        route.setHops(hops);
                    }
                } else {
                    Vector hops;
                    Enumeration paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType());
                    Element param = null;
                    if (paramChilds.hasMoreElements()) {
                        param = (Element)paramChilds.nextElement();
                    }
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
                    route.addDestEndpointAddresses(ea);
                    if (relay && (hops = ((RelayClient)proto).getActiveRelays(this.group)) != null) {
                        route.setHops(hops);
                    }
                }
                myParam = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredTextDocument xptDoc = (StructuredTextDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(myParam, myParam, xptDoc);
                padv.putServiceParam(this.assignedID, myParam);
                DiscoveryService discovery = this.group.getDiscoveryService();
                if (discovery != null) {
                    discovery.publish(padv, 0, 31536000000L, 0x6DDD00L);
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block13;
                LOG.warn((Object)"exception adding protocol transport ", (Throwable)ex);
            }
        }
    }

    private void clearProtoFromAdv(MessageTransport transpt) {
        block9: {
            try {
                PeerAdvertisement padv;
                StructuredDocument myParam;
                if (!(transpt instanceof MessageReceiver)) {
                    return;
                }
                if (transpt instanceof EndpointRouter) {
                    this.removeActiveRelayListener(this.group);
                    return;
                }
                if (transpt instanceof RelayClient) {
                    ((RelayClient)transpt).removeActiveRelayListener(this.group);
                }
                if ((myParam = (padv = this.group.getPeerAdvertisement()).getServiceParam(this.assignedID)) == null) {
                    return;
                }
                Enumeration paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType());
                Element param = null;
                if (paramChilds.hasMoreElements()) {
                    param = (Element)paramChilds.nextElement();
                }
                RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
                Iterator allAddresses = ((MessageReceiver)transpt).getPublicAddresses();
                Vector ea = new Vector();
                while (allAddresses.hasNext()) {
                    EndpointAddress anEndpointAddress = (EndpointAddress)allAddresses.next();
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)("Removing endpoint address from route advertisement : " + anEndpointAddress));
                }
                route.removeDestEndpointAddresses(ea);
                StructuredDocument newParam = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredTextDocument xptDoc = (StructuredTextDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(newParam, newParam, xptDoc);
                padv.putServiceParam(this.assignedID, newParam);
                DiscoveryService discovery = this.group.getDiscoveryService();
                if (discovery != null) {
                    discovery.publish(padv, 0, 31536000000L, 0x6DDD00L);
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block9;
                LOG.warn((Object)"exception removing protocol transport ", (Throwable)ex);
            }
        }
    }

    public boolean addMessengerEventListener(MessengerEventListener listener, int prio) {
        if (prio > 2) {
            prio = 2;
        }
        if (prio < 0) {
            prio = 0;
        }
        this.passiveMessengerListeners[prio].add(listener);
        return true;
    }

    public boolean removeMessengerEventListener(MessengerEventListener listener, int prio) {
        if (prio > 2) {
            prio = 2;
        }
        if (prio < 0) {
            prio = 0;
        }
        this.passiveMessengerListeners[prio].remove(listener);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIncomingMessageListener(EndpointListener listener, String serviceName, String serviceParam) {
        if (null == listener) {
            throw new IllegalArgumentException("EndpointListener must be non-null");
        }
        if (null == serviceName) {
            throw new IllegalArgumentException("serviceName must not be null");
        }
        if (-1 != serviceName.indexOf(47)) {
            throw new IllegalArgumentException("serviceName may not contain '/' characters");
        }
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        Map map = this.incomingMessageListeners;
        synchronized (map) {
            if (this.incomingMessageListeners.containsKey(address)) {
                return false;
            }
            InboundMeter incomingMessageListenerMeter = null;
            QuotaIncomingMessageListener quotaListener = new QuotaIncomingMessageListener(address, listener, incomingMessageListenerMeter);
            this.incomingMessageListeners.put(address, quotaListener);
        }
        if (null != this.parentEndpoint && serviceName.startsWith(ENDPOINTSERVICE_PREFIX)) {
            this.parentEndpoint.addIncomingMessageListener(listener, serviceName, serviceParam);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointListener removeIncomingMessageListener(String serviceName, String serviceParam) {
        if (null == serviceName) {
            throw new IllegalArgumentException("serviceName must not be null");
        }
        if (-1 != serviceName.indexOf(47)) {
            throw new IllegalArgumentException("serviceName may not contain '/' characters");
        }
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        QuotaIncomingMessageListener removedListener = null;
        EndpointListener result = null;
        Map map = this.incomingMessageListeners;
        synchronized (map) {
            removedListener = (QuotaIncomingMessageListener)this.incomingMessageListeners.remove(address);
            if (removedListener != null) {
                result = removedListener.getListener();
                removedListener.close();
            }
        }
        if (null != this.parentEndpoint && serviceName.startsWith(ENDPOINTSERVICE_PREFIX)) {
            this.parentEndpoint.removeIncomingMessageListener(serviceName, serviceParam);
        }
        return result;
    }

    public Messenger getMessenger(EndpointAddress addr) {
        return this.getMessenger(addr, null);
    }

    public Messenger getMessenger(EndpointAddress addr, Object hint) {
        int i = 4;
        long quitAt = TimeUtils.toAbsoluteTimeMillis(60000L);
        while (i-- > 0 && TimeUtils.toRelativeTimeMillis(quitAt) > 0L) {
            Messenger m = this.getMessengerQ(addr, hint, true);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public Messenger getMessengerQ(EndpointAddress addr, Object hint, boolean check) {
        if (addr == null) {
            throw new IllegalArgumentException("null endpoint address not allowed.");
        }
        Iterator localTransports = this.getAllLocalTransports();
        while (localTransports.hasNext()) {
            MessageTransport transpt = (MessageTransport)localTransports.next();
            if (!transpt.getProtocolName().equals(addr.getProtocolName()) || !(transpt instanceof MessageSender)) continue;
            EndpointAddress logDest = null;
            if (check) {
                Messenger m = this.messengerPool.snoop(addr);
                if (m == null) {
                    m = this.messengerPool.get(addr, hint);
                    if (m == null) {
                        return null;
                    }
                    hint = null;
                    this.messengerPool.release(m, m.getDestinationAddress());
                }
                logDest = m.getLogicalDestinationAddress();
            }
            OutboundMeter messengerMeter = null;
            return new VirtualMessenger(this, this.vmQueueSize, addr, logDest, hint, messengerMeter);
        }
        if (this.parentEndpoint == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("getMessenger : Couldn't create messenger for : '" + addr + "'"));
            }
            return null;
        }
        Iterator allTransports = this.parentEndpoint.getAllMessageTransports();
        while (allTransports.hasNext()) {
            Messenger result;
            MessageTransport transpt = (MessageTransport)allTransports.next();
            if (!transpt.getProtocolName().equals(addr.getProtocolName()) || !(transpt instanceof MessageSender)) continue;
            MessageSender sender = (MessageSender)transpt;
            EndpointServiceInterface itsEndpoint = (EndpointServiceInterface)sender.getEndpointService();
            String newServiceParam = addr.getServiceName();
            if (null != newServiceParam && null != addr.getServiceParameter()) {
                newServiceParam = newServiceParam + "/" + addr.getServiceParameter();
            }
            EndpointAddress addressToUse = new EndpointAddress(addr, this.myServiceName, newServiceParam);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getMessenger : Trying address '" + addressToUse + "' with : " + sender));
            }
            if (null == (result = itsEndpoint.getMessengerQ(addressToUse, hint, check))) continue;
            return new CrossGroupMessenger(result, null, addr.getServiceName(), addr.getServiceParameter());
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("getMessenger : Couldn't create messenger for : '" + addr + "'"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMessenger(MessengerEventListener listener, EndpointAddress addr, Object hint) {
        boolean queued = false;
        addr = (EndpointAddress)addr.clone();
        QueuedAsyncMessenger build = new QueuedAsyncMessenger(addr, hint, listener);
        try {
            queued = this.asyncMessengerNeedsWorkList.push(build, 1000L);
        }
        catch (InterruptedException woken) {
            Thread.interrupted();
        }
        if (queued) {
            List list = this.asyncMessengerWorkers;
            synchronized (list) {
                if (this.asyncMessengerWorkers.size() < this.maxWorkerThreads) {
                    AsyncMessengerWorker worker = new AsyncMessengerWorker();
                    this.asyncMessengerWorkers.add(worker);
                    Thread workerThread = new Thread(this.group.getHomeThreadGroup(), worker, "idle async messenger worker");
                    workerThread.setDaemon(true);
                    workerThread.start();
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("getMessenger : Starting new async messenger worker #" + this.asyncMessengerWorkers.size()));
                    }
                }
            }
        }
        return queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator getAllLocalTransports() {
        List<Object> transportList;
        ArrayList arrayList = this.messageTransports;
        synchronized (arrayList) {
            transportList = Arrays.asList(this.messageTransports.toArray());
        }
        return Collections.unmodifiableList(transportList).iterator();
    }

    protected Messenger getLocalTransportMessenger(EndpointAddress addr, Object hint) {
        Messenger result = null;
        Iterator localTransports = this.getAllLocalTransports();
        while (localTransports.hasNext()) {
            MessageTransport transpt = (MessageTransport)localTransports.next();
            if (!transpt.getProtocolName().equals(addr.getProtocolName()) || !(transpt instanceof MessageSender)) continue;
            MessageSender sender = (MessageSender)transpt;
            EndpointAddress addressToUse = (EndpointAddress)addr.clone();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getMessenger : Trying address '" + addressToUse + "' with : " + sender));
            }
            if (null != (result = sender.getMessenger(addressToUse, hint))) break;
        }
        if (result == null && LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("getMessenger : Couldn't create messenger for : '" + addr + "'"));
        }
        return result;
    }

    public synchronized void addIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        if (null == listener) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        FilterListenerAndMask aFilter = new FilterListenerAndMask(listener, namespace, name);
        this.incomingFilterListeners.add(aFilter);
    }

    public synchronized void addOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        if (null == listener) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        FilterListenerAndMask aFilter = new FilterListenerAndMask(listener, namespace, name);
        this.outgoingFilterListeners.add(aFilter);
    }

    public synchronized MessageFilterListener removeIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        Iterator eachListener = this.incomingFilterListeners.iterator();
        while (eachListener.hasNext()) {
            FilterListenerAndMask aFilter = (FilterListenerAndMask)eachListener.next();
            if (listener != aFilter.listener) continue;
            eachListener.remove();
            return listener;
        }
        return null;
    }

    public synchronized MessageFilterListener removeOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        Iterator eachListener = this.outgoingFilterListeners.iterator();
        while (eachListener.hasNext()) {
            FilterListenerAndMask aFilter = (FilterListenerAndMask)eachListener.next();
            if (listener != aFilter.listener || !(null != namespace ? namespace.equals(aFilter.namespace) : null == aFilter.namespace) || !(null != name ? name.equals(aFilter.name) : null == aFilter.name)) continue;
            eachListener.remove();
            return listener;
        }
        return null;
    }

    public boolean messengerReady(MessengerEvent event) {
        String cgServiceName;
        Messenger messenger;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("New messenger event for : " + event.getMessenger().getDestinationAddress()));
        }
        if (!(event.getSource() instanceof MessageTransport)) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"New messenger from non-transport. Ignored");
            }
            return false;
        }
        MessageTransport source = (MessageTransport)event.getSource();
        Messenger messengerForHere = messenger = event.getMessenger();
        EndpointAddress connAddr = event.getConnectionAddress();
        EndpointService itsEndpoint = source.getEndpointService();
        int HighestPrec = 2;
        int LowestPrec = 0;
        if (connAddr != null && (cgServiceName = connAddr.getServiceName()) != null && cgServiceName.startsWith(ENDPOINTSERVICE_PREFIX)) {
            if (!this.myServiceName.equals(cgServiceName)) {
                HighestPrec = 0;
            } else {
                LowestPrec = 1;
                String serviceParam = connAddr.getServiceParameter();
                String realService = null;
                String realParam = null;
                if (null != serviceParam) {
                    int slashAt = serviceParam.indexOf(47);
                    if (-1 == slashAt) {
                        realService = serviceParam;
                    } else {
                        realService = serviceParam.substring(0, slashAt);
                        realParam = serviceParam.substring(slashAt + 1);
                    }
                }
                connAddr.setServiceName(realService);
                connAddr.setServiceParameter(realParam);
            }
        }
        if (itsEndpoint != this.getInterface()) {
            messengerForHere = new CrossGroupMessenger(event.getMessenger(), this.myServiceName, null, null);
        }
        int prec = HighestPrec + 1;
        while (prec-- > LowestPrec) {
            List l = this.passiveMessengerListeners[prec];
            if (l == null) continue;
            Object[] allML = l.toArray();
            int i = allML.length;
            while (i-- > 0) {
                MessengerEventListener listener = (MessengerEventListener)allML[i];
                try {
                    if (!listener.messengerReady(new MessengerEvent(source, prec == 0 ? messenger : messengerForHere, connAddr))) continue;
                    return true;
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                    LOG.error((Object)"Uncaught Throwable in listener", all);
                }
            }
        }
        return false;
    }

    public MessengerEventListener getMessengerEventListener() {
        return this;
    }

    private void addActiveRelayListener(PeerGroup listeningGroup) {
        PeerGroup parentGroup = ((RefPeerGroup)this.group).getParentGroup();
        while (parentGroup != null) {
            EndpointService parentEndpoint = parentGroup.getEndpointService();
            Iterator it = parentEndpoint.getAllMessageTransports();
            while (it.hasNext()) {
                MessageTransport mt = (MessageTransport)it.next();
                if (!(mt instanceof RelayClient)) continue;
                ((RelayClient)mt).addActiveRelayListener(listeningGroup);
                break;
            }
            parentGroup = ((RefPeerGroup)parentGroup).getParentGroup();
        }
    }

    private void removeActiveRelayListener(PeerGroup listeningGroup) {
        PeerGroup parentGroup = ((RefPeerGroup)this.group).getParentGroup();
        while (parentGroup != null) {
            EndpointService parentEndpoint = parentGroup.getEndpointService();
            Iterator it = parentEndpoint.getAllMessageTransports();
            while (it.hasNext()) {
                MessageTransport mt = (MessageTransport)it.next();
                if (!(mt instanceof RelayClient)) continue;
                ((RelayClient)mt).removeActiveRelayListener(listeningGroup);
                break;
            }
            parentGroup = ((RefPeerGroup)parentGroup).getParentGroup();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VirtualMessenger
    extends AdaptorNonBlockingMessenger {
        Object hint;
        EndpointServiceImpl theEndpoint;

        public VirtualMessenger(EndpointServiceImpl theEndpoint, int vmQueueSize, EndpointAddress destination, EndpointAddress logicalDestination, Object hint, OutboundMeter messengerMeter) {
            super(destination, logicalDestination, vmQueueSize, messengerMeter);
            this.hint = hint;
            this.theEndpoint = theEndpoint;
        }

        protected Messenger getWrapped() {
            Object theHint = this.hint;
            this.hint = null;
            return this.theEndpoint.messengerPool.get(this.getDestinationAddress(), theHint);
        }

        protected void releaseWrapped(Messenger m) {
            this.theEndpoint.messengerPool.release(m, m.getDestinationAddress());
        }
    }

    private static class EndpointMessengerPool
    extends MessengerPool {
        EndpointServiceImpl theEndpoint;

        public EndpointMessengerPool(EndpointServiceImpl theEndpoint) {
            this.theEndpoint = theEndpoint;
        }

        public Messenger makeMessenger(EndpointAddress addr, Object hint) {
            return this.theEndpoint.getLocalTransportMessenger(addr, hint);
        }
    }

    private class LocalReDemuxListener
    implements EndpointListener {
        public void processIncomingMessage(Message message, EndpointAddress source, EndpointAddress destination) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Moving message from '" + EndpointServiceImpl.this.parentGroup.getPeerGroupID() + "' to '" + EndpointServiceImpl.this.group.getPeerGroupID() + "' group"));
            }
            String serviceParam = destination.getServiceParameter();
            String realService = null;
            String realParam = null;
            if (null != serviceParam) {
                int slashAt = serviceParam.indexOf(47);
                if (-1 == slashAt) {
                    realService = serviceParam;
                } else {
                    realService = serviceParam.substring(0, slashAt);
                    realParam = serviceParam.substring(slashAt + 1);
                }
            }
            destination.setServiceName(realService);
            destination.setServiceParameter(realParam);
            EndpointServiceImpl.this.processIncomingMessage(message, source, destination);
        }
    }

    private static class FilterListenerAndMask {
        public String namespace;
        public String name;
        public MessageFilterListener listener;

        public FilterListenerAndMask(MessageFilterListener listener, String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
            this.listener = listener;
        }

        public boolean equals(Object target) {
            if (this == target) {
                return true;
            }
            if (null == target) {
                return false;
            }
            if (target instanceof FilterListenerAndMask) {
                boolean result;
                FilterListenerAndMask likeMe = (FilterListenerAndMask)target;
                boolean bl = null != this.namespace ? this.namespace.equals(likeMe.namespace) : (result = null == likeMe.namespace);
                boolean bl2 = (result &= null != this.name ? this.name.equals(likeMe.name) : null == likeMe.name) & this.listener == likeMe.listener;
            }
            return false;
        }
    }

    private class AsyncMessengerWorker
    implements Runnable {
        private AsyncMessengerWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object msngr;
            boolean forcingFail = false;
            QueuedAsyncMessenger build = null;
            try {
                while (true) {
                    try {
                        build = (QueuedAsyncMessenger)EndpointServiceImpl.this.asyncMessengerNeedsWorkList.pop(2000L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                        continue;
                    }
                    if (null == build) {
                        break;
                    }
                    msngr = null;
                    if (!EndpointServiceImpl.this.asyncMessengerNeedsWorkList.isClosed()) {
                        Thread.currentThread().setName("working on " + build);
                        msngr = EndpointServiceImpl.this.getMessengerQ(build.destination, build.hint, true);
                        Thread.currentThread().setName("idle async messenger worker");
                    } else {
                        forcingFail = true;
                    }
                    if (!forcingFail && null == msngr && build.retry() < 3) {
                        boolean pushed = EndpointServiceImpl.this.asyncMessengerNeedsWorkList.push(build, 1000L);
                        if (pushed) continue;
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Giving up early; cannot requeue.");
                        }
                        build.done(null);
                        continue;
                    }
                    build.done((Messenger)msngr);
                }
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Uncaught throwable on thread : " + Thread.currentThread().getName()), all);
                }
                if (build != null) {
                    build.done(null);
                }
            }
            finally {
                msngr = EndpointServiceImpl.this.asyncMessengerWorkers;
                synchronized (msngr) {
                    EndpointServiceImpl.this.asyncMessengerWorkers.remove(this);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Async messenger worker thread exiting " + Thread.currentThread().getName() + ". " + EndpointServiceImpl.this.asyncMessengerWorkers.size() + " workers remain"));
                    }
                }
            }
        }
    }

    private class QueuedAsyncMessenger {
        EndpointAddress destination;
        Object hint;
        MessengerEventListener listener;
        volatile int retry;
        long quitAt = TimeUtils.toAbsoluteTimeMillis(60000L);

        public QueuedAsyncMessenger(EndpointAddress dest, Object hint, MessengerEventListener callback) {
            this.destination = dest;
            this.hint = hint;
            this.listener = callback;
            this.retry = 0;
        }

        int retry() {
            if (TimeUtils.toRelativeTimeMillis(this.quitAt) < 0L) {
                return Integer.MAX_VALUE;
            }
            return ++this.retry;
        }

        void done(Messenger m) {
            block4: {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Notifying listener " + (this.listener == null ? "[none]" : this.listener.toString()) + " of messenger " + (m == null ? "[failed]" : m.toString())));
                }
                if (this.listener == null) {
                    return;
                }
                try {
                    this.listener.messengerReady(new MessengerEvent(EndpointServiceImpl.this.getInterface(), m, null));
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                    LOG.warn((Object)("Uncaught throwable from listener " + this.listener), all);
                }
            }
            this.listener = null;
        }

        public void finalize() {
            if (this.listener == null) {
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)("Finalizing with a listener that was never called:" + this.listener));
            }
            this.done(null);
        }

        public String toString() {
            return "(" + this.destination + "," + this.listener + "," + (this.quitAt - System.currentTimeMillis()) + "," + this.retry + ")";
        }
    }
}

