/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class IPUtils {
    private static final Logger LOG;
    static final String IPV4ANYADDRESS = "0.0.0.0";
    static final String IPV6ANYADDRESS = "::";
    static final String IPV4LOOPBACK = "127.0.0.1";
    static final String IPV6LOOPBACK = "::1";
    public static InetAddress ANYADDRESS;
    public static InetAddress ANYADDRESSV4;
    public static InetAddress ANYADDRESSV6;
    public static InetAddress LOOPBACK;
    public static InetAddress LOOPBACKV4;
    public static InetAddress LOOPBACKV6;
    private static boolean hasJDK14;
    private static Constructor M_InetSocketAddress;
    private static Method M_bind;
    private static Method M_connect;
    private static Method M_isLoopbackAddress;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$IPUtils;
    static /* synthetic */ Class class$java$net$InetAddress;
    static /* synthetic */ Class class$java$net$Socket;

    private IPUtils() {
    }

    public static Iterator getAllLocalAddresses() {
        try {
            if (!hasJDK14) {
                InetAddress[] allAddr = InetAddress.getAllByName(InetAddress.getLocalHost().getHostAddress());
                if (0 == allAddr.length || "true".equals(System.getProperty("net.jxta.impl.IPUtils.localOnly"))) {
                    return Collections.singletonList(LOOPBACK).iterator();
                }
                return Arrays.asList(allAddr).iterator();
            }
            ArrayList<InetAddress> allAddr = new ArrayList<InetAddress>();
            Class<?> networkInterface = Class.forName("java.net.NetworkInterface");
            Method getNetworkInterfaces = networkInterface.getMethod("getNetworkInterfaces", null);
            Method getInetAddresses = networkInterface.getMethod("getInetAddresses", null);
            Enumeration allInterfaces = (Enumeration)getNetworkInterfaces.invoke(null, null);
            while (allInterfaces.hasMoreElements()) {
                Object anInterface = allInterfaces.nextElement();
                Enumeration allIntfAddr = (Enumeration)getInetAddresses.invoke(anInterface, null);
                while (allIntfAddr.hasMoreElements()) {
                    InetAddress anAddr = (InetAddress)allIntfAddr.nextElement();
                    if (((Boolean)M_isLoopbackAddress.invoke((Object)anAddr, null)).booleanValue() || allAddr.contains(anAddr)) continue;
                    allAddr.add(anAddr);
                }
            }
            if (0 == allAddr.size() || "true".equals(System.getProperty("net.jxta.impl.IPUtils.localOnly"))) {
                return Collections.singletonList(LOOPBACK).iterator();
            }
            return allAddr.iterator();
        }
        catch (Throwable caught) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Could not get local address list", caught);
            }
            return Collections.singletonList(LOOPBACK).iterator();
        }
    }

    public static boolean has14() {
        return hasJDK14;
    }

    public static boolean isLoopbackAddress(InetAddress inet) {
        if (hasJDK14 && M_isLoopbackAddress != null) {
            try {
                return (Boolean)M_isLoopbackAddress.invoke((Object)inet, null);
            }
            catch (Exception iae) {
                // empty catch block
            }
        }
        return inet.equals(LOOPBACKV6) || inet.equals(LOOPBACKV4);
    }

    public static Socket connectToFrom(InetAddress inetAddress, int port, InetAddress usingInterface, int localPort, int timeout) throws IOException {
        block7: {
            if (hasJDK14 && M_connect != null) {
                try {
                    Object[] inetSockAddParams = new Object[2];
                    Object[] bindParams = new Object[1];
                    Object[] connectParams = new Object[2];
                    inetSockAddParams[0] = usingInterface;
                    inetSockAddParams[1] = new Integer(localPort);
                    bindParams[0] = M_InetSocketAddress.newInstance(inetSockAddParams);
                    inetSockAddParams[0] = inetAddress;
                    inetSockAddParams[1] = new Integer(port);
                    connectParams[0] = M_InetSocketAddress.newInstance(inetSockAddParams);
                    connectParams[1] = new Integer(timeout);
                    Socket socket = (Socket)(class$java$net$Socket == null ? (class$java$net$Socket = IPUtils.class$("java.net.Socket")) : class$java$net$Socket).newInstance();
                    M_bind.invoke((Object)socket, bindParams);
                    M_connect.invoke((Object)socket, connectParams);
                    return socket;
                }
                catch (InvocationTargetException ite) {
                    Throwable thematter = ite.getTargetException();
                    if (thematter instanceof RuntimeException) {
                        throw (RuntimeException)thematter;
                    }
                    if (thematter instanceof Error) {
                        throw (Error)thematter;
                    }
                    if (thematter instanceof IOException) {
                        throw (IOException)thematter;
                    }
                    throw new IOException("unknown socket error: " + thematter.getMessage());
                }
                catch (Exception other) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                    LOG.warn((Object)"Had to fall back on 1.3 behaviour ! ", (Throwable)other);
                }
            }
        }
        return new Socket(inetAddress, port, usingInterface, localPort);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$IPUtils == null ? (class$net$jxta$impl$endpoint$IPUtils = IPUtils.class$("net.jxta.impl.endpoint.IPUtils")) : class$net$jxta$impl$endpoint$IPUtils).getName());
                            hasJDK14 = false;
                            M_InetSocketAddress = null;
                            M_bind = null;
                            M_connect = null;
                            M_isLoopbackAddress = null;
                            try {
                                ANYADDRESSV4 = InetAddress.getByName(IPV4ANYADDRESS);
                            }
                            catch (Throwable ignored) {
                                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block13;
                                LOG.warn((Object)"failed to intialize ANYADDRESSV4. Not fatal");
                            }
                        }
                        try {
                            ANYADDRESSV6 = InetAddress.getByName(IPV6ANYADDRESS);
                        }
                        catch (Throwable ignored) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block14;
                            LOG.warn((Object)"failed to intialize IPV6ANYADDRESS. Not fatal");
                        }
                    }
                    ANYADDRESS = ANYADDRESSV4 == null ? ANYADDRESSV6 : ANYADDRESSV4;
                    try {
                        LOOPBACKV4 = InetAddress.getByName(IPV4LOOPBACK);
                    }
                    catch (Throwable ignored) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block15;
                        LOG.warn((Object)"failed to intialize IPV4LOOPBACK. Not fatal");
                    }
                }
                try {
                    LOOPBACKV6 = InetAddress.getByName(IPV4LOOPBACK);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block16;
                    LOG.warn((Object)"failed to intialize ANYADDRESSV4. Not fatal");
                }
            }
            LOOPBACK = LOOPBACKV4 == null ? LOOPBACKV6 : LOOPBACKV4;
            if (LOOPBACK == null || ANYADDRESS == null) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"failure initializing statics. Neither IPV4 nor IPV6 seem to work.");
                }
                throw new IllegalStateException("failure initializing statics. Neither IPV4 nor IPV6 seem to work.");
            }
            String javaspec = System.getProperty("java.specification.version");
            if (null == javaspec) {
                throw new IllegalStateException("failure initializing statics. Could not determine java version");
            }
            boolean bl = hasJDK14 = javaspec.compareTo("1.4") >= 0;
            if (!hasJDK14) break block17;
            try {
                Class<?> C_InetSocketAddress = Class.forName("java.net.InetSocketAddress");
                Class<?> C_SocketAddress = Class.forName("java.net.SocketAddress");
                Class[] inetSockAddProto = new Class[2];
                Class[] bindProto = new Class[1];
                Class[] connectProto = new Class[2];
                bindProto[0] = C_SocketAddress;
                connectProto[0] = C_SocketAddress;
                connectProto[1] = Integer.TYPE;
                inetSockAddProto[0] = class$java$net$InetAddress == null ? (class$java$net$InetAddress = IPUtils.class$("java.net.InetAddress")) : class$java$net$InetAddress;
                inetSockAddProto[1] = Integer.TYPE;
                M_InetSocketAddress = C_InetSocketAddress.getConstructor(inetSockAddProto);
                M_bind = (class$java$net$Socket == null ? (class$java$net$Socket = IPUtils.class$("java.net.Socket")) : class$java$net$Socket).getMethod("bind", bindProto);
                M_connect = (class$java$net$Socket == null ? (class$java$net$Socket = IPUtils.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", connectProto);
                M_isLoopbackAddress = (class$java$net$InetAddress == null ? (class$java$net$InetAddress = IPUtils.class$("java.net.InetAddress")) : class$java$net$InetAddress).getMethod("isLoopbackAddress", null);
            }
            catch (Throwable tooBad) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block17;
                LOG.warn((Object)"Will not take advantage of JDK1.4 socket.connect() method.", tooBad);
            }
        }
    }
}

