/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JxtaMessageMessageElement
extends MessageElement {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$JxtaMessageMessageElement == null ? (class$net$jxta$impl$endpoint$JxtaMessageMessageElement = JxtaMessageMessageElement.class$("net.jxta.impl.endpoint.JxtaMessageMessageElement")) : class$net$jxta$impl$endpoint$JxtaMessageMessageElement).getName());
    protected Message msg;
    protected transient WireFormatMessage serial;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$JxtaMessageMessageElement;

    public JxtaMessageMessageElement(String name, MimeMediaType type, Message msg, MessageElement sig) {
        super(name, type, sig);
        this.msg = msg;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof MessageElement) {
            if (!super.equals(target)) {
                return false;
            }
            if (target instanceof JxtaMessageMessageElement) {
                JxtaMessageMessageElement likeMe = (JxtaMessageMessageElement)target;
                return super.equals(likeMe) & this.msg.equals(likeMe.msg);
            }
            try {
                int its;
                int mine;
                MessageElement likeMe = (MessageElement)target;
                InputStream myStream = this.getStream();
                InputStream itsStream = likeMe.getStream();
                do {
                    if ((mine = myStream.read()) == (its = itsStream.read())) continue;
                    return false;
                } while (-1 != mine && -1 != its);
                return -1 == mine && -1 == its;
            }
            catch (IOException fatal) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"MessageElements could not be compared.", (Throwable)fatal);
                }
                throw new IllegalStateException("MessageElements could not be compared." + fatal);
            }
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode() * 6037 + this.msg.hashCode();
        return 0 != result ? result : 1;
    }

    public String toString() {
        throw new UnsupportedOperationException("Cannot Generate String for this message element type.");
    }

    public long getByteLength() {
        this.initSerial();
        return this.serial.getByteLength();
    }

    public byte[] getBytes(boolean copy) {
        this.initSerial();
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)this.serial.getByteLength());
        try {
            this.sendToStream(baos);
            baos.close();
        }
        catch (IOException failed) {
            throw new IllegalStateException("failed to generate byte stream");
        }
        return baos.toByteArray();
    }

    public InputStream getStream() throws IOException {
        this.initSerial();
        return this.serial.getStream();
    }

    public void sendToStream(OutputStream sendTo) throws IOException {
        this.initSerial();
        this.serial.sendToStream(sendTo);
    }

    public byte[] getBytes() {
        return this.getBytes(false);
    }

    public Message getMessage() {
        return this.msg;
    }

    private synchronized void initSerial() {
        if (null == this.serial) {
            this.serial = WireFormatMessageFactory.toWire(this.msg, this.type, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

