/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Messenger;
import net.jxta.impl.util.FastHashMap;
import net.jxta.impl.util.TimerThreadNamer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class MessengerPool {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$MessengerPool == null ? (class$net$jxta$impl$endpoint$MessengerPool = MessengerPool.class$("net.jxta.impl.endpoint.MessengerPool")) : class$net$jxta$impl$endpoint$MessengerPool).getName());
    private Map pooledMessengers = new FastHashMap(16);
    private Timer pooledMessengersTimer = new Timer(true);
    static /* synthetic */ Class class$net$jxta$impl$endpoint$MessengerPool;

    public MessengerPool() {
        this.pooledMessengersTimer.schedule((TimerTask)new TimerThreadNamer("MessengerPool Timer"), 0L);
        this.pooledMessengersTimer.schedule((TimerTask)new PooledMessengersGC(), 60000L, 60000L);
    }

    public void close() {
        if (this.pooledMessengersTimer != null) {
            this.pooledMessengersTimer.cancel();
            this.pooledMessengersTimer = null;
        }
    }

    public void finalize() {
        this.close();
    }

    public Set allDestinations() {
        return Collections.unmodifiableSet(this.pooledMessengers.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(Messenger m, EndpointAddress fulladdr, boolean isBusy) {
        if (m.isClosed()) {
            return 0;
        }
        EndpointAddress addr = new EndpointAddress(fulladdr, null, null);
        MessengersForDest forDest = null;
        Map map = this.pooledMessengers;
        synchronized (map) {
            forDest = (MessengersForDest)this.pooledMessengers.get(addr);
            if (forDest == null) {
                forDest = new MessengersForDest();
                this.pooledMessengers.put(addr, forDest);
            }
        }
        MessengersForDest messengersForDest = forDest;
        synchronized (messengersForDest) {
            int res = forDest.add(m, isBusy);
            if (res != 1) {
                return res;
            }
            forDest.notify();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Messenger m, EndpointAddress fulladdr) {
        EndpointAddress addr = new EndpointAddress(fulladdr, null, null);
        MessengersForDest forDest = null;
        forDest = (MessengersForDest)this.pooledMessengers.get(addr);
        if (forDest == null) {
            return;
        }
        MessengersForDest messengersForDest = forDest;
        synchronized (messengersForDest) {
            forDest.makeAvail(m);
            forDest.notify();
        }
    }

    public Messenger snoop(EndpointAddress fulladdr) {
        EndpointAddress addr = new EndpointAddress(fulladdr, null, null);
        MessengersForDest forDest = null;
        forDest = (MessengersForDest)this.pooledMessengers.get(addr);
        if (forDest == null) {
            return null;
        }
        return forDest.getOpen();
    }

    public boolean exists(EndpointAddress fulladdr) {
        EndpointAddress addr = new EndpointAddress(fulladdr, null, null);
        return this.pooledMessengers.get(addr) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messenger get(EndpointAddress fulladdr, Object hint) {
        MessengersForDest forDest = null;
        Messenger m = null;
        boolean messengersExist = false;
        boolean cannotCreate = false;
        EndpointAddress addr = new EndpointAddress(fulladdr, null, null);
        boolean bePatient = true;
        while (true) {
            if ((forDest = (MessengersForDest)this.pooledMessengers.get(addr)) != null) {
                MessengersForDest messengersForDest = forDest;
                synchronized (messengersForDest) {
                    m = forDest.getAvail();
                    if (m != null) {
                        return m;
                    }
                    boolean bl = messengersExist = forDest.getTotal() > 0;
                    if (messengersExist) {
                        if (bePatient) {
                            bePatient = false;
                            try {
                                forDest.wait(1000L);
                            }
                            catch (InterruptedException intr) {
                                Thread.interrupted();
                            }
                            continue;
                        }
                        if (!forDest.canAdd() || cannotCreate) {
                            try {
                                forDest.wait();
                            }
                            catch (InterruptedException intr) {
                                Thread.interrupted();
                            }
                            continue;
                        }
                    } else if (cannotCreate) {
                        break;
                    }
                }
            }
            messengersExist = false;
            if (cannotCreate) break;
            m = this.makeMessenger(addr, hint);
            if (m == null) {
                if (!messengersExist) break;
                cannotCreate = true;
                m = null;
                continue;
            }
            int res = this.add(m, addr, true);
            if (res == 1) {
                return m;
            }
            if (res == 0) {
                m.close();
            } else {
                cannotCreate = true;
            }
            m = null;
        }
        Map map = this.pooledMessengers;
        synchronized (map) {
            forDest = (MessengersForDest)this.pooledMessengers.get(addr);
            if (forDest != null) {
                MessengersForDest messengersForDest = forDest;
                synchronized (messengersForDest) {
                    if (forDest.getTotal() == 0) {
                        this.pooledMessengers.remove(addr);
                        forDest.notifyAll();
                    }
                }
            }
        }
        return null;
    }

    public abstract Messenger makeMessenger(EndpointAddress var1, Object var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PooledMessengersGC
    extends TimerTask {
        PooledMessengersGC() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                try {
                    LinkedList all = new LinkedList();
                    Map map = MessengerPool.this.pooledMessengers;
                    synchronized (map) {
                        Iterator i = MessengerPool.this.pooledMessengers.entrySet().iterator();
                        while (i.hasNext()) {
                            MessengersForDest forDest;
                            Map.Entry e = i.next();
                            MessengersForDest messengersForDest = forDest = (MessengersForDest)e.getValue();
                            synchronized (messengersForDest) {
                                all.addAll(forDest.gc());
                            }
                        }
                    }
                    Iterator each = all.iterator();
                    while (each.hasNext()) {
                        ((Messenger)each.next()).close();
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block10;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }

    static class MessengersForDest {
        static final int MaxNb = 3;
        Messenger[] all = new Messenger[3];
        boolean[] busy = new boolean[3];

        MessengersForDest() {
            int i = 0;
            while (i < 3) {
                this.busy[i] = true;
                ++i;
            }
        }

        boolean canAdd() {
            return this.getTotal() < 3;
        }

        List gc() {
            LinkedList<Messenger> removed = new LinkedList<Messenger>();
            int i = 0;
            while (i < 3) {
                if (this.all[i] != null && !this.busy[i] && this.all[i].isIdle()) {
                    removed.add(this.all[i]);
                    this.all[i] = null;
                    this.busy[i] = true;
                }
                ++i;
            }
            return removed;
        }

        int getTotal() {
            int total = 0;
            int i = 0;
            while (i < 3) {
                if (this.all[i] != null) {
                    if (this.all[i].isClosed()) {
                        this.all[i] = null;
                        this.busy[i] = true;
                    } else {
                        ++total;
                    }
                }
                ++i;
            }
            return total;
        }

        int add(Messenger m, boolean isBusy) {
            int free = 3;
            int i = 0;
            while (i < 3) {
                if (this.all[i] == m) {
                    if (isBusy && this.busy[i]) {
                        return -1;
                    }
                    this.busy[i] = isBusy;
                    return 1;
                }
                if (this.all[i] == null) {
                    free = i;
                } else if (this.all[i].isClosed()) {
                    this.all[i] = null;
                    this.busy[i] = true;
                    free = i;
                }
                ++i;
            }
            if (free < 3) {
                this.all[free] = m;
                this.busy[free] = isBusy;
                return 1;
            }
            return 0;
        }

        boolean remove(Messenger m) {
            int i = 0;
            while (i < 3) {
                if (this.all[i] == m) {
                    this.all[i] = null;
                    this.busy[i] = true;
                    return true;
                }
                ++i;
            }
            return false;
        }

        Messenger getAvail() {
            int i = 0;
            while (i < 3) {
                if (!this.busy[i]) {
                    if (!this.all[i].isClosed()) {
                        this.busy[i] = true;
                        return this.all[i];
                    }
                    this.all[i] = null;
                    this.busy[i] = true;
                }
                ++i;
            }
            return null;
        }

        Messenger getOpen() {
            int i = 0;
            while (i < 3) {
                Messenger holdIt = this.all[i];
                if (holdIt != null && !holdIt.isClosed()) {
                    return holdIt;
                }
                ++i;
            }
            return null;
        }

        boolean makeAvail(Messenger m) {
            int i = 0;
            while (i < 3) {
                if (this.all[i] == m) {
                    this.busy[i] = false;
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

