/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.impl.endpoint.BasicMessenger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class NonBlockingMessenger
extends BasicMessenger {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$NonBlockingMessenger == null ? (class$net$jxta$impl$endpoint$NonBlockingMessenger = NonBlockingMessenger.class$("net.jxta.impl.endpoint.NonBlockingMessenger")) : class$net$jxta$impl$endpoint$NonBlockingMessenger).getName());
    static /* synthetic */ Class class$net$jxta$impl$endpoint$NonBlockingMessenger;

    public NonBlockingMessenger(EndpointAddress dest) {
        super(dest);
    }

    public final boolean isSynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sendMessage(Message msg, String destService, String destServiceParam) throws IOException {
        LocalOutgoingMsgListener localListener = new LocalOutgoingMsgListener();
        this.sendMessage(msg, destService, destServiceParam, localListener);
        OutgoingMessageEvent event = null;
        LocalOutgoingMsgListener localOutgoingMsgListener = localListener;
        synchronized (localOutgoingMsgListener) {
            event = localListener.saveEvent;
        }
        if (null == event || !localListener.failed) {
            return true;
        }
        Throwable failure = event.getFailure();
        if (null == failure) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Message could not be queued for sending.");
            }
            return false;
        }
        if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"Message send failed due to", failure);
        }
        if (failure instanceof IOException) {
            throw (IOException)failure;
        }
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
        throw new UndeclaredThrowableException(failure);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalOutgoingMsgListener
    implements OutgoingMessageEventListener {
        volatile boolean failed = false;
        volatile OutgoingMessageEvent saveEvent = null;

        private LocalOutgoingMsgListener() {
        }

        public synchronized void messageSendFailed(OutgoingMessageEvent event) {
            this.saveEvent = event;
            this.failed = true;
        }

        public synchronized void messageSendSucceeded(OutgoingMessageEvent event) {
        }
    }
}

