/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.LinkedList;
import java.util.List;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.endpointMeter.InboundMeter;
import net.jxta.impl.util.Cache;
import net.jxta.impl.util.CacheEntry;
import net.jxta.impl.util.CacheEntryListener;
import net.jxta.impl.util.ResourceAccount;
import net.jxta.impl.util.ResourceDispatcher;
import net.jxta.impl.util.UnbiasedQueue;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class QuotaIncomingMessageListener
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$QuotaIncomingMessageListener == null ? (class$net$jxta$impl$endpoint$QuotaIncomingMessageListener = QuotaIncomingMessageListener.class$("net.jxta.impl.endpoint.QuotaIncomingMessageListener")) : class$net$jxta$impl$endpoint$QuotaIncomingMessageListener).getName());
    private static ResourceDispatcher threadDispatcher = new ResourceDispatcher(100L, 1L, 3L, 150L, 6L, 5L, true, "threadDispatcher");
    static int GmaxMsgSize = 20480;
    static int GmaxSenders = 150;
    static int GminResPerSender = 2 * GmaxMsgSize;
    static int GmaxResPerSender = 2 * GminResPerSender;
    static int TotalExtra = 2 * GmaxResPerSender * GmaxSenders;
    static int MaxExtraPerSender = 10 * GmaxResPerSender;
    static int NeverReserved = TotalExtra / 8;
    private static ResourceDispatcher messageDispatcher = new ResourceDispatcher(GmaxSenders, GminResPerSender, GmaxResPerSender, TotalExtra, MaxExtraPerSender, NeverReserved, false, "messageDispatcher");
    private static Cache allSources = new Cache(100L, new MyCacheListener());
    private UnbiasedQueue messageQueue = new UnbiasedQueue(Integer.MAX_VALUE, false, new LinkedList());
    private EndpointListener listener = null;
    private String name = null;
    private InboundMeter incomingMessageListenerMeter = null;
    private ResourceAccount myAccount = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$QuotaIncomingMessageListener;

    public QuotaIncomingMessageListener(EndpointListener listener) {
        this(listener.getClass().getName(), listener);
    }

    public QuotaIncomingMessageListener(String name, EndpointListener listener) {
        this(name, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuotaIncomingMessageListener(String name, EndpointListener listener, InboundMeter incomingMessageListenerMeter) {
        this.listener = listener;
        this.name = name;
        this.incomingMessageListenerMeter = incomingMessageListenerMeter;
        ResourceDispatcher resourceDispatcher = threadDispatcher;
        synchronized (resourceDispatcher) {
            this.myAccount = threadDispatcher.newAccount(1L, -1L, this);
            threadDispatcher.notify();
        }
        Thread.yield();
    }

    public String toString() {
        return this.name;
    }

    public EndpointListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LinkedList<MessageFromSource> rmdMessages = new LinkedList<MessageFromSource>();
        ResourceDispatcher resourceDispatcher = threadDispatcher;
        synchronized (resourceDispatcher) {
            this.messageQueue.close();
            if (this.myAccount.isIdle()) {
                this.myAccount.close();
            }
            MessageFromSource mfs = null;
            while ((mfs = (MessageFromSource)this.messageQueue.pop()) != null) {
                rmdMessages.add(mfs);
            }
            threadDispatcher.notify();
        }
        Thread.yield();
        ResourceDispatcher resourceDispatcher2 = messageDispatcher;
        synchronized (resourceDispatcher2) {
            while (!rmdMessages.isEmpty()) {
                MessageFromSource mfs = (MessageFromSource)rmdMessages.removeFirst();
                mfs.src.inNeed(false);
                mfs.src.releaseQuantity(mfs.size);
                if (!mfs.src.isIdle()) continue;
                allSources.stickyCacheEntry((CacheEntry)mfs.src.getUserObject(), false);
            }
            messageDispatcher.notify();
        }
        this.listener = null;
        Object var1_1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuotaIncomingMessageListener doOne() {
        ResourceAccount next;
        block15: {
            MessageFromSource mfs = null;
            ResourceDispatcher resourceDispatcher = threadDispatcher;
            synchronized (resourceDispatcher) {
                mfs = (MessageFromSource)this.messageQueue.pop();
                this.myAccount.inNeed(this.messageQueue.getCurrentInQueue() != 0);
                threadDispatcher.notify();
            }
            if (mfs != null) {
                ResourceDispatcher resourceDispatcher2 = messageDispatcher;
                synchronized (resourceDispatcher2) {
                    mfs.src.inNeed(false);
                    mfs.src.releaseQuantity(mfs.size);
                    if (mfs.src.isIdle()) {
                        allSources.stickyCacheEntry((CacheEntry)mfs.src.getUserObject(), false);
                    }
                    messageDispatcher.notify();
                }
                long timeDequeued = 0L;
                try {
                    this.listener.processIncomingMessage(mfs.msg, mfs.srcAddress, mfs.destAddress);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block15;
                    LOG.error((Object)("Uncaught Throwable in listener : " + this.name + "(" + this.listener.getClass().getName() + ")"), ignored);
                }
            }
        }
        ResourceDispatcher resourceDispatcher = threadDispatcher;
        synchronized (resourceDispatcher) {
            this.myAccount.inNeed(this.messageQueue.getCurrentInQueue() > 0);
            next = this.myAccount.releaseItem();
            if (this.messageQueue.isClosed() && this.myAccount.isIdle()) {
                this.myAccount.close();
            }
            threadDispatcher.notify();
        }
        if (next == null) {
            return null;
        }
        return (QuotaIncomingMessageListener)next.getUserObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        ResourceAccount msgSrcAccount;
        if (this.messageQueue.isClosed()) {
            return;
        }
        long timeReceived = 0L;
        String srcAddrStr = srcAddr.toString();
        CacheEntry ce = null;
        long msgSize = message.getByteLength();
        ResourceDispatcher resourceDispatcher = messageDispatcher;
        synchronized (resourceDispatcher) {
            ce = allSources.getCacheEntry(srcAddrStr);
            if (ce == null) {
                msgSrcAccount = messageDispatcher.newAccount(40960L, -1L, srcAddrStr);
                if (msgSrcAccount.getNbReserved() < 1L) {
                    msgSrcAccount.close();
                    allSources.purge(10);
                    msgSrcAccount = messageDispatcher.newAccount(40960L, -1L, "retrying:" + srcAddrStr);
                }
                allSources.put(srcAddrStr, msgSrcAccount);
                ce = allSources.getCacheEntry(srcAddrStr);
                msgSrcAccount.setUserObject(ce);
            } else {
                msgSrcAccount = (ResourceAccount)ce.getValue();
            }
            if (!msgSrcAccount.obtainQuantity(msgSize)) {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"Peer exceeds queuing limits; msg discarded.");
                }
                messageDispatcher.notify();
                return;
            }
            allSources.stickyCacheEntry(ce, true);
            messageDispatcher.notify();
        }
        boolean obtained = false;
        boolean pushed = false;
        ResourceDispatcher resourceDispatcher2 = threadDispatcher;
        synchronized (resourceDispatcher2) {
            int queueLen;
            do {
                if ((pushed = this.messageQueue.push(new MessageFromSource(message, srcAddr, dstAddr, msgSrcAccount, timeReceived, msgSize))) || !this.messageQueue.isClosed()) continue;
                if (!LOG.isEnabledFor((Priority)Level.INFO)) break;
                LOG.info((Object)"queue closed, message discarded");
                break;
            } while (!pushed);
            if (LOG.isEnabledFor((Priority)Level.WARN) && (queueLen = this.messageQueue.getCurrentInQueue()) > 100) {
                LOG.warn((Object)("Very long queue (" + queueLen + ") for listener: " + this));
            }
            if (pushed) {
                obtained = this.myAccount.obtainItem();
            }
            threadDispatcher.notify();
        }
        if (!pushed) {
            ResourceDispatcher resourceDispatcher3 = messageDispatcher;
            synchronized (resourceDispatcher3) {
                msgSrcAccount.inNeed(false);
                msgSrcAccount.releaseQuantity(msgSize);
                if (msgSrcAccount.isIdle()) {
                    allSources.stickyCacheEntry(ce, false);
                }
                messageDispatcher.notify();
            }
            Thread.yield();
            return;
        }
        Thread.yield();
        if (obtained) {
            ListenerThread.newListenerThread(this);
        } else if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Listener '" + this + "' exceeds thread's limits; msg waits."));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ListenerThread
    extends Thread {
        private static ThreadGroup listenerGroup = new ThreadGroup("Quota Message Listeners");
        private static List idleThreads = new LinkedList();
        private QuotaIncomingMessageListener current;
        private volatile boolean terminated = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ListenerThread newListenerThread(QuotaIncomingMessageListener current) {
            ListenerThread lt = null;
            List list = idleThreads;
            synchronized (list) {
                if (idleThreads.isEmpty()) {
                    return new ListenerThread(current);
                }
                lt = (ListenerThread)idleThreads.remove(0);
            }
            lt.newJob(current);
            return lt;
        }

        private ListenerThread(QuotaIncomingMessageListener current) {
            super(listenerGroup, "QuotaListenerThread");
            this.current = current;
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void newJob(QuotaIncomingMessageListener current) {
            ListenerThread listenerThread = this;
            synchronized (listenerThread) {
                this.current = current;
                this.notify();
            }
        }

        void terminate() {
            this.terminated = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean getJob() {
            if (this.terminated) {
                return false;
            }
            List list = idleThreads;
            synchronized (list) {
                idleThreads.add(0, this);
            }
            while (true) {
                ListenerThread listenerThread = this;
                synchronized (listenerThread) {
                    if (this.current != null) {
                        return true;
                    }
                    try {
                        this.wait(4000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (this.current != null) {
                        return true;
                    }
                }
                List list2 = idleThreads;
                synchronized (list2) {
                    if (idleThreads.remove(this)) {
                        return false;
                    }
                }
            }
        }

        public void run() {
            try {
                while (true) {
                    if (this.current != null) {
                        this.current = this.current.doOne();
                        continue;
                    }
                    if (!this.getJob()) break;
                }
            }
            catch (Throwable all) {
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
        }
    }

    static class MessageFromSource {
        Message msg;
        EndpointAddress srcAddress;
        EndpointAddress destAddress;
        ResourceAccount src;
        long timeReceived;
        long size;

        MessageFromSource(Message msg, EndpointAddress srcAddress, EndpointAddress destAddress, ResourceAccount src, long timeReceived, long size) {
            this.msg = msg;
            this.src = src;
            this.srcAddress = srcAddress;
            this.destAddress = destAddress;
            this.timeReceived = timeReceived;
            this.size = size;
        }
    }

    static class MyCacheListener
    implements CacheEntryListener {
        MyCacheListener() {
        }

        public void purged(CacheEntry entry) {
            ((ResourceAccount)entry.getValue()).close();
        }
    }
}

