/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.cbjx;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.peer.PeerID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CbJxMessageInfo {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$cbjx$CbJxMessageInfo == null ? (class$net$jxta$impl$endpoint$cbjx$CbJxMessageInfo = CbJxMessageInfo.class$("net.jxta.impl.endpoint.cbjx.CbJxMessageInfo")) : class$net$jxta$impl$endpoint$cbjx$CbJxMessageInfo).getName());
    private static final String DOCTYPE = "CbJxMessageInfo";
    private static final String tagPeerCert = "PeerCert";
    private static final String tagDestination = "DestinationAddress";
    private static final String tagSource = "SourceAddress";
    private static final String tagSourceID = "SourceID";
    private Certificate rootCert = null;
    private EndpointAddress destinationAddress = null;
    private EndpointAddress sourceAddress = null;
    private ID sourceID = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$cbjx$CbJxMessageInfo;
    static /* synthetic */ Class class$net$jxta$document$XMLElement;

    public CbJxMessageInfo() {
    }

    public CbJxMessageInfo(InputStream stream, MimeMediaType type) throws IOException {
        XMLDocument document = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(type, stream);
        this.initialize(document);
    }

    public Certificate getPeerCert() {
        return this.rootCert;
    }

    public void setPeerCert(Certificate cert) {
        this.rootCert = cert;
    }

    public EndpointAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public void setDestinationAddress(EndpointAddress addr) {
        this.destinationAddress = EndpointAddress.unmodifiableEndpointAddress(addr);
    }

    public EndpointAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(EndpointAddress addr) {
        this.sourceAddress = EndpointAddress.unmodifiableEndpointAddress(addr);
    }

    public ID getSourceID() {
        return this.sourceID;
    }

    public void setSourceID(ID src) {
        this.sourceID = src;
    }

    public Document getDocument(MimeMediaType asMimeType) {
        Element element2;
        StructuredDocument document = StructuredDocumentFactory.newStructuredDocument(asMimeType, DOCTYPE);
        if (this.getPeerCert() == null) {
            throw new IllegalStateException("Missing Peer Root Certificate");
        }
        try {
            String base64cert = PSEUtils.base64Encode(this.getPeerCert().getEncoded());
            element2 = document.createElement(tagPeerCert, base64cert);
            document.appendChild(element2);
        }
        catch (Exception e) {
            throw new IllegalStateException("Bad root cert! " + e);
        }
        if (this.getSourceID() == null) {
            throw new IllegalStateException("Missing Source ID");
        }
        element2 = document.createElement(tagSourceID, this.getSourceID().toString());
        document.appendChild(element2);
        if (this.getDestinationAddress() == null) {
            throw new IllegalStateException("Missing Destination Address");
        }
        element2 = document.createElement(tagDestination, this.getDestinationAddress().toString());
        document.appendChild(element2);
        if (this.getSourceAddress() == null) {
            throw new IllegalStateException("Missing Source Address");
        }
        element2 = document.createElement(tagSource, this.getSourceAddress().toString());
        document.appendChild(element2);
        return document;
    }

    protected boolean handleElement(XMLElement elem) {
        if (elem.getName().equals(tagPeerCert)) {
            try {
                byte[] cert_der = PSEUtils.base64Decode(elem.getTextValue());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate cert = cf.generateCertificate(new ByteArrayInputStream(cert_der));
                this.setPeerCert(cert);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Bad X509 Cert!");
            }
            return true;
        }
        if (elem.getName().equals(tagDestination)) {
            EndpointAddress destination = new EndpointAddress(elem.getTextValue());
            this.setDestinationAddress(destination);
            return true;
        }
        if (elem.getName().equals(tagSource)) {
            EndpointAddress source = new EndpointAddress(elem.getTextValue());
            this.setSourceAddress(source);
            return true;
        }
        if (elem.getName().equals(tagSourceID)) {
            try {
                URL sourcePeerURL = IDFactory.jxtaURL(elem.getTextValue());
                PeerID sourcePeerID = (PeerID)IDFactory.fromURL(sourcePeerURL);
                this.setSourceID(sourcePeerID);
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad PeerGroupID in advertisement: " + elem.getTextValue());
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a peer id: " + elem.getTextValue());
            }
            return true;
        }
        return false;
    }

    protected void initialize(Element root) {
        if (!(class$net$jxta$document$XMLElement == null ? (class$net$jxta$document$XMLElement = CbJxMessageInfo.class$("net.jxta.document.XMLElement")) : class$net$jxta$document$XMLElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        if (!doctype.equals(DOCTYPE)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.getName()));
        }
        if (null == this.rootCert) {
            throw new IllegalArgumentException("Document did not contain a root cert element");
        }
        if (null == this.destinationAddress) {
            throw new IllegalArgumentException("Document did not contain a destination address element");
        }
        if (null == this.sourceAddress) {
            throw new IllegalArgumentException("Document did not contain a source address element");
        }
        if (null == this.sourceID) {
            throw new IllegalArgumentException("Document did not contain a source ID element");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

