/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.cbjx;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.cbjx.CbJxTransport;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CbJxMessenger
extends BlockingMessenger {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$cbjx$CbJxMessenger == null ? (class$net$jxta$impl$endpoint$cbjx$CbJxMessenger = CbJxMessenger.class$("net.jxta.impl.endpoint.cbjx.CbJxMessenger")) : class$net$jxta$impl$endpoint$cbjx$CbJxMessenger).getName());
    private EndpointAddress newDestAddr = null;
    private String acquireMessengerLock = new String("Messenger Acquire Lock");
    private Messenger outBoundMessenger = null;
    private CbJxTransport transport = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$cbjx$CbJxMessenger;

    public CbJxMessenger(CbJxTransport transport, EndpointAddress dest, Object hintIgnored) throws IOException {
        this(transport, dest);
    }

    public CbJxMessenger(CbJxTransport transport, EndpointAddress dest) throws IOException {
        super(EndpointAddress.unmodifiableEndpointAddress(dest));
        this.transport = transport;
        this.newDestAddr = EndpointAddress.unmodifiableEndpointAddress(new EndpointAddress("jxta", dest.getProtocolAddress(), "CbJxTransport", null));
        this.outBoundMessenger = transport.endpoint.getMessenger(this.newDestAddr);
        if (null == this.outBoundMessenger) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)("Could not get messenger for " + this.newDestAddr));
            }
            throw new IOException("Could not get messenger for " + this.newDestAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        String string = this.acquireMessengerLock;
        synchronized (string) {
            this.outBoundMessenger.close();
        }
    }

    public EndpointAddress getLogicalDestinationAddress() {
        return this.newDestAddr;
    }

    public boolean isClosed() {
        return super.isClosed();
    }

    public boolean isIdle() {
        Messenger tmp = this.outBoundMessenger;
        if (null != tmp) {
            return tmp.isIdle();
        }
        return true;
    }

    public boolean sendMessage(Message msg, String service, String serviceParam) throws IOException {
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)failure);
            }
            throw failure;
        }
        msg = (Message)msg.clone();
        EndpointAddress destAddressToUse = this.getDestAddressToUse(service, serviceParam);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Messenger: sending out " + msg + " to: " + destAddressToUse));
        }
        msg = this.transport.addCryptoInfo(msg, destAddressToUse);
        return this.sendTo(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendTo(Message msg) throws IOException {
        String string = this.acquireMessengerLock;
        synchronized (string) {
            if (this.isClosed()) {
                return false;
            }
            if (null == this.outBoundMessenger || this.outBoundMessenger.isClosed()) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sendTo : Getting messenger for " + this.newDestAddr));
                }
                this.outBoundMessenger = this.transport.endpoint.getMessenger(this.newDestAddr);
                if (this.outBoundMessenger == null) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)("sendTo : could not get messenger for " + this.newDestAddr));
                    }
                    this.close();
                    return false;
                }
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("sendTo : Sending " + msg + " to endpoint " + this.newDestAddr));
        }
        return this.outBoundMessenger.sendMessage(msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

