/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.cbjx;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Iterator;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextDocument;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageFilterListener;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.JxtaMessageMessageElement;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.cbjx.CbJxMessageInfo;
import net.jxta.impl.endpoint.cbjx.CbJxMessenger;
import net.jxta.impl.id.CBID.PeerID;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ModuleImplAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CbJxTransport
implements Module,
MessageSender,
MessageReceiver,
EndpointListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$cbjx$CbJxTransport == null ? (class$net$jxta$impl$endpoint$cbjx$CbJxTransport = CbJxTransport.class$("net.jxta.impl.endpoint.cbjx.CbJxTransport")) : class$net$jxta$impl$endpoint$cbjx$CbJxTransport).getName());
    public static final String CBJX_MSG_NS = "cbjx";
    static final String CBJX_MSG_INFO = "CryptoInfo";
    static final String CBJX_MSG_BODY = "Body";
    static final String CBJX_MSG_SIG = "Signature";
    static final String cbjxProtocolName = "cbjx";
    static final String cbjxServiceName = "CbJxTransport";
    static net.jxta.peer.PeerID localPeerID = null;
    static EndpointAddress localPeerAddr = null;
    PeerGroup group = null;
    EndpointService endpoint = null;
    PSEMembershipService membership = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$cbjx$CbJxTransport;

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.group = group;
        ModuleImplAdvertisement implAdvertisement = (ModuleImplAdvertisement)impl;
        localPeerID = group.getPeerID();
        localPeerAddr = EndpointAddress.unmodifiableEndpointAddress(new EndpointAddress("cbjx", group.getPeerID().getUniqueValue().toString(), null, null));
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring CbJx Transport : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tModule Spec ID: " + implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tImpl Description: " + implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tPublic Address : " + localPeerAddr);
            LOG.info((Object)configInfo);
        }
    }

    public int startApp(String[] arg) {
        this.endpoint = this.group.getEndpointService();
        MembershipService groupMembership = this.group.getMembershipService();
        if (!(groupMembership instanceof PSEMembershipService)) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"TLS Transport requires PSE Membership Service");
            }
            return -1;
        }
        this.membership = (PSEMembershipService)groupMembership;
        this.endpoint.addIncomingMessageListener(this, cbjxServiceName, null);
        this.endpoint.addIncomingMessageFilterListener(new CbJxInputFilter(), null, null);
        this.endpoint.addMessageTransport(this);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"CbJxTransport started");
        }
        return 0;
    }

    public void stopApp() {
        if (this.endpoint != null) {
            this.endpoint.removeMessageTransport(this);
            this.endpoint = null;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"CbJxTransport stopped");
        }
    }

    public EndpointAddress getPublicAddress() {
        return localPeerAddr;
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowsRouting() {
        return false;
    }

    public EndpointService getEndpointService() {
        return (EndpointService)this.endpoint.getInterface();
    }

    public Object transportControl(Object operation, Object value) {
        return null;
    }

    public Iterator getPublicAddresses() {
        return Collections.singletonList(this.getPublicAddress()).iterator();
    }

    public String getProtocolName() {
        return "cbjx";
    }

    public Messenger getMessenger(EndpointAddress dest, Object hintIgnored) {
        try {
            return new CbJxMessenger(this, dest, hintIgnored);
        }
        catch (IOException failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Failed to create cbjx messenger", (Throwable)failed);
            }
            return null;
        }
    }

    public Messenger getMessenger(EndpointAddress dest) {
        return this.getMessenger(dest, null);
    }

    public void propagate(Message msg, String serviceName, String serviceParams, String prunePeer) throws IOException {
    }

    public boolean ping(EndpointAddress addr) {
        Messenger messenger = this.getMessenger(addr);
        boolean reachable = null != messenger;
        messenger.close();
        return reachable;
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        block11: {
            MessageElement cryptoElement;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("processIncomingMessage : Received message from: " + srcAddr));
            }
            if ((cryptoElement = message.getMessageElement("cbjx", CBJX_MSG_INFO)) == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"processIncomingMessage : No 'CryptoInfo' in the message");
                }
                return;
            }
            message.removeMessageElement(cryptoElement);
            CbJxMessageInfo cryptoInfo = null;
            try {
                cryptoInfo = new CbJxMessageInfo(cryptoElement.getStream(), cryptoElement.getMimeType());
            }
            catch (Throwable e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"processIncomingMessage : Couldn't retrieve CbJxMessageInfo from 'CryptoInfo' element", e);
                }
                return;
            }
            Message submessage = this.checkCryptoInfo(message, cryptoElement, cryptoInfo);
            if (null == submessage) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("processIncomingMessage : discarding message from " + srcAddr));
                }
                return;
            }
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("processIncomingMessage: delivering " + submessage + " to: " + cryptoInfo.getDestinationAddress()));
                }
                this.endpoint.processIncomingMessage(submessage, cryptoInfo.getSourceAddress(), cryptoInfo.getDestinationAddress());
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block11;
                LOG.warn((Object)"processIncomingMessage: endpoint failed to demux message", all);
            }
        }
    }

    public Message addCryptoInfo(Message submessage, EndpointAddress destAddress) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Building CBJX wrapper for " + submessage));
        }
        Message.ElementIterator eachCbJxElement = submessage.getMessageElementsOfNamespace("cbjx");
        while (eachCbJxElement.hasNext()) {
            MessageElement aMessageElement = (MessageElement)eachCbJxElement.next();
            eachCbJxElement.remove();
        }
        Message message = new Message();
        CbJxMessageInfo cryptoInfo = new CbJxMessageInfo();
        cryptoInfo.setSourceID(localPeerID);
        cryptoInfo.setSourceAddress(localPeerAddr);
        cryptoInfo.setDestinationAddress(destAddress);
        PSECredential cred = (PSECredential)this.membership.getDefaultCredential();
        Certificate cert = cred.getCertificate();
        cryptoInfo.setPeerCert(cert);
        TextDocument infoDoc = (TextDocument)cryptoInfo.getDocument(MimeMediaType.XMLUTF8);
        byte[] infoSignature = null;
        try {
            infoSignature = PSEUtils.computeSignature("SHA1withRSA", cred.getPrivateKey(), infoDoc.getStream());
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("failed to sign " + submessage), e);
            }
            return null;
        }
        ByteArrayMessageElement infoSigElement = new ByteArrayMessageElement(CBJX_MSG_SIG, MimeMediaType.AOS, infoSignature, null);
        TextDocumentMessageElement cryptoInfoElement = new TextDocumentMessageElement(CBJX_MSG_INFO, infoDoc, (MessageElement)infoSigElement);
        message.addMessageElement("cbjx", cryptoInfoElement);
        WireFormatMessage subserial = WireFormatMessageFactory.toWire(submessage, new MimeMediaType("application/x-jxta-msg"), null);
        byte[] bodySignature = null;
        try {
            bodySignature = PSEUtils.computeSignature("SHA1withRSA", cred.getPrivateKey(), subserial.getStream());
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("failed to sign" + submessage), e);
            }
            return null;
        }
        subserial = null;
        ByteArrayMessageElement bodySigElement = new ByteArrayMessageElement(CBJX_MSG_SIG, MimeMediaType.AOS, bodySignature, null);
        message.addMessageElement("cbjx", new JxtaMessageMessageElement(CBJX_MSG_BODY, new MimeMediaType("application/x-jxta-msg"), submessage, bodySigElement));
        return message;
    }

    public Message checkCryptoInfo(Message message, MessageElement cryptoElement, CbJxMessageInfo cryptoInfo) {
        boolean valid;
        JxtaMessageMessageElement bodyElement = (JxtaMessageMessageElement)message.getMessageElement("cbjx", CBJX_MSG_BODY);
        if (null == bodyElement) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("No 'Body' in " + message));
            }
            return null;
        }
        message.removeMessageElement(bodyElement);
        Certificate peerCert = cryptoInfo.getPeerCert();
        RSAPublicKey publicKey = (RSAPublicKey)peerCert.getPublicKey();
        try {
            peerCert.verify(publicKey);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Invalid peer cert", (Throwable)e);
            }
            return null;
        }
        try {
            PeerID srcPeerID = (PeerID)cryptoInfo.getSourceID();
            byte[] pub_der = peerCert.getPublicKey().getEncoded();
            PeerID genID = (PeerID)IDFactory.newPeerID(this.group.getPeerGroupID(), pub_der);
            if (!srcPeerID.getUUID().equals(genID.getUUID())) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("CBID of " + message + " is not valid : " + srcPeerID + " != " + genID));
                }
                return null;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"CBID of the message is valid");
            }
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"failed to verify cbid", e);
            }
            return null;
        }
        try {
            valid = PSEUtils.verifySignature("SHA1withRSA", peerCert, cryptoElement.getSignature().getBytes(false), cryptoElement.getStream());
            if (!valid) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Failed to verify the signature of cryptinfo for " + message));
                }
                return null;
            }
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Failed to verify the signature of cryptinfo for " + message), e);
            }
            return null;
        }
        if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"verifying signature");
        }
        try {
            valid = PSEUtils.verifySignature("SHA1withRSA", peerCert, bodyElement.getSignature().getBytes(false), bodyElement.getStream());
            if (!valid) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("failed to verify the signature of " + message));
                }
                return null;
            }
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("failed to verify the signature of " + message), e);
            }
            return null;
        }
        return bodyElement.getMessage();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class CbJxOutputFilter
    implements MessageFilterListener {
        public Message filterMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            Message msg = (Message)message.clone();
            if (null == msg.getMessageElement("cbjx", CbJxTransport.CBJX_MSG_INFO)) {
                try {
                    msg = CbJxTransport.this.addCryptoInfo(msg, dstAddr);
                }
                catch (IOException failed) {
                    return null;
                }
            }
            return msg;
        }
    }

    public class CbJxInputFilter
    implements MessageFilterListener {
        public Message filterMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            if (dstAddr.getProtocolAddress().equals(CbJxTransport.this.getProtocolName())) {
                MessageElement cryptoElement = message.getMessageElement("cbjx", CbJxTransport.CBJX_MSG_INFO);
                if (cryptoElement == null) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"No 'CryptoInfo' in the message");
                    }
                    return null;
                }
                message.removeMessageElement(cryptoElement);
                CbJxMessageInfo cryptoInfo = null;
                try {
                    cryptoInfo = new CbJxMessageInfo(cryptoElement.getStream(), cryptoElement.getMimeType());
                }
                catch (Throwable e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Couldn't retrieve CbJxMessageInfo from 'CryptoInfo' element", e);
                    }
                    return null;
                }
                return CbJxTransport.this.checkCryptoInfo(message, cryptoElement, cryptoInfo);
            }
            return message;
        }
    }
}

