/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.endpoint.endpointMeter.EndpointMeter;
import net.jxta.impl.endpoint.endpointMeter.EndpointMetric;
import net.jxta.impl.endpoint.endpointMeter.EndpointServiceMetric;
import net.jxta.impl.endpoint.endpointMeter.EndpointServiceMonitorFilter;
import net.jxta.impl.endpoint.endpointMeter.InboundMeter;
import net.jxta.impl.endpoint.endpointMeter.InboundMetric;
import net.jxta.impl.endpoint.endpointMeter.OutboundMeter;
import net.jxta.impl.endpoint.endpointMeter.OutboundMetric;
import net.jxta.impl.endpoint.endpointMeter.PropagationMeter;
import net.jxta.impl.endpoint.endpointMeter.PropagationMetric;
import net.jxta.impl.meter.GenericServiceMonitor;
import net.jxta.meter.ServiceMetric;
import net.jxta.meter.ServiceMonitorFilter;

public class EndpointServiceMonitor
extends GenericServiceMonitor {
    private EndpointServiceMetric cumulativeEndpointServiceMetric;
    private Hashtable inboundMeters = new Hashtable();
    private Hashtable outboundMeters = new Hashtable();
    private Hashtable propagationMeters = new Hashtable();
    private EndpointMeter endpointMeter = new EndpointMeter();

    protected void init() {
        this.cumulativeEndpointServiceMetric = (EndpointServiceMetric)this.getCumulativeServiceMetric();
        this.cumulativeEndpointServiceMetric.setEndpointMetric(this.endpointMeter.getCumulativeMetrics());
    }

    public EndpointMeter getEndpointMeter() {
        return this.endpointMeter;
    }

    public synchronized InboundMeter getInboundMeter(String serviceName, String serviceParam) {
        InboundMeter inboundMeter;
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        if ((inboundMeter = (InboundMeter)this.inboundMeters.get(address)) == null) {
            inboundMeter = new InboundMeter(serviceName, serviceParam);
            this.inboundMeters.put(address, inboundMeter);
            this.cumulativeEndpointServiceMetric.addInboundMetric(inboundMeter.getCumulativeMetrics());
        }
        return inboundMeter;
    }

    public synchronized PropagationMeter getPropagationMeter(String serviceName, String serviceParam) {
        PropagationMeter propagationMeter;
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        if ((propagationMeter = (PropagationMeter)this.propagationMeters.get(address)) == null) {
            propagationMeter = new PropagationMeter(serviceName, serviceParam);
            this.propagationMeters.put(address, propagationMeter);
            this.cumulativeEndpointServiceMetric.addPropagationMetric(propagationMeter.getCumulativeMetrics());
        }
        return propagationMeter;
    }

    public synchronized OutboundMeter getOutboundMeter(EndpointAddress endpointAddress) {
        OutboundMeter outboundMeter = (OutboundMeter)this.outboundMeters.get(endpointAddress);
        if (outboundMeter == null) {
            outboundMeter = new OutboundMeter(endpointAddress);
            this.cumulativeEndpointServiceMetric.addOutboundMetric(outboundMeter.getCumulativeMetrics());
            this.outboundMeters.put(endpointAddress, outboundMeter);
        }
        return outboundMeter;
    }

    public ServiceMetric getServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime, int pulseIndex, long reportRate) {
        int deltaReportRateIndex = this.monitorManager.getReportRateIndex(reportRate);
        EndpointServiceMetric origEndpointServiceMetric = (EndpointServiceMetric)this.deltaServiceMetrics[deltaReportRateIndex];
        if (origEndpointServiceMetric == null) {
            return null;
        }
        EndpointServiceMonitorFilter endpointServiceMonitorFilter = (EndpointServiceMonitorFilter)serviceMonitorFilter;
        return origEndpointServiceMetric.shallowCopy(endpointServiceMonitorFilter);
    }

    public ServiceMetric getCumulativeServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime) {
        EndpointServiceMetric origEndpointServiceMetric = (EndpointServiceMetric)this.cumulativeServiceMetric;
        EndpointServiceMonitorFilter endpointServiceMonitorFilter = (EndpointServiceMonitorFilter)serviceMonitorFilter;
        return origEndpointServiceMetric.deepCopy(endpointServiceMonitorFilter);
    }

    protected ServiceMetric collectServiceMetrics() {
        EndpointServiceMetric endpointServiceMetric = (EndpointServiceMetric)this.createServiceMetric();
        boolean anyData = false;
        Enumeration e = this.inboundMeters.elements();
        while (e.hasMoreElements()) {
            InboundMeter inboundMeter = (InboundMeter)e.nextElement();
            InboundMetric inboundMetric = inboundMeter.collectMetrics();
            if (inboundMetric == null) continue;
            endpointServiceMetric.addInboundMetric(inboundMetric);
            anyData = true;
        }
        Enumeration e2 = this.outboundMeters.elements();
        while (e2.hasMoreElements()) {
            OutboundMeter outboundMeter = (OutboundMeter)e2.nextElement();
            OutboundMetric outboundMetric = outboundMeter.collectMetrics();
            if (outboundMetric == null) continue;
            endpointServiceMetric.addOutboundMetric(outboundMetric);
            anyData = true;
        }
        Enumeration e3 = this.propagationMeters.elements();
        while (e3.hasMoreElements()) {
            PropagationMeter propagationMeter = (PropagationMeter)e3.nextElement();
            PropagationMetric propagationMetric = propagationMeter.collectMetrics();
            if (propagationMetric == null) continue;
            endpointServiceMetric.addPropagationMetric(propagationMetric);
            anyData = true;
        }
        EndpointMetric endpointMetric = this.endpointMeter.collectMetrics();
        if (endpointMetric != null) {
            endpointServiceMetric.setEndpointMetric(endpointMetric);
            anyData = true;
        }
        if (anyData) {
            return endpointServiceMetric;
        }
        return null;
    }
}

