/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.msgframing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jxta.document.MimeMediaType;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MessagePackageHeader {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$msgframing$MessagePackageHeader == null ? (class$net$jxta$impl$endpoint$msgframing$MessagePackageHeader = MessagePackageHeader.class$("net.jxta.impl.endpoint.msgframing.MessagePackageHeader")) : class$net$jxta$impl$endpoint$msgframing$MessagePackageHeader).getName());
    List headers = new ArrayList();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$msgframing$MessagePackageHeader;

    public MessagePackageHeader() {
    }

    public MessagePackageHeader(InputStream in) throws IOException {
        boolean sawEmpty = false;
        boolean sawLength = false;
        boolean sawType = false;
        DataInputStream di = new DataInputStream(in);
        do {
            byte headerNameLength;
            if (0 == (headerNameLength = di.readByte())) {
                sawEmpty = true;
                continue;
            }
            byte[] headerNameBytes = new byte[headerNameLength];
            di.readFully(headerNameBytes);
            String headerNameString = new String(headerNameBytes, "UTF-8");
            if (headerNameString.equalsIgnoreCase("content-length")) {
                if (sawLength) {
                    throw new IOException("Duplicate content-length header");
                }
                sawLength = true;
            }
            if (headerNameString.equalsIgnoreCase("content-type")) {
                if (sawType) {
                    throw new IOException("Duplicate content-type header");
                }
                sawType = true;
            }
            int headerValueLength = di.readUnsignedShort();
            byte[] headerValueBytes = new byte[headerValueLength];
            di.readFully(headerValueBytes);
            this.headers.add(new Header(headerNameString, headerValueBytes));
        } while (!sawEmpty);
        if (!sawLength) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Content Length header was missing");
            }
            throw new IOException("Content Length header was missing");
        }
        if (!sawType) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Content Type header was missing");
            }
            throw new IOException("Content Type header was missing");
        }
    }

    public void addHeader(String name, byte[] value) {
        this.headers.add(new Header(name, value));
    }

    public void replaceHeader(String name, byte[] value) {
        Iterator eachHeader = this.getHeaders();
        while (eachHeader.hasNext()) {
            Header aHeader = (Header)eachHeader.next();
            if (!aHeader.getName().equalsIgnoreCase(name)) continue;
            this.headers.remove(aHeader);
        }
        this.headers.add(new Header(name, value));
    }

    public Iterator getHeaders() {
        return this.headers.iterator();
    }

    public Iterator getHeader(String name) {
        Iterator eachHeader = this.getHeaders();
        ArrayList<Header> matchingHeaders = new ArrayList<Header>();
        while (eachHeader.hasNext()) {
            Header aHeader = (Header)eachHeader.next();
            if (!name.equals(aHeader.getName())) continue;
            matchingHeaders.add(aHeader);
        }
        return matchingHeaders.iterator();
    }

    public void sendToStream(OutputStream out) throws IOException {
        Iterator eachHeader = this.getHeaders();
        DataOutputStream dos = new DataOutputStream(out);
        while (eachHeader.hasNext()) {
            Header aHeader = (Header)eachHeader.next();
            byte[] nameBytes = aHeader.getName().getBytes("UTF-8");
            byte[] value = aHeader.getValue();
            dos.write(nameBytes.length);
            dos.write(nameBytes);
            dos.writeShort(value.length);
            dos.write(value);
        }
        dos.write(0);
    }

    public void setContentLengthHeader(long length) {
        byte[] lengthAsBytes = new byte[8];
        long lengthAsLong = length;
        int eachByte = 0;
        while (eachByte < 8) {
            lengthAsBytes[eachByte] = (byte)(lengthAsLong >> (int)((long)(7 - eachByte) * 8L));
            ++eachByte;
        }
        this.replaceHeader("content-length", lengthAsBytes);
    }

    public long getContentLengthHeader() {
        Header header = (Header)this.getHeader("content-length").next();
        byte[] lengthAsBytes = header.getValue();
        long lengthAsLong = 0L;
        int eachByte = 0;
        while (eachByte < 8) {
            lengthAsLong |= (long)(lengthAsBytes[eachByte] & 0xFF) << (int)((long)(7 - eachByte) * 8L);
            ++eachByte;
        }
        return lengthAsLong;
    }

    public void setContentTypeHeader(MimeMediaType type) {
        try {
            this.replaceHeader("content-type", type.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException never) {
            throw new IllegalStateException("UTF-8 encoding support missing!");
        }
    }

    public MimeMediaType getContentTypeHeader() {
        Header header = (Header)this.getHeader("content-type").next();
        try {
            return new MimeMediaType(new String(header.getValue(), "UTF-8"));
        }
        catch (UnsupportedEncodingException never) {
            throw new IllegalStateException("UTF-8 encoding support missing!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Header {
        String name;
        byte[] value;

        public Header(String name, byte[] value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getValue() {
            return this.value;
        }
    }
}

