/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.msgframing;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.StringTokenizer;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;

public class WelcomeMessage {
    private static final String GREETING = "JXTAHELLO";
    private static final String SPACE = " ";
    private static final String CURRENTVERSION = "1.1";
    private static final String CRLF = "\r\n";
    private String welcomeString;
    private byte[] welcomeBytes;
    private ID peerID;
    private EndpointAddress publicAddress;
    private EndpointAddress destinationAddress;
    private String versionString;
    private boolean dontPropagate;

    public WelcomeMessage(EndpointAddress destAddr, EndpointAddress publicaddress, ID peerid, boolean dontPropagate) {
        this.peerID = peerid;
        this.publicAddress = publicaddress;
        this.destinationAddress = destAddr;
        this.versionString = CURRENTVERSION;
        this.welcomeString = "JXTAHELLO " + destAddr.toString() + SPACE + this.publicAddress.toString() + SPACE + this.peerID.toString() + SPACE + (dontPropagate ? "0" : "1") + SPACE + this.versionString;
        try {
            this.welcomeBytes = this.welcomeString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException never) {}
    }

    public WelcomeMessage(InputStream in) throws IOException {
        this.welcomeBytes = new byte[4096];
        int readAt = 0;
        boolean sawCR = false;
        boolean sawCRLF = false;
        do {
            int c = in.read();
            switch (c) {
                case -1: {
                    throw new EOFException("Stream terminated before end of welcome message");
                }
                case 13: {
                    if (sawCR) {
                        this.welcomeBytes[readAt++] = 13;
                    }
                    sawCR = true;
                    break;
                }
                case 10: {
                    if (sawCR) {
                        sawCRLF = true;
                        break;
                    }
                    this.welcomeBytes[readAt++] = 10;
                    break;
                }
                default: {
                    this.welcomeBytes[readAt++] = (byte)c;
                    sawCR = false;
                }
            }
            if (readAt != this.welcomeBytes.length) continue;
            throw new IOException("Invalid welcome message, too long");
        } while (!sawCRLF);
        byte[] truncatedBytes = new byte[readAt];
        System.arraycopy(this.welcomeBytes, 0, truncatedBytes, 0, readAt);
        this.welcomeBytes = truncatedBytes;
        this.welcomeString = new String(this.welcomeBytes, "UTF-8");
        StringTokenizer thePieces = new StringTokenizer(this.welcomeString, SPACE);
        if (!thePieces.hasMoreTokens() || !GREETING.equals(thePieces.nextToken())) {
            throw new IOException("Invalid welcome message, did not start with greeting");
        }
        if (!thePieces.hasMoreTokens()) {
            throw new IOException("Invalid welcome message, nothing after greeting");
        }
        this.destinationAddress = new EndpointAddress(thePieces.nextToken());
        if (!thePieces.hasMoreTokens()) {
            throw new IOException("Invalid welcome message, nothing after destination address");
        }
        this.publicAddress = new EndpointAddress(thePieces.nextToken());
        if (!thePieces.hasMoreTokens()) {
            throw new IOException("Invalid welcome message, nothing after public address");
        }
        URL peerURL = IDFactory.jxtaURL(thePieces.nextToken());
        this.peerID = IDFactory.fromURL(peerURL);
        if (!thePieces.hasMoreTokens()) {
            throw new IOException("Invalid welcome message, nothing after peer id");
        }
        String dontPropagateStr = thePieces.nextToken();
        if (dontPropagateStr.equals("1")) {
            this.dontPropagate = true;
        } else if (dontPropagateStr.equals("0")) {
            this.dontPropagate = false;
        } else {
            throw new IOException("Invalid welcome message, illegal value for propagate flag");
        }
        if (!thePieces.hasMoreTokens()) {
            throw new IOException("Invalid welcome message, version missing");
        }
        this.versionString = thePieces.nextToken();
        if (thePieces.hasMoreTokens()) {
            throw new IOException("Invalid welcome message, text after version string");
        }
    }

    public void sendToStream(OutputStream theStream) throws IOException {
        theStream.write(this.welcomeBytes);
        theStream.write(13);
        theStream.write(10);
    }

    public ID getPeerID() {
        return this.peerID;
    }

    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    public EndpointAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public boolean dontPropagate() {
        return this.dontPropagate;
    }

    public String getWelcomeVersion() {
        return this.versionString;
    }

    public String getWelcomeString() {
        return this.welcomeString;
    }
}

