/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.relay;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.BasicMessenger;
import net.jxta.impl.endpoint.relay.RelayTransport;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RelayClient
implements MessageReceiver,
PropertyChangeListener,
Runnable {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$relay$RelayClient == null ? (class$net$jxta$impl$endpoint$relay$RelayClient = RelayClient.class$("net.jxta.impl.endpoint.relay.RelayClient")) : class$net$jxta$impl$endpoint$relay$RelayClient).getName());
    private static final long DEFAULT_EXPIRATION = 1200000L;
    private static final long WEEK_EXPIRATION = 604800000L;
    private static final long DAY_EXPIRATION = 86400000L;
    private PeerGroup group = null;
    private DiscoveryService discovery = null;
    private EndpointService endpoint = null;
    private EndpointAddress publicAddress = null;
    private String groupName = null;
    private String peerId = null;
    private Thread thread = null;
    private long messengerPollInterval = 0L;
    private long leaseLengthToRequest = 0L;
    private int maxServers = 0;
    private String serviceName = null;
    private Vector activeRelayListeners = new Vector();
    private Hashtable activeRelays = new Hashtable();
    private EndpointAddress[] seedRelays = null;
    protected RelayServerConnection currentServer = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$relay$RelayClient;

    public RelayClient(RelayTransport transport, String serviceName, EndpointAddress[] seedRelays, int maxServers, long messengerPollInterval, long leaseLengthToRequest) {
        this.group = transport.getGroup();
        this.groupName = this.group.getPeerGroupID().getUniqueValue().toString();
        this.serviceName = serviceName;
        this.seedRelays = seedRelays;
        this.maxServers = maxServers;
        this.leaseLengthToRequest = leaseLengthToRequest;
        this.messengerPollInterval = messengerPollInterval;
        if (leaseLengthToRequest == 0L || maxServers == 0 || messengerPollInterval == 0L) {
            throw new IllegalArgumentException("invalid initial parameters");
        }
        this.peerId = this.group.getPeerID().getUniqueValue().toString();
        this.publicAddress = new EndpointAddress("relay", this.peerId, null, null);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("publicAddress=" + this.publicAddress.toString()));
        }
    }

    public void startClient() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("startClients " + this.publicAddress.toString()));
        }
        this.endpoint = this.group.getEndpointService();
        this.discovery = this.group.getDiscoveryService();
        this.endpoint.addMessageTransport(this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stopClient() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("stopClients " + this.publicAddress.toString()));
        }
        this.endpoint.removeMessageTransport(this);
        Thread tempThread = this.thread;
        this.thread = null;
        if (tempThread != null) {
            tempThread.interrupt();
        }
    }

    public Iterator getPublicAddresses() {
        EndpointAddress addr = null;
        if (this.publicAddress != null) {
            addr = (EndpointAddress)this.publicAddress.clone();
        }
        return Collections.singletonList(addr).iterator();
    }

    public String getProtocolName() {
        return "relay";
    }

    public EndpointService getEndpointService() {
        return this.endpoint;
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("propertyChange evt=" + evt));
        }
        if ("close".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"notify RelayClient");
            }
            RelayClient relayClient = this;
            synchronized (relayClient) {
                this.notifyAll();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (RelayClient.LOG.isEnabledFor((Priority)Level.DEBUG)) {
            RelayClient.LOG.debug((Object)"start client thread");
        }
        triedSeedsAt = 0L;
        triedDiscoveryAt = 0L;
        while (!this.isRelayConnectDone()) {
            block20: {
                block19: {
                    block18: {
                        if (triedDiscoveryAt + 30000L > System.currentTimeMillis()) {
                            try {
                                Thread.sleep(30000L);
                            }
                            catch (InterruptedException e) {
                                if (!RelayClient.LOG.isEnabledFor((Priority)Level.DEBUG)) break block18;
                                RelayClient.LOG.debug((Object)"Thread Interrupted ", (Throwable)e);
                            }
                        }
                    }
                    if (this.isRelayConnectDone()) break;
                    if (RelayClient.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        RelayClient.LOG.debug((Object)"Check discovery for Relay Advertisement");
                    }
                    enum = null;
                    try {
                        enum = this.discovery.getLocalAdvertisements(2, "RdvServiceName", this.serviceName);
                    }
                    catch (IOException e) {
                        if (!RelayClient.LOG.isEnabledFor((Priority)Level.DEBUG)) break block19;
                        RelayClient.LOG.debug((Object)"Could not load Relay Advertisement ", (Throwable)e);
                    }
                }
                while (enum != null && enum.hasMoreElements() && !this.isRelayConnectDone()) {
                    obj = enum.nextElement();
                    if (obj instanceof RdvAdvertisement && this.serviceName.equals((relayAdv = (RdvAdvertisement)obj).getServiceName())) ** GOTO lbl30
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        relayAdv = this.connectToRelay(new RelayServerConnection(this, relayAdv));
lbl30:
                        // 2 sources

                        ** while (relayAdv != null)
                    }
lbl31:
                    // 1 sources

                }
                triedDiscoveryAt = System.currentTimeMillis();
                if (triedSeedsAt + 30000L > System.currentTimeMillis()) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        if (!RelayClient.LOG.isEnabledFor((Priority)Level.DEBUG)) break block20;
                        RelayClient.LOG.debug((Object)"Thread Interrupted ", (Throwable)e);
                    }
                }
            }
            if (this.isRelayConnectDone()) break;
            if (RelayClient.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                RelayClient.LOG.debug((Object)"use the seed relay servers");
            }
            i = 0;
            while (i < this.seedRelays.length && !this.isRelayConnectDone()) {
                relayAdv = this.connectToRelay(new RelayServerConnection(this, this.seedRelays[i]));
                if (relayAdv != null) {
                    while (relayAdv != null) {
                        relayAdv = this.connectToRelay(new RelayServerConnection(this, relayAdv));
                    }
                    break;
                }
                ++i;
            }
            triedSeedsAt = System.currentTimeMillis();
        }
        if (RelayClient.LOG.isEnabledFor((Priority)Level.DEBUG)) {
            RelayClient.LOG.debug((Object)"stop client thread");
        }
    }

    protected boolean isRelayConnectDone() {
        return this.thread == null || Thread.currentThread() != this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RdvAdvertisement connectToRelay(RelayServerConnection server) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("connectToRelay " + server));
        }
        RdvAdvertisement alternateRelayAdv = null;
        this.currentServer = server;
        if (!server.createMessenger(this.leaseLengthToRequest)) {
            return alternateRelayAdv;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("got messenger " + server));
        }
        if (server.logicalAddress != null && "jxta".equals(server.logicalAddress.getProtocolName())) {
            server.peerId = server.logicalAddress.getProtocolAddress();
        }
        if (server.peerId == null) {
            if (server.messenger != null) {
                server.sendDisconnectMessage();
                server.messenger.close();
            }
            return alternateRelayAdv;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("got peerId " + server));
        }
        RelayClient relayClient = this;
        synchronized (relayClient) {
            long requestTimeoutAt = System.currentTimeMillis() + 5000L;
            while (this.currentServer != null && this.currentServer.leaseLength == 0L && !this.isRelayConnectDone()) {
                block29: {
                    long waitTimeout = requestTimeoutAt - System.currentTimeMillis();
                    if (waitTimeout <= 0L) break;
                    try {
                        this.wait(waitTimeout);
                    }
                    catch (InterruptedException e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block29;
                        LOG.debug((Object)"wait got interrupted early ", (Throwable)e);
                    }
                }
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)"wait done");
            }
        }
        if (this.currentServer == null) {
            return server.alternateRelayAdv;
        }
        if (this.isRelayConnectDone()) {
            if (this.currentServer.messenger != null) {
                this.currentServer.messenger.close();
            }
            this.currentServer = null;
            return server.alternateRelayAdv;
        }
        if (this.currentServer.leaseLength == 0L) {
            this.currentServer.sendConnectMessage(this.leaseLengthToRequest);
            RelayClient requestTimeoutAt = this;
            synchronized (requestTimeoutAt) {
                long requestTimeoutAt2 = System.currentTimeMillis() + 15000L;
                while (this.currentServer != null && this.currentServer.leaseLength == 0L && !this.isRelayConnectDone()) {
                    block30: {
                        long waitTimeout = requestTimeoutAt2 - System.currentTimeMillis();
                        if (waitTimeout <= 0L) break;
                        try {
                            this.wait(waitTimeout);
                        }
                        catch (InterruptedException e) {
                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block30;
                            LOG.debug((Object)"wait got interrupted early ", (Throwable)e);
                        }
                    }
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"wait done");
                }
            }
        }
        if (this.currentServer == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("did not get connect from " + server));
            }
            return server.alternateRelayAdv;
        }
        if (this.currentServer.relayAdv == null || this.currentServer.leaseLength == 0L || this.isRelayConnectDone()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("did not get connect from " + server));
            }
            if (this.currentServer.messenger != null) {
                this.currentServer.sendDisconnectMessage();
                this.currentServer.messenger.close();
            }
            this.currentServer = null;
            return server.alternateRelayAdv;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("got connected " + server));
        }
        RouteAdvertisement holdAdv = server.relayAdv.getRouteAdv();
        EndpointAddress holdDest = server.logicalAddress;
        this.addActiveRelay(holdDest, holdAdv);
        alternateRelayAdv = this.maintainRelayConnection(server);
        this.removeActiveRelay(holdDest, holdAdv);
        return alternateRelayAdv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RdvAdvertisement maintainRelayConnection(RelayServerConnection server) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("maintainRelayConnection() start " + this.currentServer));
        }
        if (server == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("RelayConnection() failed at start " + this.currentServer));
            }
            return null;
        }
        RelayClient relayClient = this;
        synchronized (relayClient) {
            long currentTime = System.currentTimeMillis();
            long renewLeaseAt = this.currentServer.leaseObtainedAt + this.currentServer.leaseLength / 3L;
            long waitTimeout = 0L;
            boolean earlyRenew = this.currentServer.seeded;
            if (this.currentServer.relayAdv != null) {
                RouteAdvertisement route = this.currentServer.relayAdv.getRouteAdv();
                if (route != null) {
                    route.setDestPeerID(RelayClient.addr2pid(this.currentServer.logicalAddress));
                }
                this.endpoint.getMessenger(this.currentServer.logicalAddress, route);
            }
            while (this.currentServer != null && !this.isRelayConnectDone()) {
                block26: {
                    waitTimeout = renewLeaseAt - currentTime;
                    if (waitTimeout > this.messengerPollInterval || waitTimeout < 0L) {
                        waitTimeout = this.messengerPollInterval;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("waitTimeout=" + waitTimeout + " server=" + this.currentServer));
                    }
                    try {
                        this.wait(waitTimeout);
                    }
                    catch (InterruptedException e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block26;
                        LOG.debug((Object)"wait got interrupted early ", (Throwable)e);
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("wait done, server=" + this.currentServer));
                }
                if (this.currentServer == null) break;
                currentTime = System.currentTimeMillis();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("check messenger " + this.currentServer));
                }
                if (this.currentServer.messenger.isClosed()) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Server connection broken");
                    }
                    if (!this.currentServer.createMessenger(this.currentServer.leaseLength)) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"Server connection NOT re-established");
                        }
                        this.currentServer = null;
                        break;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Server connection re-established");
                    }
                    if (!this.isRelayConnectDone()) continue;
                }
                if (this.isRelayConnectDone()) break;
                renewLeaseAt = this.currentServer.leaseObtainedAt + this.currentServer.leaseLength / 3L;
                if (currentTime < renewLeaseAt && !earlyRenew) continue;
                earlyRenew = false;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("renew lease " + this.currentServer));
                }
                if (currentTime <= this.currentServer.leaseObtainedAt + this.currentServer.leaseLength / 3L + 240000L && this.currentServer.sendConnectMessage(this.leaseLengthToRequest)) continue;
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("renew lease failed" + this.currentServer));
                }
                if (this.currentServer.messenger != null) {
                    this.currentServer.messenger.close();
                }
                this.currentServer.messenger = null;
                this.currentServer.peerId = null;
                this.currentServer.leaseLength = 0L;
                this.currentServer.leaseObtainedAt = 0L;
                this.currentServer.relayAdv = null;
                this.currentServer = null;
                break;
            }
        }
        if (this.isRelayConnectDone() && this.currentServer != null) {
            this.currentServer.sendDisconnectMessage();
            if (this.currentServer.messenger != null) {
                this.currentServer.messenger.close();
            }
            this.currentServer.messenger = null;
            this.currentServer.peerId = null;
            this.currentServer.leaseLength = 0L;
            this.currentServer.leaseObtainedAt = 0L;
            this.currentServer.relayAdv = null;
            this.currentServer.alternateRelayAdv = null;
            this.currentServer = null;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("maintainRelayConnection() terminated " + this.currentServer));
        }
        return server.alternateRelayAdv;
    }

    protected synchronized void handleResponse(Message message, EndpointAddress dstAddr) {
        String serverPeerId;
        RdvAdvertisement relayAdv;
        String response;
        block30: {
            block29: {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("handleResponse " + this.currentServer));
                }
                if (this.currentServer == null) {
                    return;
                }
                response = RelayTransport.getString(message, "response");
                if (response == null) {
                    return;
                }
                response = response.toLowerCase();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("response = " + response));
                }
                relayAdv = null;
                String relayAdvStr = RelayTransport.getString(message, "relayAdv");
                if (relayAdvStr != null) {
                    try {
                        Advertisement adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, new ByteArrayInputStream(relayAdvStr.getBytes()));
                        if (adv instanceof RdvAdvertisement) {
                            relayAdv = (RdvAdvertisement)adv;
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Got relay adv for : " + relayAdv.getPeerID()));
                            }
                        }
                    }
                    catch (IOException e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block29;
                        LOG.debug((Object)"Could not read Relay RdvAdvertisement", (Throwable)e);
                    }
                }
            }
            if (relayAdv != null) {
                try {
                    this.discovery.publish(relayAdv, 2, 86400000L, 86400000L);
                }
                catch (IOException e) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block30;
                    LOG.debug((Object)"Could not publish Relay RdvAdvertisement", (Throwable)e);
                }
            }
        }
        if ((serverPeerId = dstAddr.getServiceParameter()) == null) {
            return;
        }
        if (!serverPeerId.equals(this.currentServer.peerId)) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("serverPeerId = " + serverPeerId));
        }
        if ("connected".equals(response)) {
            long responseLease;
            block31: {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("connected response for " + this.currentServer));
                }
                String responseLeaseString = RelayTransport.getString(message, "lease");
                responseLease = 0L;
                if (responseLeaseString != null) {
                    try {
                        responseLease = Long.parseLong(responseLeaseString);
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block31;
                        LOG.warn((Object)"could not parse response lease string", (Throwable)e);
                    }
                }
            }
            if (responseLease == 0L) {
                return;
            }
            this.currentServer.leaseLength = responseLease;
            this.currentServer.leaseObtainedAt = System.currentTimeMillis();
            this.currentServer.flushNeeded = false;
            if (relayAdv != null) {
                PeerID pidOfAdv = relayAdv.getPeerID();
                String pidOfAdvUnique = pidOfAdv.getUniqueValue().toString();
                if (this.currentServer.peerId.equals(pidOfAdvUnique)) {
                    this.currentServer.relayAdv = relayAdv;
                    this.currentServer.relayAdv.getRouteAdv().setDestPeerID(pidOfAdv);
                } else {
                    this.currentServer.alternateRelayAdv = relayAdv;
                }
            }
            this.notifyAll();
        } else if ("disconnected".equals(response)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("disconnected from " + this.currentServer));
            }
            this.currentServer.alternateRelayAdv = relayAdv;
            if (this.currentServer.messenger != null) {
                this.currentServer.messenger.close();
            }
            this.currentServer.messenger = null;
            this.currentServer.peerId = null;
            this.currentServer.leaseLength = 0L;
            this.currentServer.leaseObtainedAt = 0L;
            this.currentServer.relayAdv = null;
            this.currentServer = null;
            this.notifyAll();
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("response handled for " + this.currentServer));
        }
    }

    public synchronized boolean addActiveRelayListener(Object service) {
        if (!this.activeRelayListeners.contains(service)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Register group to relay connection" + ((PeerGroup)service).getPeerGroupName()));
            }
            this.activeRelayListeners.add(service);
        }
        return true;
    }

    public synchronized boolean removeActiveRelayListener(Object service) {
        this.activeRelayListeners.remove(service);
        return true;
    }

    public synchronized boolean addActiveRelay(EndpointAddress address, RouteAdvertisement relayRoute) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("notify add relay connection for " + address.toString()));
        }
        Enumeration e = this.activeRelayListeners.elements();
        while (e.hasMoreElements()) {
            PeerGroup pg = (PeerGroup)e.nextElement();
            this.addRelay(pg, relayRoute);
        }
        this.activeRelays.put(address, relayRoute);
        return true;
    }

    public synchronized boolean removeActiveRelay(EndpointAddress address, RouteAdvertisement relayRoute) {
        Enumeration e = this.activeRelayListeners.elements();
        while (e.hasMoreElements()) {
            PeerGroup pg = (PeerGroup)e.nextElement();
            this.removeRelay(pg, relayRoute);
        }
        this.activeRelays.remove(address);
        return true;
    }

    private void addRelay(PeerGroup pg, RouteAdvertisement relayRoute) {
        block14: {
            block13: {
                try {
                    DiscoveryService discovery = pg.getDiscoveryService();
                    if (discovery != null) {
                        discovery.publish(relayRoute, 2, 1200000L, 1200000L);
                    }
                }
                catch (Throwable theMatter) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block13;
                    LOG.warn((Object)"could not publish relay route adv", theMatter);
                }
            }
            ModuleClassID assignedID = PeerGroup.endpointClassID;
            try {
                PeerAdvertisement padv = pg.getPeerAdvertisement();
                StructuredDocument myParam = padv.getServiceParam(assignedID);
                RouteAdvertisement route = null;
                if (myParam == null) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"no route found in peer adv");
                    }
                    return;
                }
                Enumeration paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType());
                Element param = null;
                if (paramChilds.hasMoreElements()) {
                    param = (Element)paramChilds.nextElement();
                }
                if ((route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param)) == null) {
                    return;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("found route info for local peer \n" + route.display()));
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("OLD route info to local peer" + route.display()));
                }
                route.removeHop(relayRoute.getDestPeerID());
                Vector hops = route.getVectorHops();
                hops.add(relayRoute.getDest());
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("NEW route info to local peer" + route.display()));
                }
                myParam = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredTextDocument xptDoc = (StructuredTextDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(myParam, myParam, xptDoc);
                padv.putServiceParam(assignedID, myParam);
                this.discovery = pg.getDiscoveryService();
                if (this.discovery != null) {
                    this.discovery.publish(padv, 0, 31536000000L, 0x6DDD00L);
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block14;
                LOG.debug((Object)("exception adding relay route " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private void removeRelay(PeerGroup pg, RouteAdvertisement relayRoute) {
        block9: {
            ModuleClassID assignedID = PeerGroup.endpointClassID;
            PeerID relayPid = relayRoute.getDestPeerID();
            try {
                PeerAdvertisement padv = null;
                padv = pg.getPeerAdvertisement();
                StructuredDocument myParam = padv.getServiceParam(assignedID);
                RouteAdvertisement route = null;
                if (myParam == null) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"no route found in peer adv");
                        return;
                    }
                } else {
                    Enumeration paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType());
                    Element param = null;
                    if (paramChilds.hasMoreElements()) {
                        param = (Element)paramChilds.nextElement();
                    }
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
                }
                if (route == null) {
                    return;
                }
                route.removeHop(relayPid);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("new route info to the peer" + route.display()));
                }
                myParam = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredTextDocument xptDoc = (StructuredTextDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(myParam, myParam, xptDoc);
                padv.putServiceParam(assignedID, myParam);
                DiscoveryService discovery = pg.getDiscoveryService();
                if (discovery != null) {
                    discovery.publish(padv, 0, 31536000000L, 0x6DDD00L);
                }
            }
            catch (Throwable theMatter) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block9;
                LOG.warn((Object)"Failed adding relay route", theMatter);
            }
        }
    }

    public Vector getActiveRelays(PeerGroup pg) {
        try {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"get active Relays list");
            }
            if (this.activeRelays.size() != 0) {
                Vector<AccessPointAdvertisement> hops = new Vector<AccessPointAdvertisement>();
                Enumeration e = this.activeRelays.elements();
                while (e.hasMoreElements()) {
                    DiscoveryService discovery;
                    RouteAdvertisement route = (RouteAdvertisement)e.nextElement();
                    if (pg != null && (discovery = pg.getDiscoveryService()) != null) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("publishing route to active relay " + route.display()));
                        }
                        discovery.publish(route, 2, 1200000L, 1200000L);
                    }
                    hops.add(route.getDest());
                }
                return hops;
            }
            return null;
        }
        catch (Exception ex) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"error publishing active relay", (Throwable)ex);
            }
            return null;
        }
    }

    private static PeerID addr2pid(EndpointAddress addr) {
        try {
            EndpointAddress asAddress = new EndpointAddress(addr, null, null);
            return (PeerID)IDFactory.fromURL(IDFactory.jxtaURL("urn", "", "jxta:" + asAddress.getProtocolAddress()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RelayServerConnection {
        RelayClient client = null;
        Messenger messenger = null;
        EndpointAddress logicalAddress = null;
        String peerId = null;
        long leaseLength = 0L;
        long leaseObtainedAt = 0L;
        RdvAdvertisement relayAdv = null;
        EndpointAddress relayAddress = null;
        RdvAdvertisement alternateRelayAdv = null;
        boolean seeded = false;
        boolean flushNeeded = true;

        protected RelayServerConnection(RelayClient client, EndpointAddress addr) {
            this.client = client;
            this.relayAddress = new EndpointAddress(addr, null, null);
            this.seeded = true;
        }

        protected RelayServerConnection(RelayClient client, RdvAdvertisement relayAdv) {
            this.client = client;
            this.relayAdv = relayAdv;
            relayAdv.getRouteAdv().setDestPeerID(relayAdv.getPeerID());
        }

        protected boolean createMessenger(long leaseLengthToRequest) {
            if (this.messenger != null) {
                this.messenger.close();
                this.messenger = null;
            }
            Vector endpointAddresses = null;
            if (this.relayAdv != null) {
                AccessPointAdvertisement accessPointAdv;
                RouteAdvertisement routeAdv = this.relayAdv.getRouteAdv();
                if (routeAdv != null && (accessPointAdv = routeAdv.getDest()) != null) {
                    endpointAddresses = accessPointAdv.getVectorEndpointAddresses();
                }
            } else {
                endpointAddresses = new Vector(1);
                endpointAddresses.add(this.relayAddress.toString());
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("createMessenger to " + endpointAddresses));
            }
            if (endpointAddresses == null) {
                return false;
            }
            int i = 0;
            while (i < endpointAddresses.size()) {
                String s = (String)endpointAddresses.get(i);
                if (s != null) {
                    EndpointAddress addr = new EndpointAddress(s);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("find transport for " + addr));
                    }
                    Iterator transports = this.client.endpoint.getAllMessageTransports();
                    while (transports.hasNext() && this.messenger == null) {
                        MessageTransport transport = (MessageTransport)transports.next();
                        if (!(transport instanceof MessageSender) || !((MessageSender)transport).allowsRouting()) continue;
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("try transport " + transport));
                        }
                        if (!addr.getProtocolName().equals(transport.getProtocolName())) continue;
                        String reqStr = RelayTransport.createConnectString(leaseLengthToRequest, this.relayAdv == null, false);
                        EndpointAddress addrToUse = new EndpointAddress(addr, "EndpointService:" + this.client.groupName, this.client.serviceName + "/" + reqStr);
                        this.messenger = ((MessageSender)transport).getMessenger(addrToUse, null);
                        if (this.messenger != null && this.messenger.isClosed()) {
                            this.messenger = null;
                        }
                        if (this.messenger == null) continue;
                        this.logicalAddress = this.messenger.getLogicalDestinationAddress();
                        if (this.relayAdv != null && !RelayClient.addr2pid(this.logicalAddress).equals(this.relayAdv.getPeerID())) {
                            this.messenger.close();
                            this.messenger = null;
                            this.logicalAddress = null;
                        }
                        if (!(this.messenger instanceof BasicMessenger)) continue;
                        ((BasicMessenger)this.messenger).addPropertyChangeListener(this.client);
                        this.relayAddress = addr;
                    }
                }
                ++i;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("messenger=" + this.messenger));
            }
            return this.messenger != null;
        }

        protected boolean sendConnectMessage(long leaseLengthToRequest) {
            if (this.messenger == null || this.messenger.isClosed()) {
                return false;
            }
            Message message = RelayTransport.createConnectMessage(leaseLengthToRequest, this.relayAdv == null, this.flushNeeded);
            try {
                this.messenger.sendMessage(message, "EndpointService:" + this.client.groupName, this.client.serviceName + "/" + this.client.peerId);
            }
            catch (IOException e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"could not send connect message", (Throwable)e);
                }
                return false;
            }
            return true;
        }

        protected boolean sendDisconnectMessage() {
            if (this.messenger == null || this.messenger.isClosed()) {
                return false;
            }
            Message message = RelayTransport.createDisconnectMessage();
            try {
                this.messenger.sendMessage(message, "EndpointService:" + this.client.groupName, this.client.serviceName + "/" + this.client.peerId);
            }
            catch (IOException e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"could not send disconnect message", (Throwable)e);
                }
                return false;
            }
            return true;
        }

        public String toString() {
            return (this.relayAddress == null ? "(adv to " + this.relayAdv.getPeerID() + ")" : this.relayAddress.toString()) + " [" + this.leaseLength + ", " + this.leaseObtainedAt + "] ";
        }
    }
}

