/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.relay;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.relay.RelayServerClient;
import net.jxta.impl.endpoint.relay.RelayTransport;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RelayServer
implements MessageSender,
MessengerEventListener,
Runnable {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$relay$RelayServer == null ? (class$net$jxta$impl$endpoint$relay$RelayServer = RelayServer.class$("net.jxta.impl.endpoint.relay.RelayServer")) : class$net$jxta$impl$endpoint$relay$RelayServer).getName());
    private static final int MAX_CACHED_SERVERS = 20;
    private EndpointService endpointService = null;
    private DiscoveryService discoveryService = null;
    private EndpointAddress publicAddress = null;
    private HashMap relayedClients = new HashMap();
    protected String serviceName = null;
    private int maxClients = 0;
    private long maxLeaseLength = 0L;
    private long stallTimeout = 0L;
    private int clientQueueSize = 100;
    private long minBroadcastInterval = 600000L;
    private Thread gcThread = null;
    protected String peerId = null;
    protected PeerGroup group = null;
    protected RelayServerCache relayServerCache = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$relay$RelayServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRelayedClients() {
        HashMap hashMap = this.relayedClients;
        synchronized (hashMap) {
            Vector<String> res = new Vector<String>();
            Iterator entries = this.relayedClients.values().iterator();
            while (entries.hasNext()) {
                String client = ((RelayServerClient)entries.next()).toString();
                res.add(client);
            }
            return res;
        }
    }

    public RelayServer(PeerGroup group, String serviceName, int maxClients, long maxLeaseLength, long stallTimeout, int clientQueueSize, long minBroadcastInterval) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("RelayServer " + serviceName));
        }
        this.group = group;
        this.endpointService = group.getEndpointService();
        this.peerId = group.getPeerID().getUniqueValue().toString();
        this.publicAddress = new EndpointAddress("relay", this.peerId, null, null);
        this.serviceName = serviceName;
        this.maxClients = maxClients;
        this.maxLeaseLength = maxLeaseLength;
        this.clientQueueSize = clientQueueSize;
        this.minBroadcastInterval = minBroadcastInterval;
        this.stallTimeout = stallTimeout;
        boolean result = this.endpointService.addMessageTransport(this);
        this.relayServerCache = new RelayServerCache(this);
    }

    public void startServer() {
        block3: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("startServer " + this.publicAddress.toString()));
            }
            this.discoveryService = this.group.getDiscoveryService();
            try {
                this.discoveryService.publish(this.getRdvAdvertisement(), 2);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block3;
                LOG.debug((Object)"Could not publish Relay RdvAdvertisement", (Throwable)e);
            }
        }
        this.relayServerCache.startCache();
        this.endpointService.addMessengerEventListener(this, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        RelayServerClient[] oldClients;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("stopServer " + this.publicAddress.toString()));
        }
        this.relayServerCache.stopCache();
        this.endpointService.removeMessengerEventListener(this, 2);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Messenger Event Listener removed " + this.serviceName));
        }
        HashMap hashMap = this.relayedClients;
        synchronized (hashMap) {
            oldClients = this.relayedClients.values().toArray(new RelayServerClient[0]);
        }
        int i = oldClients.length;
        while (i-- > 0) {
            oldClients[i].closeClient();
        }
    }

    public EndpointAddress getPublicAddress() {
        return (EndpointAddress)this.publicAddress.clone();
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean allowsRouting() {
        return true;
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    public Messenger getMessenger(EndpointAddress destAddr, Object hintIgnored) {
        Messenger messenger = null;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("getMessenger for dest " + destAddr.toString()));
        }
        if (!"relay".equals(destAddr.getProtocolName())) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("could not make messenger for protocol :" + destAddr.getProtocolName()));
            }
            return null;
        }
        RelayServerClient handler = this.getClient(destAddr.getProtocolAddress());
        if (handler != null) {
            messenger = handler.getMessenger(this.publicAddress, destAddr, false);
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("messenger for " + destAddr.getProtocolAddress() + " is " + messenger));
        }
        return messenger;
    }

    public void propagate(Message msg, String serviceName, String serviceParams, String prunePeer) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"propagate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(EndpointAddress addr) {
        boolean result = false;
        RelayServerClient handler = null;
        HashMap hashMap = this.relayedClients;
        synchronized (hashMap) {
            handler = (RelayServerClient)this.relayedClients.get(addr.getProtocolAddress());
        }
        if (handler != null) {
            result = true;
        }
        return result;
    }

    public String getProtocolName() {
        return "relay";
    }

    public EndpointService getEndpointService() {
        return this.endpointService;
    }

    public boolean messengerReady(MessengerEvent event) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"messengerReady");
        }
        Messenger newMessenger = event.getMessenger();
        Object source = event.getSource();
        EndpointAddress connectionAddress = event.getConnectionAddress();
        if (newMessenger == null || source == null || connectionAddress == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"there was not a messenger or not enough information");
            }
            return false;
        }
        if (!this.serviceName.equals(connectionAddress.getServiceName())) {
            return false;
        }
        if (source instanceof MessageSender && !((MessageSender)source).allowsRouting()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"this is a higher level messenger");
            }
            return false;
        }
        if (source == this || newMessenger instanceof RelayServerClient.RelayMessenger) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"this is a relay messenger");
            }
            return false;
        }
        EndpointAddress destAddr = newMessenger.getLogicalDestinationAddress();
        if (destAddr == null || !"jxta".equals(destAddr.getProtocolName())) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"LogicalDestinationAddress is not a \"jxta\" protocol");
            }
            return false;
        }
        String clientPeerId = destAddr.getProtocolAddress();
        RelayServerClient handler = this.getClient(clientPeerId);
        if (handler != null) {
            return handler.addMessenger(newMessenger);
        }
        this.handleRequest(newMessenger, connectionAddress);
        return true;
    }

    protected RdvAdvertisement getRdvAdvertisement() {
        RdvAdvertisement rdvAdv = null;
        try {
            rdvAdv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(RdvAdvertisement.getAdvertisementType());
            rdvAdv.setPeerID(this.group.getPeerID());
            rdvAdv.setGroupID(this.group.getPeerGroupID());
            rdvAdv.setServiceName(this.serviceName);
            rdvAdv.setName(this.group.getPeerName());
            rdvAdv.setRouteAdv(RelayTransport.getRouteAdvertisement(this.group.getPeerAdvertisement()));
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Could not create Local RdvAdvertisement: ", (Throwable)e);
            }
            return null;
        }
        return rdvAdv;
    }

    protected void handleRequest(Messenger messenger, EndpointAddress connectionAddress) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"handleRequest from messenger");
        }
        String request = connectionAddress.getServiceParameter();
        EndpointAddress clientAddr = messenger.getLogicalDestinationAddress();
        if (clientAddr == null || !"jxta".equals(clientAddr.getProtocolName())) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"LogicalDestinationAddress is not a \"jxta\" protocol");
            }
            return;
        }
        String clientPeerId = clientAddr.getProtocolAddress();
        this.handleRequest(request, clientPeerId, messenger);
    }

    protected void handleRequest(Message message, EndpointAddress dstAddr) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"handleRequest from message");
        }
        String request = RelayTransport.getString(message, "request");
        String clientPeerId = dstAddr.getServiceParameter();
        this.handleRequest(request, clientPeerId, null);
    }

    void handleRequest(String request, String clientPeerId, Messenger messenger) {
        boolean closeMessenger;
        RelayServerClient closingHandler;
        block47: {
            if (request == null) {
                return;
            }
            request = request.toLowerCase();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("request = " + request));
            }
            if (clientPeerId == null) {
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("clientPeerId = " + clientPeerId));
            }
            if (clientPeerId == "unknown-unknown" && !request.startsWith("pid")) {
                return;
            }
            Message responseMessage = null;
            closingHandler = null;
            boolean rawMessenger = false;
            closeMessenger = false;
            if (request.startsWith("connect")) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("connect clientPeerId = " + clientPeerId));
                }
                long requestedLease = this.maxLeaseLength;
                boolean returnRelayAdv = false;
                boolean returnOtherRelayAdv = false;
                boolean flushQueue = false;
                String requestedLeaseString = null;
                int startIdx = request.indexOf(44);
                if (startIdx != -1) {
                    int endIdx = request.indexOf(44, startIdx + 1);
                    if (endIdx == -1) {
                        requestedLeaseString = request.substring(startIdx + 1);
                    } else {
                        requestedLeaseString = request.substring(startIdx + 1, endIdx);
                        String flags = request.substring(endIdx + 1);
                        if (flags.endsWith("true")) {
                            returnRelayAdv = true;
                        } else if (flags.endsWith("other")) {
                            returnOtherRelayAdv = true;
                        }
                        if (flags.startsWith("flush")) {
                            flushQueue = true;
                        }
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("request lease string = " + requestedLeaseString));
                    LOG.debug((Object)("return relay adv = " + returnRelayAdv));
                    LOG.debug((Object)("return other relay adv = " + returnOtherRelayAdv));
                    LOG.debug((Object)("flush queue = " + flushQueue));
                }
                if (requestedLeaseString != null) {
                    block46: {
                        try {
                            requestedLease = Long.parseLong(requestedLeaseString);
                        }
                        catch (NumberFormatException e) {
                            if (!LOG.isEnabledFor((Priority)Level.INFO)) break block46;
                            LOG.info((Object)"could not parse requested lease string");
                        }
                    }
                    if (requestedLease > this.maxLeaseLength) {
                        requestedLease = this.maxLeaseLength;
                    }
                }
                EndpointAddress clientAddr = new EndpointAddress("jxta", clientPeerId, this.serviceName, this.peerId);
                RelayServerClient handler = this.addClient(clientPeerId, requestedLease, messenger, flushQueue);
                if (handler != null) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("added client " + clientPeerId));
                    }
                    messenger = handler.getMessenger(this.publicAddress, clientAddr, true);
                    responseMessage = RelayTransport.createConnectedMessage(handler.getLeaseRemaining());
                    String stringRelayAdv = null;
                    if (returnRelayAdv) {
                        RdvAdvertisement relayAdv = this.getRdvAdvertisement();
                        if (relayAdv != null) {
                            stringRelayAdv = relayAdv.toString();
                        }
                    } else if (returnOtherRelayAdv) {
                        stringRelayAdv = this.relayServerCache.getRandomCacheAdv();
                    }
                    if (stringRelayAdv != null) {
                        RelayTransport.setString(responseMessage, "relayAdv", stringRelayAdv);
                    }
                } else {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("could not add client " + clientPeerId));
                    }
                    if (messenger == null) {
                        messenger = this.endpointService.getMessenger(clientAddr);
                        if (messenger != null) {
                            closeMessenger = true;
                        }
                    } else {
                        rawMessenger = true;
                    }
                    responseMessage = RelayTransport.createDisconnectedMessage();
                    String stringRelayAdv = this.relayServerCache.getRandomCacheAdv();
                    if (stringRelayAdv != null) {
                        RelayTransport.setString(responseMessage, "relayAdv", stringRelayAdv);
                    }
                }
            } else if ("disconnect".equals(request)) {
                if (clientPeerId != null && (closingHandler = this.removeClient(clientPeerId)) != null && LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("removed client " + clientPeerId));
                }
            } else if ("pid".equals(request)) {
                PeerGroupID groupOfMyPid = (PeerGroupID)this.group.getPeerID().getPeerGroupID();
                String pidStr = IDFactory.newPeerID(groupOfMyPid).toString();
                responseMessage = RelayTransport.createPIDResponseMessage(pidStr);
                rawMessenger = true;
            }
            if (messenger != null && responseMessage != null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sending response to client " + clientPeerId));
                }
                if (rawMessenger) {
                    new BGSend(messenger, responseMessage, this.serviceName, this.peerId);
                } else {
                    try {
                        messenger.sendMessage(responseMessage, this.serviceName, this.peerId);
                    }
                    catch (IOException e) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block47;
                        LOG.warn((Object)("could not send response message to " + clientPeerId), (Throwable)e);
                    }
                }
            }
        }
        if (closeMessenger) {
            messenger.close();
        }
        if (closingHandler != null) {
            closingHandler.closeClient();
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("relayedClients.size()=" + this.relayedClients.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelayServerClient getClient(String clientPeerId) {
        RelayServerClient handler = null;
        HashMap hashMap = this.relayedClients;
        synchronized (hashMap) {
            handler = (RelayServerClient)this.relayedClients.get(clientPeerId);
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("getClient(" + clientPeerId + ") = " + handler));
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelayServerClient addClient(String clientPeerId, long requestedLease, Messenger messenger, boolean flushQueue) {
        RelayServerClient handler = null;
        boolean isNewClient = false;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("addClient(" + clientPeerId + ")"));
        }
        HashMap hashMap = this.relayedClients;
        synchronized (hashMap) {
            handler = (RelayServerClient)this.relayedClients.get(clientPeerId);
            if (handler == null) {
                if (this.relayedClients.size() < this.maxClients && messenger != null && !messenger.isClosed()) {
                    handler = new RelayServerClient(this, clientPeerId, requestedLease, this.stallTimeout, this.clientQueueSize);
                    this.relayedClients.put(clientPeerId, handler);
                    isNewClient = true;
                    if (this.relayedClients.size() == 1 && this.gcThread == null) {
                        this.gcThread = new Thread(this);
                        this.gcThread.start();
                    }
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("new client denied. nb clients: " + this.maxClients + ", messenger: " + messenger));
                }
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("added = " + (handler != null)));
        }
        if (handler == null) {
            return null;
        }
        if (!handler.renewLease()) {
            return null;
        }
        if (flushQueue) {
            handler.flushQueue();
        }
        if (messenger != null) {
            handler.addMessenger(messenger);
            if (isNewClient) {
                EndpointAddress ear = new EndpointAddress("relay", clientPeerId, null, null);
                MessengerEvent me = new MessengerEvent(this, handler.getMessenger(this.publicAddress, ear, false), null);
                this.endpointService.getMessengerEventListener().messengerReady(me);
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelayServerClient removeClient(String clientPeerId) {
        RelayServerClient handler = null;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("removeClient(" + clientPeerId + ")"));
        }
        HashMap hashMap = this.relayedClients;
        synchronized (hashMap) {
            block7: {
                handler = (RelayServerClient)this.relayedClients.remove(clientPeerId);
                if (this.relayedClients.size() == 0 && this.gcThread != null) {
                    try {
                        this.gcThread.interrupt();
                    }
                    catch (SecurityException e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block7;
                        LOG.debug((Object)e);
                    }
                }
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClient(String clientPeerId, RelayServerClient handler) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("removeClient(" + clientPeerId + "," + handler + ")"));
        }
        HashMap hashMap = this.relayedClients;
        synchronized (hashMap) {
            block8: {
                RelayServerClient currentHandler = (RelayServerClient)this.relayedClients.get(clientPeerId);
                if (currentHandler == handler) {
                    this.relayedClients.remove(clientPeerId);
                }
                if (this.relayedClients.size() == 0 && this.gcThread != null) {
                    try {
                        this.gcThread.interrupt();
                    }
                    catch (SecurityException e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block8;
                        LOG.debug((Object)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"starting lease gc thread");
        }
        while (true) {
            HashMap hashMap = this.relayedClients;
            synchronized (hashMap) {
                if (this.relayedClients.size() == 0) {
                    this.gcThread = null;
                    break;
                }
            }
            this.doClientGC();
            HashMap hashMap2 = this.relayedClients;
            synchronized (hashMap2) {
                if (this.relayedClients.size() == 0) {
                    this.gcThread = null;
                    break;
                }
            }
            try {
                Thread.sleep(this.stallTimeout);
            }
            catch (InterruptedException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)e);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"stopping lease gc thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClientGC() {
        RelayServerClient[] handlers;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("start: check for expired client handler. # clients = " + this.relayedClients.size()));
        }
        HashMap hashMap = this.relayedClients;
        synchronized (hashMap) {
            handlers = this.relayedClients.values().toArray(new RelayServerClient[0]);
        }
        int i = handlers.length;
        while (i-- > 0) {
            try {
                handlers[i].isExpired();
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.INFO)) continue;
                LOG.info((Object)"Exception during client gc", (Throwable)e);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("stop: check for expired client handler. # clients = " + this.relayedClients.size()));
        }
    }

    private PeerID addr2pid(EndpointAddress addr) {
        try {
            EndpointAddress asAddress = new EndpointAddress(addr, null, null);
            return (PeerID)IDFactory.fromURL(IDFactory.jxtaURL("urn", "", "jxta:" + asAddress.getProtocolAddress()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class BGSend
    extends Thread {
        Messenger mr;
        Message ms;
        String sn;
        String ps;

        BGSend(Messenger mr, Message ms, String sn, String ps) {
            this.mr = mr;
            this.ms = ms;
            this.sn = sn;
            this.ps = ps;
            this.start();
        }

        public void run() {
            block2: {
                try {
                    this.mr.sendMessage(this.ms, this.sn, this.ps);
                }
                catch (IOException e) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                    LOG.warn((Object)("could not send response message to " + this.ps), (Throwable)e);
                }
            }
        }
    }

    private static class RelayServerCache
    implements PipeMsgListener,
    Runnable {
        RelayServer server;
        PipeAdvertisement pipeAdv;
        InputPipe inputPipe;
        volatile boolean doRun;
        Thread cacheThread;
        Map relayAdvCache;
        Random rand;
        static String pipeIDStr = "urn:jxta:uuid-59616261646162614E50472050325033DEADBEEFDEAFBABAFEEDBABE0000000F04";

        protected RelayServerCache(RelayServer server) {
            block2: {
                this.server = null;
                this.pipeAdv = null;
                this.inputPipe = null;
                this.doRun = false;
                this.cacheThread = null;
                this.relayAdvCache = new HashMap();
                this.rand = new Random();
                this.server = server;
                try {
                    ID pipeId = IDFactory.fromURL(IDFactory.jxtaURL(pipeIDStr));
                    this.pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
                    this.pipeAdv.setPipeID(pipeId);
                    this.pipeAdv.setType("JxtaPropagate");
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                    LOG.debug((Object)"Could not create pipe advertisement ", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int relayAdvCacheSize() {
            Map map = this.relayAdvCache;
            synchronized (map) {
                return this.relayAdvCache.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getRandomCacheAdv() {
            Map map = this.relayAdvCache;
            synchronized (map) {
                String[] items = this.relayAdvCache.values().toArray(new String[0]);
                if (items.length == 0) {
                    return null;
                }
                return items[this.rand.nextInt(items.length)];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean putCacheAdv(String peerId, String adv) {
            Map map = this.relayAdvCache;
            synchronized (map) {
                if (this.relayAdvCache.containsKey(peerId)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("updated cache entry for : " + peerId));
                    }
                    this.relayAdvCache.put(peerId, adv);
                    return false;
                }
                if (this.relayAdvCache.size() >= 20) {
                    String[] keys = this.relayAdvCache.keySet().toArray(new String[0]);
                    this.relayAdvCache.remove(keys[this.rand.nextInt(keys.length)]);
                }
                this.relayAdvCache.put(peerId, adv);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("created cache entry for : " + peerId));
                }
                return true;
            }
        }

        public void pipeMsgEvent(PipeMsgEvent event) {
            String relayAdv;
            Message message = event.getMessage();
            if (message == null) {
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"pipeMsgEvent()");
            }
            boolean isResponse = RelayTransport.getString(message, "response") != null;
            String peerId = RelayTransport.getString(message, "peerid");
            if (peerId == null || peerId.equals(this.server.peerId)) {
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("pipeMsgEvent() from " + peerId));
            }
            if ((relayAdv = RelayTransport.getString(message, "relayAdv")) == null) {
                return;
            }
            if (this.putCacheAdv(peerId, relayAdv)) {
                if (isResponse) {
                    return;
                }
                int i = this.relayAdvCacheSize();
                long magic = this.server.peerId.hashCode() % i;
                if ((long)this.rand.nextInt(i) == magic) {
                    OutputPipe retPipe;
                    block16: {
                        RdvAdvertisement myAdv = this.server.getRdvAdvertisement();
                        if (myAdv == null) {
                            return;
                        }
                        PeerID localPid = myAdv.getPeerID();
                        if (localPid == null) {
                            return;
                        }
                        PipeService pipeService = this.server.group.getPipeService();
                        if (pipeService == null) {
                            return;
                        }
                        retPipe = null;
                        try {
                            pipeService.createOutputPipe(this.pipeAdv, localPid, 2000L);
                            if (retPipe == null) {
                                return;
                            }
                            message = new Message();
                            RelayTransport.setString(message, "peerid", this.server.peerId);
                            RelayTransport.setString(message, "relayAdv", myAdv.toString());
                            RelayTransport.setString(message, "response", "t");
                            retPipe.send(message);
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)"Responded");
                            }
                        }
                        catch (IOException e) {
                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block16;
                            LOG.debug((Object)"Could not send reply on pipe ", (Throwable)e);
                        }
                    }
                    if (retPipe != null) {
                        retPipe.close();
                    }
                    return;
                }
            }
        }

        public void run() {
            OutputPipe outputPipe;
            block29: {
                outputPipe = null;
                PipeService pipeService = this.server.group.getPipeService();
                while (this.doRun && this.inputPipe == null) {
                    block27: {
                        try {
                            this.inputPipe = pipeService.createInputPipe(this.pipeAdv, this);
                        }
                        catch (IOException e) {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)"Could not create input pipe, try again");
                            }
                        }
                        catch (IllegalStateException e) {
                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block27;
                            LOG.debug((Object)"Pipe Service not ready yet, try again");
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)"wait interrupted");
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Created input pipe");
                }
                while (this.doRun && outputPipe == null) {
                    block28: {
                        try {
                            outputPipe = pipeService.createOutputPipe(this.pipeAdv, 5000L);
                        }
                        catch (IOException e) {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)"Could not create output pipe, try again");
                            }
                        }
                        catch (IllegalStateException e) {
                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block28;
                            LOG.debug((Object)"Pipe Service not ready yet, try again");
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)"wait interrupted ");
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Created output pipe");
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block29;
                    LOG.debug((Object)"wait interrupted");
                }
            }
            while (this.doRun) {
                block31: {
                    RdvAdvertisement adv;
                    block30: {
                        adv = this.server.getRdvAdvertisement();
                        try {
                            this.server.discoveryService.publish(adv, 2);
                        }
                        catch (IOException e) {
                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block30;
                            LOG.debug((Object)"Could not publish Relay RdvAdvertisement", (Throwable)e);
                        }
                    }
                    if (adv != null) {
                        Message message = new Message();
                        RelayTransport.setString(message, "peerid", this.server.peerId);
                        RelayTransport.setString(message, "relayAdv", adv.toString());
                        try {
                            outputPipe.send(message);
                        }
                        catch (IOException e) {
                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block31;
                            LOG.debug((Object)"Could not send message on pipe ", (Throwable)e);
                        }
                    }
                }
                long sleepTime = this.server.minBroadcastInterval + (long)((this.server.relayedClients.size() + 1) * 100 / (this.server.maxClients + 1)) * this.server.minBroadcastInterval;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sleepTime=" + sleepTime));
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"wait interrupted ", (Throwable)e);
                }
            }
            outputPipe.close();
        }

        protected void startCache() {
            this.doRun = true;
            this.cacheThread = new Thread((Runnable)this, "RelayCache");
            this.cacheThread.setDaemon(true);
            this.cacheThread.start();
        }

        protected void stopCache() {
            this.doRun = false;
            if (this.inputPipe != null) {
                this.inputPipe.close();
                this.inputPipe = null;
            }
            this.cacheThread.interrupt();
        }
    }
}

