/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.IllegalTransportLoopException;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.endpoint.MessengerPool;
import net.jxta.impl.endpoint.router.BadRoute;
import net.jxta.impl.endpoint.router.EndpointRouterMessage;
import net.jxta.impl.endpoint.router.RouteCM;
import net.jxta.impl.endpoint.router.RouteControl;
import net.jxta.impl.endpoint.router.RouteResolver;
import net.jxta.impl.endpoint.router.RouterMessenger;
import net.jxta.impl.util.FastHashMap;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EndpointRouter
implements EndpointListener,
MessageReceiver,
MessageSender,
MessengerEventListener,
Module {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$router$EndpointRouter == null ? (class$net$jxta$impl$endpoint$router$EndpointRouter = EndpointRouter.class$("net.jxta.impl.endpoint.router.EndpointRouter")) : class$net$jxta$impl$endpoint$router$EndpointRouter).getName());
    private Map routedRoutes = new FastHashMap(16);
    private Map triedAndFailed = new HashMap();
    protected EndpointAddress localPeerAddr = null;
    private ID localPeerId = null;
    EndpointService endpoint = null;
    private PeerGroup group = null;
    private static String routerPName = "jxta";
    public static final String routerSName = "EndpointRouter";
    private static String routerSParam = null;
    private Set newDestinations = Collections.synchronizedSet(new HashSet());
    private MessengerPool messengerPool;
    private Map badRoutes = new HashMap();
    protected Map pendingQueries = new HashMap();
    private Timer timer;
    private static final long MAXFINDROUTE_TIMEOUT = 15000L;
    private static final long MAXASYNC_GETMESSENGER_RETRY = 30000L;
    private PeerAdvertisement lastPeerAdv = null;
    private int lastModCount = -1;
    private RouteAdvertisement localRoute = null;
    private RouteCM routeCM = new RouteCM();
    private RouteResolver routeResolver = new RouteResolver();
    public static final Integer GET_ROUTE_CONTROL = new Integer(0);
    public static final int RouteControlOp = 0;
    public static final long ASYNC_MESSENGER_WAIT = 3000L;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$router$EndpointRouter;

    protected RouteAdvertisement getMyLocalRoute() {
        block7: {
            PeerAdvertisement newPadv = this.group.getPeerAdvertisement();
            int newModCount = newPadv.getModCount();
            if (this.lastPeerAdv == newPadv && this.lastModCount == newModCount) {
                return this.localRoute;
            }
            this.lastPeerAdv = newPadv;
            this.lastModCount = newModCount;
            TextElement endpParam = (TextElement)((Object)newPadv.getServiceParam(PeerGroup.endpointClassID));
            if (endpParam == null) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"getMyLocalRoute: no Endpoint Params");
                }
                return this.localRoute;
            }
            Enumeration paramChilds = endpParam.getChildren(RouteAdvertisement.getAdvertisementType());
            Element param = null;
            if (!paramChilds.hasMoreElements()) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"getMyLocalRoute: no Endpoint Route Adv");
                }
                return this.localRoute;
            }
            param = (Element)paramChilds.nextElement();
            try {
                RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
                route.setDestPeerID((PeerID)this.localPeerId);
                this.localRoute = route;
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)"getMyLocalRoute: error extracting route", (Throwable)ex);
            }
        }
        return this.localRoute;
    }

    protected boolean isLocalRoute(EndpointAddress pId) {
        return this.messengerPool.exists(pId);
    }

    protected boolean ensureLocalRoute(EndpointAddress pId) {
        return this.ensureLocalRoute(pId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ensureLocalRoute(EndpointAddress pId, Object hint) {
        Messenger m = this.messengerPool.snoop(pId);
        if (m == null) {
            boolean existed = this.messengerPool.exists(pId);
            m = this.messengerPool.get(pId, hint);
            if (m == null) {
                return false;
            }
            if (!existed) {
                this.newDestinations.add(pId);
            }
            this.messengerPool.release(m, pId);
            EndpointRouter endpointRouter = this;
            synchronized (endpointRouter) {
                this.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    void sendOnLocalRoute(EndpointAddress destination, Message message) throws IOException {
        Throwable failure;
        Messenger wm;
        OutgoingMessageEvent ev = null;
        LocalOutgoingListener localListener = new LocalOutgoingListener();
        while ((wm = this.messengerPool.get(destination, null)) != null) {
            void var5_5;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sending to " + destination + " found a messenger"));
            }
            localListener.reset();
            var5_5.sendMessage(message, routerSName, null, localListener);
            ev = localListener.waitEvent();
            this.messengerPool.release((Messenger)var5_5, destination);
            if (ev.getFailure() == null || ev.getFailure() instanceof RuntimeException) break;
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Trying next messenger to " + destination));
        }
        if (ev == null) {
            failure = new IOException("No longer any reachable endpoints to destination.");
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)failure);
            }
            ev = new OutgoingMessageEvent(message, failure);
        }
        if (ev.getFailure() != null) {
            failure = ev.getFailure();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sending to " + destination + " failed: " + failure.getMessage()));
            }
            if (failure instanceof IOException) {
                throw failure;
            }
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new UndeclaredThrowableException(failure);
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Sending to " + destination + " worked"));
        }
    }

    public void init(PeerGroup g, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new TimerThreadNamer("EndpointRouter Timer for " + g.getPeerGroupID()), 0L);
        this.group = g;
        this.endpoint = this.group.getEndpointService();
        this.localPeerId = this.group.getPeerID();
        this.localPeerAddr = new EndpointAddress(routerPName, this.group.getPeerID().getUniqueValue().toString(), null, null);
        this.messengerPool = new EndpointMessengerPool();
        this.routeCM.init(g, assignedID, impl, this);
        this.routeResolver.init(g, assignedID, impl, this);
        this.endpoint.addIncomingMessageListener(this, routerSName, null);
        this.endpoint.addMessageTransport(this);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Router Transport : " + assignedID);
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + this.group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + this.group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + this.group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tPeerID : " + this.localPeerId);
            configInfo.append("\n\t\tPublic Address : " + this.localPeerAddr);
            configInfo.append("\n\t\tUse Cm : " + this.routeCM.useRouteCM());
            configInfo.append("\n\t\tUse RouteResolver : " + this.routeResolver.useRouteResolver());
            LOG.info((Object)configInfo);
        }
    }

    public int startApp(String[] arg) {
        int status = 0;
        status = this.routeCM.startApp(arg);
        if (status != 0) {
            return status;
        }
        this.endpoint.addMessengerEventListener(this, 1);
        status = this.routeResolver.startApp(arg);
        if (status != 0) {
            return status;
        }
        this.routeCM.publishRoute(this.getMyLocalRoute());
        return status;
    }

    public void stopApp() {
        this.routeCM.stopApp();
        this.routeCM = null;
        this.routeResolver.stopApp();
        this.routeResolver = null;
        if (this.endpoint != null) {
            this.endpoint.removeIncomingMessageListener(routerSName, null);
            this.endpoint.removeMessengerEventListener(this, 1);
            this.endpoint.removeMessageTransport(this);
            this.endpoint = null;
        }
        this.messengerPool.close();
        this.timer.cancel();
        this.timer = null;
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowsRouting() {
        return false;
    }

    public EndpointService getEndpointService() {
        return this.endpoint;
    }

    public EndpointAddress getPublicAddress() {
        return (EndpointAddress)this.localPeerAddr.clone();
    }

    public Iterator getPublicAddresses() {
        return Collections.singletonList(this.getPublicAddress()).iterator();
    }

    public String getProtocolName() {
        return routerPName;
    }

    public void propagate(Message srcMsg, String pName, String pParam, String prunePeer) throws IOException {
    }

    EndpointAddress getGatewayAddress(EndpointAddress dest, boolean seekRoute) {
        return this.getGatewayAddress(dest, seekRoute, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EndpointAddress getGatewayAddress(EndpointAddress dest, boolean seekRoute, Object hint) {
        try {
            EndpointAddress pId = new EndpointAddress(dest, null, null);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getGatewayAddress for " + pId));
            }
            long quitAt = TimeUtils.toAbsoluteTimeMillis(15000L);
            long findRouteAt = TimeUtils.toAbsoluteTimeMillis(3000L);
            EndpointAddress addr = null;
            while (TimeUtils.toRelativeTimeMillis(quitAt) > 0L) {
                if (this.ensureLocalRoute(pId, hint)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("getGatewayAddress - Found local address: " + pId));
                    }
                    return pId;
                }
                RouteAdvertisement route = null;
                route = hint != null ? (RouteAdvertisement)hint : this.getRoute(pId, seekRoute);
                if (route != null && route.size() > 0) {
                    addr = this.pid2addr(route.getLastHop().getPeerID());
                    if (this.ensureLocalRoute(addr)) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("getGatewayAddress - Found last hop remote address: " + pId + " -> " + route.getLastHop().getPeerID()));
                        }
                        return addr;
                    }
                    addr = this.pid2addr(route.getFirstHop().getPeerID());
                    if (this.ensureLocalRoute(addr)) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("getGatewayAddress - Found first hop remote address first hop: " + pId + " -> " + route.getFirstHop().getPeerID()));
                        }
                        return addr;
                    }
                    this.removeRoute(pId);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("getGatewayAddress - Found no reachable route to " + pId));
                    }
                }
                if (!seekRoute || !this.routeResolver.useRouteResolver()) break;
                Long nextTry = (Long)this.triedAndFailed.get(pId);
                if (nextTry == null || nextTry < TimeUtils.toAbsoluteTimeMillis(30000L) || TimeUtils.toRelativeTimeMillis(findRouteAt) <= 0L) {
                    boolean doFind = false;
                    ClearPendingQuery t = null;
                    EndpointRouter endpointRouter = this;
                    synchronized (endpointRouter) {
                        t = (ClearPendingQuery)this.pendingQueries.get(pId);
                        if (t == null) {
                            doFind = true;
                            t = new ClearPendingQuery(pId);
                            this.pendingQueries.put(pId, t);
                        } else {
                            if (t.isFailed()) {
                                break;
                            }
                            if (t.isTimeToRetry()) {
                                doFind = true;
                            }
                        }
                    }
                    if (doFind) {
                        this.routeResolver.findRoute(pId);
                        seekRoute = false;
                    }
                }
                EndpointRouter endpointRouter = this;
                synchronized (endpointRouter) {
                    try {
                        if (this.messengerPool.snoop(pId) == null) {
                            this.wait(3000L);
                        }
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                }
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getGatewayAddress - No route to " + pId));
            }
            return null;
        }
        catch (Exception ex) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"getGatewayAddress exception", (Throwable)ex);
            }
            return null;
        }
    }

    public boolean ping(EndpointAddress addr) {
        EndpointAddress plainAddr = new EndpointAddress(addr, null, null);
        try {
            return this.getGatewayAddress(plainAddr, true) != null;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.debug((Object)("Ping failure (exception) for : " + plainAddr), (Throwable)e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean messengerReady(MessengerEvent event) {
        boolean haveMessenger;
        Messenger messenger = event.getMessenger();
        EndpointAddress logDest = messenger.getLogicalDestinationAddress();
        Object source = event.getSource();
        if (source instanceof MessageSender && !((MessageSender)source).allowsRouting()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Ignoring messenger to :" + logDest));
            }
            return false;
        }
        String originAddr = messenger.getDestinationAddress().getProtocolAddress();
        boolean reachable = true;
        if (!originAddr.equals(logDest.getProtocolAddress())) {
            int srcPort = Integer.parseInt(originAddr.substring(originAddr.lastIndexOf(58) + 1));
            reachable = srcPort != 0;
        }
        boolean taken = false;
        boolean bl = haveMessenger = this.messengerPool.snoop(logDest) != null;
        if (reachable || !haveMessenger) {
            boolean existed = haveMessenger || this.messengerPool.exists(logDest);
            boolean bl2 = taken = this.messengerPool.add(messenger, logDest, false) == 1;
            if (taken && !existed) {
                this.newDestinations.add(logDest);
            }
        }
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            this.notifyAll();
        }
        return taken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noMessenger(EndpointAddress logDest) {
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            Long curr = (Long)this.triedAndFailed.get(logDest);
            if (curr != null && curr > TimeUtils.toAbsoluteTimeMillis(30000L)) {
                this.triedAndFailed.put(logDest, new Long(TimeUtils.toAbsoluteTimeMillis(30000L)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean newMessenger(MessengerEvent event) {
        Messenger messenger = event.getMessenger();
        EndpointAddress logDest = messenger.getLogicalDestinationAddress();
        boolean existed = this.messengerPool.exists(logDest);
        if (this.messengerPool.add(messenger, logDest, false) == 1 && !existed) {
            this.newDestinations.add(logDest);
        }
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            this.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected RouteAdvertisement getRoute(EndpointAddress pId, boolean seekRoute) {
        route = null;
        var4_4 = this;
        synchronized (var4_4) {
            route = (RouteAdvertisement)this.routedRoutes.get(pId);
        }
        if (route != null || !seekRoute) {
            return route;
        }
        allRadvs = this.routeCM.getRouteAdv(pId);
        if (allRadvs != null) ** GOTO lbl37
        return null;
lbl-1000:
        // 1 sources

        {
            route = (RouteAdvertisement)allRadvs.next();
            newRoute = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            newRoute.setDest((AccessPointAdvertisement)route.getDest().clone());
            hops = route.getVectorHops();
            newHops = new Vector<Object>();
            if (hops.size() == 0) continue;
            i = hops.size() - 1;
            while (i >= 0) {
                addr = this.pid2addr(((AccessPointAdvertisement)hops.elementAt(i)).getPeerID());
                if (addr.equals(this.localPeerAddr)) continue block3;
                if (this.ensureLocalRoute(addr)) {
                    j = i;
                    while (j <= hops.size() - 1) {
                        newHops.add(((AccessPointAdvertisement)hops.elementAt(j)).clone());
                        ++j;
                    }
                    if (newHops.size() == 0) continue block3;
                    newRoute.setHops(newHops);
                    if (!this.setRoute(newRoute, false)) continue block3;
                    return newRoute;
                }
                --i;
            }
lbl37:
            // 6 sources

            ** while (allRadvs.hasNext())
        }
lbl38:
        // 1 sources

        return null;
    }

    private boolean checkRoute(RouteAdvertisement r) {
        if (r == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"route is null");
            }
            return false;
        }
        if (r.size() == 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"route is empty");
            }
            return false;
        }
        if (r.containsHop((PeerID)this.localPeerId)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"route contains this peer - loopback");
            }
            return false;
        }
        PeerID destPid = r.getDest().getPeerID();
        if (r.containsHop(destPid)) {
            Vector hops = r.getVectorHops();
            hops.remove(hops.lastElement());
            if (r.containsHop(destPid)) {
                return false;
            }
        }
        if (r.hasALoop()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"route has a loop ");
            }
            return false;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"route is ok");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setRoute(RouteAdvertisement r, boolean force) {
        PeerID pid = null;
        EndpointAddress pidAddr = null;
        boolean pushNeeded = false;
        boolean status = false;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"setRoute:");
        }
        if (r == null) {
            return false;
        }
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)r.display());
                }
                pid = r.getDest().getPeerID();
                pidAddr = this.pid2addr(pid);
                if (!force) {
                    BadRoute badRoute = (BadRoute)this.badRoutes.get(pidAddr);
                    if (badRoute != null) {
                        Long nextTry = badRoute.getExpiration();
                        if (nextTry > System.currentTimeMillis()) {
                            RouteAdvertisement routeClean = (RouteAdvertisement)r.cloneOnlyPIDs();
                            if (routeClean.equals(badRoute.getRoute())) {
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)"try to use a known bad route");
                                }
                                return false;
                            }
                        } else {
                            this.badRoutes.remove(pidAddr);
                        }
                    }
                } else {
                    this.badRoutes.remove(pidAddr);
                }
                if (this.isLocalRoute(pidAddr)) {
                    return false;
                }
                if (!this.checkRoute(r)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Route is invalid");
                    }
                    return false;
                }
                if (!this.isLocalRoute(this.pid2addr(r.getFirstHop().getPeerID()))) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Unreachable route - ignore");
                    }
                    return false;
                }
            }
            catch (Exception ez1) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Got an empty route - discard" + r.display()));
                }
                return false;
            }
            try {
                if (this.group.isRendezvous() && !this.routedRoutes.containsKey(pidAddr)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("push new SRDI route " + pid));
                    }
                    pushNeeded = true;
                }
                if (!this.routedRoutes.containsKey(pidAddr)) {
                    this.routeCM.createRoute(r);
                    this.newDestinations.add(pidAddr);
                }
                RouteAdvertisement newRoute = (RouteAdvertisement)r.cloneOnlyPIDs();
                this.routedRoutes.put(pidAddr, newRoute);
                this.badRoutes.remove(pidAddr);
                this.notifyAll();
                status = true;
            }
            catch (Exception e2) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("   failed setting route with " + e2));
                }
                status = false;
            }
        }
        if (pushNeeded && status) {
            this.routeResolver.pushSrdi(null, pid);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRoute(EndpointAddress pId) {
        boolean needRemove;
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            needRemove = false;
            if (this.routedRoutes.containsKey(pId)) {
                if (this.group.isRendezvous()) {
                    needRemove = true;
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("remove SRDI route " + pId));
                    }
                }
                this.routedRoutes.remove(pId);
            }
        }
        if (needRemove) {
            this.routeResolver.removeSrdi(null, this.addr2pid(pId));
        }
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        Object ip = null;
        EndpointAddress srcPeer = null;
        EndpointAddress destPeer = null;
        EndpointAddress lastHop = null;
        boolean connectLastHop = false;
        EndpointAddress origSrcAddr = null;
        EndpointAddress origDstAddr = null;
        Vector origHops = null;
        EndpointRouterMessage routerMsg = null;
        EndpointAddress nextHop = null;
        RouteAdvertisement radv = null;
        routerMsg = new EndpointRouterMessage(msg, false);
        if (!routerMsg.msgExists()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"processIncomingMessage: no routing info");
            }
            return;
        }
        try {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)routerMsg.display());
            }
            origSrcAddr = new EndpointAddress(routerMsg.getSrcAddress());
            origDstAddr = new EndpointAddress(routerMsg.getDestAddress());
            srcPeer = new EndpointAddress(origSrcAddr, null, null);
            destPeer = new EndpointAddress(origDstAddr, null, null);
            if (routerMsg.getLastHop() != null) {
                lastHop = new EndpointAddress(routerMsg.getLastHop());
            }
            if ((radv = routerMsg.getRouteAdv()) != null) {
                if (this.pid2addr(radv.getDestPeerID()).equals(lastHop)) {
                    connectLastHop = true;
                }
                this.updateRouteAdv(radv);
            }
        }
        catch (Exception badHdr) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Bad routing header or bad message. Message dropped.");
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"exception: ", (Throwable)badHdr);
            }
            return;
        }
        if (srcPeer != null && srcPeer.equals(this.localPeerAddr)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"processIncomingMessage: dropped loopback");
            }
            return;
        }
        if (lastHop != null && lastHop.equals(this.localPeerAddr)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"processIncomingMessage: dropped loopback from impersonating Peer");
            }
            return;
        }
        if (connectLastHop) {
            this.ensureLocalRoute(lastHop);
        }
        try {
            Vector reverseHops = routerMsg.getReverseHops();
            if (reverseHops == null) {
                reverseHops = new Vector();
            }
            if (!this.isLocalRoute(srcPeer) && lastHop != null && reverseHops.size() > 0 && ((AccessPointAdvertisement)reverseHops.firstElement()).getPeerID().equals(this.addr2pid(lastHop))) {
                this.setRoute(RouteAdvertisement.newRoute(this.addr2pid(srcPeer), (Vector)reverseHops.clone()), true);
            }
            if (destPeer.equals(this.localPeerAddr)) {
                routerMsg.clearAll();
                routerMsg.updateMessage();
                this.endpoint.processIncomingMessage(msg, origSrcAddr, origDstAddr);
                return;
            }
            AccessPointAdvertisement selfAp = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            selfAp.setPeerID(this.addr2pid(this.localPeerAddr));
            if (reverseHops.contains(selfAp)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Routing loop detected. Message dropped");
                }
                this.removeRoute(destPeer);
                return;
            }
            if (this.isLocalRoute(lastHop)) {
                reverseHops.add(0, selfAp);
                routerMsg.prependReverseHop(selfAp);
            } else {
                RouteAdvertisement newReverseRoute = (RouteAdvertisement)this.routedRoutes.get(srcPeer);
                if (newReverseRoute != null) {
                    reverseHops = (Vector)newReverseRoute.getVectorHops().clone();
                    reverseHops.add(0, selfAp);
                } else {
                    reverseHops = null;
                }
                routerMsg.setReverseHops(reverseHops);
            }
            origHops = routerMsg.getForwardHops();
            if (origHops != null) {
                nextHop = this.getNextHop(origHops);
            }
            if (this.isLocalRoute(destPeer)) {
                routerMsg.setForwardHops(null);
                nextHop = (EndpointAddress)destPeer.clone();
            } else {
                if (nextHop == null) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"No next hop in forward route - Using destination as next hop");
                    }
                    nextHop = (EndpointAddress)destPeer.clone();
                    routerMsg.setForwardHops(null);
                }
                if (!this.ensureLocalRoute(nextHop)) {
                    RouteAdvertisement route;
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Forward route element broken - trying alternate route");
                    }
                    if ((route = this.getRoute(destPeer, false)) == null) {
                        this.cantRoute("No new route to repair the route - drop message", null, origSrcAddr, destPeer, origHops);
                        return;
                    }
                    if (this.pid2addr(route.getFirstHop().getPeerID()).equals(nextHop)) {
                        this.removeRoute(destPeer);
                        this.cantRoute("No better route to repair the route - drop message", null, origSrcAddr, destPeer, origHops);
                        return;
                    }
                    EndpointAddress addr = this.pid2addr(route.getLastHop().getPeerID());
                    if (this.isLocalRoute(addr)) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Found new remote route via : " + addr));
                        }
                        routerMsg.setForwardHops(null);
                    } else {
                        Vector newHops = (Vector)route.getVectorHops().clone();
                        addr = this.pid2addr(((AccessPointAdvertisement)newHops.remove(0)).getPeerID());
                        if (!this.isLocalRoute(addr)) {
                            this.removeRoute(destPeer);
                            this.cantRoute("No usable route to repair the route - drop message", null, origSrcAddr, destPeer, origHops);
                            return;
                        }
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Found new remote route via : " + addr));
                        }
                        routerMsg.setForwardHops(newHops);
                    }
                    nextHop = addr;
                }
            }
            if (this.newDestinations.remove(nextHop)) {
                routerMsg.setRouteAdv(this.getMyLocalRoute());
            }
            routerMsg.setLastHop(this.localPeerAddr.toString());
            routerMsg.updateMessage();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Trying to forward to " + nextHop));
            }
            this.sendOnLocalRoute(nextHop, msg);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Successfully forwarded to " + nextHop));
            }
        }
        catch (Exception e) {
            this.cantRoute("failed to deliver or forward message: ", e, origSrcAddr, destPeer, origHops);
        }
    }

    private void cantRoute(String logMsg, Exception e, EndpointAddress origSrcAddr, EndpointAddress destPeer, Vector origHops) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            if (e == null) {
                LOG.debug((Object)logMsg);
            } else {
                LOG.debug((Object)logMsg, (Throwable)e);
            }
        }
        this.routeResolver.generateNACKRoute(this.addr2pid(origSrcAddr), this.addr2pid(destPeer), origHops);
    }

    private EndpointAddress getNextHop(Vector hops) {
        if (hops == null || hops.size() == 0) {
            return null;
        }
        Enumeration e = hops.elements();
        while (e.hasMoreElements()) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)e.nextElement();
            if (!this.localPeerId.equals(ap.getPeerID())) continue;
            if (!e.hasMoreElements()) {
                return null;
            }
            return this.pid2addr(((AccessPointAdvertisement)e.nextElement()).getPeerID());
        }
        return this.pid2addr(((AccessPointAdvertisement)hops.elementAt(0)).getPeerID());
    }

    private boolean isFast(MessageTransport p) {
        String name = p.getProtocolName();
        return name.equals("tcp") || name.equals("beep");
    }

    private boolean isRelay(MessageTransport p) {
        String name = p.getProtocolName();
        return name.equals("relay");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Messenger findBestReachableEndpoint(EndpointAddress dest, List mightWork, boolean exist) {
        ArrayList<Integer> rankings = new ArrayList<Integer>(mightWork.size());
        ArrayList<EndpointAddress> worthTrying = new ArrayList<EndpointAddress>(mightWork.size());
        Iterator eachMightWork = mightWork.iterator();
        block8: while (eachMightWork.hasNext()) {
            EndpointAddress addr = (EndpointAddress)eachMightWork.next();
            if (this.getProtocolName().equals(addr.getProtocolName())) continue;
            int rank = -1;
            Iterator eachTransport = this.endpoint.getAllMessageTransports();
            while (eachTransport.hasNext()) {
                MessageSender sender;
                MessageTransport transpt = (MessageTransport)eachTransport.next();
                if (!transpt.getProtocolName().equals(addr.getProtocolName()) || !(transpt instanceof MessageSender) || !(sender = (MessageSender)transpt).allowsRouting()) continue;
                ++rank;
                if (sender.isConnectionOriented()) {
                    rank += 2;
                }
                if (this.isRelay(transpt) && exist) {
                    rank -= 1000;
                }
                if (!this.isFast(transpt)) continue;
                rank += 4;
            }
            if (rank < 0) continue;
            int eachCurrent = 0;
            while (eachCurrent <= rankings.size()) {
                if (rankings.size() == eachCurrent) {
                    rankings.add(new Integer(rank));
                    worthTrying.add(addr);
                    continue block8;
                }
                if (rank > (Integer)rankings.get(eachCurrent)) {
                    rankings.add(eachCurrent, new Integer(rank));
                    worthTrying.add(eachCurrent, addr);
                    continue block8;
                }
                ++eachCurrent;
            }
        }
        rankings = null;
        Iterator eachWorthTrying = worthTrying.iterator();
        while (eachWorthTrying.hasNext()) {
            EndpointAddress addr = null;
            try {
                addr = (EndpointAddress)eachWorthTrying.next();
                eachWorthTrying.remove();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("getBestLocalRoute - Trying : " + addr));
                }
                Messenger messenger = null;
                EndpointGetMessengerAsyncListener getMessengerListener = new EndpointGetMessengerAsyncListener(this, dest);
                boolean stat = this.endpoint.getMessenger(getMessengerListener, new EndpointAddress(addr, routerSName, null), null);
                if (!stat) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"failed creating async messenger, continue");
                    }
                    EndpointRouter endpointRouter = this;
                    synchronized (endpointRouter) {
                        this.triedAndFailed.put(dest, new Long(TimeUtils.toAbsoluteTimeMillis(30000L)));
                        continue;
                    }
                }
                boolean quick = this.getRoute(dest, false) != null;
                messenger = getMessengerListener.waitForMessenger(quick);
                if (messenger == null) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"did not get our async messenger, bail out");
                    continue;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"we got our async messenger, proceed");
                }
                EndpointRouter endpointRouter = this;
                synchronized (endpointRouter) {
                    this.triedAndFailed.remove(dest);
                    this.notifyAll();
                }
                return messenger;
            }
            catch (Throwable e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("getBestLocalRoute - failed checking route : " + addr), e);
            }
        }
        return null;
    }

    Messenger findReachableEndpoint(EndpointAddress destPeer, boolean exist) {
        return this.findReachableEndpoint(destPeer, exist, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Messenger findReachableEndpoint(EndpointAddress destPeer, boolean exist, Object hint) {
        block20: {
            EndpointRouter endpointRouter = this;
            synchronized (endpointRouter) {
                Long nextTry = (Long)this.triedAndFailed.get(destPeer);
                if (nextTry != null && nextTry > TimeUtils.timeNow()) {
                    return null;
                }
                this.triedAndFailed.put(destPeer, new Long(TimeUtils.toAbsoluteTimeMillis(Long.MAX_VALUE)));
            }
            Iterator advs = null;
            try {
                Object addrs;
                advs = hint != null ? Collections.singletonList(hint).iterator() : this.routeCM.getRouteAdv(destPeer);
                if (advs != null) {
                    Messenger bestMessenger;
                    addrs = new ArrayList();
                    while (advs.hasNext()) {
                        RouteAdvertisement adv = (RouteAdvertisement)advs.next();
                        String saddr = null;
                        Enumeration e = adv.getDest().getEndpointAddresses();
                        while (e.hasMoreElements()) {
                            try {
                                saddr = (String)e.nextElement();
                                addrs.add(new EndpointAddress(saddr));
                            }
                            catch (Throwable ex) {
                                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                                LOG.debug((Object)(" bad address in route adv : " + saddr));
                            }
                        }
                    }
                    if (addrs.size() > 0 && (bestMessenger = this.findBestReachableEndpoint(destPeer, (List)addrs, exist)) != null) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"found direct route");
                        }
                        return bestMessenger;
                    }
                }
                addrs = this;
                synchronized (addrs) {
                    this.triedAndFailed.put(destPeer, new Long(TimeUtils.toAbsoluteTimeMillis(30000L)));
                }
            }
            catch (Throwable e) {
                EndpointRouter endpointRouter2 = this;
                synchronized (endpointRouter2) {
                    this.triedAndFailed.put(destPeer, new Long(TimeUtils.toAbsoluteTimeMillis(30000L)));
                }
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block20;
                LOG.warn((Object)"error looking for an address ", e);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("did not find a direct route to :" + destPeer));
        }
        return null;
    }

    public Messenger getMessenger(EndpointAddress addr, Object hint) {
        RouteAdvertisement routeHint = null;
        EndpointAddress plainAddr = new EndpointAddress(addr, null, null);
        if (plainAddr.equals(this.localPeerAddr)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"getMessenger: return LoopbackMessenger");
            }
            return new LoopbackMessenger(this.endpoint, this.localPeerAddr, addr, addr);
        }
        try {
            if (hint != null && hint instanceof RouteAdvertisement) {
                routeHint = (RouteAdvertisement)((RouteAdvertisement)hint).clone();
                AccessPointAdvertisement firstHop = routeHint.getFirstHop();
                PeerID firstHopPid = null;
                EndpointAddress firstHopAddr = null;
                if (firstHop != null) {
                    firstHopPid = firstHop.getPeerID();
                    firstHopAddr = this.pid2addr(firstHopPid);
                    if (firstHopAddr.equals(addr)) {
                        routeHint.removeHop(firstHopPid);
                        firstHop = null;
                    } else if (firstHopPid.equals(this.localPeerId)) {
                        firstHop = null;
                    }
                }
                if (firstHop == null) {
                    EndpointAddress da = this.pid2addr(routeHint.getDestPeerID());
                    if (!this.isLocalRoute(da) && !this.routedRoutes.containsKey(da)) {
                        this.routeCM.publishRoute(routeHint);
                    }
                } else {
                    RouteAdvertisement routeFirstHop = null;
                    if (!this.isLocalRoute(firstHopAddr) && !this.routedRoutes.containsKey(firstHopAddr)) {
                        routeFirstHop = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                        routeFirstHop.setDest((AccessPointAdvertisement)firstHop.clone());
                        this.updateRouteAdv(routeFirstHop);
                    }
                    if (this.ensureLocalRoute(firstHopAddr, routeFirstHop)) {
                        this.setRoute((RouteAdvertisement)routeHint.clone(), false);
                    }
                }
            }
        }
        catch (Throwable ioe) {
            return null;
        }
        try {
            return new RouterMessenger(this.getPublicAddress(), addr, this, routeHint);
        }
        catch (IOException caught) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getMessenger: can't generate messenger for addr " + addr + " " + caught.getMessage()));
            }
            return null;
        }
    }

    EndpointAddress addressMessage(Message message, EndpointAddress dstAddress) {
        EndpointRouterMessage routerMsg;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Create a new EndpointRouterMessage " + dstAddress));
        }
        if ((routerMsg = new EndpointRouterMessage(message, true)).isDirty()) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Possible transport recursion");
            }
            throw new IllegalTransportLoopException("RouterMessage element already present");
        }
        routerMsg.setSrcAddress(this.localPeerAddr.toString());
        routerMsg.setDestAddress(dstAddress.toString());
        EndpointAddress theGatewayAddress = null;
        EndpointAddress dstAddressPlain = null;
        try {
            RouteAdvertisement route = null;
            int attempt = 4;
            long quitAt = TimeUtils.toAbsoluteTimeMillis(60000L);
            while (theGatewayAddress == null) {
                if (attempt-- == 0 || TimeUtils.toRelativeTimeMillis(quitAt) < 0L) {
                    routerMsg.clearAll();
                    routerMsg.updateMessage();
                    return null;
                }
                theGatewayAddress = this.getGatewayAddress(dstAddress, true);
            }
            dstAddressPlain = new EndpointAddress(dstAddress, null, null);
            if (!theGatewayAddress.equals(dstAddressPlain)) {
                route = this.getRoute(dstAddressPlain, false);
            }
            if (route != null) {
                routerMsg.setForwardHops((Vector)route.getVectorHops().clone());
            }
            routerMsg.setLastHop(this.localPeerAddr.toString());
            boolean newDest = this.newDestinations.remove(dstAddressPlain);
            boolean newGatw = this.newDestinations.remove(theGatewayAddress);
            if (newDest || newGatw) {
                routerMsg.setRouteAdv(this.getMyLocalRoute());
            }
            routerMsg.updateMessage();
        }
        catch (Exception ez1) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Could not fully address message", (Throwable)ez1);
            }
            return null;
        }
        return theGatewayAddress;
    }

    public Object transportControl(Object operation, Object value) {
        if (!(operation instanceof Integer)) {
            return null;
        }
        int op = (Integer)operation;
        switch (op) {
            case 0: {
                return new RouteControl(this, this.localPeerId);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.debug((Object)"Invalid Transport Control operation argument");
        }
        return null;
    }

    protected PeerID addr2pid(EndpointAddress addr) {
        try {
            return (PeerID)IDFactory.fromURL(IDFactory.jxtaURL("urn", "", "jxta:" + addr.getProtocolAddress()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected EndpointAddress pid2addr(PeerID pid) {
        return new EndpointAddress(routerPName, pid.getUniqueValue().toString(), null, null);
    }

    protected void updateRouteAdv(RouteAdvertisement route) {
        this.updateRouteAdv(route, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRouteAdv(RouteAdvertisement route, boolean force) {
        block12: {
            try {
                PeerID pID = route.getDestPeerID();
                if (this.routeCM.updateRoute(route)) {
                    EndpointRouter endpointRouter = this;
                    synchronized (endpointRouter) {
                        Long nextTry = (Long)this.triedAndFailed.get(this.pid2addr(pID));
                        if (nextTry != null && nextTry <= TimeUtils.toAbsoluteTimeMillis(30000L)) {
                            this.triedAndFailed.remove(this.pid2addr(pID));
                            this.notifyAll();
                        }
                        break block12;
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)" new route is same as old one not publishing it");
                }
                if (!force) break block12;
                EndpointRouter endpointRouter = this;
                synchronized (endpointRouter) {
                    Long nextTry = (Long)this.triedAndFailed.get(this.pid2addr(pID));
                    if (nextTry != null && nextTry <= TimeUtils.toAbsoluteTimeMillis(30000L)) {
                        this.triedAndFailed.remove(this.pid2addr(pID));
                        this.notifyAll();
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block12;
                LOG.debug((Object)"  failure to publish route advertisement  response", (Throwable)e);
            }
        }
    }

    protected Vector cleanupAnyEdges(String src, Vector results) {
        Vector<PeerID> clean = new Vector<PeerID>(results.size());
        PeerID pid = null;
        Vector rpvId = this.routeResolver.getGlobalPeerView();
        int i = 0;
        while (i < results.size()) {
            pid = (PeerID)results.elementAt(i);
            if (!src.equals(pid.toString()) && !this.localPeerId.equals(pid)) {
                if (rpvId.contains(pid)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("valid rdv for SRDI forward " + pid));
                    }
                    clean.add(pid);
                } else {
                    this.routeResolver.removeSrdiIndex(pid);
                }
            }
            ++i;
        }
        return clean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPendingRouteQuery(EndpointAddress addr) {
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            return this.pendingQueries.containsKey(addr);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClearPendingQuery getPendingRouteQuery(EndpointAddress addr) {
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            return (ClearPendingQuery)this.pendingQueries.get(addr);
        }
    }

    protected boolean isRoutedRoute(EndpointAddress addr) {
        return this.routedRoutes.containsKey(addr);
    }

    protected Messenger snoopMessengerPool(EndpointAddress addr) {
        return this.messengerPool.snoop(addr);
    }

    protected Iterator getMessengerPoolAllDestinations() {
        return this.messengerPool.allDestinations().iterator();
    }

    protected Iterator getRoutedRouteAllDestinations() {
        return this.routedRoutes.entrySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator getAllRoutedRouteAddresses() {
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            return this.routedRoutes.keySet().iterator();
        }
    }

    protected Iterator getPendingQueriesAllDestinations() {
        return this.pendingQueries.entrySet().iterator();
    }

    protected RouteCM getRouteCM() {
        return this.routeCM;
    }

    protected RouteResolver getRouteResolver() {
        return this.routeResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBadRoute(EndpointAddress addr, BadRoute badRoute) {
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            this.badRoutes.put(addr, badRoute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BadRoute getBadRoute(EndpointAddress addr) {
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            return (BadRoute)this.badRoutes.get(addr);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalOutgoingListener
    implements OutgoingMessageEventListener {
        private volatile OutgoingMessageEvent event = null;
        protected boolean failed = false;

        private LocalOutgoingListener() {
        }

        public void reset() {
            this.event = null;
            this.failed = false;
        }

        public synchronized void messageSendFailed(OutgoingMessageEvent event) {
            this.event = event;
            this.failed = true;
            this.notify();
        }

        public synchronized void messageSendSucceeded(OutgoingMessageEvent event) {
            this.event = event;
            this.notify();
        }

        public synchronized OutgoingMessageEvent waitEvent() {
            while (this.event == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException i) {
                    Thread.interrupted();
                }
            }
            return this.event;
        }
    }

    private static class EndpointGetMessengerAsyncListener
    implements MessengerEventListener {
        volatile boolean hasResponse = false;
        volatile boolean isGone = false;
        private Messenger messenger = null;
        private EndpointRouter router = null;
        private EndpointAddress logDest = null;

        EndpointGetMessengerAsyncListener(EndpointRouter router, EndpointAddress logDest) {
            this.router = router;
            this.logDest = (EndpointAddress)logDest.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean messengerReady(MessengerEvent event) {
            Messenger toClose = null;
            EndpointGetMessengerAsyncListener endpointGetMessengerAsyncListener = this;
            synchronized (endpointGetMessengerAsyncListener) {
                this.hasResponse = true;
                if (event != null) {
                    this.messenger = event.getMessenger();
                    if (this.messenger != null && !this.messenger.getLogicalDestinationAddress().equals(this.logDest)) {
                        toClose = this.messenger;
                        this.messenger = null;
                    }
                } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("null messenger event for dest :" + this.logDest));
                }
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                if (this.messenger == null) {
                    LOG.debug((Object)("error creating messenger for dest :" + this.logDest));
                } else {
                    LOG.debug((Object)("got a new messenger for dest :" + this.logDest));
                }
            }
            if (this.messenger == null) {
                if (toClose != null) {
                    toClose.close();
                }
                this.router.noMessenger(this.logDest);
                EndpointGetMessengerAsyncListener endpointGetMessengerAsyncListener2 = this;
                synchronized (endpointGetMessengerAsyncListener2) {
                    this.notify();
                }
                return false;
            }
            EndpointGetMessengerAsyncListener endpointGetMessengerAsyncListener3 = this;
            synchronized (endpointGetMessengerAsyncListener3) {
                if (!this.isGone) {
                    this.notify();
                    return true;
                }
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("async caller gone add the messenger " + this.logDest));
            }
            return this.router.newMessenger(event);
        }

        public synchronized Messenger waitForMessenger(boolean quick) {
            if (!quick) {
                long quitAt = TimeUtils.toAbsoluteTimeMillis(3000L);
                while (TimeUtils.toRelativeTimeMillis(quitAt) > 0L) {
                    try {
                        if (this.hasResponse) break;
                        this.wait(3000L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                        break;
                    }
                }
            }
            this.isGone = true;
            return this.messenger;
        }
    }

    private class EndpointMessengerPool
    extends MessengerPool {
        private EndpointMessengerPool() {
        }

        public Messenger makeMessenger(EndpointAddress addr, Object hint) {
            boolean exist = this.snoop(addr) != null;
            return EndpointRouter.this.findReachableEndpoint(addr, exist, hint);
        }
    }

    protected class ClearPendingQuery
    extends TimerTask {
        EndpointAddress pid;
        volatile boolean failed = false;
        long timeToRetry = 0L;

        ClearPendingQuery(EndpointAddress pid) {
            this.pid = pid;
            EndpointRouter.this.timer.schedule((TimerTask)this, 60000L, 300000L);
            this.timeToRetry = TimeUtils.toAbsoluteTimeMillis(20000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                try {
                    if (this.failed) {
                        EndpointRouter endpointRouter = EndpointRouter.this;
                        synchronized (endpointRouter) {
                            EndpointRouter.this.pendingQueries.remove(this.pid);
                        }
                        this.cancel();
                        break block6;
                    }
                    this.failed = true;
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block6;
                    LOG.error((Object)("Uncaught Throwable in timer task " + Thread.currentThread().getName() + " for " + this.pid), all);
                }
            }
        }

        public synchronized boolean isTimeToRetry() {
            if (TimeUtils.toRelativeTimeMillis(this.timeToRetry) > 0L) {
                return false;
            }
            this.timeToRetry = TimeUtils.toAbsoluteTimeMillis(20000L);
            return true;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

