/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RouteCM {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$router$RouteCM == null ? (class$net$jxta$impl$endpoint$router$RouteCM = RouteCM.class$("net.jxta.impl.endpoint.router.RouteCM")) : class$net$jxta$impl$endpoint$router$RouteCM).getName());
    private boolean useCM = false;
    private boolean useCMDesired = true;
    public static final long DEFAULT_EXPIRATION = 1200000L;
    private PeerGroup group = null;
    private DiscoveryService discovery = null;
    private EndpointRouter router = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$router$RouteCM;

    protected boolean useRouteCM() {
        return this.useCM;
    }

    protected void disableRouteCM() {
        this.useCM = false;
    }

    protected void enableRouteCM() {
        this.useCM = true;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl, EndpointRouter router) throws PeerGroupException {
        Enumeration param;
        PlatformConfig confAdv = (PlatformConfig)group.getConfigAdvertisement();
        StructuredDocument paramBlock = null;
        if (confAdv != null) {
            paramBlock = confAdv.getServiceParam(assignedID);
        }
        if (paramBlock != null && (param = paramBlock.getChildren("useCM")).hasMoreElements()) {
            this.useCMDesired = Boolean.getBoolean(((TextElement)param.nextElement()).getTextValue());
        }
        this.group = group;
        this.router = router;
    }

    public int startApp(String[] arg) {
        this.discovery = this.group.getDiscoveryService();
        if (null == this.discovery) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Endpoint Router start stalled until discovery service available");
            }
            return 2;
        }
        this.useCM = this.useCMDesired;
        return 0;
    }

    public void stopApp() {
        this.discovery = null;
    }

    protected Iterator getRouteAdv(EndpointAddress pId) {
        ArrayList<RouteAdvertisement> result;
        block16: {
            ExtendableAdvertisement adv;
            Enumeration advs;
            String realPeerID;
            block15: {
                if (!this.useCM) {
                    return null;
                }
                realPeerID = null;
                try {
                    URL asUrl = IDFactory.jxtaURL("urn", "", "jxta:" + pId.getProtocolAddress());
                    realPeerID = asUrl.toString();
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("bad peer address: " + pId));
                    }
                    return null;
                }
                result = new ArrayList<RouteAdvertisement>(2);
                try {
                    advs = this.discovery.getLocalAdvertisements(2, "DstPID", realPeerID);
                    while (advs.hasMoreElements()) {
                        adv = (RouteAdvertisement)advs.nextElement();
                        if (result.contains(adv)) continue;
                        result.add((RouteAdvertisement)adv);
                    }
                }
                catch (Exception e1) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block15;
                    LOG.debug((Object)"  failed with ", (Throwable)e1);
                }
            }
            try {
                advs = this.discovery.getLocalAdvertisements(0, "PID", realPeerID);
                while (advs.hasMoreElements()) {
                    adv = (PeerAdvertisement)advs.nextElement();
                    TextElement endpParam = (TextElement)((Object)((PeerAdvertisement)adv).getServiceParam(PeerGroup.endpointClassID));
                    if (endpParam == null) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)"getRouteAdv: no Endpoint Params");
                        continue;
                    }
                    Enumeration paramChilds = endpParam.getChildren(RouteAdvertisement.getAdvertisementType());
                    Element param = null;
                    if (!paramChilds.hasMoreElements()) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)"getRouteAdv: no Route Adv in Peer Adv");
                        continue;
                    }
                    param = (Element)paramChilds.nextElement();
                    try {
                        RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
                        route.setDestPeerID(((PeerAdvertisement)adv).getPeerID());
                        if (result.contains(route)) continue;
                        this.discovery.publish(route, 2, 1200000L, 1200000L);
                        result.add(route);
                    }
                    catch (Exception ex) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)"Error processing route from padv", (Throwable)ex);
                    }
                }
            }
            catch (Exception e2) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block16;
                LOG.debug((Object)"  failed with ", (Throwable)e2);
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result.iterator();
    }

    protected void createRoute(RouteAdvertisement route) {
        block11: {
            if (!this.useCM) {
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"try to publish route ");
            }
            try {
                RouteAdvertisement newRoute = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                PeerID pId = route.getDestPeerID();
                URL asUrl = IDFactory.jxtaURL("urn", "", "jxta:" + this.router.pid2addr(pId).getProtocolAddress());
                String realPeerID = asUrl.toString();
                Enumeration advs = this.discovery.getLocalAdvertisements(2, "DstPID", realPeerID);
                if (advs == null || !advs.hasMoreElements()) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("could not find a route advertisement " + realPeerID));
                    }
                    return;
                }
                RouteAdvertisement dest = (RouteAdvertisement)advs.nextElement();
                newRoute.setDest(dest.getDest());
                Vector<AccessPointAdvertisement> newHops = new Vector<AccessPointAdvertisement>();
                Enumeration e = route.getHops();
                while (e.hasMoreElements()) {
                    AccessPointAdvertisement ap = (AccessPointAdvertisement)e.nextElement();
                    asUrl = IDFactory.jxtaURL("urn", "", "jxta:" + this.router.pid2addr(ap.getPeerID()).getProtocolAddress());
                    realPeerID = asUrl.toString();
                    advs = this.discovery.getLocalAdvertisements(2, "DstPID", realPeerID);
                    if (advs == null || !advs.hasMoreElements()) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("could not find a route advertisement for hop " + realPeerID));
                        }
                        return;
                    }
                    dest = (RouteAdvertisement)advs.nextElement();
                    newHops.add(dest.getDest());
                }
                if (newHops.size() == 0) {
                    return;
                }
                newRoute.setHops(newHops);
                this.discovery.publish(newRoute, 2, 1200000L, 1200000L);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("published new " + newRoute.display()));
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block11;
                LOG.debug((Object)("error publishing route" + route.display()), (Throwable)ex);
            }
        }
    }

    protected void publishRoute(RouteAdvertisement route) {
        block3: {
            if (!this.useCM) {
                return;
            }
            try {
                this.discovery.publish(route, 2, 1200000L, 1200000L);
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block3;
                LOG.error((Object)("error publishing route adv \n" + route), (Throwable)ex);
            }
        }
    }

    protected void flushRoute(EndpointAddress addr) {
        block9: {
            if (!this.useCM) {
                return;
            }
            try {
                URL asUrl = IDFactory.jxtaURL("urn", "", "jxta:" + addr.getProtocolAddress());
                String realPeerID = asUrl.toString();
                try {
                    Enumeration advs = this.discovery.getLocalAdvertisements(2, "DstPID", realPeerID);
                    if (advs != null && advs.hasMoreElements()) {
                        RouteAdvertisement badRouteAdv = (RouteAdvertisement)advs.nextElement();
                        this.discovery.flushAdvertisement(badRouteAdv);
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("remove RouteAdvertisement " + badRouteAdv.display()));
                        }
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    this.discovery.flushAdvertisements(realPeerID, 0);
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block9;
                    LOG.debug((Object)("remove  PeerAdvertisement " + realPeerID));
                }
                catch (IOException ex) {
                }
            }
            catch (IOException ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block9;
                LOG.warn((Object)("invlaid endpoint address " + addr));
            }
        }
    }

    protected boolean updateRoute(RouteAdvertisement route) {
        block5: {
            if (!this.useCM) {
                return false;
            }
            try {
                PeerID pID = route.getDestPeerID();
                URL asUrl = IDFactory.jxtaURL("urn", "", "jxta:" + this.router.pid2addr(pID).getProtocolAddress());
                String realPeerID = asUrl.toString();
                Enumeration advs = this.discovery.getLocalAdvertisements(2, "DstPID", realPeerID);
                if (advs != null && advs.hasMoreElements()) {
                    RouteAdvertisement oldRouteAdv = (RouteAdvertisement)advs.nextElement();
                    if (!route.equals(oldRouteAdv)) {
                        this.discovery.publish(route, 2, 1200000L, 1200000L);
                        return true;
                    }
                    break block5;
                }
                this.discovery.publish(route, 2, 1200000L, 1200000L);
                return true;
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block5;
                LOG.debug((Object)("  failure to publish route advertisement  response" + e));
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

