/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.jxta.document.AdvertisementFactory;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Messenger;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteCM;
import net.jxta.peer.PeerID;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RouteControl {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$router$RouteControl == null ? (class$net$jxta$impl$endpoint$router$RouteControl = RouteControl.class$("net.jxta.impl.endpoint.router.RouteControl")) : class$net$jxta$impl$endpoint$router$RouteControl).getName());
    public static final int OK = 0;
    public static final int ALREADY_EXIST = 1;
    public static final int FAILED = -1;
    public static final int DIRECT_ROUTE = 2;
    public static final int INVALID_ROUTE = 3;
    private EndpointRouter router = null;
    private RouteCM routeCM = null;
    private ID localPeerId = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$router$RouteControl;

    public RouteControl(EndpointRouter router, ID pid) {
        this.router = router;
        this.routeCM = router.getRouteCM();
        this.localPeerId = pid;
    }

    public RouteAdvertisement getMyLocalRoute() {
        return this.router.getMyLocalRoute();
    }

    public int addRoute(RouteAdvertisement newRoute) {
        RouteAdvertisement route = (RouteAdvertisement)newRoute.clone();
        if (route.getDestPeerID().equals(this.localPeerId)) {
            return 3;
        }
        AccessPointAdvertisement firstHop = route.getFirstHop();
        PeerID firstHopPid = null;
        EndpointAddress firstHopAddr = null;
        if (firstHop == null) {
            EndpointAddress da = this.router.pid2addr(route.getDestPeerID());
            if (!this.router.isLocalRoute(da) && !this.router.isRoutedRoute(da)) {
                if (this.router.ensureLocalRoute(da, route)) {
                    this.routeCM.publishRoute(route);
                    return 0;
                }
                return -1;
            }
            return 1;
        }
        RouteAdvertisement firstHopRoute = null;
        firstHopPid = firstHop.getPeerID();
        firstHopAddr = this.router.pid2addr(firstHopPid);
        if (!this.router.isLocalRoute(firstHopAddr) && !this.router.isRoutedRoute(firstHopAddr)) {
            firstHopRoute = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            firstHopRoute.setDest((AccessPointAdvertisement)firstHop.clone());
            this.router.updateRouteAdv(firstHopRoute);
        }
        if (this.router.ensureLocalRoute(firstHopAddr, firstHopRoute)) {
            this.router.setRoute((RouteAdvertisement)route.clone(), false);
            return 0;
        }
        return -1;
    }

    public RouteAdvertisement getRouteInfo(PeerID pId) {
        EndpointAddress pcaddr;
        RouteAdvertisement route = null;
        EndpointRouter.ClearPendingQuery entry = null;
        EndpointAddress addr = this.router.pid2addr(pId);
        Messenger oneOfThem = this.router.snoopMessengerPool(addr);
        EndpointAddress endpointAddress = pcaddr = oneOfThem == null ? null : oneOfThem.getDestinationAddress();
        if (pcaddr != null) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(pId);
            Vector<String> eas = new Vector<String>();
            eas.add(pcaddr.getProtocolName() + "://" + pcaddr.getProtocolAddress());
            ap.setEndpointAddresses(eas);
            route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            route.setDest(ap);
            return route;
        }
        route = this.router.getRoute(addr, false);
        if (route != null) {
            return route;
        }
        entry = this.router.getPendingRouteQuery(addr);
        if (entry != null) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(pId);
            Vector<String> eas = new Vector<String>();
            eas.add("pending " + (entry.isFailed() ? "(failed)" : "(new)"));
            ap.setEndpointAddresses(eas);
            route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            route.setDest(ap);
            return route;
        }
        AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        ap.setPeerID(pId);
        Vector<String> eas = new Vector<String>();
        eas.add("unknown");
        route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        route.setDest(ap);
        return route;
    }

    public int deleteRoute(PeerID pId) {
        if (pId.equals(this.localPeerId)) {
            return 3;
        }
        EndpointAddress addr = this.router.pid2addr(pId);
        if (this.router.isLocalRoute(addr)) {
            return 2;
        }
        this.router.removeRoute(addr);
        this.routeCM.flushRoute(addr);
        return 0;
    }

    public Vector getAllRoutesInfo() {
        Vector<RouteAdvertisement> routes;
        block7: {
            routes = new Vector<RouteAdvertisement>();
            EndpointAddress ea = null;
            try {
                Iterator it = this.router.getMessengerPoolAllDestinations();
                while (it.hasNext()) {
                    EndpointAddress pcaddr;
                    ea = (EndpointAddress)it.next();
                    AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
                    ap.setPeerID(this.router.addr2pid(ea));
                    Vector<String> eas = new Vector<String>();
                    Messenger oneOfThem = this.router.snoopMessengerPool(ea);
                    EndpointAddress endpointAddress = pcaddr = oneOfThem == null ? null : oneOfThem.getDestinationAddress();
                    if (pcaddr == null) {
                        eas.add("unknown");
                    } else {
                        eas.add(pcaddr.getProtocolName() + "://" + pcaddr.getProtocolAddress());
                    }
                    ap.setEndpointAddresses(eas);
                    RouteAdvertisement r = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                    r.setDest(ap);
                    routes.add(r);
                }
                Iterator i = this.router.getRoutedRouteAllDestinations();
                while (i.hasNext()) {
                    Map.Entry entry = (Map.Entry)i.next();
                    routes.add((RouteAdvertisement)entry.getValue());
                }
                Iterator it2 = this.router.getPendingQueriesAllDestinations();
                while (it2.hasNext()) {
                    Map.Entry entry = (Map.Entry)it2.next();
                    ea = (EndpointAddress)entry.getKey();
                    AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
                    ap.setPeerID(this.router.addr2pid(ea));
                    Vector<String> eas = new Vector<String>();
                    eas.add("pending " + (((EndpointRouter.ClearPendingQuery)entry.getValue()).isFailed() ? "(failed)" : "(new)"));
                    ap.setEndpointAddresses(eas);
                    RouteAdvertisement r = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                    r.setDest(ap);
                    routes.add(r);
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)"getAllRoutesInfo error : ", (Throwable)ex);
            }
        }
        return routes;
    }

    public boolean useRouteCM() {
        return this.router.getRouteCM().useRouteCM();
    }

    public boolean useRouteResolver() {
        return this.router.getRouteResolver().useRouteResolver();
    }

    public void enableRouteCM() {
        this.router.getRouteCM().enableRouteCM();
    }

    public void disableRouteCM() {
        this.router.getRouteCM().disableRouteCM();
    }

    public void enableRouteResolver() {
        this.router.getRouteResolver().enableRouteResolver();
    }

    public void disableRouteResolver() {
        this.router.getRouteResolver().disableRouteResolver();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

