/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Srdi;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.endpoint.router.BadRoute;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteCM;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.protocol.RouteQuery;
import net.jxta.impl.protocol.RouteResponse;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.impl.util.TimeUtils;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.protocol.SrdiMessage;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RouteResolver
implements QueryHandler,
SrdiHandler,
Srdi.SrdiInterface {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$router$RouteResolver == null ? (class$net$jxta$impl$endpoint$router$RouteResolver = RouteResolver.class$("net.jxta.impl.endpoint.router.RouteResolver")) : class$net$jxta$impl$endpoint$router$RouteResolver).getName());
    private boolean useRouteResolver = true;
    private PeerGroup group = null;
    private ResolverService resolver = null;
    private EndpointRouter router = null;
    private EndpointAddress localPeerAddr = null;
    private ID localPeerId = null;
    public final String routerSName = "EndpointRouter";
    private RouteCM routeCM = null;
    private int qid = 0;
    private MembershipService membership = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private SrdiIndex srdiIndex = null;
    private static final String srdiIndexerFileName = "routerSrdi";
    private Srdi srdi = null;
    private static final int NACKROUTE_QUERYID = -1;
    private static final long BADROUTE_EXPIRATION = 120000L;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$router$RouteResolver;

    protected boolean useRouteResolver() {
        return this.useRouteResolver;
    }

    protected void disableRouteResolver() {
        this.useRouteResolver = false;
    }

    protected void enableRouteResolver() {
        this.useRouteResolver = true;
    }

    RouteResolver() {
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl, EndpointRouter router) throws PeerGroupException {
        Enumeration param;
        PlatformConfig confAdv = (PlatformConfig)group.getConfigAdvertisement();
        StructuredDocument paramBlock = null;
        if (confAdv != null) {
            paramBlock = confAdv.getServiceParam(assignedID);
        }
        if (paramBlock != null && (param = paramBlock.getChildren("useRouteResolver")).hasMoreElements()) {
            this.useRouteResolver = Boolean.getBoolean(((TextElement)param.nextElement()).getTextValue());
        }
        this.group = group;
        this.router = router;
        this.localPeerId = group.getPeerID();
        this.localPeerAddr = new EndpointAddress("jxta", this.localPeerId.getUniqueValue().toString(), null, null);
    }

    public int startApp(String[] arg) {
        block7: {
            this.resolver = this.group.getResolverService();
            this.membership = this.group.getMembershipService();
            if (null == this.resolver) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Endpoint Router start stalled until resolver service available");
                }
                return 2;
            }
            if (null == this.membership) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Endpoint Router start stalled until membership service available");
                }
                return 2;
            }
            this.resolver.registerHandler("EndpointRouter", this);
            this.srdiIndex = new SrdiIndex(this.group, srdiIndexerFileName);
            this.srdi = new Srdi(this.group, "EndpointRouter", this, this.srdiIndex, 0L, 0L);
            this.resolver.registerSrdiHandler("EndpointRouter", this);
            try {
                Enumeration enumeration = this.membership.getCurrentCredentials();
                if (enumeration.hasMoreElements()) {
                    this.credential = (Credential)enumeration.nextElement();
                    this.credentialDoc = this.credential.getDocument(MimeMediaType.XMLUTF8);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block7;
                LOG.error((Object)"failed to get credential", (Throwable)e);
            }
        }
        this.routeCM = this.router.getRouteCM();
        return 0;
    }

    public void stopApp() {
        this.resolver.unregisterHandler("EndpointRouter");
        this.resolver.unregisterSrdiHandler("EndpointRouter");
        this.srdiIndex.stop();
        this.resolver = null;
        this.srdi = null;
        this.membership = null;
    }

    protected void findRoute(EndpointAddress peer) {
        block17: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"findRoute starts");
                LOG.debug((Object)("      peer= " + peer));
            }
            try {
                RouteQuery doc = null;
                BadRoute badRoute = this.router.getBadRoute(peer);
                if (badRoute != null) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("findRoute sends query: known bad Hops" + badRoute.display()));
                    }
                    doc = new RouteQuery(this.router.addr2pid(peer), this.router.getMyLocalRoute(), badRoute.getHops());
                } else {
                    doc = new RouteQuery(this.router.addr2pid(peer), this.router.getMyLocalRoute(), null);
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"findRoute sends query EndpointRouter");
                    LOG.debug((Object)("findRoute sends query for peer : " + peer));
                }
                ResolverQuery query = new ResolverQuery("EndpointRouter", this.credentialDoc, this.localPeerId.toString(), doc.toString(), this.qid++);
                if (this.group.isRendezvous()) {
                    Vector results = null;
                    if (this.srdiIndex != null) {
                        results = this.srdiIndex.query("route", "DstPID", this.router.addr2pid(peer).toString(), 10);
                        if (results != null && results.size() > 0) {
                            Vector clean = this.cleanupAnyEdges(query.getSrc(), results);
                            if (clean.size() > 0) {
                                query.incrementHopCount();
                                this.srdi.forwardQuery(clean, query, 1);
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)"found an srdi entry forwarding query to SRDI peer");
                                }
                                return;
                            }
                        } else {
                            PeerID destPeer = this.srdi.getReplicaPeer(this.router.addr2pid(peer).toString());
                            if (destPeer != null && !destPeer.equals(this.localPeerId)) {
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)("processQuery srdiIndex DHT forward :" + destPeer));
                                }
                                this.srdi.forwardQuery(destPeer.toString(), (ResolverQueryMsg)query);
                                return;
                            }
                        }
                    }
                }
                this.resolver = this.group.getResolverService();
                if (this.resolver != null) {
                    this.resolver.sendQuery(null, query);
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block17;
                    LOG.debug((Object)"find route query sent");
                    break block17;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"cannot get the resolver service");
                }
            }
            catch (Exception ee) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block17;
                LOG.debug((Object)"Exception in findRoute", (Throwable)ee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processResponse(ResolverResponseMsg response) {
        block29: {
            if (!this.useRouteResolver) {
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"processResponse got a response");
            }
            StringReader ip = null;
            RouteResponse doc = null;
            try {
                ip = new StringReader(response.getResponse());
                StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, ip);
                doc = new RouteResponse(asDoc);
            }
            catch (Throwable e) {
                try {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                    LOG.debug((Object)"processResponse: malformed response - discard", e);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (null != ip) {
                            ((Reader)ip).close();
                            ip = null;
                        }
                    }
                    catch (Throwable ignored) {}
                }
            }
            try {
                if (null != ip) {
                    ((Reader)ip).close();
                    ip = null;
                }
            }
            catch (Throwable ignored) {}
            RouteAdvertisement dstRoute = doc.getDestRoute();
            RouteAdvertisement srcRoute = doc.getSrcRoute();
            int queryId = response.getQueryId();
            if (dstRoute == null || srcRoute == null) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                LOG.debug((Object)"processResponse: malformed response - discard.");
                return;
            }
            EndpointAddress routingPeer = this.router.pid2addr(srcRoute.getDestPeerID());
            EndpointAddress destPeer = this.router.pid2addr(dstRoute.getDestPeerID());
            if (routingPeer == null || destPeer == null) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                LOG.debug((Object)"processResponse: malformed PeerID in response - discard.");
                return;
            }
            if (queryId == -1) {
                AccessPointAdvertisement badHop = dstRoute.nextHop(this.router.addr2pid(routingPeer));
                PeerID badPeer = null;
                badPeer = badHop != null ? badHop.getPeerID() : dstRoute.getDestPeerID();
                this.processBadRoute(badPeer, dstRoute);
                return;
            }
            if (!this.router.isLocalRoute(this.router.pid2addr(srcRoute.getDestPeerID())) && !this.router.isRoutedRoute(this.router.pid2addr(srcRoute.getDestPeerID()))) {
                this.router.updateRouteAdv(srcRoute);
            }
            if (destPeer.equals(routingPeer)) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                LOG.debug((Object)"learn route directly from the destination");
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("learn route:" + routingPeer));
            }
            try {
                RouteAdvertisement candidateRoute = RouteAdvertisement.newRoute(this.router.addr2pid(destPeer), this.router.addr2pid(routingPeer), (Vector)dstRoute.getVectorHops().clone());
                RouteAdvertisement.cleanupLoop(candidateRoute, (PeerID)this.localPeerId);
                if (candidateRoute.size() == 0) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Route response outdated: NACK responder");
                    }
                    this.generateNACKRoute(this.router.addr2pid(routingPeer), this.router.addr2pid(destPeer), dstRoute.getVectorHops());
                    return;
                }
                EndpointAddress candidateRouter = this.router.pid2addr(candidateRoute.getFirstHop().getPeerID());
                if (!this.router.ensureLocalRoute(candidateRouter)) {
                    RouteAdvertisement routeToRouter = this.router.getRoute(candidateRouter, false);
                    if (routeToRouter == null) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                        LOG.debug((Object)"Route response useless: no route to next router hop");
                        return;
                    }
                    if (!RouteAdvertisement.stichRoute(candidateRoute, routeToRouter, (PeerID)this.localPeerId)) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                        LOG.debug((Object)"Route response error stiching route response");
                        return;
                    }
                    this.router.setRoute(candidateRoute, false);
                } else {
                    this.router.setRoute(candidateRoute, false);
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block29;
                LOG.debug((Object)("Route response exception when building response route" + ex));
                LOG.debug((Object)("               bad dstRoute: " + dstRoute.display()));
            }
        }
        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
        LOG.debug((Object)"finish process route response successfully");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBadRoute(PeerID badHop, RouteAdvertisement dest) {
        EndpointAddress addr = this.router.pid2addr(dest.getDestPeerID());
        if (addr == null) {
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
            LOG.debug((Object)"remove bad route has a bad route info - discard");
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("remove bad route info for dest " + dest.display()));
            if (badHop != null) {
                LOG.debug((Object)("remove bad route bad hop " + badHop));
            }
        }
        try {
            BadRoute badRoute;
            RouteAdvertisement currentRoute = this.router.getRoute(addr, false);
            if (currentRoute == null) {
                return;
            }
            if (!currentRoute.equals(dest)) {
                if (!badHop.equals(this.router.addr2pid(addr))) {
                    if (badHop == null) return;
                    if (!currentRoute.containsHop(badHop)) {
                        return;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("current route is bad because it contains known bad hop" + badHop));
                    }
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("current route is bad because it contains known bad destination" + badHop));
                }
            }
            if ((badRoute = this.router.getBadRoute(addr)) != null) {
                Long nextTry = badRoute.getExpiration();
                if (nextTry <= System.currentTimeMillis()) {
                    nextTry = new Long(TimeUtils.toAbsoluteTimeMillis(120000L));
                    badRoute.setExpiration(nextTry);
                }
                Vector badHops = badRoute.getHops();
                if (badHop != null && !badHops.contains(badHop)) {
                    badHops.add(badHop);
                    nextTry = new Long(TimeUtils.toAbsoluteTimeMillis(120000L));
                    badRoute.setHops(badHops);
                    badRoute.setExpiration(nextTry);
                }
                this.router.setBadRoute(addr, badRoute);
                return;
            }
            Vector<PeerID> badHops = new Vector<PeerID>();
            if (badHop != null) {
                badHops.add(badHop);
            }
            badRoute = new BadRoute(dest, new Long(TimeUtils.toAbsoluteTimeMillis(120000L)), badHops);
            this.router.setBadRoute(addr, badRoute);
            this.routeCM.flushRoute(addr);
            this.router.removeRoute(addr);
            return;
        }
        catch (Exception ex) {
            if (!LOG.isEnabledFor((Priority)Level.WARN)) return;
            LOG.warn((Object)"exception during bad route removal", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processQuery(ResolverQueryMsg query) {
        if (!this.useRouteResolver) {
            return 0;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"processQuery starts");
        }
        RouteQuery routeQuery = null;
        StringReader ip = null;
        try {
            ip = new StringReader(query.getQuery());
            StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, ip);
            routeQuery = new RouteQuery(asDoc);
        }
        catch (Throwable e) {
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Malformed Route query ", e);
                }
                int n = 0;
                return n;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (null != ip) {
                        ((Reader)ip).close();
                        ip = null;
                    }
                }
                catch (Throwable ignored) {}
            }
        }
        try {
            if (null != ip) {
                ((Reader)ip).close();
                ip = null;
            }
        }
        catch (Throwable ignored) {}
        PeerID pId = routeQuery.getDestPeerID();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("processQuery: looking for route to " + pId));
        }
        RouteAdvertisement srcRoute = routeQuery.getSrcRoute();
        Vector badHops = routeQuery.getBadHops();
        if (LOG.isEnabledFor((Priority)Level.DEBUG) && badHops != null) {
            LOG.debug((Object)"processQuery: bad Hops");
            int i = 0;
            while (i < badHops.size()) {
                LOG.debug((Object)("processQuery:   :" + ((PeerID)badHops.elementAt(i)).toString()));
                ++i;
            }
        }
        if (srcRoute == null) {
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return 0;
            LOG.debug((Object)"No src Route in route query - discard ");
            return 0;
        }
        if (!srcRoute.getDestPeerID().equals(this.localPeerId)) {
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("processQuery: publishing sender route info " + srcRoute.getDestPeerID()));
                }
                if (!this.router.isLocalRoute(this.router.pid2addr(srcRoute.getDestPeerID())) && !this.router.isRoutedRoute(this.router.pid2addr(srcRoute.getDestPeerID()))) {
                    this.routeCM.publishRoute(srcRoute);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return 0;
                LOG.debug((Object)"Could not publish Route Adv from query - discard", (Throwable)e);
                return 0;
            }
        }
        if (pId == null) {
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return 0;
            LOG.debug((Object)"Malformed route query request, no PeerId - discard");
            return 0;
        }
        int queryId = query.getQueryId();
        EndpointAddress qReqAddr = this.router.pid2addr(pId);
        RouteAdvertisement route = null;
        boolean found = false;
        if (qReqAddr.equals(this.localPeerAddr)) {
            found = true;
            route = this.router.getMyLocalRoute();
        } else if (this.router.isLocalRoute(qReqAddr)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"processQuery: peer has direct route to destination ");
            }
            found = true;
            route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(pId);
            route.setDest(ap);
        } else {
            route = this.router.getRoute(qReqAddr, false);
            if (route != null) {
                found = true;
                int i = 0;
                while (i < badHops.size()) {
                    if (this.router.addr2pid(qReqAddr).equals((PeerID)badHops.elementAt(i))) {
                        this.processBadRoute((PeerID)badHops.elementAt(i), route);
                        found = false;
                        break;
                    }
                    if (route.containsHop((PeerID)badHops.elementAt(i))) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("processQuery: peer has bad route due to " + ((PeerID)badHops.elementAt(i)).toString()));
                        }
                        this.processBadRoute((PeerID)badHops.elementAt(i), route);
                        found = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (!found) {
            Vector results;
            if (!this.group.isRendezvous()) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return 0;
                LOG.debug((Object)"discard query forwarding as not a rendezvous");
                return 0;
            }
            if (query.getHopCount() < 2 && (results = this.srdiIndex.query("route", "DstPID", pId.toString(), 10)).size() > 0) {
                Vector clean;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("processQuery srdiIndex lookup match :" + results.size()));
                }
                if ((clean = this.cleanupAnyEdges(query.getSrc(), results)).size() > 0) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"found an srdi entry forwarding query to SRDI peer");
                    }
                    query.incrementHopCount();
                    this.srdi.forwardQuery(clean, query, 1);
                    return 0;
                }
            }
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return -1;
            LOG.debug((Object)"did not find a route or SRDI index");
            return -1;
        }
        try {
            if (route == null) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return 0;
                LOG.debug((Object)"we should have had a route at this point");
                return 0;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("processQuery: we have a route build route response" + route.display()));
            }
            RouteResponse routeResponse = new RouteResponse();
            routeResponse.setDestRoute(route);
            routeResponse.setSrcRoute(this.router.getMyLocalRoute());
            if (routeResponse == null) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return 0;
                LOG.debug((Object)"error creating route response");
                return 0;
            }
            ResolverResponseMsg res = query.makeResponse();
            res.setCredential(this.credentialDoc);
            res.setResponse(routeResponse.toString());
            this.resolver.sendResponse(query.getSrc(), res);
            return 0;
        }
        catch (Exception ee) {
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return 0;
            LOG.debug((Object)"processQuery: error while processing query ", (Throwable)ee);
            return 0;
        }
    }

    protected void generateNACKRoute(PeerID src, PeerID dest, Vector origHops) {
        if (this.resolver == null) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("generate NACK Route response " + src));
        }
        if (this.router.isPendingRouteQuery(this.router.pid2addr(src))) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("drop NACK due to pending route discovery " + src));
            }
            return;
        }
        RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        ap.setPeerID(dest);
        route.setDest(ap);
        route.setHops(origHops);
        RouteAdvertisement routeSrc = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        AccessPointAdvertisement apSrc = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        apSrc.setPeerID((PeerID)this.localPeerId);
        routeSrc.setDest(apSrc);
        RouteResponse routeResponse = new RouteResponse();
        routeResponse.setDestRoute(route);
        routeResponse.setSrcRoute(routeSrc);
        if (routeResponse == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"error creating route NACKresponse");
            }
            return;
        }
        ResolverResponse res = new ResolverResponse("EndpointRouter", this.credentialDoc, -1, routeResponse.toString());
        this.resolver.sendResponse(src.toString(), res);
    }

    public boolean processSrdi(ResolverSrdiMsg message) {
        SrdiMessageImpl srdiMsg;
        try {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Received a SRDI messsage in group" + this.group.getPeerGroupName()));
            }
            srdiMsg = new SrdiMessageImpl(new ByteArrayInputStream(message.getPayload().getBytes()));
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"corrupted SRDI message", (Throwable)e);
            }
            return false;
        }
        PeerID pid = srdiMsg.getPeerID();
        if (pid.equals(this.localPeerId)) {
            return false;
        }
        Vector entries = srdiMsg.getEntries();
        if (entries != null) {
            int i = 0;
            while (i < entries.size()) {
                SrdiMessage.Entry entry = (SrdiMessage.Entry)entries.elementAt(i);
                if (!entry.key.equals(this.localPeerId.toString())) {
                    String value = entry.value;
                    if (value == null) {
                        value = "";
                    }
                    this.srdiIndex.add(srdiMsg.getPrimaryKey(), "DstPID", entry.key, pid, entry.expiration);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Primary Key [" + srdiMsg.getPrimaryKey() + "] key [DstPID]" + " value [" + entry.key + "] exp [" + entry.expiration + "]"));
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public void pushEntries(boolean all) {
        this.pushSrdi(null, all);
    }

    protected void pushSrdi(String peer, boolean all) {
        block5: {
            Vector<SrdiMessage.Entry> routeIx = new Vector<SrdiMessage.Entry>();
            Iterator iterator = this.router.getAllRoutedRouteAddresses();
            while (iterator.hasNext()) {
                PeerID pid = this.router.addr2pid((EndpointAddress)iterator.next());
                SrdiMessage.Entry entry = new SrdiMessage.Entry(pid.toString(), "", Long.MAX_VALUE);
                routeIx.addElement(entry);
            }
            try {
                if (routeIx.size() == 0) {
                    return;
                }
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, "route", routeIx);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending a SRDI messsage of [All=" + all + "] routes"));
                }
                this.srdi.replicateEntries(srdiMsg);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"SRDI Push failed", (Throwable)e);
            }
        }
    }

    protected void pushSrdi(String peer, PeerID id) {
        block5: {
            try {
                PeerID destPeer;
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, "route", id.toString(), null, new Long(Long.MAX_VALUE));
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sending a router SRDI message add route " + id));
                }
                if (peer == null && (destPeer = this.srdi.getReplicaPeer(id.toString())) != null) {
                    peer = destPeer.toString();
                }
                if (peer != null && !peer.equals(this.localPeerId.toString())) {
                    this.srdi.pushSrdi(peer, srdiMsg);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"SRDI push failed", (Throwable)e);
            }
        }
    }

    protected void removeSrdi(String peer, PeerID id) {
        block4: {
            try {
                PeerID destPeer;
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, "route", id.toString(), null, new Long(0L));
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sending a router SRDI message delete route " + id));
                }
                if (peer == null && (destPeer = this.srdi.getReplicaPeer(id.toString())) != null && !destPeer.equals(this.localPeerId)) {
                    this.srdi.pushSrdi(destPeer.toString(), srdiMsg);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block4;
                LOG.debug((Object)"Removing srdi entry failed", (Throwable)e);
            }
        }
    }

    public void messageSendFailed(PeerID peerid, OutgoingMessageEvent e) {
        this.removeSrdiIndex(peerid);
    }

    protected Vector cleanupAnyEdges(String src, Vector results) {
        Vector<PeerID> clean = new Vector<PeerID>(results.size());
        PeerID pid = null;
        Vector rpvId = this.srdi.getGlobalPeerView();
        int i = 0;
        while (i < results.size()) {
            pid = (PeerID)results.elementAt(i);
            if (!src.equals(pid.toString()) && !this.localPeerId.equals(pid)) {
                if (rpvId.contains(pid)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("valid rdv for SRDI forward " + pid));
                    }
                    clean.add(pid);
                } else {
                    this.srdiIndex.remove(pid);
                }
            }
            ++i;
        }
        return clean;
    }

    protected Vector getGlobalPeerView() {
        return this.srdi.getGlobalPeerView();
    }

    protected void removeSrdiIndex(PeerID pid) {
        this.srdiIndex.remove(pid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

