/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.IllegalTransportLoopException;
import net.jxta.impl.endpoint.router.EndpointRouter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class RouterMessenger
extends BlockingMessenger {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$router$RouterMessenger == null ? (class$net$jxta$impl$endpoint$router$RouterMessenger = RouterMessenger.class$("net.jxta.impl.endpoint.router.RouterMessenger")) : class$net$jxta$impl$endpoint$router$RouterMessenger).getName());
    private EndpointAddress srcAddress = null;
    protected EndpointRouter router = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$router$RouterMessenger;

    public RouterMessenger(EndpointAddress srcAddress, EndpointAddress dstAddress, EndpointRouter r, Object hint) throws IOException {
        super(dstAddress);
        this.srcAddress = (EndpointAddress)srcAddress.clone();
        this.router = r;
        EndpointAddress plainAddr = new EndpointAddress(dstAddress, null, null);
        EndpointAddress gate = this.router.getGatewayAddress(plainAddr, true, hint);
        if (gate == null) {
            throw new IOException("Could not construct RouterMessenger, no route for " + plainAddr);
        }
    }

    public boolean sendMessage(Message message, String service, String serviceParam) throws IOException {
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)failure, (Throwable)failure);
            }
            throw failure;
        }
        EndpointAddress dest = this.getDestAddressToUse(service, serviceParam);
        Throwable lastFailure = null;
        while (true) {
            EndpointAddress sendTo = null;
            try {
                sendTo = this.router.addressMessage(message, dest);
                if (null != sendTo) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Sending " + message + " to " + sendTo));
                    }
                    this.router.sendOnLocalRoute(sendTo, message);
                    return true;
                }
            }
            catch (RuntimeException rte) {
                lastFailure = rte;
            }
            catch (Throwable theMatter) {
                if (sendTo == null) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break;
                    LOG.debug((Object)"unknown error while routing: ", theMatter);
                    break;
                }
                lastFailure = theMatter;
                EndpointAddress destPeer = new EndpointAddress(this.getDestinationAddress(), null, null);
                this.router.removeRoute(destPeer);
                message.removeMessageElement(message.getMessageElement("jxta", "EndpointRouterMsg"));
                continue;
            }
            break;
        }
        if (lastFailure == null) {
            lastFailure = new IOException("RouterMessenger - Could not find a route for : " + dest);
        }
        if (!(lastFailure instanceof IllegalTransportLoopException)) {
            this.close();
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Messenger failed:", lastFailure);
        }
        if (lastFailure instanceof IOException) {
            throw (IOException)lastFailure;
        }
        if (lastFailure instanceof RuntimeException) {
            throw lastFailure;
        }
        if (lastFailure instanceof Error) {
            throw (Error)lastFailure;
        }
        throw new UndeclaredThrowableException(lastFailure);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

