/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.EndpointServiceImpl;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HttpClientMessenger
extends BlockingMessenger {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$servlethttp$HttpClientMessenger == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpClientMessenger = HttpClientMessenger.class$("net.jxta.impl.endpoint.servlethttp.HttpClientMessenger")) : class$net$jxta$impl$endpoint$servlethttp$HttpClientMessenger).getName());
    private static String DEFAULT_RECEIVER_QUERY_STRING;
    private URL receiverURL = null;
    private URL senderURL = null;
    private EndpointService endpointService = null;
    private MessageElement srcAddressElement = null;
    private EndpointAddress logicalDest = null;
    private ServletHttpTransport servletHttpTransport;
    private TransportBindingMeter transportBindingMeter;
    private transient long lastUsed = System.currentTimeMillis();
    private BackChannelListener listener = null;
    private static HashMap backChannelListeners;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpClientMessenger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        BackChannelListener[] all;
        HashMap hashMap = backChannelListeners;
        synchronized (hashMap) {
            all = backChannelListeners.values().toArray(new BackChannelListener[0]);
        }
        int i = all.length;
        while (i-- > 0) {
            all[i].stopReceiving();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClientMessenger(EndpointService endpointService, ServletHttpTransport servletHttpTransport, String peerId, EndpointAddress destAddr) throws IOException {
        super(destAddr);
        this.endpointService = endpointService;
        this.servletHttpTransport = servletHttpTransport;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("peerId" + peerId));
        }
        EndpointAddress plainAddr = new EndpointAddress(destAddr, null, null);
        this.receiverURL = new URL(plainAddr.toString() + "/" + peerId + DEFAULT_RECEIVER_QUERY_STRING + "," + destAddr);
        this.senderURL = new URL(plainAddr.toString());
        EndpointAddress srcAddr = new EndpointAddress("jxta", peerId, null, null);
        this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", srcAddr.toString(), null);
        this.logicalDest = this.retreiveLogicalDestinationAddress();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("connected to " + this.logicalDest.toString()));
        }
        HashMap hashMap = backChannelListeners;
        synchronized (hashMap) {
            String hostName = HttpClientMessenger.getBackChannelName(this.receiverURL);
            this.listener = (BackChannelListener)backChannelListeners.get(hostName);
            if (this.listener == null) {
                this.listener = new BackChannelListener(this.receiverURL, endpointService, this.transportBindingMeter);
                backChannelListeners.put(hostName, this.listener);
                this.listener.addMessenger(this, false);
            } else {
                this.listener.addMessenger(this, destAddr.getServiceParameter() != null);
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("created messenger for " + hostName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        super.close();
        if (this.logicalDest == null || this.listener == null) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("close messenger to " + this.logicalDest.toString()));
        }
        HashMap hashMap = backChannelListeners;
        synchronized (hashMap) {
            if (this.listener.removeMessenger(this) == 0) {
                this.listener.stopReceiving();
            }
        }
    }

    public boolean sendMessage(Message message, String service, String serviceParam) throws IOException {
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)failure, (Throwable)failure);
            }
            throw failure;
        }
        message.replaceMessageElement("jxta", this.srcAddressElement);
        EndpointAddress destAddressToUse = this.getDestAddressToUse(service, serviceParam);
        StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddressToUse.toString(), (MessageElement)null);
        message.replaceMessageElement("jxta", dstAddressElement);
        try {
            this.doSend(message);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return true;
    }

    public EndpointAddress getLogicalDestinationAddress() {
        if (this.logicalDest == null) {
            return super.getLogicalDestinationAddress();
        }
        return this.logicalDest;
    }

    public boolean isIdle() {
        return this.isClosed() || System.currentTimeMillis() - this.lastUsed > 900000L;
    }

    private EndpointAddress retreiveLogicalDestinationAddress() throws IOException {
        byte[] peerIdBytes = null;
        long beginConnectTime = 0L;
        long connectTime = 0L;
        HttpURLConnection urlConn = (HttpURLConnection)this.senderURL.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setRequestMethod("GET");
        urlConn.setAllowUserInteraction(false);
        urlConn.setUseCaches(false);
        try {
            int code = urlConn.getResponseCode();
            if (code != 200) {
                throw new IOException("Message not accepted: HTTP status code=" + code + " reason=" + urlConn.getResponseMessage());
            }
        }
        catch (IOException ioe) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Peer URL could not be connected. May be down. ", (Throwable)ioe);
            }
            throw ioe;
        }
        int msglength = urlConn.getContentLength();
        if (msglength > 0) {
            InputStream inputStream = urlConn.getInputStream();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("message body (" + msglength + ") starts"));
            }
            peerIdBytes = new byte[msglength];
            int bytesRead = 0;
            while (bytesRead != msglength) {
                bytesRead = inputStream.read(peerIdBytes, bytesRead, msglength - bytesRead);
            }
            String peerIdString = new String(peerIdBytes);
            return new EndpointAddress("jxta", peerIdString, null, null);
        }
        throw new IOException("Could not get destination logical address");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(Message msg) throws IOException {
        long beginConnectTime = 0L;
        long connectTime = 0L;
        WireFormatMessage serialed = WireFormatMessageFactory.toWire(msg, EndpointServiceImpl.DEFAULT_MESSAGE_TYPE, null);
        MimeMediaType encoding = serialed.getContentEncoding();
        URL tempURL = new URL(this.senderURL, "");
        HttpURLConnection urlConn = (HttpURLConnection)tempURL.openConnection();
        try {
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setRequestMethod("POST");
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            if (null != encoding) {
                urlConn.setRequestProperty("content-encoding", serialed.getContentEncoding().toString());
            }
            urlConn.setRequestProperty("content-length", Integer.toString((int)serialed.getByteLength()));
            urlConn.setRequestProperty("content-type", serialed.getMimeType().toString());
            OutputStream out = urlConn.getOutputStream();
            serialed.sendToStream(out);
            out.flush();
            int code = urlConn.getResponseCode();
            if (code != 200) {
                throw new IOException("Message not accepted: HTTP status code=" + code + " reason=" + urlConn.getResponseMessage());
            }
            this.lastUsed = System.currentTimeMillis();
            Object var13_10 = null;
            urlConn.disconnect();
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            urlConn.disconnect();
            throw throwable;
        }
    }

    private static String getBackChannelName(URL url) {
        return url.getHost() + ":" + url.getPort();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String javaspec = System.getProperty("java.specification.version");
        DEFAULT_RECEIVER_QUERY_STRING = null == javaspec || javaspec.compareTo("1.4") < 0 ? "?120000,-1" : "?120000,120000";
        backChannelListeners = new HashMap();
    }

    private static class BackChannelListener
    implements Runnable {
        private volatile URL backChannelURL = null;
        private EndpointService endpointService = null;
        private TransportBindingMeter transportBindingMeter = null;
        private volatile Thread backChannelThread = null;
        private volatile HttpURLConnection currentConnection = null;
        private volatile boolean isStopped = false;
        private List messengerList = new ArrayList();
        private String backChannelName = null;
        private boolean currentThreadReady = false;

        private BackChannelListener(URL backChannelURL, EndpointService endpointService, TransportBindingMeter transportBindingMeter) {
            this.backChannelName = HttpClientMessenger.getBackChannelName(backChannelURL);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("new BackChannelListener for " + this.backChannelName));
            }
            this.backChannelURL = backChannelURL;
            this.endpointService = endpointService;
            this.transportBindingMeter = transportBindingMeter;
            this.backChannelThread = new Thread((Runnable)this, "HttpClientMessenger backChannel to " + this.backChannelName);
            this.backChannelThread.start();
        }

        protected synchronized int addMessenger(HttpClientMessenger messenger, boolean reopenBackChannel) throws IOException {
            if (this.isStopReceiving()) {
                throw new IOException("Could not use back channel, it is stopping");
            }
            this.messengerList.add(messenger);
            if (reopenBackChannel) {
                try {
                    while (!this.currentThreadReady) {
                        this.wait();
                    }
                }
                catch (InterruptedException ie) {
                    throw new IOException("Could not reopen back channel");
                }
                this.backChannelURL = messenger.receiverURL;
                this.backChannelThread = new Thread((Runnable)this, "HttpClientMessenger backChannel to " + this.backChannelName);
                if (this.currentConnection != null) {
                    HttpURLConnection conn = this.currentConnection;
                    this.currentConnection = null;
                    conn.disconnect();
                }
                this.backChannelThread.start();
            }
            return this.messengerList.size();
        }

        protected synchronized int removeMessenger(Messenger messenger) {
            if (this.isStopReceiving()) {
                return -1;
            }
            this.messengerList.remove(messenger);
            return this.messengerList.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopReceiving() {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("stopReceiving for " + this.backChannelName));
            }
            this.isStopped = true;
            String hostName = HttpClientMessenger.getBackChannelName(this.backChannelURL);
            HashMap hashMap = backChannelListeners;
            synchronized (hashMap) {
                if (backChannelListeners.get(hostName) == this) {
                    backChannelListeners.remove(hostName);
                }
            }
            HttpURLConnection holdIt = this.currentConnection;
            this.currentConnection = null;
            if (holdIt != null) {
                holdIt.disconnect();
            }
        }

        protected boolean isStopReceiving() {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("isStopReceiving for " + this.backChannelName + " is " + this.isStopped));
            }
            return this.isStopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BackChannelListener backChannelListener;
            try {
                long beginConnectTime = 0L;
                long connectTime = 0L;
                URLConnection conn = null;
                URL myBackChannelURL = this.backChannelURL;
                BackChannelListener backChannelListener2 = this;
                synchronized (backChannelListener2) {
                    this.currentThreadReady = true;
                    this.notifyAll();
                }
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("start receiving messages from " + this.backChannelName));
                }
                InputStream inputStream = null;
                while (!this.isStopReceiving()) {
                    try {
                        long messageReceivedTime = connectTime;
                        if (LOG.isEnabledFor((Priority)Level.DEBUG) && conn != null) {
                            LOG.debug((Object)("Content-Length = " + conn.getHeaderField("Content-Length")));
                            LOG.debug((Object)("Transfer-Encoding = " + conn.getHeaderField("Transfer-Encoding")));
                        }
                        while (!this.isStopReceiving()) {
                            Message incomingMsg;
                            block42: {
                                if (conn != null) {
                                    block41: {
                                        try {
                                            conn.connect();
                                        }
                                        catch (IOException ioe) {
                                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block41;
                                            LOG.debug((Object)"Unable to reconnect.", (Throwable)ioe);
                                        }
                                    }
                                    try {
                                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                            LOG.debug((Object)("waiting for response code from " + this.backChannelName));
                                        }
                                        if (((HttpURLConnection)conn).getResponseCode() != 200) {
                                            throw new IOException("HTTP Error: " + ((HttpURLConnection)conn).getResponseCode() + " " + ((HttpURLConnection)conn).getResponseMessage());
                                        }
                                    }
                                    catch (RuntimeException wrapper) {
                                        if (this.backChannelThread != Thread.currentThread()) {
                                            return;
                                        }
                                        conn = null;
                                        continue;
                                    }
                                    catch (ConnectException ce) {
                                        if (conn == this.currentConnection) {
                                            this.stopReceiving();
                                            continue;
                                        }
                                        if (this.backChannelThread != Thread.currentThread()) {
                                            return;
                                        }
                                        conn = null;
                                        continue;
                                    }
                                    inputStream = conn.getInputStream();
                                }
                                if (conn == null) {
                                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                        LOG.debug((Object)("Opening new connection to " + this.backChannelName));
                                    }
                                    conn = (HttpURLConnection)myBackChannelURL.openConnection();
                                    this.currentConnection = conn;
                                    conn.setDoOutput(false);
                                    conn.setDoInput(true);
                                    ((HttpURLConnection)conn).setRequestMethod("GET");
                                    conn.setAllowUserInteraction(false);
                                    conn.setUseCaches(false);
                                    continue;
                                }
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)("got response code from " + this.backChannelName));
                                }
                                incomingMsg = null;
                                try {
                                    incomingMsg = WireFormatMessageFactory.fromWire(inputStream, EndpointServiceImpl.DEFAULT_MESSAGE_TYPE, null);
                                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block42;
                                    LOG.debug((Object)("incoming message from " + this.backChannelName));
                                }
                                catch (EOFException e) {
                                    if (this.backChannelThread != Thread.currentThread()) {
                                        return;
                                    }
                                    conn = null;
                                    inputStream.close();
                                    continue;
                                }
                            }
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("message received from " + this.backChannelName));
                            }
                            this.endpointService.demux(incomingMsg);
                        }
                    }
                    catch (IOException e) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("failed to read message from " + this.backChannelName), (Throwable)e);
                        }
                        this.stopReceiving();
                        break;
                    }
                }
            }
            catch (Throwable argh) {
                backChannelListener = this;
                synchronized (backChannelListener) {
                    this.currentThreadReady = true;
                    this.notifyAll();
                }
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Backchannel listener existing because of uncaugth exception", argh);
                }
                this.stopReceiving();
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("stop receiving messages from " + this.backChannelName));
            }
            List theList = null;
            backChannelListener = this;
            synchronized (backChannelListener) {
                theList = this.messengerList;
                this.messengerList = null;
            }
            if (theList != null) {
                Iterator each = theList.iterator();
                while (each.hasNext()) {
                    Messenger messenger = (Messenger)each.next();
                    messenger.close();
                }
                theList.clear();
                theList = null;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("done removing messengers " + this.backChannelName));
            }
        }
    }
}

