/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.net.ConnectException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.impl.endpoint.servlethttp.HttpClientMessenger;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HttpMessageSender
implements MessageSender {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$servlethttp$HttpMessageSender == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpMessageSender = HttpMessageSender.class$("net.jxta.impl.endpoint.servlethttp.HttpMessageSender")) : class$net$jxta$impl$endpoint$servlethttp$HttpMessageSender).getName());
    private EndpointService endpointService = null;
    private ServletHttpTransport servletHttpTransport;
    private EndpointAddress publicAddress = null;
    private String peerId = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpMessageSender;

    public HttpMessageSender(EndpointService endpointService, ServletHttpTransport servletHttpTransport, EndpointAddress publicAddress, String peerId) {
        this.endpointService = endpointService;
        this.servletHttpTransport = servletHttpTransport;
        this.publicAddress = publicAddress;
        this.peerId = peerId;
    }

    public EndpointAddress getPublicAddress() {
        return (EndpointAddress)this.publicAddress.clone();
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean allowsRouting() {
        return true;
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    public void shutdown() {
        HttpClientMessenger.shutdown();
    }

    public Messenger getMessenger(EndpointAddress destAddr, Object hintIgnored) {
        block6: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getMessenger for dest : " + destAddr.toString()));
            }
            if (!this.getProtocolName().equals(destAddr.getProtocolName())) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("could not make messenger for protocol :" + destAddr.getProtocolName()));
                }
                return null;
            }
            try {
                return new HttpClientMessenger(this.endpointService, this.servletHttpTransport, this.peerId, destAddr);
            }
            catch (ConnectException noConnect) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                LOG.warn((Object)("Failed to connect to host for " + destAddr));
            }
            catch (Throwable e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                LOG.warn((Object)("could not make messenger for " + destAddr), e);
            }
        }
        return null;
    }

    public void propagate(Message msg, String serviceName, String serviceParams, String prunePeer) throws IOException {
    }

    public boolean ping(EndpointAddress addr) {
        boolean result = false;
        Messenger messenger = this.getMessenger(addr, null);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Using http client sender to ping " + addr));
        }
        return messenger != null;
    }

    public String getProtocolName() {
        return ServletHttpTransport.protocolName;
    }

    public EndpointService getEndpointService() {
        return this.endpointService;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

