/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.impl.endpoint.EndpointServiceImpl;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.servlethttp.HttpMessageReceiver;
import net.jxta.impl.endpoint.servlethttp.HttpServletMessenger;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HttpMessageServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$servlethttp$HttpMessageServlet == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpMessageServlet = HttpMessageServlet.class$("net.jxta.impl.endpoint.servlethttp.HttpMessageServlet")) : class$net$jxta$impl$endpoint$servlethttp$HttpMessageServlet).getName());
    private HttpMessageReceiver owner = null;
    private EndpointService endpoint = null;
    private EndpointAddress localAddress = null;
    private int pingResponseLength = 0;
    private byte[] pingResponseBytes = new byte[0];
    private ServletHttpTransport servletHttpTransport = null;
    private static final int MAX_POST_CONTENT_LEN = 0xA00000;
    private boolean destroyed = false;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpMessageServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.owner = (HttpMessageReceiver)this.getServletContext().getAttribute("HttpMessageReceiver");
            if (this.owner == null) {
                throw new ServletException("Servlet Context did not contain 'HttpMessageReceiver'");
            }
            this.servletHttpTransport = this.owner.getServletHttpTransport();
        }
        catch (ClassCastException e) {
            throw new ServletException("'HttpMessageReceiver' attribute was not of the proper type in the Servlet Context");
        }
        this.endpoint = this.owner.getEndpointService();
        String peerId = this.endpoint.getGroup().getPeerID().getUniqueValue().toString();
        this.localAddress = new EndpointAddress("jxta", peerId, null, null);
        this.pingResponseBytes = peerId.getBytes();
        this.pingResponseLength = this.pingResponseBytes.length;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("GET " + req.getQueryString() + " thread = " + Thread.currentThread()));
        }
        this.processRequest(req, res);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("GET done for thread = " + Thread.currentThread()));
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("POST " + req.getQueryString() + " thread = " + Thread.currentThread()));
        }
        this.processRequest(req, res);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("POST done for thread = " + Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HttpMessageServlet httpMessageServlet = this;
        synchronized (httpMessageServlet) {
            this.destroyed = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void processRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            int nl = 10;
            StringBuffer b = new StringBuffer();
            b.append("HTTP request:\n");
            b.append("  AUTH_TYPE: " + req.getAuthType() + '\n');
            b.append("  CONTEXT_PATH: " + req.getContextPath() + '\n');
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    b.append("  COOKIE[" + i + "]:" + '\n');
                    b.append("    comment: " + cookies[i].getComment() + '\n');
                    b.append("    domain: " + cookies[i].getDomain() + '\n');
                    b.append("    max age: " + cookies[i].getMaxAge() + '\n');
                    b.append("    name: " + cookies[i].getName() + '\n');
                    b.append("    path: " + cookies[i].getPath() + '\n');
                    b.append("    secure: " + cookies[i].getSecure() + '\n');
                    b.append("    value: " + cookies[i].getValue() + '\n');
                    b.append("    version: " + cookies[i].getVersion() + '\n');
                    ++i;
                }
            }
            Enumeration headers = req.getHeaderNames();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                b.append("  HEADER[" + header + "]: " + req.getHeader(header) + '\n');
            }
            b.append("  METHOD: " + req.getMethod() + '\n');
            b.append("  PATH_INFO: " + req.getPathInfo() + '\n');
            b.append("  PATH_TRANSLATED: " + req.getPathTranslated() + '\n');
            b.append("  QUERY_STRING: " + req.getQueryString() + '\n');
            b.append("  REMOTE_USER: " + req.getRemoteUser() + '\n');
            b.append("  REQUESTED_SESSION_ID: " + req.getRequestedSessionId() + '\n');
            b.append("  REQUEST_URI: " + req.getRequestURI() + '\n');
            b.append("  SERVLET_PATH: " + req.getServletPath() + '\n');
            b.append("  REMOTE_USER: " + req.getRemoteUser() + '\n');
            b.append("  isSessionIdFromCookie: " + req.isRequestedSessionIdFromCookie() + '\n');
            b.append("  isSessionIdFromURL: " + req.isRequestedSessionIdFromURL() + '\n');
            b.append("  isSessionIdValid: " + req.isRequestedSessionIdValid() + '\n');
            Enumeration attributes = req.getAttributeNames();
            while (attributes.hasMoreElements()) {
                String attribute = (String)attributes.nextElement();
                b.append("  ATTRIBUTE[" + attribute + "]: " + req.getAttribute(attribute) + '\n');
            }
            b.append("  ENCODING: " + req.getCharacterEncoding() + '\n');
            b.append("  CONTENT_LENGTH: " + req.getContentLength() + '\n');
            b.append("  CONTENT_TYPE: " + req.getContentType() + '\n');
            b.append("  LOCALE: " + req.getLocale().toString() + '\n');
            Enumeration parameters = req.getParameterNames();
            while (parameters.hasMoreElements()) {
                String parameter2 = (String)parameters.nextElement();
                b.append("  PARAMETER[" + parameter2 + "]: " + req.getParameter(parameter2) + '\n');
            }
            b.append("  PROTOCOL: " + req.getProtocol() + '\n');
            b.append("  REMOTE_ADDR: " + req.getRemoteAddr() + '\n');
            b.append("  REMOTE_HOST: " + req.getRemoteHost() + '\n');
            b.append("  SCHEME: " + req.getScheme() + '\n');
            b.append("  SERVER_NAME: " + req.getServerName() + '\n');
            b.append("  SERVER_PORT: " + req.getServerPort() + '\n');
            b.append("  isSecure: " + req.isSecure() + '\n');
            LOG.debug((Object)b);
        }
        long requestStartTime = 0L;
        long connectionEstablishedTime = 0L;
        long lastReadWriteTime = 0L;
        boolean requestSize = false;
        Object transportBindingMeter = null;
        String requestorPeerId = this.getRequestorPeerId(req);
        String queryString = req.getQueryString();
        String requestTimeoutString = null;
        String lazyCloseTimeoutString = null;
        String reqDestAddrString = null;
        if (queryString != null) {
            int commaIndex = queryString.indexOf(44);
            if (commaIndex == -1) {
                requestTimeoutString = queryString;
                lazyCloseTimeoutString = null;
            } else {
                requestTimeoutString = queryString.substring(0, commaIndex);
                lazyCloseTimeoutString = queryString.substring(commaIndex + 1);
                if ((commaIndex = lazyCloseTimeoutString.indexOf(44)) != -1) {
                    reqDestAddrString = lazyCloseTimeoutString.substring(commaIndex + 1);
                    lazyCloseTimeoutString = lazyCloseTimeoutString.substring(0, commaIndex);
                }
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("req.getQueryString() = " + queryString + ", requestTimeoutString = " + requestTimeoutString + ", lazyCloseTimeoutString = " + lazyCloseTimeoutString + ", reqDestAddrString = " + reqDestAddrString));
        }
        long timeout = this.getRequestTimeout(requestTimeoutString);
        long lazyCloseTimeout = this.getLazyCloseTimeout(lazyCloseTimeoutString);
        boolean hasMessageContent = this.hasMessageContent(req);
        if (null == requestorPeerId && !hasMessageContent) {
            this.pingResponse(res);
            return;
        }
        HttpServletMessenger messenger = null;
        if (null != requestorPeerId && -1L != timeout && null != reqDestAddrString) {
            EndpointAddress incomingAddr = new EndpointAddress("jxta", requestorPeerId, null, null);
            EndpointAddress reqDestAddr = new EndpointAddress(reqDestAddrString);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("creating back channel messenger for " + incomingAddr + " ( " + reqDestAddr + ")"));
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Making incoming messenger to: " + incomingAddr));
            }
            messenger = new HttpServletMessenger(this.localAddress, incomingAddr);
            boolean taken = this.endpoint.getMessengerEventListener().messengerReady(new MessengerEvent(this.owner, messenger, reqDestAddr));
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Incoming messenger to: " + incomingAddr + " taken=" + taken));
            }
            if (!taken) {
                messenger.close();
                messenger = null;
            }
        }
        Message incomingMessage = null;
        if (hasMessageContent) {
            ServletInputStream in = req.getInputStream();
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Constructing MessageImpl");
                }
                incomingMessage = WireFormatMessageFactory.fromWire((InputStream)in, EndpointServiceImpl.DEFAULT_MESSAGE_TYPE, null);
            }
            catch (IOException e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Malformed JXTA message, responding with BAD_REQUEST: ");
                }
                res.sendError(400, "Message was not a valid JXTA message");
                if (null != messenger) {
                    messenger.close();
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"ending request without returning a message");
                }
                return;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Sending OK in response to request");
        }
        boolean mustSetContentLength = true;
        res.setStatus(200);
        if (null != incomingMessage) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"posting message to endpoint demux");
            }
            this.endpoint.demux(incomingMessage);
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG) && messenger != null) {
            LOG.debug((Object)("messenger.isClosed() = " + messenger.isClosed()));
        }
        if (timeout != -1L) {
            long quitAt;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Wait for message from the messenger timeout = " + timeout));
            }
            Message outMsg = null;
            if (messenger == null) {
                try {
                    quitAt = System.currentTimeMillis() + timeout;
                    HttpMessageServlet httpMessageServlet = this;
                    synchronized (httpMessageServlet) {
                        long left;
                        while ((left = quitAt - System.currentTimeMillis()) > 0L && !this.destroyed) {
                            void var25_36;
                            ((Object)((Object)this)).wait((long)var25_36);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
            } else {
                outMsg = messenger.waitForMessage(timeout);
            }
            if (outMsg == null) {
                if (messenger != null) {
                    messenger.close();
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"terminating request with no message to send.");
                }
                return;
            }
            WireFormatMessage serialed = WireFormatMessageFactory.toWire(outMsg, EndpointServiceImpl.DEFAULT_MESSAGE_TYPE, null);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("sending message on back channel, length = " + serialed.getByteLength()));
            }
            if (lazyCloseTimeout == -1L) {
                res.setContentLength((int)serialed.getByteLength());
            }
            mustSetContentLength = false;
            ServletOutputStream out = res.getOutputStream();
            try {
                serialed.sendToStream((OutputStream)out);
                out.flush();
                messenger.messageSent(true);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"successfully sent message on back channel");
                }
            }
            catch (IOException ex) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Could not sent message on back channel");
                }
                messenger.messageSent(false);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"failed to send message on back channel");
                }
                res.flushBuffer();
                messenger.close();
                throw ex;
            }
            if (lazyCloseTimeout == -1L) {
                messenger.close();
            } else {
                quitAt = System.currentTimeMillis() + lazyCloseTimeout;
                while (!messenger.isClosed()) {
                    long tempTimeout = quitAt - System.currentTimeMillis();
                    if (tempTimeout <= 0L) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break;
                        LOG.debug((Object)"lazy close timed out");
                        break;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Wait for more messages from the messenger. timeout = " + tempTimeout));
                    }
                    if ((outMsg = messenger.waitForMessage(tempTimeout)) == null) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break;
                        LOG.debug((Object)"no additional message to send in response");
                        break;
                    }
                    serialed = WireFormatMessageFactory.toWire(outMsg, EndpointServiceImpl.DEFAULT_MESSAGE_TYPE, null);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("sending more message on back channel, length = " + serialed.getByteLength()));
                    }
                    try {
                        serialed.sendToStream((OutputStream)out);
                        out.flush();
                        messenger.messageSent(true);
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)"successfully sent more message on back channel");
                    }
                    catch (IOException ex) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"Could not sent message on back channel");
                        }
                        messenger.messageSent(false);
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"Failed to send more message on back channel");
                        }
                        messenger.close();
                        throw ex;
                    }
                }
                messenger.close();
            }
        }
        if (mustSetContentLength) {
            res.setContentLength(0);
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Done processing the request from " + req.getRemoteHost()));
        }
    }

    private String getRequestorPeerId(HttpServletRequest req) {
        String requestorPeerId = req.getPathInfo();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("req.getPathInfo() = " + requestorPeerId));
        }
        if (null != requestorPeerId) {
            int begin = 0;
            int end = requestorPeerId.length();
            while (begin < end && requestorPeerId.charAt(begin) == '/') {
                ++begin;
            }
            while (end - begin > 0 && requestorPeerId.charAt(end - 1) == '/') {
                --end;
            }
            requestorPeerId = begin == end ? null : requestorPeerId.substring(begin, end);
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("requestorPeerId = " + requestorPeerId));
        }
        return requestorPeerId;
    }

    private long getRequestTimeout(String requestTimeoutString) {
        long timeout;
        block5: {
            timeout = -1L;
            if (null != requestTimeoutString) {
                try {
                    timeout = Long.parseLong(requestTimeoutString);
                    if (timeout > 120000L || timeout == 0L) {
                        timeout = 120000L;
                    }
                }
                catch (NumberFormatException e) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                    LOG.warn((Object)("the requestTimeout does not contain a decimal number " + requestTimeoutString));
                }
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("requestTimeout = " + timeout));
        }
        return timeout;
    }

    private long getLazyCloseTimeout(String lazyCloseTimeoutString) {
        long timeout;
        block5: {
            timeout = -1L;
            if (null != lazyCloseTimeoutString) {
                try {
                    timeout = Long.parseLong(lazyCloseTimeoutString);
                    if (timeout > 120000L || timeout == 0L) {
                        timeout = 120000L;
                    }
                }
                catch (NumberFormatException e) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                    LOG.warn((Object)("the lazyCloseTimeoutString does not contain a decimal number " + lazyCloseTimeoutString));
                }
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("lazyCloseTimeout = " + timeout));
        }
        return timeout;
    }

    private boolean hasMessageContent(HttpServletRequest req) {
        String transferEncoding;
        boolean hasContent = false;
        int contentLength = req.getContentLength();
        if (contentLength > 0) {
            hasContent = true;
        } else if (contentLength == -1 && "chunked".equals(transferEncoding = req.getHeader("Transfer-Encoding"))) {
            hasContent = true;
        }
        return hasContent;
    }

    private void pingResponse(HttpServletResponse res) throws ServletException, IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"responding with 200 and peerID to request");
        }
        res.setStatus(200);
        res.setContentLength(this.pingResponseBytes.length);
        ServletOutputStream out = res.getOutputStream();
        out.write(this.pingResponseBytes);
        out.flush();
        out.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

