/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HttpServletMessenger
extends BlockingMessenger {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$servlethttp$HttpServletMessenger == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpServletMessenger = HttpServletMessenger.class$("net.jxta.impl.endpoint.servlethttp.HttpServletMessenger")) : class$net$jxta$impl$endpoint$servlethttp$HttpServletMessenger).getName());
    private static final int SEND_IDLE = 0;
    private static final int SEND_INPROGRESS = 1;
    private static final int SEND_SUCCESS = 2;
    private static final int SEND_FAIL = 3;
    private static final int SEND_TOOLONG = 4;
    private static final int MAX_SENDING_BLOCK = 120000;
    private static final int MAX_SENDING_WAIT = 3000;
    private static final EndpointAddress nullEndpointAddr = new EndpointAddress("http", "0.0.0.0:0", null, null);
    private EndpointAddress logicalAddress = null;
    private MessageElement srcAddressElement = null;
    private Thread currentOwner = null;
    private Message outgoingMessage = null;
    private int sendResult = 0;
    private long sendingSince = 0L;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpServletMessenger;

    public HttpServletMessenger(EndpointAddress srcAddress, EndpointAddress logicalAddress) {
        super(nullEndpointAddr);
        this.logicalAddress = logicalAddress;
        this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", srcAddress.toString(), null);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("HttpServletMessenger\n\t" + this.toString()));
        }
    }

    public EndpointAddress getLogicalDestinationAddress() {
        return (EndpointAddress)this.logicalAddress.clone();
    }

    public synchronized boolean sendMessage(Message message, String service, String serviceParam) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("send " + message + " to " + this.dstAddress.toString() + "\n\t" + this.toString()));
        }
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)failure, (Throwable)failure);
            }
            throw failure;
        }
        message.replaceMessageElement("jxta", this.srcAddressElement);
        EndpointAddress destAddressToUse = this.getDestAddressToUse(service, serviceParam);
        StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddressToUse.toString(), (MessageElement)null);
        message.replaceMessageElement("jxta", dstAddressElement);
        if (!this.doSend(message)) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("sendMessage failed (messenger closed).\n\t" + this.toString()), (Throwable)failure);
            }
            throw failure;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("sendMessage successful\n\t" + this.toString()));
        }
        return false;
    }

    public synchronized void close() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("close\n\t" + this.toString()));
        }
        super.close();
        this.notifyAll();
    }

    private boolean doSend(Message message) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("doSend()\n\t" + this.toString()));
        }
        if (this.isClosed()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.sendResult != 0) {
            if (this.sendResult == 4 && now > this.sendingSince + 120000L) {
                this.close();
            }
            return true;
        }
        this.sendResult = 1;
        this.outgoingMessage = message;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("message queued:" + message));
        }
        this.notifyAll();
        try {
            long left = 3000L;
            long quitAt = now + left;
            this.sendingSince = now;
            while (this.sendResult == 1 && !this.isClosed() && left > 0L) {
                this.wait(left);
                left = quitAt - System.currentTimeMillis();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("got result\n\t" + this.toString()));
        }
        this.currentOwner = null;
        this.outgoingMessage = null;
        boolean result = this.sendResult != 3;
        this.sendResult = this.sendResult == 1 ? 4 : 0;
        this.notifyAll();
        return result;
    }

    protected synchronized Message waitForMessage(long timeout) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("waitForMessage(" + timeout + ")\n\t" + this.toString()));
        }
        long timeOutAt = System.currentTimeMillis() + timeout;
        while (this.outgoingMessage == null && !this.isClosed()) {
            long tempTimeout = 0L;
            if (timeout != 0L) {
                tempTimeout = timeOutAt - System.currentTimeMillis();
                if (tempTimeout <= 0L) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break;
                    LOG.debug((Object)"waitForMessage timed out");
                    break;
                }
            } else {
                tempTimeout = 0L;
            }
            try {
                this.wait(tempTimeout);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("InterruptedException timeout = " + tempTimeout + "\n\t" + this.toString()), (Throwable)e);
            }
        }
        if (this.isClosed()) {
            return null;
        }
        Message tmp = this.outgoingMessage;
        this.outgoingMessage = null;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("got message: " + tmp));
        }
        if (tmp == null) {
            this.sendResult = 0;
            this.notifyAll();
        }
        return tmp;
    }

    protected synchronized void messageSent(boolean wasSuccessful) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("messageSent(" + wasSuccessful + ")\n\t" + this.toString()));
        }
        this.sendResult = this.sendResult == 4 ? 0 : (wasSuccessful ? 2 : 3);
        this.notifyAll();
    }

    public String toString() {
        String ownerStr = "";
        if (this.currentOwner != null) {
            ownerStr = Integer.toString(this.currentOwner.hashCode());
        }
        String msgStr = "";
        if (this.outgoingMessage != null) {
            msgStr = Integer.toString(this.outgoingMessage.hashCode());
        }
        return "[" + this.hashCode() + "] isClosed=" + this.isClosed() + " sendResult=" + this.sendResult + " owner=" + ownerStr + " outmsg=" + msgStr + " currentThread = " + Thread.currentThread().hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

