/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.config.Config;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.endpoint.servlethttp.HttpMessageReceiver;
import net.jxta.impl.endpoint.servlethttp.HttpMessageSender;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeter;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ServletHttpTransport
implements Module {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport == null ? (class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport = ServletHttpTransport.class$("net.jxta.impl.endpoint.servlethttp.ServletHttpTransport")) : class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport).getName());
    private static int minThreads = 10;
    private static int maxThreads = 100;
    private static int maxThreadIdleTime = 10000;
    private static int maxReqReadTime = 30000;
    protected static String protocolName = "http";
    private PeerGroup peerGroup = null;
    private HttpMessageSender sender = null;
    private HttpMessageReceiver receiver = null;
    private TransportMeter transportMeter;
    private TransportBindingMeter unknownTransportBindingMeter;
    private EndpointAddress publicAddress;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport;

    public void init(PeerGroup peerGroup, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.peerGroup = peerGroup;
        String peerId = peerGroup.getPeerID().getUniqueValue().toString();
        try {
            Enumeration httpChilds;
            Enumeration list;
            Properties prop = this.getJxtaProperties();
            this.initFromProperties(prop);
            ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
            ConfigParams peerAdv = peerGroup.getConfigAdvertisement();
            Element param = implAdv.getParam();
            if (param != null && (list = param.getChildren("Proto")).hasMoreElements()) {
                TextElement pname = (TextElement)list.nextElement();
            }
            if ((httpChilds = (param = peerAdv.getServiceParam(assignedID)).getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                param = (Element)httpChilds.nextElement();
                Attribute typeAttr = ((Attributable)((Object)param)).getAttribute("type");
                if (!HTTPAdv.getAdvertisementType().equals(typeAttr.getValue())) {
                    throw new IllegalArgumentException("transport adv is not an http adv");
                }
                if (httpChilds.hasMoreElements()) {
                    throw new IllegalArgumentException("configuration contained multiple http advertisements");
                }
            } else {
                throw new IllegalArgumentException("configuration did not contain http advertisement");
            }
            Advertisement paramsAdv = AdvertisementFactory.newAdvertisement((TextElement)param);
            if (!(paramsAdv instanceof HTTPAdv)) {
                throw new IllegalArgumentException("Provided Advertisement was not a " + HTTPAdv.getAdvertisementType());
            }
            HTTPAdv httpAdv = (HTTPAdv)paramsAdv;
            if (httpAdv.isProxyEnabled()) {
                this.configureProxyServer(httpAdv);
            }
            String interfaceAddressStr = httpAdv.getInterfaceAddress();
            boolean publicAddressOnly = httpAdv.getPublicAddressOnly();
            InetAddress usingInterface = null;
            if (interfaceAddressStr != null) {
                try {
                    usingInterface = InetAddress.getByName(interfaceAddressStr);
                }
                catch (UnknownHostException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Invalid address for local interface address, using default");
                    }
                    usingInterface = IPUtils.ANYADDRESS;
                }
            } else {
                usingInterface = IPUtils.ANYADDRESS;
            }
            int serverSocketPort = -1;
            try {
                serverSocketPort = httpAdv.getPort();
            }
            catch (NumberFormatException badint) {
                serverSocketPort = 0;
            }
            if (serverSocketPort < 1 || serverSocketPort > 65535) {
                throw new IllegalArgumentException("Illegal port value in advertisement :" + serverSocketPort);
            }
            EndpointService endpoint = peerGroup.getEndpointService();
            List publicAddresses = this.getPublicAddresses(httpAdv.isServerEnabled(), httpAdv.getServer(), usingInterface, serverSocketPort, publicAddressOnly);
            if (!httpAdv.isServerEnabled() && !httpAdv.isClientEnabled()) {
                throw new IllegalArgumentException("Neither incoming nor outgoing connections configured.");
            }
            this.publicAddress = (EndpointAddress)publicAddresses.get(0);
            if (httpAdv.isClientEnabled()) {
                this.sender = new HttpMessageSender(endpoint, this, this.publicAddress, peerId);
                endpoint.addMessageTransport(this.sender);
            }
            if (httpAdv.isServerEnabled()) {
                this.receiver = new HttpMessageReceiver(endpoint, this, publicAddresses, usingInterface, serverSocketPort, minThreads, maxThreads, maxThreadIdleTime, maxReqReadTime);
                endpoint.addMessageTransport(this.receiver);
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                StringBuffer configInfo = new StringBuffer("Configuring HTTP Transport : " + assignedID);
                configInfo.append("\n\tGroup Params:");
                configInfo.append("\n\t\tGroup: " + peerGroup.getPeerGroupName());
                configInfo.append("\n\t\tGroup ID: " + peerGroup.getPeerGroupID());
                configInfo.append("\n\t\tPeer ID: " + peerGroup.getPeerID());
                configInfo.append("\n\tFrom Adv:");
                configInfo.append("\n\t\tProtocol: " + httpAdv.getProtocol());
                configInfo.append("\n\t\tPublic address: " + (httpAdv.getServer() == null ? "(unspecified)" : httpAdv.getServer()));
                configInfo.append("\n\t\tInterface address: " + (interfaceAddressStr == null ? "(unspecified)" : interfaceAddressStr));
                configInfo.append("\n\tConfiguration :");
                configInfo.append("\n\t\tServer Enabled: " + httpAdv.getServerEnabled());
                configInfo.append("\n\t\tClient Enabled: " + httpAdv.isClientEnabled());
                configInfo.append("\n\t\tUnicast Server Bind Addr: " + usingInterface.getHostAddress() + ":" + serverSocketPort);
                configInfo.append("\n\t\tPublic Addresses: ");
                configInfo.append("\n\t\t\tDefault Endpoint Addr : " + this.publicAddress);
                Iterator eachPublic = publicAddresses.iterator();
                while (eachPublic.hasNext()) {
                    EndpointAddress anAddr = (EndpointAddress)eachPublic.next();
                    configInfo.append("\n\t\t\tEndpoint Addr : " + anAddr);
                }
                LOG.info((Object)configInfo);
            }
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Failure during initialization: ", e);
            }
            throw new PeerGroupException("Failure during initialization", e);
        }
    }

    public int startApp(String[] args) {
        block2: {
            if (this.receiver == null) break block2;
            try {
                this.receiver.startServer();
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"Could not start http message receiver", (Throwable)e);
            }
        }
        return 0;
    }

    public void stopApp() {
        if (this.receiver != null) {
            this.receiver.stopServer();
        }
        if (this.sender != null) {
            this.sender.shutdown();
        }
    }

    public EndpointService getEndpointService() {
        return this.peerGroup.getEndpointService();
    }

    private void configureProxyServer(HTTPAdv httpAdv) {
        String proxyName = httpAdv.getProxy();
        if (proxyName != null) {
            String host = proxyName;
            String port = "8080";
            int sepAt = proxyName.lastIndexOf(58);
            if (-1 != sepAt) {
                host = proxyName.substring(0, sepAt);
                port = proxyName.substring(sepAt + 1);
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Configuring HTTP proxy server: host" + host + ":" + port));
            }
            Properties prop = System.getProperties();
            prop.put("http.proxyHost", host);
            prop.put("http.proxyPort", port);
        } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"Configuration error: proxy server turned on, but no proxy server specified");
        }
    }

    private Properties getJxtaProperties() {
        FileInputStream in;
        Properties prop;
        block9: {
            prop = null;
            in = null;
            try {
                in = new FileInputStream(Config.JXTA_HOME + "jxta.properties");
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Read jxta.properties from present working directory");
                }
            }
            catch (FileNotFoundException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block9;
                LOG.debug((Object)"no jxta.properties from present working directory");
            }
        }
        if (in != null) {
            try {
                prop = new Properties();
                prop.load(in);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Error reading jxta.properties");
                }
                prop = null;
            }
        } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"jxta.properties cannot be found");
        }
        return prop;
    }

    private void initFromProperties(Properties prop) {
        block20: {
            if (prop != null) {
                String maxThreadIdleTimeStr;
                block19: {
                    String maxReqReadTimeStr;
                    block18: {
                        String maxThreadsStr;
                        block17: {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)"Using jxta.properties to configure HTTP server");
                            }
                            String minThreadsStr = prop.getProperty("HttpServer.MinThreads");
                            maxThreadsStr = prop.getProperty("HttpServer.MaxThreads");
                            maxReqReadTimeStr = prop.getProperty("HttpServer.MaxRequestReadTime");
                            maxThreadIdleTimeStr = prop.getProperty("HttpServer.MaxThreadIdleTime");
                            try {
                                if (minThreadsStr != null) {
                                    minThreads = Integer.parseInt(minThreadsStr);
                                }
                            }
                            catch (NumberFormatException e) {
                                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block17;
                                LOG.warn((Object)"Invalid HttpServer.MinThreads value; using default");
                            }
                        }
                        try {
                            if (maxThreadsStr != null) {
                                maxThreads = Integer.parseInt(maxThreadsStr);
                            }
                        }
                        catch (NumberFormatException e) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block18;
                            LOG.warn((Object)"Invalid HttpServer.MaxThreads value; using default");
                        }
                    }
                    try {
                        if (maxReqReadTimeStr != null) {
                            maxReqReadTime = Integer.parseInt(maxReqReadTimeStr);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block19;
                        LOG.warn((Object)"Invalid HttpServer.MaxReqReadTime value; using default");
                    }
                }
                try {
                    if (maxThreadIdleTimeStr != null) {
                        maxThreadIdleTime = Integer.parseInt(maxThreadIdleTimeStr);
                    }
                    break block20;
                }
                catch (NumberFormatException e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Invalid HttpServer.MaxThreadIdleTime value; using default");
                    }
                    break block20;
                }
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"jxta.properties not found: using default values");
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer info = new StringBuffer("Configuration read from properties:");
            info.append("\n\tminThreads = " + minThreads);
            info.append("\tmaxThreads = " + maxThreads);
            info.append("\tmaxReqReadTime = " + maxReqReadTime);
            info.append("\tmaxThreadIdleTime = " + maxThreadIdleTime);
            LOG.info((Object)info);
        }
    }

    private List getPublicAddresses(boolean serverEnabled, String serverName, InetAddress usingInterface, int serverSocketPort, boolean publicAddressOnly) {
        EndpointAddress newAddr;
        ArrayList<EndpointAddress> publicAddresses = new ArrayList<EndpointAddress>();
        if (serverEnabled && serverName != null) {
            newAddr = new EndpointAddress(protocolName, serverName, null, null);
            publicAddresses.add(newAddr);
            if (publicAddressOnly) {
                return publicAddresses;
            }
        }
        if (usingInterface.equals(IPUtils.ANYADDRESS)) {
            Iterator eachLocal = IPUtils.getAllLocalAddresses();
            ArrayList<EndpointAddress> wildAddrs = new ArrayList<EndpointAddress>();
            while (eachLocal.hasNext()) {
                InetAddress anAddress = (InetAddress)eachLocal.next();
                EndpointAddress newAddr2 = new EndpointAddress(protocolName, anAddress.getHostAddress() + ":" + Integer.toString(serverSocketPort), null, null);
                if (publicAddresses.contains(newAddr2)) continue;
                wildAddrs.add(newAddr2);
            }
            Collections.sort(wildAddrs, new Comparator(){

                public int compare(Object one, Object two) {
                    return one.toString().compareTo(two.toString());
                }

                public boolean equals(Object that) {
                    return this == that;
                }
            });
            publicAddresses.addAll(wildAddrs);
        } else {
            newAddr = new EndpointAddress(protocolName, usingInterface.getHostAddress() + ":" + Integer.toString(serverSocketPort), null, null);
            if (!publicAddresses.contains(newAddr)) {
                publicAddresses.add(newAddr);
            }
        }
        return publicAddresses;
    }

    TransportBindingMeter getTransportBindingMeter(String peerIDString, EndpointAddress destinationAddress) {
        if (this.transportMeter != null) {
            return this.transportMeter.getTransportBindingMeter(peerIDString != null ? peerIDString : TransportMeter.UNKNOWN_PEER, destinationAddress);
        }
        return null;
    }

    TransportBindingMeter getUnknownTransportBindingMeter() {
        return this.unknownTransportBindingMeter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

