/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.impl.endpoint.tcp.TcpConnection;
import net.jxta.impl.endpoint.tcp.TcpMessenger;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class IncomingUnicastServer
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$tcp$IncomingUnicastServer == null ? (class$net$jxta$impl$endpoint$tcp$IncomingUnicastServer = IncomingUnicastServer.class$("net.jxta.impl.endpoint.tcp.IncomingUnicastServer")) : class$net$jxta$impl$endpoint$tcp$IncomingUnicastServer).getName());
    private TcpTransport owner = null;
    private InetAddress serverLocalInterface;
    private int serverLocalPort;
    private ServerSocket serverSocket;
    private volatile boolean closed = false;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$IncomingUnicastServer;

    public IncomingUnicastServer(TcpTransport owner, InetAddress serverInterface, int serverPort) {
        this.owner = owner;
        this.serverLocalInterface = serverInterface;
        this.serverLocalPort = serverPort;
    }

    public synchronized boolean start(ThreadGroup inGroup) {
        block5: {
            if (this.serverSocket != null) {
                return false;
            }
            try {
                this.serverSocket = new ServerSocket(this.serverLocalPort, 50, this.serverLocalInterface);
                this.serverLocalInterface = this.serverSocket.getInetAddress();
                this.serverLocalPort = this.serverSocket.getLocalPort();
                Thread thread = new Thread(inGroup, this, "TCP Unicast Server Connection Listener");
                thread.setDaemon(true);
                thread.start();
                return true;
            }
            catch (BindException e0) {
                if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block5;
                LOG.fatal((Object)("Cannot bind ServerSocket on " + this.serverLocalInterface + ":" + this.serverLocalPort), (Throwable)e0);
            }
            catch (IOException e1) {
                if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block5;
                LOG.fatal((Object)("Cannot create ServerSocket on port " + this.serverLocalInterface + ":" + this.serverLocalPort), (Throwable)e1);
            }
            catch (SecurityException e2) {
                if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block5;
                LOG.fatal((Object)("Cannot create ServerSocket on port " + this.serverLocalInterface + ":" + this.serverLocalPort), (Throwable)e2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.closed = true;
        if (this.serverSocket != null) {
            try {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                        LOG.fatal((Object)("Cannot stop TCP Unicast Server " + e));
                    }
                    Object var3_2 = null;
                    this.serverSocket = null;
                }
                Object var3_1 = null;
                this.serverSocket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.serverSocket = null;
                throw throwable;
            }
        }
    }

    public InetAddress getLocalInterface() {
        return this.serverLocalInterface;
    }

    public int getLocalPort() {
        return this.serverLocalPort;
    }

    public void run() {
        block22: {
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Server is ready to receive request");
                }
                while (!this.closed) {
                    Socket inputSocket = null;
                    try {
                        inputSocket = this.serverSocket.accept();
                        if (this.closed) {
                            return;
                        }
                    }
                    catch (IOException e1) {
                        if (this.closed) {
                            return;
                        }
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)("[1] ServerSocket.accept() failed on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort()), (Throwable)e1);
                        continue;
                    }
                    catch (SecurityException e2) {
                        if (this.closed) {
                            return;
                        }
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)("[2] ServerSocket.accept() failed on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort()), (Throwable)e2);
                        continue;
                    }
                    try {
                        TcpConnection newConnect = new TcpConnection(inputSocket, this.owner);
                        if (!newConnect.isConnected()) continue;
                        TcpMessenger newMessenger = new TcpMessenger(newConnect.getDestinationAddress(), newConnect, this.owner);
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Registering connection from " + inputSocket.getInetAddress().getHostAddress() + ":" + inputSocket.getPort()));
                        }
                        this.owner.endpoint.getMessengerEventListener().messengerReady(new MessengerEvent(this.owner, newMessenger, newConnect.getConnectionAddress()));
                        newMessenger.start();
                    }
                    catch (OutOfMemoryError oom) {
                        try {
                            Thread.sleep(2000L);
                            inputSocket.close();
                        }
                        catch (Throwable any) {
                            // empty catch block
                        }
                        if (!this.closed) continue;
                        return;
                    }
                    catch (Throwable all) {
                        block21: {
                            try {
                                inputSocket.close();
                            }
                            catch (Throwable any) {
                                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block21;
                                LOG.error((Object)"Failed to close dead socket", any);
                            }
                        }
                        if (this.closed) {
                            return;
                        }
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)"Failed to create connection", all);
                    }
                }
                this.closed = true;
            }
            catch (Throwable all) {
                if (this.closed) {
                    return;
                }
                if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block22;
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Server has been shut down.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

