/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.msgframing.MessagePackageHeader;
import net.jxta.impl.endpoint.tcp.IncomingUnicastServer;
import net.jxta.impl.endpoint.tcp.TcpMessenger;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeter;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import net.jxta.util.CountingOutputStream;
import net.jxta.util.DevNullOutputStream;
import net.jxta.util.LimitInputStream;
import net.jxta.util.WatchedStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TcpTransport
implements Runnable,
Module,
MessageSender,
MessageReceiver {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$tcp$TcpTransport == null ? (class$net$jxta$impl$endpoint$tcp$TcpTransport = TcpTransport.class$("net.jxta.impl.endpoint.tcp.TcpTransport")) : class$net$jxta$impl$endpoint$tcp$TcpTransport).getName());
    static final int SendBufferSize = 65536;
    static final int RecvBufferSize = 65536;
    static final int LongTimeout = 1800000;
    static final int ShortTimeout = 10000;
    static final int LingerDelay = 120000;
    int connectionTimeOut;
    static final int MaxAcceptCnxBacklog = 50;
    List ShortCycle;
    List LongCycle;
    private String serverName;
    private List publicAddresses;
    private EndpointAddress publicAddress;
    private MessageElement msgSrcAddrElement;
    private String interfaceAddressStr;
    InetAddress usingInterface;
    private int serverSocketPort;
    private int restrictionPort;
    private IncomingUnicastServer unicastServer;
    private boolean isClosed;
    private boolean allowMulticast;
    private String multicastAddress;
    private int multicastPortNb;
    private int multicastPacketSize;
    private EndpointAddress mAddress;
    private InetAddress propagateInetAddress;
    private int propagatePort;
    private int propagateSize;
    private Thread multicastThread;
    private MulticastSocket multicastSocket;
    PeerGroup group;
    EndpointService endpoint;
    private String protocolName;
    private TransportMeter unicastTransportMeter;
    private TransportMeter multicastTransportMeter;
    private TransportBindingMeter multicastTransportBindingMeter;
    private boolean publicAddressOnly;
    ThreadGroup myThreadGroup;
    Timer connectionWatchTimer;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpTransport;

    public TcpTransport() {
        block3: {
            this.connectionTimeOut = 10000;
            this.ShortCycle = Collections.synchronizedList(new ArrayList());
            this.LongCycle = Collections.synchronizedList(new ArrayList());
            this.serverName = null;
            this.publicAddresses = new ArrayList();
            this.publicAddress = null;
            this.msgSrcAddrElement = null;
            this.restrictionPort = -1;
            this.unicastServer = null;
            this.isClosed = false;
            this.allowMulticast = true;
            this.multicastAddress = "224.0.1.85";
            this.multicastPortNb = 1234;
            this.multicastPacketSize = 16384;
            this.mAddress = null;
            this.multicastThread = null;
            this.multicastSocket = null;
            this.group = null;
            this.endpoint = null;
            this.protocolName = "tcp";
            this.publicAddressOnly = false;
            this.myThreadGroup = null;
            try {
                String connectTOStr = System.getProperty("sun.net.client.defaultConnectTimeout");
                if (connectTOStr != null) {
                    int i;
                    this.connectionTimeOut = i = Integer.parseInt(connectTOStr);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"Could not parse system property: sun.net.client.defaultConnectTimeout");
            }
        }
        this.connectionWatchTimer = new Timer(true);
        this.connectionWatchTimer.schedule((TimerTask)new TimerThreadNamer("TCP Transport Connection Timer"), 0L);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (null == target) {
            return false;
        }
        if (target instanceof TcpTransport) {
            TcpTransport likeMe = (TcpTransport)target;
            if (!this.getProtocolName().equals(likeMe.getProtocolName())) {
                return false;
            }
            Iterator myAddrs = this.publicAddresses.iterator();
            Iterator itsAddrs = likeMe.publicAddresses.iterator();
            while (myAddrs.hasNext()) {
                EndpointAddress its;
                if (!itsAddrs.hasNext()) {
                    return false;
                }
                EndpointAddress mine = (EndpointAddress)myAddrs.next();
                if (mine.equals(its = (EndpointAddress)itsAddrs.next())) continue;
                return false;
            }
            return !itsAddrs.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return this.getPublicAddress().hashCode();
    }

    public void init(PeerGroup g, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.group = g;
        this.endpoint = g.getEndpointService();
        this.connectionWatchTimer.schedule((TimerTask)new Watcher(this.LongCycle), 1800000L, 1800000L);
        this.connectionWatchTimer.schedule((TimerTask)new Watcher(this.ShortCycle), 10000L, 10000L);
        try {
            Iterator eachLocal;
            Enumeration tcpChilds;
            Enumeration list;
            ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
            ConfigParams configAdv = g.getConfigAdvertisement();
            Element param = implAdv.getParam();
            if (param != null && (list = param.getChildren("Proto")).hasMoreElements()) {
                TextElement pname = (TextElement)list.nextElement();
                this.protocolName = pname.getTextValue();
            }
            if ((tcpChilds = (param = configAdv.getServiceParam(assignedID)).getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                param = (Element)tcpChilds.nextElement();
                Attribute typeAttr = ((Attributable)((Object)param)).getAttribute("type");
                if (!TCPAdv.getAdvertisementType().equals(typeAttr.getValue())) {
                    throw new IllegalArgumentException("transport adv is not a " + TCPAdv.getAdvertisementType());
                }
                if (tcpChilds.hasMoreElements()) {
                    throw new IllegalArgumentException("Multiple transport advs detected for " + assignedID);
                }
            } else {
                throw new IllegalArgumentException(TransportAdvertisement.getAdvertisementType() + " could not be located");
            }
            Advertisement paramsAdv = AdvertisementFactory.newAdvertisement((TextElement)param);
            if (!(paramsAdv instanceof TCPAdv)) {
                throw new IllegalArgumentException("Provided Advertisement was not a " + TCPAdv.getAdvertisementType());
            }
            TCPAdv adv = (TCPAdv)paramsAdv;
            this.interfaceAddressStr = adv.getInterfaceAddress();
            if (this.interfaceAddressStr != null) {
                try {
                    this.usingInterface = InetAddress.getByName(this.interfaceAddressStr);
                }
                catch (UnknownHostException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Invalid address for local interface address, using default");
                    }
                    this.usingInterface = IPUtils.ANYADDRESS;
                }
            } else {
                this.usingInterface = IPUtils.ANYADDRESS;
            }
            this.serverName = adv.getServer();
            this.serverSocketPort = new Integer(adv.getPort());
            if (this.serverSocketPort < 0 || this.serverSocketPort > 65535) {
                throw new IllegalArgumentException("Illegal port value in advertisement :" + this.serverSocketPort);
            }
            this.publicAddressOnly = adv.getPublicAddressOnly();
            this.myThreadGroup = new ThreadGroup(this.group.getHomeThreadGroup(), "TcpTransport " + this.usingInterface.getHostAddress());
            if (adv.isServerEnabled()) {
                this.unicastServer = new IncomingUnicastServer(this, this.usingInterface, this.serverSocketPort);
                if (!this.unicastServer.start(this.myThreadGroup)) {
                    throw new PeerGroupException("Unable to start TCP Unicast Server");
                }
                if (this.serverName != null) {
                    if (0 == this.serverSocketPort) {
                        throw new IllegalArgumentException("Dynamic port selection cannot be used with NAT port forwarding");
                    }
                    EndpointAddress newAddr = new EndpointAddress(this.protocolName, this.serverName, null, null);
                    this.publicAddresses.add(newAddr);
                }
                boolean localOnly = true;
                if (this.usingInterface.equals(IPUtils.ANYADDRESS)) {
                    eachLocal = IPUtils.getAllLocalAddresses();
                    ArrayList<EndpointAddress> wildAddrs = new ArrayList<EndpointAddress>();
                    while (eachLocal.hasNext()) {
                        InetAddress anAddress = (InetAddress)eachLocal.next();
                        EndpointAddress newAddr = new EndpointAddress(this.protocolName, anAddress.getHostAddress() + ":" + Integer.toString(this.unicastServer.getLocalPort()), null, null);
                        if (!IPUtils.isLoopbackAddress(anAddress)) {
                            localOnly = false;
                        }
                        if (this.publicAddresses.contains(newAddr)) continue;
                        wildAddrs.add(newAddr);
                    }
                    Collections.sort(wildAddrs, new Comparator(){

                        public int compare(Object one, Object two) {
                            return one.toString().compareTo(two.toString());
                        }

                        public boolean equals(Object that) {
                            return this == that;
                        }
                    });
                    if (this.serverName == null || !this.publicAddressOnly) {
                        this.publicAddresses.addAll(wildAddrs);
                    }
                } else {
                    if (!IPUtils.isLoopbackAddress(this.usingInterface)) {
                        localOnly = false;
                    }
                    EndpointAddress newAddr = new EndpointAddress(this.protocolName, this.usingInterface.getHostAddress() + ":" + Integer.toString(this.unicastServer.getLocalPort()), null, null);
                    if (!(this.serverName != null && this.publicAddressOnly || this.publicAddresses.contains(newAddr))) {
                        this.publicAddresses.add(newAddr);
                    }
                }
                if (localOnly) {
                    this.usingInterface = IPUtils.LOOPBACK;
                    this.publicAddresses.clear();
                    EndpointAddress pubAddr = new EndpointAddress(this.protocolName, this.usingInterface.getHostAddress() + ":" + Integer.toString(this.unicastServer.getLocalPort()), null, null);
                    this.publicAddresses.add(pubAddr);
                }
                this.publicAddress = (EndpointAddress)this.publicAddresses.get(0);
            } else {
                if (this.usingInterface.equals(IPUtils.ANYADDRESS)) {
                    boolean localOnly = true;
                    eachLocal = IPUtils.getAllLocalAddresses();
                    while (eachLocal.hasNext()) {
                        InetAddress anAddress = (InetAddress)eachLocal.next();
                        if (IPUtils.isLoopbackAddress(anAddress)) continue;
                        localOnly = false;
                        break;
                    }
                    if (localOnly) {
                        this.usingInterface = IPUtils.LOOPBACK;
                    }
                }
                this.publicAddress = new EndpointAddress(this.protocolName, this.usingInterface.getHostAddress() + ":0", null, null);
            }
            this.msgSrcAddrElement = new StringMessageElement("EndpointSourceAddress", this.publicAddress.toString(), (MessageElement)null);
            this.allowMulticast = adv.getMulticastState();
            if (this.allowMulticast) {
                block45: {
                    this.multicastAddress = adv.getMulticastAddr();
                    this.multicastPortNb = new Integer(adv.getMulticastPort());
                    this.multicastPacketSize = new Integer(adv.getMulticastSize());
                    this.mAddress = new EndpointAddress(this.protocolName, this.multicastAddress + ":" + Integer.toString(this.multicastPortNb), null, null);
                    this.propagatePort = this.multicastPortNb;
                    this.propagateSize = this.multicastPacketSize;
                    this.propagateInetAddress = InetAddress.getByName(this.multicastAddress);
                    this.multicastSocket = new MulticastSocket(this.propagatePort);
                    if (!this.usingInterface.equals(IPUtils.ANYADDRESS)) {
                        try {
                            this.multicastSocket.setInterface(this.usingInterface);
                        }
                        catch (SocketException e1) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block45;
                            LOG.error((Object)"Could not bind multicast socket to explicit address: mcast is left bound to all.");
                        }
                    }
                }
                try {
                    this.multicastSocket.joinGroup(this.propagateInetAddress);
                }
                catch (SocketException soe) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"Could not join multicast group, setting Multicast off");
                    }
                    this.allowMulticast = false;
                }
                if (this.allowMulticast) {
                    this.multicastThread = new Thread(this.myThreadGroup, this, "TCP Multicast Server Listener");
                    this.multicastThread.start();
                }
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                StringBuffer configInfo = new StringBuffer("Configuring TCP Transport : " + assignedID);
                configInfo.append("\n\tGroup Params:");
                configInfo.append("\n\t\tGroup: " + this.group.getPeerGroupName());
                configInfo.append("\n\t\tGroup ID: " + this.group.getPeerGroupID());
                configInfo.append("\n\t\tPeer ID: " + this.group.getPeerID());
                configInfo.append("\n\tFrom Adv:");
                configInfo.append("\n\t\tProtocol: " + adv.getProtocol());
                configInfo.append("\n\t\tPublic address: " + (this.serverName == null ? "(unspecified)" : this.serverName));
                configInfo.append("\n\t\tInterface address: " + (this.interfaceAddressStr == null ? "(unspecified)" : this.interfaceAddressStr));
                configInfo.append("\n\t\tMulticast State: " + (this.allowMulticast ? "Enabled" : "Disabled"));
                if (this.allowMulticast) {
                    configInfo.append("\n\t\t\tMulticastAddr: " + this.multicastAddress);
                    configInfo.append("\n\t\t\tMulticastPort: " + this.multicastPortNb);
                    configInfo.append("\n\t\t\tMulticastPacketSize: " + this.multicastPacketSize);
                }
                configInfo.append("\n\tConfiguration :");
                configInfo.append("\n\t\tUnicast Server Bind Addr: " + this.usingInterface.getHostAddress() + ":" + this.serverSocketPort);
                if (this.allowMulticast) {
                    configInfo.append("\n\t\tMulticast Server Bind Addr: " + this.multicastSocket.getLocalAddress().getHostAddress() + ":" + this.multicastSocket.getLocalPort());
                }
                configInfo.append("\n\t\tPublic Addresses: ");
                configInfo.append("\n\t\t\tDefault Endpoint Addr : " + this.publicAddress);
                Iterator eachPublic = this.publicAddresses.iterator();
                while (eachPublic.hasNext()) {
                    EndpointAddress anAddr = (EndpointAddress)eachPublic.next();
                    configInfo.append("\n\t\t\tEndpoint Addr : " + anAddr);
                }
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)configInfo);
                }
            }
            this.endpoint.addMessageTransport(this);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Initialization exception", (Throwable)e);
            }
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"FIXME: there may be threads that need killing.");
            }
            throw new PeerGroupException(e.getMessage());
        }
    }

    public synchronized int startApp(String[] arg) {
        if (this.allowMulticast) {
            // empty if block
        }
        this.isClosed = false;
        return 0;
    }

    public synchronized void stopApp() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.endpoint.removeMessageTransport(this);
        if (this.unicastServer != null) {
            this.unicastServer.stop();
            this.unicastServer = null;
        }
        if (this.multicastSocket != null) {
            this.multicastSocket.close();
            this.multicastSocket = null;
            this.multicastThread = null;
        }
        this.endpoint = null;
        this.group = null;
        this.connectionWatchTimer.cancel();
        WatchedStream[] allStreams = this.ShortCycle.toArray(new WatchedStream[0]);
        int i = 0;
        int len = allStreams.length;
        while (i < len) {
            try {
                allStreams[i].close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            ++i;
        }
        allStreams = this.LongCycle.toArray(new WatchedStream[0]);
        int i2 = 0;
        int len2 = allStreams.length;
        while (i2 < len2) {
            try {
                allStreams[i2].close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            ++i2;
        }
        this.ShortCycle.clear();
        this.LongCycle.clear();
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public EndpointAddress getPublicAddress() {
        return (EndpointAddress)this.publicAddress.clone();
    }

    public EndpointService getEndpointService() {
        return (EndpointService)this.endpoint.getInterface();
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    public Iterator getPublicAddresses() {
        return Collections.unmodifiableList(this.publicAddresses).iterator();
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean allowsRouting() {
        return true;
    }

    public Messenger getMessenger(EndpointAddress dst, Object hintIgnored) {
        if (null == dst) {
            throw new IllegalArgumentException("Null addr");
        }
        EndpointAddress plainAddr = new EndpointAddress(dst, null, null);
        if (!plainAddr.getProtocolName().equals(this.getProtocolName())) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("getMessenger: cannot make messenger for protocol: " + plainAddr.getProtocolName()));
            }
            return null;
        }
        if (this.publicAddresses.contains(plainAddr)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getMessenger: return LoopbackMessenger for addr : " + dst));
            }
            return new LoopbackMessenger(this.endpoint, this.getPublicAddress(), dst, new EndpointAddress("jxta", this.group.getPeerID().getUniqueValue().toString(), null, null));
        }
        try {
            TcpMessenger m = new TcpMessenger(dst, this);
            m.start();
            return m;
        }
        catch (Throwable caught) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("getMessenger: could not get messenger for " + dst), caught);
                } else {
                    LOG.info((Object)("getMessenger: could not get messenger for " + dst + "/" + caught.getMessage()));
                }
            }
            return null;
        }
    }

    public void run() {
        block13: {
            if (!this.allowMulticast) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Multicast disabled");
                }
                return;
            }
            try {
                while (true) {
                    if (this.isClosed) {
                        return;
                    }
                    byte[] buffer = new byte[this.propagateSize];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    try {
                        this.multicastSocket.receive(packet);
                        if (this.isClosed) {
                            return;
                        }
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("multicast message received from :" + packet.getAddress().getHostAddress()));
                        }
                        this.processMulticast(buffer, packet.getLength());
                    }
                    catch (Exception e) {
                        if (LOG.isEnabledFor((Priority)Level.ERROR) && !this.isClosed) {
                            LOG.error((Object)"failure during multicast receive", (Throwable)e);
                        }
                        if (this.isClosed) {
                            return;
                        }
                        break;
                    }
                    Object var2_3 = null;
                }
            }
            catch (Throwable all) {
                if (this.isClosed) {
                    return;
                }
                if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block13;
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
        }
    }

    public void processMulticast(byte[] buffer, int size) {
        if (!this.allowMulticast) {
            return;
        }
        long messageReceiveBeginTime = 0L;
        try {
            if (size < 4) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"processMulticast : damaged multicast discarded");
                }
                return;
            }
            if (74 != buffer[0] || 88 != buffer[1] || 84 != buffer[2] || 65 != buffer[3]) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"processMulticast : damaged multicast discarded");
                }
                return;
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 4, size - 4);
            MessagePackageHeader header = new MessagePackageHeader(inputStream);
            if (this.restrictionPort != -1) {
                MessagePackageHeader.Header srcEAHeader = (MessagePackageHeader.Header)header.getHeader("srcEA").next();
                EndpointAddress srcAddr = null;
                try {
                    srcAddr = new EndpointAddress(new String(srcEAHeader.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException never) {
                    throw new IllegalStateException("utf-8 encoding support missing!");
                }
                String strAddr = srcAddr.getProtocolAddress();
                int srcPort = Integer.parseInt(strAddr.substring(strAddr.lastIndexOf(58) + 1));
                if (srcPort < this.serverSocketPort - 1 || srcPort > this.serverSocketPort + 1) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"processMulticast : simulated separate networks killed multicast message.");
                    }
                    return;
                }
            }
            MimeMediaType msgMime = header.getContentTypeHeader();
            long msglength = header.getContentLengthHeader();
            Message msg = WireFormatMessageFactory.fromWire(new LimitInputStream(inputStream, msglength), msgMime, null);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"processMulticast : handing multicast message to EndpointService");
            }
            this.endpoint.demux(msg);
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"processMulticast : discard incoming multicast message - exception ", e);
            }
            return;
        }
    }

    public synchronized void propagate(Message message, String pName, String pParams, String prunePeer) throws IOException {
        block8: {
            if (!this.allowMulticast) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Multicast is off, therefore propagate disabled, returning");
                }
                return;
            }
            long sendStartTime = 0L;
            int numBytesInPacket = 0;
            try {
                this.mAddress.setServiceName(pName);
                this.mAddress.setServiceParameter(pParams);
                message.replaceMessageElement("jxta", this.msgSrcAddrElement);
                StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", this.mAddress.toString(), (MessageElement)null);
                message.replaceMessageElement("jxta", dstAddressElement);
                WireFormatMessage serialed = WireFormatMessageFactory.toWire(message, new MimeMediaType("application/x-jxta-msg"), null);
                MessagePackageHeader header = new MessagePackageHeader();
                header.setContentTypeHeader(serialed.getMimeType());
                header.setContentLengthHeader(serialed.getByteLength());
                try {
                    header.replaceHeader("srcEA", this.getPublicAddress().toString().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException never) {
                    throw new IllegalStateException("utf-8 encoding support missing!");
                }
                CountingOutputStream count = new CountingOutputStream(new DevNullOutputStream());
                count.write(74);
                count.write(88);
                count.write(84);
                count.write(65);
                header.sendToStream(count);
                if (serialed.getByteLength() >= (long)this.multicastPacketSize - count.getBytesWritten()) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Message discarded : larger than multicast packet size (" + this.multicastPacketSize + "<" + (serialed.getByteLength() + count.getBytesWritten()) + ")"));
                    }
                    throw new IOException("Message discarded : larger than multicast packet size");
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(this.multicastPacketSize);
                buffer.write(74);
                buffer.write(88);
                buffer.write(84);
                buffer.write(65);
                header.sendToStream(buffer);
                serialed.sendToStream(buffer);
                buffer.flush();
                buffer.close();
                numBytesInPacket = (int)(count.getBytesWritten() + serialed.getByteLength());
                DatagramPacket packet = new DatagramPacket(buffer.toByteArray(), numBytesInPacket, this.propagateInetAddress, this.propagatePort);
                this.multicastSocket.send(packet);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block8;
                LOG.debug((Object)"socket send failed", (Throwable)e);
            }
        }
    }

    public boolean ping(EndpointAddress addr) {
        boolean result;
        block3: {
            result = false;
            EndpointAddress endpointAddress = null;
            long pingStartTime = 0L;
            try {
                endpointAddress = new EndpointAddress(addr, null, null);
                TcpMessenger tcpMessenger = new TcpMessenger(endpointAddress, this);
                result = true;
            }
            catch (Throwable e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)("failure pinging " + addr.toString()), e);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("ping to " + addr.toString() + " == " + result));
        }
        return result;
    }

    int getRestrictionPort() {
        return this.restrictionPort;
    }

    TransportBindingMeter getUnicastTransportBindingMeter(PeerID peerID, EndpointAddress destinationAddress) {
        if (this.unicastTransportMeter != null) {
            return this.unicastTransportMeter.getTransportBindingMeter(peerID != null ? peerID.toString() : TransportMeter.UNKNOWN_PEER, destinationAddress);
        }
        return null;
    }

    TransportBindingMeter getMulticastTransportBindingMeter(EndpointAddress destinationAddress) {
        if (this.multicastTransportMeter != null) {
            return this.multicastTransportMeter.getTransportBindingMeter(this.group.getPeerID(), destinationAddress);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Watcher
    extends TimerTask {
        private Collection watchList;

        public Watcher(Collection watchList) {
            this.watchList = watchList;
        }

        public void run() {
            block3: {
                try {
                    WatchedStream[] allStreams = this.watchList.toArray(new WatchedStream[0]);
                    int len = allStreams.length;
                    int i = 0;
                    while (i < len) {
                        allStreams[i].watch();
                        ++i;
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block3;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }
}

