/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class JTlsInputStream
extends InputStream {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$tls$JTlsInputStream == null ? (class$net$jxta$impl$endpoint$tls$JTlsInputStream = JTlsInputStream.class$("net.jxta.impl.endpoint.tls.JTlsInputStream")) : class$net$jxta$impl$endpoint$tls$JTlsInputStream).getName());
    private static final boolean DEBUGIO = false;
    private static int MAXQUEUESIZE = 25;
    private TlsConn conn;
    private volatile boolean closed = false;
    private JTlsRecord jtrec = null;
    private volatile int sequenceNumber = 0;
    private Vector inputQueue = new Vector(MAXQUEUESIZE);
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$JTlsInputStream;

    public JTlsInputStream(TlsConn conn) {
        this.conn = conn;
        this.jtrec = new JTlsRecord();
        this.sequenceNumber = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        this.closed = true;
        Vector vector = this.inputQueue;
        synchronized (vector) {
            this.inputQueue.clear();
            this.inputQueue.notifyAll();
        }
    }

    public int read() throws IOException {
        int len;
        if (this.closed) {
            return -1;
        }
        byte[] a = new byte[1];
        while ((len = this.local_read(a, 0, 1)) >= 0) {
            if (len <= 0) continue;
            return a[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] a, int offset, int length) throws IOException {
        if (this.closed) {
            return -1;
        }
        if (0 == length) {
            return 0;
        }
        int i = this.local_read(a, offset, length);
        return i;
    }

    int getSequenceNumber() {
        return this.sequenceNumber;
    }

    int getMaxIQSize() {
        return MAXQUEUESIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendACK(int seqnAck) {
        ArrayList<Integer> selectedAckList = new ArrayList<Integer>();
        Vector vector = this.inputQueue;
        synchronized (vector) {
            Iterator eachInQueue = this.inputQueue.iterator();
            while (eachInQueue.hasNext() && selectedAckList.size() < MAXQUEUESIZE) {
                IQElt anIQElt = (IQElt)eachInQueue.next();
                if (anIQElt.seqnum <= seqnAck) continue;
                selectedAckList.add(new Integer(anIQElt.seqnum));
            }
        }
        this.sendACK(seqnAck, selectedAckList);
    }

    private void sendACK(int seqnAck, List sackList) {
        block4: {
            ByteArrayOutputStream bos = new ByteArrayOutputStream((1 + sackList.size()) * 4);
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeInt(seqnAck);
                Iterator eachSACK = sackList.iterator();
                while (eachSACK.hasNext()) {
                    int aSack = (Integer)eachSACK.next();
                    dos.writeInt(aSack);
                }
                dos.close();
                bos.close();
                Message ACKMsg = new Message();
                ByteArrayMessageElement elt = new ByteArrayMessageElement("TLSACK", JTlsDefs.ACKS, bos.toByteArray(), null);
                ACKMsg.addMessageElement("jxtatls", elt);
                this.conn.sendToRemoteTls(ACKMsg);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("SENT ACK, seqn#" + seqnAck + " and " + sackList.size() + " SACKs "));
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.INFO)) break block4;
                LOG.info((Object)"sendACK caught IOException:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void queueIncomingMessage(Message msg) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Queue Incoming Message begins for " + msg));
        }
        long startEnqueue = TimeUtils.timeNow();
        Message.ElementIterator e = msg.getMessageElements("jxtatls", JTlsDefs.BLOCKS);
        block5: while (!this.closed && e.hasNext()) {
            MessageElement elt = (MessageElement)e.next();
            e.remove();
            int msgSeqn = 0;
            try {
                msgSeqn = Integer.parseInt(elt.getElementName());
            }
            catch (NumberFormatException n) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Discarding element (" + elt.getElementName() + ") Not one of ours."));
                continue;
            }
            IQElt newElt = new IQElt();
            newElt.seqnum = msgSeqn;
            newElt.elt = elt;
            newElt.ackd = false;
            do {
                if (newElt.seqnum <= this.sequenceNumber) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("RCVD OLD MESSAGE : Discard seqn#" + newElt.seqnum + " now at seqn#" + this.sequenceNumber));
                    }
                    newElt = null;
                    continue block5;
                }
                Vector vector = this.inputQueue;
                synchronized (vector) {
                    int insertIndex = this.inputQueue.size();
                    boolean duplicate = false;
                    int j = 0;
                    while (j < this.inputQueue.size()) {
                        IQElt iq = (IQElt)this.inputQueue.elementAt(j);
                        if (newElt.seqnum < iq.seqnum) {
                            insertIndex = j;
                            break;
                        }
                        if (newElt.seqnum == iq.seqnum) {
                            duplicate = true;
                            break;
                        }
                        ++j;
                    }
                    if (duplicate) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("RCVD OLD MESSAGE : Discard duplicate msg, seqn#" + newElt.seqnum));
                        }
                        newElt = null;
                        continue block5;
                    }
                    this.inputQueue.add(insertIndex, newElt);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Enqueued msg with seqn#" + newElt.seqnum + " at index " + insertIndex));
                    }
                    this.inputQueue.notify();
                    newElt = null;
                }
            } while (!this.closed && null != newElt);
        }
        this.notify();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            long waited = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startEnqueue);
            LOG.debug((Object)("Queue Incoming Message for " + msg + " completed in " + waited + " msec."));
        }
        msg.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MessageElement dequeueMessage(int desiredSeqn) {
        IQElt iQ = null;
        long startDequeue = TimeUtils.timeNow();
        int wct = 0;
        long nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
        Vector vector = this.inputQueue;
        // MONITORENTER : vector
        while (!this.closed) {
            if (this.inputQueue.size() == 0) {
                try {
                    ++wct;
                    this.inputQueue.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
                continue;
            }
            iQ = (IQElt)this.inputQueue.elementAt(0);
            if (iQ.seqnum != desiredSeqn) {
                if (TimeUtils.toRelativeTimeMillis(nextRetransRequest) < 0L) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Trigger retransmission. Wanted seqn#" + desiredSeqn + " found seqn#" + iQ.seqnum));
                    }
                    this.sendACK(desiredSeqn - 1);
                    nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
                }
                try {
                    ++wct;
                    this.inputQueue.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                continue;
            }
            this.inputQueue.removeElementAt(0);
            break;
        }
        // MONITOREXIT : vector
        if (null == iQ) {
            return null;
        }
        this.sendACK(desiredSeqn);
        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return iQ.elt;
        long waited = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startDequeue);
        LOG.debug((Object)("DEQUEUED seqn#" + iQ.seqnum + " in " + waited + " msec on input queue"));
        if (wct <= 0) return iQ.elt;
        LOG.debug((Object)("DEQUEUE waited " + wct + " times on input queue"));
        return iQ.elt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int local_read(byte[] a, int offset, int length) throws IOException {
        JTlsRecord jTlsRecord = this.jtrec;
        synchronized (jTlsRecord) {
            int res;
            if (this.jtrec.size == 0L || this.jtrec.nextByte == this.jtrec.size) {
                MessageElement elt;
                this.jtrec.resetRecord();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("local_read: getting next data block at seqn#" + (this.sequenceNumber + 1)));
                }
                if (null == (elt = this.dequeueMessage(this.sequenceNumber + 1))) {
                    return -1;
                }
                ++this.sequenceNumber;
                this.jtrec.size = elt.getByteLength();
                this.jtrec.tlsRecord = elt.getStream();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("local_read: new seqn#" + this.sequenceNumber + ", bytes = " + this.jtrec.size));
                }
            }
            long left = this.jtrec.size - this.jtrec.nextByte;
            int copyLen = (int)Math.min((long)length, left);
            int copied = 0;
            while ((res = this.jtrec.tlsRecord.read(a, offset + copied, copyLen - copied)) >= 0 && (copied += res) < copyLen) {
            }
            this.jtrec.nextByte += (long)copied;
            return copied;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IQElt {
        int seqnum;
        MessageElement elt;
        boolean ackd;

        private IQElt() {
        }
    }

    private static class JTlsRecord {
        public InputStream tlsRecord = null;
        public long nextByte = 0L;
        public long size = 0L;

        public void resetRecord() {
            if (null != this.tlsRecord) {
                try {
                    this.tlsRecord.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            this.tlsRecord = null;
            this.nextByte = 0L;
            this.size = 0L;
        }
    }
}

