/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.sslg.CertVerifyPolicyInt;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import jxta.security.exceptions.CryptoException;
import jxta.security.impl.random.JRandom;
import net.jxta.impl.endpoint.tls.JTlsUtil;

public class JTlsParams {
    private File rootfile = null;
    private File keyfile = null;
    private String passphrase = null;
    private boolean acceptUnverifiedCerts = false;
    private boolean validateDates = false;
    private short[] cipherSuites = null;
    private SSLContext ctx = new SSLContext();
    private SSLPolicyInt policy = new SSLPolicyInt();
    private CertVerifyPolicyInt certPolicy = new CertVerifyPolicyInt();

    public JTlsParams() {
        JRandom srng;
        try {
            srng = new JRandom();
        }
        catch (CryptoException failed) {
            throw new UndeclaredThrowableException(failed);
        }
        byte[] seedbytes = new byte[128];
        srng.nextBytes(seedbytes);
        this.ctx.seedRNG(seedbytes);
        this.cipherSuites = null;
    }

    public JTlsParams(File rootfile, File keyfile, String passphrase, String suites, boolean unverifiedOK, boolean checkDates) throws IOException {
        this();
        if (rootfile == null || keyfile == null) {
            throw new IOException("null file name as argument");
        }
        this.loadRootCerts(rootfile);
        this.loadEAYKeyFile(keyfile, passphrase);
        this.setCertPolicies(unverifiedOK, checkDates);
        this.setCipherSuites(suites);
        this.ctx.setPolicy(this.policy);
    }

    public JTlsParams(File rootfile, File keyfile, String passphrase, boolean clientAuthorization) throws IOException {
        this();
        if (rootfile == null || keyfile == null) {
            throw new IOException("null file name as argument");
        }
        this.loadRootCerts(rootfile);
        this.loadEAYKeyFile(keyfile, passphrase);
        this.policy.requireClientAuth(clientAuthorization);
        this.ctx.setPolicy(this.policy);
    }

    public SSLContext getContext() {
        return this.ctx;
    }

    public SSLPolicyInt getPolicy() {
        return this.policy;
    }

    private void loadRootCerts(File rootfile) throws IOException {
        this.rootfile = rootfile;
        this.ctx.loadRootCertificates(rootfile.getPath());
    }

    private void loadEAYKeyFile(File keyfile, String passphrase) throws IOException {
        this.keyfile = keyfile;
        this.passphrase = passphrase;
        this.ctx.loadEAYKeyFile(keyfile.getPath(), passphrase);
    }

    private void setCertPolicies(boolean unverifiedOK, boolean checkDates) {
        this.acceptUnverifiedCerts = unverifiedOK;
        this.validateDates = checkDates;
        this.certPolicy.checkDates(this.validateDates);
        this.certPolicy.requireBasicConstraints(true);
        this.policy.acceptUnverifiableCertificates(this.acceptUnverifiedCerts);
    }

    private void setCipherSuites(String suites) {
        if (suites == null) {
            return;
        }
        this.cipherSuites = JTlsUtil.parseCipherSuites(suites);
        if (this.cipherSuites != null) {
            this.policy.setCipherSuites(this.cipherSuites);
        }
    }
}

