/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.sslg.SSLPolicyInt;
import java.util.StringTokenizer;
import java.util.Vector;
import jxta.security.cipher.Cipher;
import jxta.security.cipher.Key;
import jxta.security.exceptions.CryptoException;
import jxta.security.impl.cipher.KeyBuilder;
import jxta.security.impl.cipher.SecretKey;
import jxta.security.impl.crypto.JxtaCryptoSuite;
import org.apache.log4j.Logger;

public final class JTlsUtil {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$tls$JTlsUtil == null ? (class$net$jxta$impl$endpoint$tls$JTlsUtil = JTlsUtil.class$("net.jxta.impl.endpoint.tls.JTlsUtil")) : class$net$jxta$impl$endpoint$tls$JTlsUtil).getName());
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$JTlsUtil;

    private JTlsUtil() {
    }

    public static short[] parseCipherSuites(String suites) throws ArrayIndexOutOfBoundsException {
        StringTokenizer t = new StringTokenizer(suites, ":", false);
        Vector<Integer> v = new Vector<Integer>();
        while (t.hasMoreTokens()) {
            String tok = t.nextToken();
            int num = SSLPolicyInt.getCipherSuiteNumber((String)tok);
            if (num <= -1) continue;
            v.addElement(new Integer(num));
        }
        if (v.size() > 0) {
            short[] retval = new short[v.size()];
            int i = 0;
            while (i < v.size()) {
                Integer x = (Integer)v.elementAt(i);
                retval[i] = x.shortValue();
                ++i;
            }
            return retval;
        }
        return null;
    }

    public static byte[] tlsCipher(byte[] data, String password, byte mode) throws CryptoException {
        JxtaCryptoSuite suite = new JxtaCryptoSuite(1, null, 0, 0);
        Cipher rc4 = suite.getJxtaCipher();
        SecretKey k1 = (SecretKey)KeyBuilder.buildKey((byte)8, (short)128, (boolean)false);
        byte[] pbytes = password.getBytes();
        byte[] forkey = new byte[16];
        int i = 0;
        int j = 0;
        while (i < forkey.length) {
            forkey[i] = pbytes[j++];
            if (j == pbytes.length) {
                j = 0;
            }
            ++i;
        }
        k1.setKey(forkey, 0);
        byte[] obuf = new byte[data.length];
        rc4.init((Key)k1, mode);
        rc4.doFinal(data, 0, data.length, obuf, 0);
        return obuf;
    }

    public static String toHex(byte[] arr, int offset, int len) {
        StringBuffer str = new StringBuffer(3 * len + 9 * (len / 16));
        int i = offset;
        while (i < len) {
            if (i % 16 == 0) {
                String address = "00000000" + Integer.toHexString(i);
                str.append(address.substring(address.length() - 8) + ":");
            }
            str.append(hex[arr[i] >> 4 & 0xF]);
            str.append(hex[arr[i] & 0xF]);
            if (15 != i % 16) {
                str.append(' ');
            } else {
                str.append('\n');
            }
            ++i;
        }
        return str.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

