/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLSocket;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.JTlsInputStream;
import net.jxta.impl.endpoint.tls.JTlsOutputStream;
import net.jxta.impl.endpoint.tls.JTlsParams;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.util.TimeUtils;
import net.jxta.util.IgnoreFlushFilterOutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class TlsConn {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$tls$TlsConn == null ? (class$net$jxta$impl$endpoint$tls$TlsConn = TlsConn.class$("net.jxta.impl.endpoint.tls.TlsConn")) : class$net$jxta$impl$endpoint$tls$TlsConn).getName());
    static final int BOSIZE = 16000;
    TlsTransport transport = null;
    EndpointAddress destAddr = null;
    private String acquireMessengerLock = new String("Messenger Acquire Lock");
    private Messenger outBoundMessenger = null;
    private SSLSocket ssls = null;
    JTlsOutputStream jout = null;
    JTlsInputStream jin = null;
    private OutputStream plaintext_out = null;
    private ReadPlaintextMessage readerThread = null;
    JTlsParams params = null;
    String suites = null;
    boolean unverifiedCerts = true;
    boolean checkDates = true;
    boolean clientAuthorization = false;
    private boolean client;
    private volatile HandshakeState currentState;
    private boolean closing = false;
    long lastAccessed;
    int retrans;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsConn;

    TlsConn(TlsTransport tp, EndpointAddress destAddr, boolean client) {
        this.transport = tp;
        this.destAddr = destAddr;
        this.client = client;
        this.currentState = client ? HandshakeState.CLIENTSTART : HandshakeState.SERVERSTART;
        this.lastAccessed = TimeUtils.timeNow();
    }

    public String toString() {
        return super.toString() + "/" + this.getHandshakeState() + ":" + (this.client ? "Client" : "Server") + " for " + this.destAddr;
    }

    HandshakeState getHandshakeState() {
        return this.currentState;
    }

    synchronized HandshakeState setHandshakeState(HandshakeState newstate) {
        HandshakeState oldstate = this.currentState;
        this.currentState = newstate;
        this.notifyAll();
        return oldstate;
    }

    void init() throws IOException {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)((this.client ? "Initiating" : "Accepting") + " new connection for : " + this.destAddr.getProtocolAddress()));
        }
        PSECredential cred = null;
        cred = (PSECredential)this.transport.membership.getDefaultCredential();
        if (null == cred) {
            throw new IOException("No default credential, cannot make connections");
        }
        this.unverifiedCerts = true;
        this.clientAuthorization = false;
        File rootCertFile = null;
        rootCertFile = this.transport.getRootCert(this.destAddr);
        if (rootCertFile != null) {
            if (this.client) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Verifying certs, root = " + rootCertFile));
                }
                this.unverifiedCerts = false;
            } else {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Authorizing client, root = " + rootCertFile));
                }
                this.clientAuthorization = true;
            }
        } else {
            rootCertFile = this.transport.membership.getPSEConfig().getRootCertFile(null);
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                String who = this.client ? "Server" : "Client";
                LOG.info((Object)("NOT Verifying " + who + " cert, root = " + rootCertFile));
            }
        }
        this.params = this.client ? new JTlsParams(rootCertFile, this.transport.membership.getPSEConfig().getClientCertFile(null), this.transport.membership.getPassphrase(), this.suites, this.unverifiedCerts, this.checkDates) : new JTlsParams(rootCertFile, this.transport.membership.getPSEConfig().getClientCertFile(null), this.transport.membership.getPassphrase(), this.clientAuthorization);
        if (!this.unverifiedCerts || this.clientAuthorization) {
            this.transport.removeRootCertFile(this.destAddr);
        }
        rootCertFile = null;
        this.jin = new JTlsInputStream(this);
        this.jout = new JTlsOutputStream(this.transport, this);
    }

    void openTLSConnection() throws IOException {
        String shash1 = this.destAddr.getProtocolAddress();
        int shash2 = 1376911;
        long startTime = 0L;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            startTime = TimeUtils.timeNow();
            LOG.info((Object)((this.client ? "Client:" : "Server:") + " Handshake START"));
        }
        this.ssls = new SSLSocket(this.params.getContext(), (InputStream)this.jin, (OutputStream)this.jout, shash1, shash2, this.client ? 1 : 2);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            long hsTime = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startTime) / 1000L;
            LOG.info((Object)((this.client ? "Client:" : "Server:") + "Handshake DONE in " + hsTime + " secs"));
        }
        this.setPlaintextOutputStream(this.ssls.getOutputStream());
        this.readerThread = new ReadPlaintextMessage(this.transport, this.ssls.getInputStream());
    }

    synchronized void close(HandshakeState finalstate) throws IOException {
        if (this.closing && LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Ignoring re-entrant call to close() for " + this), new Throwable("fake for stack trace"));
        }
        this.closing = true;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Shutting down " + this));
        }
        this.setHandshakeState(HandshakeState.CONNECTIONCLOSING);
        this.lastAccessed = Long.MIN_VALUE;
        try {
            block17: {
                try {
                    if (null != this.jin) {
                        try {
                            this.jin.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    if (null != this.jout) {
                        try {
                            this.jout.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    if (null != this.ssls) {
                        try {
                            this.ssls.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        this.ssls = null;
                    }
                    if (null != this.readerThread) {
                        this.readerThread.close();
                    }
                    if (null == this.outBoundMessenger) break block17;
                    this.outBoundMessenger.close();
                    this.outBoundMessenger = null;
                }
                catch (Throwable failure) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Throwable during close " + this), failure);
                    }
                    throw new IOException("bad bad" + failure.getMessage());
                }
            }
            Object var4_6 = null;
            this.notifyAll();
            this.closing = false;
            this.setHandshakeState(finalstate);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.notifyAll();
            this.closing = false;
            this.setHandshakeState(finalstate);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendToRemoteTls(Message msg) throws IOException {
        String string = this.acquireMessengerLock;
        synchronized (string) {
            if (null == this.outBoundMessenger || this.outBoundMessenger.isClosed()) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sendToRemoteTls : Getting messenger for " + this.destAddr));
                }
                EndpointAddress realAddr = new EndpointAddress(this.destAddr, "TlsTransport", null);
                this.outBoundMessenger = this.transport.endpoint.getMessenger(realAddr);
                if (this.outBoundMessenger == null) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)("sendToRemoteTls : could not get messenger for " + realAddr));
                    }
                    return false;
                }
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("sendToRemoteTls : Sending " + msg + " to endpoint " + this.destAddr));
        }
        return this.outBoundMessenger.sendMessage(msg);
    }

    void setPlaintextOutputStream(OutputStream s) {
        this.plaintext_out = new BufferedOutputStream(s, 16000);
    }

    void sendMessage(Message msg) throws IOException {
        try {
            WireFormatMessage serialed = WireFormatMessageFactory.toWire(msg, JTlsDefs.MTYPE, null);
            serialed.sendToStream(new IgnoreFlushFilterOutputStream(this.plaintext_out));
            this.plaintext_out.flush();
        }
        catch (IOException failed) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("sendMessage : Closing " + this + " due to exception "), (Throwable)failed);
            }
            this.close(HandshakeState.CONNECTIONDEAD);
            throw failed;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReadPlaintextMessage
    implements Runnable {
        volatile boolean closed = false;
        InputStream ptin = null;
        TlsTransport tp = null;
        int nErrors = 0;
        Thread th = null;

        public ReadPlaintextMessage(TlsTransport tp, InputStream ptin) {
            this.ptin = ptin;
            this.tp = tp;
            this.th = new Thread(tp.myThreadGroup, this, "JXTA TLS Plaintext Reader for " + TlsConn.this.destAddr);
            this.th.setDaemon(true);
            this.th.start();
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Started ReadPlaintextMessage thread for " + TlsConn.this.destAddr));
            }
        }

        public void close() {
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block16: {
                try {
                    try {
                        while (!this.closed) {
                            try {
                                Message msg = WireFormatMessageFactory.fromWire(this.ptin, JTlsDefs.MTYPE, null);
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)"Dispatching msg to TlsTransport");
                                }
                                this.tp.processReceivedMessage(msg);
                                TlsConn tlsConn = TlsConn.this;
                                synchronized (tlsConn) {
                                    TlsConn.this.lastAccessed = TimeUtils.timeNow();
                                }
                                this.nErrors = 0;
                            }
                            catch (IOException iox) {
                                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)"I/O error while reading decrypted Message", (Throwable)iox);
                                }
                                ++this.nErrors;
                                if (this.nErrors != 10) continue;
                                try {
                                    TlsConn.this.close(HandshakeState.CONNECTIONDEAD);
                                }
                                catch (IOException ignored) {}
                                break;
                            }
                        }
                    }
                    catch (Throwable all) {
                        if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                            LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                        }
                        Object var5_7 = null;
                        this.closed = true;
                        break block16;
                    }
                    Object var5_6 = null;
                    this.closed = true;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.closed = true;
                    throw throwable;
                }
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Finishing ReadPlaintextMessage thread");
            }
            this.th = null;
            this.ptin = null;
        }
    }

    static class HandshakeState {
        public static final HandshakeState CLIENTSTART = new HandshakeState(){

            public String toString() {
                return "CLIENTSTART";
            }
        };
        public static final HandshakeState SERVERSTART = new HandshakeState(){

            public String toString() {
                return "SERVERSTART";
            }
        };
        public static final HandshakeState HANDSHAKESTARTED = new HandshakeState(){

            public String toString() {
                return "HANDSHAKESTARTED";
            }
        };
        public static final HandshakeState HANDSHAKEFAILED = new HandshakeState(){

            public String toString() {
                return "HANDSHAKEFAILED";
            }
        };
        public static final HandshakeState HANDSHAKEFINISHED = new HandshakeState(){

            public String toString() {
                return "HANDSHAKEFINISHED";
            }
        };
        public static final HandshakeState CONNECTIONCLOSING = new HandshakeState(){

            public String toString() {
                return "CONNECTIONCLOSING";
            }
        };
        public static final HandshakeState CONNECTIONDEAD = new HandshakeState(){

            public String toString() {
                return "CONNECTIONDEAD";
            }
        };

        private HandshakeState() {
        }
    }
}

