/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class TlsManager
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$tls$TlsManager == null ? (class$net$jxta$impl$endpoint$tls$TlsManager = TlsManager.class$("net.jxta.impl.endpoint.tls.TlsManager")) : class$net$jxta$impl$endpoint$tls$TlsManager).getName());
    private TlsTransport transport = null;
    private Map connections = new HashMap();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsManager;

    TlsManager(TlsTransport tp) {
        this.transport = tp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Shutting down all connections");
        }
        Map map = this.connections;
        synchronized (map) {
            Iterator eachConnection = this.connections.values().iterator();
            while (eachConnection.hasNext()) {
                block7: {
                    TlsConn aConnection = (TlsConn)eachConnection.next();
                    try {
                        aConnection.close(TlsConn.HandshakeState.CONNECTIONDEAD);
                    }
                    catch (IOException ignored) {
                        if (!LOG.isEnabledFor((Priority)Level.INFO)) break block7;
                        LOG.info((Object)("Non-fatal problem shutting down connection to " + aConnection));
                    }
                }
                eachConnection.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TlsConn getTlsConn(EndpointAddress dstAddr) {
        boolean startHandshake = false;
        String paddr = dstAddr.getProtocolAddress();
        TlsConn conn = null;
        Map map = this.connections;
        synchronized (map) {
            conn = (TlsConn)this.connections.get(paddr);
            if (null != conn && (TlsConn.HandshakeState.CONNECTIONDEAD == conn.getHandshakeState() || TlsConn.HandshakeState.HANDSHAKEFAILED == conn.getHandshakeState())) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Removing connection for: " + paddr));
                }
                this.connections.remove(paddr);
                conn = null;
            }
            if (null == conn) {
                conn = new TlsConn(this.transport, dstAddr, true);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Adding connection for: " + paddr));
                }
                this.connections.put(paddr, conn);
                startHandshake = true;
            }
        }
        if (startHandshake) {
            try {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Start of client handshake for " + paddr));
                }
                conn.init();
                conn.setHandshakeState(TlsConn.HandshakeState.HANDSHAKESTARTED);
                conn.openTLSConnection();
                conn.setHandshakeState(TlsConn.HandshakeState.HANDSHAKEFINISHED);
            }
            catch (Throwable e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("failed making connection to " + paddr), e);
                }
                Map map2 = this.connections;
                synchronized (map2) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Removing connection for: " + paddr));
                    }
                    this.connections.remove(paddr);
                }
                try {
                    conn.close(TlsConn.HandshakeState.HANDSHAKEFAILED);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return null;
            }
        }
        while (true) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getTlsConn : getting " + conn));
            }
            TlsConn tlsConn = conn;
            synchronized (tlsConn) {
                TlsConn.HandshakeState currentState = conn.getHandshakeState();
                if (TlsConn.HandshakeState.SERVERSTART == currentState || TlsConn.HandshakeState.CLIENTSTART == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("getTlsConn: Sleeping until handshake starts for " + paddr));
                    }
                    try {
                        conn.wait();
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                    continue;
                }
                if (TlsConn.HandshakeState.HANDSHAKESTARTED == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("getTlsConn: Handshake in progress for " + paddr));
                    }
                    try {
                        conn.wait(60000L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                    continue;
                }
                if (TlsConn.HandshakeState.HANDSHAKEFINISHED == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("getTlsConn: Returning active connection to " + paddr));
                    }
                    conn.lastAccessed = TimeUtils.timeNow();
                    return conn;
                }
                if (TlsConn.HandshakeState.HANDSHAKEFAILED == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("getTlsConn: Handshake failed. " + paddr + " unreachable"));
                    }
                    return null;
                }
                if (TlsConn.HandshakeState.CONNECTIONDEAD == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("getTlsConn: Connection dead for " + paddr));
                    }
                    return null;
                }
                if (TlsConn.HandshakeState.CONNECTIONCLOSING == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("getTlsConn: Connection closing for " + paddr));
                    }
                    return null;
                }
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)("getTlsConn: Unhandled Handshake state: " + currentState));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        MessageElement retryElement;
        boolean retrans;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("processIncomingMessage starts for " + msg));
        }
        boolean bl = retrans = null != (retryElement = msg.getMessageElement("jxtatls", "MARKRetr"));
        if (retrans) {
            msg.removeMessageElement(retryElement);
            retryElement = null;
        }
        int seqN = TlsManager.getMsgSequenceNumber(msg);
        String paddr = srcAddr.getProtocolAddress();
        TlsConn conn = null;
        boolean serverStart = false;
        Map map = this.connections;
        synchronized (map) {
            conn = (TlsConn)this.connections.get(paddr);
            if (null != conn) {
                if (1 == seqN) {
                    TlsConn tlsConn = conn;
                    synchronized (tlsConn) {
                        long idle = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), conn.lastAccessed);
                        if (idle > this.transport.MIN_IDLE_RECONNECT) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)("Restarting : " + conn + " which has been idle for " + idle + " millis"));
                            }
                            try {
                                conn.close(TlsConn.HandshakeState.CONNECTIONDEAD);
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (TlsConn.HandshakeState.CONNECTIONDEAD == conn.getHandshakeState() || TlsConn.HandshakeState.HANDSHAKEFAILED == conn.getHandshakeState()) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Removing connection for: " + paddr));
                    }
                    this.connections.remove(paddr);
                    conn = null;
                }
            }
            if (null == conn) {
                if (1 == seqN) {
                    conn = new TlsConn(this.transport, srcAddr, false);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Adding connection for: " + paddr));
                    }
                    this.connections.put(paddr, conn);
                    serverStart = true;
                } else {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)(msg + " is not start of handshake (seqn#" + seqN + ") for " + paddr));
                    }
                    msg.clear();
                    return;
                }
            }
        }
        if (serverStart) {
            try {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Start of SERVER handshake for " + paddr));
                }
                conn.init();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Queue initial message seqn#" + seqN + " for " + paddr));
                }
                conn.jin.queueIncomingMessage(msg);
                conn.setHandshakeState(TlsConn.HandshakeState.HANDSHAKESTARTED);
                conn.openTLSConnection();
                conn.setHandshakeState(TlsConn.HandshakeState.HANDSHAKEFINISHED);
                conn.lastAccessed = TimeUtils.timeNow();
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Handshake complete for SERVER TLS for: " + paddr));
                }
                return;
            }
            catch (Throwable e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("TLS Handshake failure for connection: " + paddr), e);
                }
                Map map2 = this.connections;
                synchronized (map2) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Removing connection for: " + paddr));
                    }
                    this.connections.remove(paddr);
                }
                try {
                    conn.close(TlsConn.HandshakeState.HANDSHAKEFAILED);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return;
            }
        }
        while (true) {
            TlsConn.HandshakeState currentState;
            TlsConn tlsConn = conn;
            synchronized (tlsConn) {
                if (retrans) {
                    ++conn.retrans;
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("retrans received, " + conn.retrans + " total."));
                    }
                    retrans = false;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Process incoming message for " + conn));
                }
                if (TlsConn.HandshakeState.HANDSHAKESTARTED != (currentState = conn.getHandshakeState()) && TlsConn.HandshakeState.HANDSHAKEFINISHED != currentState && TlsConn.HandshakeState.CONNECTIONCLOSING != currentState) {
                    if (TlsConn.HandshakeState.CONNECTIONDEAD == currentState) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("Connection failed, discarding msg with seqn#" + seqN + " for " + paddr));
                        }
                        return;
                    }
                    if (TlsConn.HandshakeState.SERVERSTART == currentState || TlsConn.HandshakeState.CLIENTSTART == currentState) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Sleeping msg with seqn#" + seqN + " until handshake starts for " + paddr));
                        }
                        try {
                            conn.wait(60000L);
                        }
                        catch (InterruptedException woken) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    if (TlsConn.HandshakeState.HANDSHAKEFAILED == currentState) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("Handshake failed, discarding msg with seqn#" + seqN + " for " + paddr));
                        }
                        return;
                    }
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Unexpected state : " + currentState));
                    }
                }
            }
            if (TlsConn.HandshakeState.HANDSHAKESTARTED == currentState || TlsConn.HandshakeState.HANDSHAKEFINISHED == currentState || TlsConn.HandshakeState.CONNECTIONCLOSING == currentState) break;
        }
        Message.ElementIterator eachACK = msg.getMessageElements("jxtatls", JTlsDefs.ACKS);
        while (eachACK.hasNext()) {
            MessageElement elt = (MessageElement)eachACK.next();
            eachACK.remove();
            int sackCount = (int)elt.getByteLength() / 4 - 1;
            try {
                DataInputStream dis = new DataInputStream(elt.getStream());
                int seqack = dis.readInt();
                int[] sacs = new int[sackCount];
                int eachSac = 0;
                while (eachSac < sackCount) {
                    sacs[eachSac] = dis.readInt();
                    ++eachSac;
                }
                Arrays.sort(sacs);
                conn.jout.ackReceived(seqack, sacs);
            }
            catch (IOException failed) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)"Failure processing ACK", (Throwable)failed);
            }
        }
        if (0 == seqN) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Queue message " + msg + " seqn#" + seqN + " for " + conn));
        }
        conn.jin.queueIncomingMessage(msg);
    }

    private static int getMsgSequenceNumber(Message msg) {
        int seqN = 0;
        Message.ElementIterator eachElement = msg.getMessageElements("jxtatls", JTlsDefs.BLOCKS);
        while (eachElement.hasNext()) {
            MessageElement elt = (MessageElement)eachElement.next();
            try {
                seqN = Integer.parseInt(elt.getElementName());
                break;
            }
            catch (NumberFormatException e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Bad tls record name=" + elt.getElementName()));
                }
                eachElement.remove();
            }
        }
        return seqN;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

