/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsTransport;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TlsMessenger
extends BlockingMessenger {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$tls$TlsMessenger == null ? (class$net$jxta$impl$endpoint$tls$TlsMessenger = TlsMessenger.class$("net.jxta.impl.endpoint.tls.TlsMessenger")) : class$net$jxta$impl$endpoint$tls$TlsMessenger).getName());
    private TlsTransport transport = null;
    private TlsConn conn = null;
    private EndpointAddress srcAddress = null;
    private MessageElement srcAddressElement = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsMessenger;

    TlsMessenger(EndpointAddress destAddress, TlsConn conn, TlsTransport tp) {
        super(destAddress);
        if (conn == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"null TLS connection!");
            }
            throw new IllegalArgumentException("null TLS connection!");
        }
        this.conn = conn;
        this.transport = tp;
        this.srcAddress = this.transport.getPublicAddress();
        this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", this.srcAddress.toString(), (MessageElement)null);
    }

    public synchronized void close() {
        super.close();
        this.conn = null;
    }

    public EndpointAddress getLogicalDestinationAddress() {
        return new EndpointAddress("jxta", this.dstAddress.getProtocolAddress(), null, null);
    }

    public synchronized boolean sendMessage(Message message, String service, String serviceParam) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"sendMessage starts");
        }
        if (TlsConn.HandshakeState.CONNECTIONDEAD == this.conn.getHandshakeState()) {
            this.close();
        }
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger is closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)failure, (Throwable)failure);
            }
            throw failure;
        }
        message.replaceMessageElement("jxta", this.srcAddressElement);
        StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", this.getDestAddressToUse(service, serviceParam).toString(), (MessageElement)null);
        message.replaceMessageElement("jxta", dstAddressElement);
        try {
            this.conn.sendMessage(message);
        }
        catch (IOException caught) {
            this.close();
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)("Message send to '" + this.dstAddress + "' failed for " + message), (Throwable)caught);
            }
            throw caught;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Message send to '" + this.dstAddress + "' succeeded for " + message));
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

