/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsManager;
import net.jxta.impl.endpoint.tls.TlsMessenger;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TlsTransport
implements Module,
MessageSender,
MessageReceiver {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$tls$TlsTransport == null ? (class$net$jxta$impl$endpoint$tls$TlsTransport = TlsTransport.class$("net.jxta.impl.endpoint.tls.TlsTransport")) : class$net$jxta$impl$endpoint$tls$TlsTransport).getName());
    static final boolean ACT_AS_SERVER = true;
    private PeerGroup group = null;
    EndpointService endpoint = null;
    PSEMembershipService membership = null;
    EndpointAddress localPeerAddr = null;
    EndpointAddress localTlsPeerAddr = null;
    PeerID localPeerId = null;
    long MIN_IDLE_RECONNECT = 600000L;
    long CONNECTION_IDLE_TIMEOUT = 1800000L;
    long RETRMAXAGE = 600000L;
    private TlsManager manager = null;
    ThreadGroup myThreadGroup = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsTransport;

    public TlsTransport() {
        try {
            long override_long;
            String override_str;
            ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.user");
            try {
                override_str = jxtaRsrcs.getString("impl.endpoint.tls.connection.idletimeout");
                if (null != override_str && (override_long = Long.parseLong(override_str.trim())) >= 1L) {
                    this.CONNECTION_IDLE_TIMEOUT = override_long * 60000L;
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Adjusting TLS connection idle timeout to " + this.CONNECTION_IDLE_TIMEOUT + " millis."));
                    }
                }
            }
            catch (NumberFormatException badvalue) {
                // empty catch block
            }
            try {
                override_str = jxtaRsrcs.getString("impl.endpoint.tls.connection.minidlereconnect");
                if (null != override_str && (override_long = Long.parseLong(override_str.trim())) >= 1L) {
                    this.MIN_IDLE_RECONNECT = override_long * 60000L;
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Adjusting TLS min reconnection idle to " + this.MIN_IDLE_RECONNECT + " millis."));
                    }
                }
            }
            catch (NumberFormatException badvalue) {
                // empty catch block
            }
            try {
                override_str = jxtaRsrcs.getString("impl.endpoint.tls.connection.maxretryage");
                if (null != override_str && (override_long = Long.parseLong(override_str.trim())) >= 1L) {
                    this.RETRMAXAGE = override_long * 60000L;
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Adjusting TLS maximum retry queue age to " + this.RETRMAXAGE + " millis."));
                    }
                }
            }
            catch (NumberFormatException badvalue) {
                // empty catch block
            }
            this.MIN_IDLE_RECONNECT = Math.min(this.MIN_IDLE_RECONNECT, this.CONNECTION_IDLE_TIMEOUT);
            this.RETRMAXAGE = Math.min(this.RETRMAXAGE, this.CONNECTION_IDLE_TIMEOUT);
        }
        catch (MissingResourceException notthere) {}
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (null == target) {
            return false;
        }
        if (target instanceof TlsTransport) {
            TlsTransport likeMe = (TlsTransport)target;
            if (!this.getProtocolName().equals(likeMe.getProtocolName())) {
                return false;
            }
            return this.localTlsPeerAddr.equals(likeMe.localTlsPeerAddr);
        }
        return false;
    }

    PeerGroup getPeerGroup() {
        return this.group;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.group = group;
        this.endpoint = group.getEndpointService();
        this.localPeerId = group.getPeerID();
        this.localPeerAddr = this.mkAddress(group.getPeerID(), null, null);
        this.localTlsPeerAddr = new EndpointAddress(JTlsDefs.tlsPName, this.localPeerId.getUniqueValue().toString(), null, null);
        ModuleImplAdvertisement implAdvertisement = (ModuleImplAdvertisement)impl;
        this.myThreadGroup = new ThreadGroup(group.getHomeThreadGroup(), "TLSTransport " + this.localTlsPeerAddr);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring TLS Transport : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tImpl Description: " + implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tProtocol: " + JTlsDefs.tlsPName);
            configInfo.append("\n\t\tOutgoing Connections Enabled: " + Boolean.TRUE);
            configInfo.append("\n\t\tIncoming Connections Enabled: true");
            configInfo.append("\n\t\tMinimum idle for reconnect : " + this.MIN_IDLE_RECONNECT + " millis");
            configInfo.append("\n\t\tConnection idle timeout : " + this.CONNECTION_IDLE_TIMEOUT + " millis");
            configInfo.append("\n\t\tRetry queue maximum age : " + this.RETRMAXAGE + " millis");
            configInfo.append("\n\t\tPeerID : " + this.localPeerId);
            configInfo.append("\n\t\tRoute through : " + this.localPeerAddr);
            configInfo.append("\n\t\tPublic Address : " + this.localTlsPeerAddr);
            LOG.info((Object)configInfo);
        }
    }

    public int startApp(String[] args) {
        MembershipService groupMembership = this.group.getMembershipService();
        if (!(groupMembership instanceof PSEMembershipService)) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"TLS Transport requires PSE Membership Service");
            }
            return -1;
        }
        this.membership = (PSEMembershipService)groupMembership;
        this.manager = new TlsManager(this);
        try {
            this.endpoint.addIncomingMessageListener(this.manager, "TlsTransport", null);
        }
        catch (Throwable e2) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"TLS could not register listener...as good as dead", e2);
            }
            return -1;
        }
        this.endpoint.addMessageTransport(this);
        return 0;
    }

    public void stopApp() {
        this.endpoint.removeIncomingMessageListener("TlsTransport", null);
        this.endpoint.removeMessageTransport(this);
        this.manager.close();
        this.manager = null;
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowsRouting() {
        return false;
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    public EndpointAddress getPublicAddress() {
        return (EndpointAddress)this.localTlsPeerAddr.clone();
    }

    public EndpointService getEndpointService() {
        return this.endpoint;
    }

    public Iterator getPublicAddresses() {
        return Collections.singletonList(this.getPublicAddress()).iterator();
    }

    public String getProtocolName() {
        return JTlsDefs.tlsPName;
    }

    public void propagate(Message srcMsg, String pName, String pParam, String prunePeer) throws IOException {
    }

    public boolean ping(EndpointAddress addr) {
        return null != this.getMessenger(addr, null);
    }

    public Messenger getMessenger(EndpointAddress addr, Object hintIgnored) {
        EndpointAddress plainAddress;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("TlsTransport: getMessanger for " + addr.toString()));
        }
        if ((plainAddress = new EndpointAddress(addr, null, null)).equals(this.localTlsPeerAddr)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"getMessenger: return LoopbackMessenger");
            }
            return new TlsLoopbackMessenger(this.endpoint, plainAddress, addr, this.localPeerAddr);
        }
        EndpointAddress dstPAddr = this.mkAddress("urn:jxta:" + addr.getProtocolAddress(), null, null);
        TlsConn conn = this.manager.getTlsConn(dstPAddr);
        if (conn == null) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Cannot get a TLS connection");
            }
            return null;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"TlsTransport: TlsMessanger with TlsConn DONE");
        }
        return new TlsMessenger(addr, conn, this);
    }

    void processReceivedMessage(Message msg) {
        block3: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"processReceivedMessage starts");
            }
            msg.setMessageProperty(class$net$jxta$impl$endpoint$tls$TlsTransport == null ? (class$net$jxta$impl$endpoint$tls$TlsTransport = TlsTransport.class$("net.jxta.impl.endpoint.tls.TlsTransport")) : class$net$jxta$impl$endpoint$tls$TlsTransport, this);
            try {
                this.endpoint.demux(msg);
            }
            catch (Throwable e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"Failure demuxing an incoming message", e);
            }
        }
    }

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
        }
        catch (MalformedURLException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        catch (UnknownServiceException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return this.mkAddress(asID, serv, parm);
    }

    private EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    File getRootCert(EndpointAddress destAddr) {
        ID peerID = null;
        try {
            String urn = "urn:jxta:" + destAddr.getProtocolAddress();
            peerID = IDFactory.fromURL(IDFactory.jxtaURL(urn));
        }
        catch (UnknownServiceException badID) {
            throw new IllegalArgumentException("Unusable ID in endpoint address");
        }
        catch (MalformedURLException badID) {
            throw new IllegalArgumentException("Unusable ID in endpoint address");
        }
        DiscoveryService discovery = this.group.getDiscoveryService();
        try {
            Enumeration enumeration = null;
            String rc = null;
            enumeration = discovery.getLocalAdvertisements(0, "PID", peerID.toString());
            if (!enumeration.hasMoreElements()) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("getRootCert: no peer advertisement found for : " + peerID));
                }
                return null;
            }
            PeerAdvertisement adv = (PeerAdvertisement)enumeration.nextElement();
            StructuredDocument doc = adv.getServiceParam(PeerGroup.peerGroupClassID);
            Enumeration children = doc.getChildren("RootCert");
            rc = ((TextElement)children.nextElement()).getTextValue();
            rc = rc + "\n";
            byte[] cert_der = PSEUtils.base64Decode(rc);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert_der));
            this.membership.getPSEConfig().writeRootCert(peerID, cert);
            File rcFile = this.membership.getPSEConfig().getRootCertFile(peerID);
            PSEUtils.writeBase64Cert(rcFile, rc);
            rcFile.deleteOnExit();
            return rcFile;
        }
        catch (Throwable s) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"genRootCert, Exception: ", s);
            }
            return null;
        }
    }

    void removeRootCertFile(EndpointAddress destAddr) {
        block7: {
            ID peerID = null;
            try {
                String urn = "urn:jxta:" + destAddr.getProtocolAddress();
                peerID = IDFactory.fromURL(IDFactory.jxtaURL(urn));
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in endpoint address");
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Unusable ID in endpoint address");
            }
            File rcFile = this.membership.getPSEConfig().getRootCertFile(peerID);
            try {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    rcFile.delete();
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Removed root cert for :" + peerID));
                }
            }
            catch (Throwable e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)("Failed to delete :" + rcFile));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TlsLoopbackMessenger
    extends LoopbackMessenger {
        TlsLoopbackMessenger(EndpointService ep, EndpointAddress src, EndpointAddress dest, EndpointAddress logicalDest) {
            super(ep, src, dest, logicalDest);
        }

        public boolean sendMessage(Message message, String service, String serviceParam) throws IOException {
            if (this.isClosed()) {
                IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)failure, (Throwable)failure);
                }
                throw failure;
            }
            message.setMessageProperty(class$net$jxta$impl$endpoint$tls$TlsTransport == null ? (class$net$jxta$impl$endpoint$tls$TlsTransport = TlsTransport.class$("net.jxta.impl.endpoint.tls.TlsTransport")) : class$net$jxta$impl$endpoint$tls$TlsTransport, TlsTransport.this);
            return super.sendMessage(message, service, serviceParam);
        }
    }
}

