/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.transportMeter;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.exception.JxtaException;
import net.jxta.impl.endpoint.transportMeter.TransportMetric;
import net.jxta.impl.endpoint.transportMeter.TransportServiceMonitorFilter;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.ServiceMetric;
import net.jxta.platform.ModuleClassID;
import net.jxta.util.JxtaUtilities;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class TransportServiceMetric
implements ServiceMetric {
    private LinkedList transportMetrics = new LinkedList();
    private ModuleClassID moduleClassID = MonitorResources.transportServiceMonitorClassID;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$transportMeter$TransportMetric;

    public void init(ModuleClassID moduleClassID) {
        this.moduleClassID = moduleClassID;
    }

    public ModuleClassID getModuleClassID() {
        return this.moduleClassID;
    }

    public void addTransportMetric(TransportMetric transportMetric) {
        this.transportMetrics.add(transportMetric);
    }

    public Iterator getTransportMetrics() {
        return this.transportMetrics.iterator();
    }

    public TransportMetric getTransportMetric(String protocol, EndpointAddress endpointAddress) {
        Iterator i = this.transportMetrics.iterator();
        while (i.hasNext()) {
            TransportMetric transportMetric = (TransportMetric)i.next();
            if (!protocol.equals(transportMetric.getProtocol()) || !endpointAddress.equals(transportMetric.getEndpointAddress())) continue;
            return transportMetric;
        }
        return null;
    }

    public TransportMetric getTransportMetric(TransportMetric prototype) {
        return this.getTransportMetric(prototype.getProtocol(), prototype.getEndpointAddress());
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        Iterator i = this.transportMetrics.iterator();
        while (i.hasNext()) {
            TransportMetric transportMetric = (TransportMetric)i.next();
            DocumentSerializableUtilities.addDocumentSerializable(element2, "transportMetric", transportMetric);
        }
        if (this.moduleClassID != null) {
            DocumentSerializableUtilities.addString(element2, "moduleClassID", this.moduleClassID.toString());
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("transportMetric")) {
                TransportMetric transportMetric = (TransportMetric)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, class$net$jxta$impl$endpoint$transportMeter$TransportMetric == null ? TransportServiceMetric.class$("net.jxta.impl.endpoint.transportMeter.TransportMetric") : class$net$jxta$impl$endpoint$transportMeter$TransportMetric);
                this.transportMetrics.add(transportMetric);
            }
            if (!tagName.equals("moduleClassID")) continue;
            try {
                this.moduleClassID = (ModuleClassID)JxtaUtilities.getIdFromString(DocumentSerializableUtilities.getString(childElement));
            }
            catch (JxtaException jex) {
                throw new DocumentSerializationException("Can't read moduleClassID", jex);
            }
        }
    }

    public TransportServiceMetric shallowCopy(TransportServiceMonitorFilter transportServiceMonitorFilter) {
        TransportServiceMetric serviceMetric = new TransportServiceMetric();
        serviceMetric.moduleClassID = this.moduleClassID;
        Iterator i = this.getTransportMetrics();
        while (i.hasNext()) {
            TransportMetric transportMetric = (TransportMetric)i.next();
            String protocol = transportMetric.getProtocol();
            if (!transportServiceMonitorFilter.hasTransport(protocol)) continue;
            serviceMetric.addTransportMetric(transportMetric);
        }
        return serviceMetric;
    }

    public void mergeMetrics(ServiceMetric serviceMetric) {
        this.mergeMetrics(serviceMetric, null);
    }

    public void mergeMetrics(ServiceMetric serviceMetric, TransportServiceMonitorFilter transportServiceMonitorFilter) {
        TransportServiceMetric otherTransportServiceMetric = (TransportServiceMetric)serviceMetric;
        Iterator i = otherTransportServiceMetric.getTransportMetrics();
        while (i.hasNext()) {
            TransportMetric otherTransportMetric = (TransportMetric)i.next();
            String protocol = otherTransportMetric.getProtocol();
            if (transportServiceMonitorFilter != null && !transportServiceMonitorFilter.hasTransport(protocol)) continue;
            TransportMetric transportMetric = this.getTransportMetric(otherTransportMetric.getProtocol(), otherTransportMetric.getEndpointAddress());
            if (transportMetric == null) {
                transportMetric = new TransportMetric(otherTransportMetric);
                this.addTransportMetric(transportMetric);
            }
            transportMetric.mergeMetrics(otherTransportMetric);
        }
    }

    public TransportServiceMetric deepCopy(TransportServiceMonitorFilter transportServiceMonitorFilter) {
        TransportServiceMetric serviceMetric = new TransportServiceMetric();
        serviceMetric.moduleClassID = this.moduleClassID;
        serviceMetric.mergeMetrics(this, transportServiceMonitorFilter);
        return serviceMetric;
    }

    public void diffMetrics(ServiceMetric otherOne) {
        throw new RuntimeException("Not Supported");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

