/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.CBID;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import net.jxta.id.ID;
import net.jxta.impl.id.CBID.CodatID;
import net.jxta.impl.id.CBID.IDFormat;
import net.jxta.impl.id.CBID.ModuleClassID;
import net.jxta.impl.id.CBID.ModuleSpecID;
import net.jxta.impl.id.CBID.PeerGroupID;
import net.jxta.impl.id.CBID.PeerID;
import net.jxta.impl.id.CBID.PipeID;
import net.jxta.impl.id.UUID.IDBytes;

public class Instantiator
extends net.jxta.impl.id.UUID.Instantiator {
    static final String CBIDEncoded = "cbid";

    public String getSupportedIDFormat() {
        return CBIDEncoded;
    }

    public ID fromURL(URL source) throws MalformedURLException, UnknownServiceException {
        if (!"urn".equalsIgnoreCase(source.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String encoded = source.getFile();
        int colonAt = encoded.indexOf(58);
        if (-1 == colonAt) {
            throw new UnknownServiceException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(encoded.substring(0, colonAt))) {
            throw new UnknownServiceException("URN namespace was not as expected.");
        }
        int dashAt = (encoded = encoded.substring(colonAt + 1)).indexOf(45);
        if (-1 == dashAt) {
            throw new UnknownServiceException("URN Encodingtype was missing.");
        }
        if (!encoded.substring(0, dashAt).equals(this.getSupportedIDFormat())) {
            throw new UnknownServiceException("JXTA ID Format was not as expected.");
        }
        if (0 != (encoded = encoded.substring(dashAt + 1)).length() % 2) {
            throw new MalformedURLException("URN contains an odd number of chars");
        }
        if (encoded.length() < 2) {
            throw new MalformedURLException("URN does not contain enough chars");
        }
        if (64 < encoded.length() % 2) {
            throw new MalformedURLException("URN contains too many chars");
        }
        ID result = null;
        IDBytes id = new IDBytes();
        try {
            int eachByte = 0;
            while (eachByte < encoded.length() / 2 - 1) {
                int index = eachByte * 2;
                String twoChars = encoded.substring(index, index + 2);
                id.bytes[eachByte] = (byte)Integer.parseInt(twoChars, 16);
                ++eachByte;
            }
            int eachByte2 = 63;
            while (eachByte2 < 64) {
                int index = encoded.length() - (64 - eachByte2) * 2;
                String twoChars = encoded.substring(index, index + 2);
                id.bytes[eachByte2] = (byte)Integer.parseInt(twoChars, 16);
                ++eachByte2;
            }
        }
        catch (NumberFormatException caught) {
            throw new MalformedURLException("Invalid Character in JXTA URI");
        }
        switch (id.bytes[63]) {
            case 1: {
                result = new CodatID(id);
                break;
            }
            case 2: {
                result = new PeerGroupID(id);
                result = (PeerGroupID)IDFormat.translateToWellKnown(result);
                break;
            }
            case 3: {
                result = new PeerID(id);
                break;
            }
            case 4: {
                result = new PipeID(id);
                break;
            }
            case 5: {
                result = new ModuleClassID(id);
                break;
            }
            case 6: {
                result = new ModuleSpecID(id);
                break;
            }
            default: {
                throw new MalformedURLException("JXTA ID Type not recognized");
            }
        }
        return result;
    }

    public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID groupID) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatID(peerGroupID);
    }

    public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID groupID, byte[] seed) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatID(peerGroupID, seed);
    }

    public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID groupID, InputStream in) throws IOException {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatID(peerGroupID, in);
    }

    public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID groupID, byte[] seed, InputStream in) throws IOException {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatID(peerGroupID, seed, in);
    }

    public net.jxta.peergroup.PeerGroupID newPeerGroupID() {
        return new PeerGroupID();
    }

    public net.jxta.peergroup.PeerGroupID newPeerGroupID(byte[] seed) {
        return new PeerGroupID(seed);
    }

    public net.jxta.peergroup.PeerGroupID newPeerGroupID(net.jxta.peergroup.PeerGroupID parent) {
        return new PeerGroupID();
    }

    public net.jxta.peergroup.PeerGroupID newPeerGroupID(net.jxta.peergroup.PeerGroupID parent, byte[] seed) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(parent);
        return new PeerGroupID(parentGroupID, seed);
    }

    public net.jxta.peer.PeerID newPeerID(net.jxta.peergroup.PeerGroupID groupID) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        throw new UnsupportedOperationException("Must provide a cert as seed to generate a peer id.");
    }

    public net.jxta.peer.PeerID newPeerID(net.jxta.peergroup.PeerGroupID groupID, byte[] seed) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PeerID(peerGroupID, seed);
    }

    public net.jxta.pipe.PipeID newPipeID(net.jxta.peergroup.PeerGroupID groupID) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PipeID(peerGroupID);
    }

    public net.jxta.pipe.PipeID newPipeID(net.jxta.peergroup.PeerGroupID groupID, byte[] seed) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PipeID(peerGroupID, seed);
    }

    public net.jxta.platform.ModuleClassID newModuleClassID() {
        return new ModuleClassID();
    }

    public net.jxta.platform.ModuleClassID newModuleClassID(net.jxta.platform.ModuleClassID classID) {
        return new ModuleClassID((ModuleClassID)classID);
    }

    public net.jxta.platform.ModuleSpecID newModuleSpecID(net.jxta.platform.ModuleClassID classID) {
        return new ModuleSpecID((ModuleClassID)classID);
    }
}

