/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.net.URL;
import net.jxta.id.ID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import org.apache.log4j.Logger;

public class PipeID
extends net.jxta.pipe.PipeID {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$id$UUID$PipeID == null ? (class$net$jxta$impl$id$UUID$PipeID = PipeID.class$("net.jxta.impl.id.UUID.PipeID")) : class$net$jxta$impl$id$UUID$PipeID).getName());
    protected static final int groupIdOffset = 0;
    protected static final int idOffset = 16;
    protected static final int padOffset = 32;
    protected static final int padSize = 31;
    protected IDBytes id;
    static /* synthetic */ Class class$net$jxta$impl$id$UUID$PipeID;

    protected PipeID() {
        this.id = new IDBytes();
        this.id.bytes[63] = 4;
    }

    protected PipeID(IDBytes id) {
        this.id = id;
    }

    protected PipeID(UUID groupUUID, UUID idUUID) {
        this();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, idUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, idUUID.getLeastSignificantBits());
    }

    public PipeID(PeerGroupID groupID) {
        this(groupID.getUUID(), UUIDFactory.newUUID());
    }

    public PipeID(PeerGroupID groupID, byte[] seed) {
        this();
        UUID groupUUID = groupID.getUUID();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        int copySeed = Math.min(16, seed.length) - 1;
        while (copySeed >= 0) {
            this.id.bytes[copySeed + 16] = seed[copySeed];
            --copySeed;
        }
        this.id.bytes[22] = (byte)(this.id.bytes[22] & 0xF);
        this.id.bytes[22] = (byte)(this.id.bytes[22] | 0x40);
        this.id.bytes[24] = (byte)(this.id.bytes[24] & 0x3F);
        this.id.bytes[24] = (byte)(this.id.bytes[24] | 0x80);
        this.id.bytes[26] = (byte)(this.id.bytes[26] & 0x3F);
        this.id.bytes[26] = (byte)(this.id.bytes[26] | 0x80);
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof PipeID) {
            PipeID pipeTarget = (PipeID)target;
            if (!this.getIDFormat().equals(pipeTarget.getIDFormat())) {
                return false;
            }
            if (this.id == pipeTarget.id) {
                return true;
            }
            boolean result = this.id.equals(pipeTarget.id);
            if (result) {
                pipeTarget.id = this.id;
            }
            return result;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public ID getPeerGroupID() {
        UUID groupUUID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        PeerGroupID groupID = new PeerGroupID(groupUUID);
        return IDFormat.translateToWellKnown(groupID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

