/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.io.Serializable;

public final class UUID
implements Serializable {
    public static final UUID nullUUID = new UUID(0L, 0L);
    private long mostSig;
    private long leastSig;

    public UUID(long mostSig, long leastSig) {
        this.mostSig = mostSig;
        this.leastSig = leastSig;
    }

    public UUID(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("bytes must be 16 bytes in length");
        }
        long mostSig = 0L;
        int i = 0;
        while (i < 8) {
            mostSig = mostSig << 8 | (long)(bytes[i] & 0xFF);
            ++i;
        }
        long leastSig = 0L;
        int i2 = 8;
        while (i2 < 16) {
            leastSig = leastSig << 8 | (long)(bytes[i2] & 0xFF);
            ++i2;
        }
        this.mostSig = mostSig;
        this.leastSig = leastSig;
    }

    public UUID(String uuid) {
        if (36 != uuid.length()) {
            throw new IllegalArgumentException("uuid must be 36 characters in length");
        }
        byte[] bytes = new byte[16];
        boolean hi = true;
        int eachChar = 0;
        int offset = 0;
        while (eachChar < 36) {
            char aChar = uuid.charAt(eachChar);
            switch (eachChar) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if ('-' == uuid.charAt(eachChar)) break;
                    throw new IllegalArgumentException("uuid has an illegal character at position " + eachChar);
                }
                default: {
                    int aNibble;
                    aChar = Character.toLowerCase(aChar);
                    if ('0' <= aChar && '9' >= aChar) {
                        aNibble = aChar - 48;
                    } else if ('a' <= aChar && 'f' >= aChar) {
                        aNibble = aChar - 97 + 10;
                    } else {
                        throw new IllegalArgumentException("uuid has an illegal character at position " + eachChar);
                    }
                    if (hi) {
                        aNibble <<= 4;
                    }
                    int n = offset++;
                    bytes[n] = (byte)(bytes[n] | aNibble);
                    if (!hi) {
                        // empty if block
                    }
                    hi = !hi;
                }
            }
            ++eachChar;
        }
        this.mostSig = 0L;
        int i = 0;
        while (i < 8) {
            this.mostSig = this.mostSig << 8 | (long)(bytes[i] & 0xFF);
            ++i;
        }
        this.leastSig = 0L;
        int i2 = 8;
        while (i2 < 16) {
            this.leastSig = this.leastSig << 8 | (long)(bytes[i2] & 0xFF);
            ++i2;
        }
    }

    public long getMostSignificantBits() {
        return this.mostSig;
    }

    public long getLeastSignificantBits() {
        return this.leastSig;
    }

    public int hashCode() {
        return (int)(this.mostSig >> 32 ^ this.mostSig ^ this.leastSig >> 32 ^ this.leastSig);
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof UUID) {
            return this.equals((UUID)target);
        }
        return false;
    }

    public boolean equals(UUID sid) {
        return this.mostSig == sid.mostSig && this.leastSig == sid.leastSig;
    }

    public String toString() {
        return UUID.digits(this.mostSig >> 32, 8) + "-" + UUID.digits(this.mostSig >> 16, 4) + "-" + UUID.digits(this.mostSig, 4) + "-" + UUID.digits(this.leastSig >> 48, 4) + "-" + UUID.digits(this.leastSig, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }
}

