/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.security.SecureRandom;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import jxta.security.impl.random.JRandom;
import net.jxta.impl.id.UUID.UUID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class UUIDFactory {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$id$UUID$UUIDFactory == null ? (class$net$jxta$impl$id$UUID$UUIDFactory = UUIDFactory.class$("net.jxta.impl.id.UUID.UUIDFactory")) : class$net$jxta$impl$id$UUID$UUIDFactory).getName());
    static final long GREGORIAN_MILLIS_OFFSET = 12219292800000L;
    private long utc_offset = 0L;
    private long lastTimeSequence = 0L;
    private long inSequenceCounter = 0L;
    private long clock_seq = 0L;
    private long node = 0L;
    private Random randNum = null;
    private static UUIDFactory factory = new UUIDFactory();
    static /* synthetic */ Class class$net$jxta$impl$id$UUID$UUIDFactory;

    public static synchronized UUID newUUID() {
        return UUIDFactory.newUUID(UUIDFactory.factory.randNum.nextLong(), UUIDFactory.factory.randNum.nextLong());
    }

    private synchronized long getTimeSequence() {
        long now = (System.currentTimeMillis() - 12219292800000L + this.utc_offset) * 10000L;
        if (now > this.lastTimeSequence) {
            this.lastTimeSequence = now;
            this.inSequenceCounter = 0L;
        } else {
            ++this.inSequenceCounter;
            if (this.inSequenceCounter >= 10000L) {
                ++this.lastTimeSequence;
                this.inSequenceCounter = 0L;
            }
        }
        return now + this.inSequenceCounter;
    }

    public static UUID newSeqUUID() {
        long mostSig = 0L;
        long leastSig = 0L;
        long timeSeq = factory.getTimeSequence();
        mostSig |= (timeSeq & 0xFFFFFFFFL) << 32;
        mostSig |= (timeSeq >> 32 & 0xFFFFL) << 16;
        mostSig |= 0x1000L;
        leastSig |= Long.MIN_VALUE;
        leastSig |= (UUIDFactory.factory.clock_seq >> 8 & 0x3FL) << 56;
        leastSig |= (UUIDFactory.factory.clock_seq & 0xFFL) << 48;
        return new UUID(mostSig |= timeSeq >> 48 & 0xFFFL, leastSig |= UUIDFactory.factory.node & 0xFFFFFFFFFFFFL);
    }

    public static UUID newUUID(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("bytes must be 16 bytes in length");
        }
        long mostSig = 0L;
        int i = 0;
        while (i < 8) {
            mostSig = mostSig << 8 | (long)(bytes[i] & 0xFF);
            ++i;
        }
        long leastSig = 0L;
        int i2 = 8;
        while (i2 < 16) {
            leastSig = leastSig << 8 | (long)(bytes[i2] & 0xFF);
            ++i2;
        }
        return UUIDFactory.newUUID(mostSig, leastSig);
    }

    public static UUID newHashUUID(long mostSig, long leastSig) {
        mostSig &= 0xFFFFFFFFFFFF0FFFL;
        leastSig &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(mostSig |= 0x3000L, leastSig |= Long.MIN_VALUE);
    }

    public static UUID newUUID(long mostSig, long leastSig) {
        mostSig &= 0xFFFFFFFFFFFF0FFFL;
        leastSig &= 0x3FFFFFFFFFFFFFFFL;
        leastSig |= Long.MIN_VALUE;
        leastSig &= 0xFFFF7FFFFFFFFFFFL;
        return new UUID(mostSig |= 0x4000L, leastSig |= 0x800000000000L);
    }

    private UUIDFactory() {
        try {
            JRandom seeder = new JRandom();
            byte[] seed = new byte[256];
            seeder.nextBytes(seed);
            this.randNum = new SecureRandom(seed);
        }
        catch (Throwable everything) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Unable to seed. Using self-seeding SecureRandom");
            }
            this.randNum = new SecureRandom();
        }
        String[] tz_ids = TimeZone.getAvailableIDs(0);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.utc_offset = gregorianCalendar.get(15) + gregorianCalendar.get(16);
        this.clock_seq = (long)this.randNum.nextInt() & 0x3FFL;
        this.node = this.randNum.nextLong() & 0xFFFFFFFFFFFFL;
        this.node |= 0x800000000000L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

