/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.binaryID;

import java.io.Serializable;
import jxta.security.util.URLBase64;
import net.jxta.id.ID;
import org.apache.log4j.Logger;

public class BinaryID
implements Serializable {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$id$binaryID$BinaryID == null ? (class$net$jxta$impl$id$binaryID$BinaryID = BinaryID.class$("net.jxta.impl.id.binaryID.BinaryID")) : class$net$jxta$impl$id$binaryID$BinaryID).getName());
    public static String UUIDEncoded = "uuid";
    public static final int flagsSize = 1;
    public static final byte flagPeerGroupID = 97;
    public static final byte flagPeerID = 98;
    public static final byte flagPipeID = 99;
    public static final byte flagModuleClassID = 100;
    public static final byte flagModuleClassRoleID = 101;
    public static final byte flagModuleSpecID = 102;
    public static final byte flagCodatID = 103;
    public static final byte flagGenericID = 122;
    public static final int flagsOffset = 0;
    public static final int dataOffset = 1;
    private static final byte[] nullID = new byte[]{0};
    public static final BinaryID nullBinaryID = new BinaryID(122, nullID, true);
    protected String encodedValue = null;
    static /* synthetic */ Class class$net$jxta$impl$id$binaryID$BinaryID;

    public BinaryID() {
        this.encodedValue = BinaryID.nullBinaryID.encodedValue;
    }

    public BinaryID(byte id) {
        this(id, nullID, true);
    }

    protected BinaryID(String encodedValue) {
        this.encodedValue = encodedValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BinaryID(byte type, byte[] data, boolean lengthIncluded) {
        if (lengthIncluded && data.length < 256 && data.length > 1) {
            if (data[0] != data.length - 1) throw new RuntimeException("Length of data section is " + (data.length - 1) + " but byte zero says length is:" + data[0] + ".");
            this.encodedValue = (char)type + new String(URLBase64.encode((byte[])data));
            return;
        } else if (!lengthIncluded && data.length > 0) {
            byte[] temp = new byte[data.length + 1];
            temp[0] = (byte)data.length;
            int i = 0;
            while (i < data.length) {
                temp[i + 1] = data[i];
                ++i;
            }
            try {
                this.encodedValue = (char)type + new String(URLBase64.encode((byte[])temp));
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to encode binary value.", (Throwable)e);
                throw new RuntimeException("Unable to encode binary value.");
            }
        } else {
            if (lengthIncluded && (data.length > 256 || data.length == 0)) {
                throw new RuntimeException("Length of 'data' is " + data.length + " must be >0 and less or equal to 256.");
            }
            if (lengthIncluded || data.length <= 255) return;
            throw new RuntimeException("Length of 'data' is " + data.length + "  must be less than 256. ");
        }
    }

    public byte[] toByteArray() {
        try {
            byte[] dataIn = this.encodedValue.substring(1).getBytes();
            byte[] data = URLBase64.decode((byte[])dataIn, (int)0, (int)dataIn.length);
            return data;
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to decode binary value.", (Throwable)e);
            throw new RuntimeException("Unable to encode binary value.");
        }
    }

    public byte[] toSizeIncludedByteArray() {
        byte[] data = null;
        try {
            byte[] dataIn = this.encodedValue.substring(1).getBytes();
            data = URLBase64.decode((byte[])dataIn, (int)0, (int)dataIn.length);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to decode binary value.", (Throwable)e);
            throw new RuntimeException("Unable to encode binary value.");
        }
        byte[] temp = new byte[data.length - 1];
        int i = 1;
        while (i < data.length) {
            temp[i - 1] = data[i];
            ++i;
        }
        return temp;
    }

    public String encodedValue() {
        return this.encodedValue;
    }

    public int hashCode() {
        return this.encodedValue.hashCode();
    }

    public boolean equals(Object target) {
        boolean result = false;
        if (target == this) {
            result = true;
        } else if (target == null) {
            result = false;
        } else if (target instanceof BinaryID) {
            result = this.encodedValue().equals(((BinaryID)target).encodedValue());
            LOG.error((Object)("((BinaryID)target).encodedValue():" + ((BinaryID)target).encodedValue()));
        } else if (target instanceof ID && (ID)target == ID.nullID && nullBinaryID.encodedValue().equals(this.encodedValue())) {
            result = true;
        }
        return result;
    }

    public byte type() {
        return (byte)this.encodedValue.charAt(0);
    }

    public String toString() {
        return this.encodedValue;
    }

    public String getID() {
        return this.encodedValue;
    }

    public Object clone() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

