/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.binaryID;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Random;
import jxta.security.impl.random.JRandom;
import net.jxta.codat.CodatID;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.binaryID.BinaryID;
import net.jxta.impl.id.binaryID.CodatBinaryID;
import net.jxta.impl.id.binaryID.IDFormat;
import net.jxta.impl.id.binaryID.ModuleClassBinaryID;
import net.jxta.impl.id.binaryID.ModuleSpecBinaryID;
import net.jxta.impl.id.binaryID.PeerBinaryID;
import net.jxta.impl.id.binaryID.PeerGroupBinaryID;
import net.jxta.impl.id.binaryID.PipeBinaryID;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import org.apache.log4j.Logger;

public final class Instantiator
implements IDFactory.Instantiator {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$id$binaryID$Instantiator == null ? (class$net$jxta$impl$id$binaryID$Instantiator = Instantiator.class$("net.jxta.impl.id.binaryID.Instantiator")) : class$net$jxta$impl$id$binaryID$Instantiator).getName());
    static final String BinaryIDEncoded = "binaryid";
    private Random randNumGenerator;
    static /* synthetic */ Class class$net$jxta$impl$id$binaryID$Instantiator;

    public String getSupportedIDFormat() {
        return BinaryIDEncoded;
    }

    public ID fromURL(URL source) throws MalformedURLException, UnknownServiceException {
        ID result = null;
        if (!"urn".equalsIgnoreCase(source.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String encoded = source.getFile();
        int colonAt = encoded.indexOf(58);
        if (-1 == colonAt) {
            throw new UnknownServiceException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(encoded.substring(0, colonAt))) {
            throw new UnknownServiceException("URN namespace was not as expected.");
        }
        int dashAt = (encoded = encoded.substring(colonAt + 1)).indexOf(45);
        if (-1 == dashAt) {
            throw new UnknownServiceException("URN Encodingtype was missing.");
        }
        if (!encoded.substring(0, dashAt).equals(BinaryIDEncoded)) {
            throw new UnknownServiceException("JXTA id format was not as expected. Should have been BinaryIDEncoded found:" + encoded.substring(0, dashAt));
        }
        if ((encoded = encoded.substring(dashAt + 1)).length() < 1) {
            throw new MalformedURLException("URN does not contain enough chars. Must have at least one byte");
        }
        BinaryID id = new BinaryID(encoded);
        switch (id.type()) {
            case 103: {
                result = new CodatBinaryID(encoded);
            }
            case 97: {
                result = new PeerGroupBinaryID(encoded);
                if (!PeerGroupID.worldPeerGroupID.equals(result)) break;
                result = PeerGroupID.worldPeerGroupID;
                break;
            }
            case 98: {
                result = new PeerBinaryID(encoded);
                break;
            }
            case 99: {
                result = new PipeBinaryID(encoded);
                break;
            }
            case 100: {
                result = new ModuleClassBinaryID(encoded);
                break;
            }
            case 102: {
                result = new ModuleSpecBinaryID(encoded);
                break;
            }
            default: {
                throw new MalformedURLException("jxta ID type not recognized");
            }
        }
        return result;
    }

    private synchronized byte[] randomID() {
        byte[] randBuf16 = new byte[16];
        if (this.randNumGenerator == null) {
            try {
                this.randNumGenerator = new JRandom();
            }
            catch (Throwable everything) {
                this.randNumGenerator = new Random();
            }
        }
        this.randNumGenerator.nextBytes(randBuf16);
        return randBuf16;
    }

    public CodatID newCodatID(PeerGroupID groupID) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatBinaryID(parentGroupID, this.randomID(), false);
    }

    public CodatID newCodatID(PeerGroupID groupID, byte[] seed) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatBinaryID(parentGroupID, seed, false);
    }

    public CodatID newCodatID(PeerGroupID groupID, InputStream in) throws IOException {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatBinaryID(parentGroupID, this.randomID(), false);
    }

    public CodatID newCodatID(PeerGroupID groupID, byte[] idValue, InputStream in) throws IOException {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatBinaryID(parentGroupID, idValue, false);
    }

    public PeerID newPeerID(PeerGroupID groupID) {
        LOG.error((Object)"random peer created", (Throwable)new RuntimeException());
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PeerBinaryID(parentGroupID, this.randomID(), false);
    }

    public PeerID newPeerID(PeerGroupID groupID, byte[] idValue) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PeerBinaryID(parentGroupID, idValue, false);
    }

    public PeerGroupID newPeerGroupID() {
        return IDFactory.newPeerGroupID(this.randomID());
    }

    public PeerGroupID newPeerGroupID(byte[] idValue) {
        return new PeerGroupBinaryID(idValue, false);
    }

    public PeerGroupID newPeerGroupID(PeerGroupID parent) {
        LOG.error((Object)"random peergroup created", (Throwable)new RuntimeException());
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(parent);
        return IDFactory.newPeerGroupID(parentGroupID, this.randomID());
    }

    public PeerGroupID newPeerGroupID(PeerGroupID parent, byte[] idValue) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(parent);
        return new PeerGroupBinaryID(parentGroupID, idValue, false);
    }

    public PipeID newPipeID(PeerGroupID groupID) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return IDFactory.newPipeID(parentGroupID, this.randomID());
    }

    public PipeID newPipeID(PeerGroupID groupID, byte[] idValue) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PipeBinaryID(peerGroupID, idValue, false);
    }

    public ModuleClassID newModuleClassID() {
        throw new UnsupportedOperationException("This form is not supported because a binary ID is meant to be created with a random ID. Use UUID package instead.");
    }

    public ModuleClassID newModuleClassID(ModuleClassID classID) {
        throw new UnsupportedOperationException("This form is not supported because a binary ID is meant to be created with a random ID. Use UUID package instead.");
    }

    public ModuleSpecID newModuleSpecID(ModuleClassID classID) {
        throw new UnsupportedOperationException("This form is not supported because a binary ID is meant to be created with a random ID. Use UUID package instead.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

