/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class NullMembershipService
implements MembershipService {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$membership$NullMembershipService == null ? (class$net$jxta$impl$membership$NullMembershipService = NullMembershipService.class$("net.jxta.impl.membership.NullMembershipService")) : class$net$jxta$impl$membership$NullMembershipService).getName());
    private ModuleImplAdvertisement implAdvertisement = null;
    private PeerGroup peergroup = null;
    private List principals = new ArrayList();
    private List principalsAuth = new ArrayList();
    private NullCredential defaultCredential = null;
    static /* synthetic */ Class class$net$jxta$impl$membership$NullMembershipService;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.peergroup = group;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Null Membership Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tImpl Description: " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            LOG.info((Object)configInfo);
        }
        this.defaultCredential = new NullCredential(this, "nobody");
        this.resign();
    }

    public Service getInterface() {
        return this;
    }

    PeerGroup getPeerGroup() {
        return this.peergroup;
    }

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
        this.peergroup = null;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public Authenticator apply(AuthenticationCredential application) throws PeerGroupException, ProtocolNotSupportedException {
        String method = application.getMethod();
        if (null != method && !"StringAuthentication".equals(method) && !"NullAuthentication".equals(method)) {
            throw new ProtocolNotSupportedException("Authentication method not recognized");
        }
        return new NullAuthenticator(this, application);
    }

    public Credential getDefaultCredential() {
        return this.defaultCredential;
    }

    public synchronized Enumeration getCurrentCredentials() {
        return Collections.enumeration(this.principals);
    }

    public synchronized Enumeration getAuthCredentials() {
        return Collections.enumeration(this.principalsAuth);
    }

    public synchronized Credential join(Authenticator authenticated) throws PeerGroupException {
        if (!(authenticated instanceof NullAuthenticator)) {
            throw new ClassCastException("This is not my authenticator!");
        }
        if (!authenticated.isReadyForJoin()) {
            throw new PeerGroupException("Not ready to join()!");
        }
        NullAuthenticator myAuthenticated = (NullAuthenticator)authenticated;
        NullCredential newCred = new NullCredential(this, myAuthenticated.getAuth1Identity());
        this.principals.add(newCred);
        this.principals.add(myAuthenticated.application);
        return newCred;
    }

    public synchronized void resign() throws PeerGroupException {
        this.principals.clear();
        this.principalsAuth.clear();
        this.principals.add(this.defaultCredential);
    }

    public Credential makeCredential(Element element2) throws PeerGroupException, Exception {
        return new NullCredential(this, element2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class NullAuthenticator
    implements Authenticator {
        MembershipService source;
        AuthenticationCredential application;
        String whoami = "nobody";

        NullAuthenticator(MembershipService source, AuthenticationCredential application) {
            this.source = source;
            this.application = application;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public synchronized boolean isReadyForJoin() {
            return true;
        }

        public String getMethodName() {
            return "NullAuthentication";
        }

        public AuthenticationCredential getAuthenticationCredential() {
            return this.application;
        }

        public void setAuth1Identity(String who) {
            if (null == who) {
                throw new IllegalArgumentException("You must supply an identity");
            }
            this.whoami = who;
        }

        public String getAuth1Identity() {
            return this.whoami;
        }
    }

    private static final class NullCredential
    implements Credential {
        private NullMembershipService source;
        private String whoami;
        private ID peerid;

        protected NullCredential(NullMembershipService source, String whoami) {
            this.source = source;
            this.whoami = whoami;
            this.peerid = source.getPeerGroup().getPeerID();
        }

        protected NullCredential(NullMembershipService source, Element root) throws PeerGroupException {
            this.source = source;
            this.initialize(root);
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return this.peerid;
        }

        private void setPeerID(PeerID peerid) {
            this.peerid = peerid;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public Object getSubject() {
            return this.whoami;
        }

        private void setSubject(String subject) {
            this.whoami = subject;
        }

        public Service getSourceService() {
            return this.source.getInterface();
        }

        public StructuredDocument getDocument(MimeMediaType as) throws Exception {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
            if (doc instanceof Attributable) {
                ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
                ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
                ((Attributable)((Object)doc)).addAttribute("type", "jxta:NullCred");
            }
            Element e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
            doc.appendChild(e);
            e = doc.createElement("PeerID", this.peerid.toString());
            doc.appendChild(e);
            e = doc.createElement("Identity", this.whoami);
            doc.appendChild(e);
            return doc;
        }

        protected boolean handleElement(TextElement elem) {
            if (elem.getName().equals("PeerGroupID")) {
                try {
                    URL gID = IDFactory.jxtaURL(elem.getTextValue());
                    ID pgid = IDFactory.fromURL(gID);
                    if (!pgid.equals(this.getPeerGroupID())) {
                        throw new IllegalArgumentException("Operation is from a different group. " + pgid + " != " + this.getPeerGroupID());
                    }
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad PeerGroupID in advertisement: " + elem.getTextValue());
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("PeerID")) {
                try {
                    URL pID = IDFactory.jxtaURL(elem.getTextValue());
                    ID pid = IDFactory.fromURL(pID);
                    this.setPeerID((PeerID)pid);
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad Peer ID in advertisement: " + elem.getTextValue());
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a peer id: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("Identity")) {
                this.setSubject(elem.getTextValue());
                return true;
            }
            return false;
        }

        protected void initialize(Element root) {
            String doctype;
            Attribute itsType;
            if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = NullMembershipService.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
            }
            TextElement doc = (TextElement)root;
            String typedoctype = "";
            if (root instanceof Attributable && null != (itsType = ((Attributable)((Object)root)).getAttribute("type"))) {
                typedoctype = itsType.getValue();
            }
            if (!(doctype = doc.getName()).equals("jxta:NullCred") && !typedoctype.equals("jxta:NullCred")) {
                throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
            }
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                TextElement elem = (TextElement)elements.nextElement();
                if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Unhandleded element '" + elem.getName() + "' in " + doc.getName()));
            }
            if (null == this.getSubject()) {
                throw new IllegalArgumentException("subject was never initialized.");
            }
            if (null == this.getPeerID()) {
                throw new IllegalArgumentException("peer id was never initialized.");
            }
        }
    }
}

