/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PasswdMembershipService
implements MembershipService {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$membership$PasswdMembershipService == null ? (class$net$jxta$impl$membership$PasswdMembershipService = PasswdMembershipService.class$("net.jxta.impl.membership.PasswdMembershipService")) : class$net$jxta$impl$membership$PasswdMembershipService).getName());
    public static final ModuleSpecID passwordMembershipSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000050206");
    private PeerGroup peergroup = null;
    private PasswdCredential defaultCredential = null;
    private List principals = new ArrayList();
    private List authCredentials = new ArrayList();
    private ModuleImplAdvertisement implAdvertisement = null;
    private Map logins = null;
    static /* synthetic */ Class class$net$jxta$impl$membership$PasswdMembershipService;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.peergroup = group;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Password Membership Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tImpl Description: " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            LOG.info((Object)configInfo);
        }
        PeerGroupAdvertisement configAdv = group.getPeerGroupAdvertisement();
        TextElement myParam = (TextElement)((Object)configAdv.getServiceParam(assignedID));
        this.logins = new HashMap();
        if (null == myParam) {
            throw new PeerGroupException("parameters for group passwords missing");
        }
        Enumeration allLogins = myParam.getChildren();
        while (allLogins.hasMoreElements()) {
            String etcPasswd;
            int nextDelim;
            TextElement aLogin = (TextElement)allLogins.nextElement();
            if (!aLogin.getName().equals("login") || -1 == (nextDelim = (etcPasswd = aLogin.getTextValue()).indexOf(58))) continue;
            String login = etcPasswd.substring(0, nextDelim).trim();
            int lastDelim = etcPasswd.indexOf(58, nextDelim + 1);
            String passwd = etcPasswd.substring(nextDelim + 1, lastDelim);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Adding login : '" + login + "' with encoded password : '" + passwd + "'"));
            }
            this.logins.put(login, passwd);
        }
        this.defaultCredential = new PasswdCredential(this, "nobody", "blah");
        this.resign();
    }

    public Service getInterface() {
        return this;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
        try {
            this.resign();
        }
        catch (PeerGroupException ignored) {}
    }

    public PeerGroup getPeerGroup() {
        return this.peergroup;
    }

    public Authenticator apply(AuthenticationCredential application) throws PeerGroupException, ProtocolNotSupportedException {
        String method = application.getMethod();
        if (null != method && !"StringAuthentication".equals(method) && !"PasswdAuthentication".equals(method)) {
            throw new ProtocolNotSupportedException("Authentication method not recognized");
        }
        return new PasswdAuthenticator(this, application);
    }

    public Credential getDefaultCredential() {
        return this.defaultCredential;
    }

    public synchronized Enumeration getCurrentCredentials() {
        return Collections.enumeration(this.principals);
    }

    public synchronized Enumeration getAuthCredentials() {
        return Collections.enumeration(this.authCredentials);
    }

    public synchronized Credential join(Authenticator authenticated) throws PeerGroupException {
        if (!(authenticated instanceof PasswdAuthenticator)) {
            throw new ClassCastException("This is not my authenticator!");
        }
        if (!authenticated.isReadyForJoin()) {
            throw new PeerGroupException("Not Ready to join!");
        }
        if (!this.checkPasswd(((PasswdAuthenticator)authenticated).getAuth1Identity(), ((PasswdAuthenticator)authenticated).getAuth2_Password())) {
            throw new PeerGroupException("Incorrect Password!");
        }
        PasswdCredential newCred = new PasswdCredential(this, ((PasswdAuthenticator)authenticated).getAuth1Identity(), "blah");
        this.principals.add(newCred);
        this.authCredentials.add(authenticated.getAuthenticationCredential());
        return newCred;
    }

    public synchronized void resign() throws PeerGroupException {
        this.principals.clear();
        this.authCredentials.clear();
        this.principals.add(this.defaultCredential);
    }

    public Credential makeCredential(Element element2) throws PeerGroupException, Exception {
        return new PasswdCredential(this, element2);
    }

    private boolean checkPasswd(String identity, String passwd) {
        String mustMatch;
        if (!this.logins.containsKey(identity)) {
            return false;
        }
        String encodedPW = PasswdMembershipService.makePsswd(passwd);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Password '" + passwd + "' encodes as: '" + encodedPW + "'"));
        }
        if ((mustMatch = (String)this.logins.get(identity)).equals("")) {
            return true;
        }
        boolean result = encodedPW.equals(mustMatch);
        return result;
    }

    public static String makePsswd(String source) {
        String xlateTable = "DQKWHRTENOGXCVYSFJPILZABMU";
        StringBuffer work = new StringBuffer(source);
        int eachChar = work.length() - 1;
        while (eachChar >= 0) {
            char aChar = Character.toUpperCase(work.charAt(eachChar));
            int replaceIdx = "DQKWHRTENOGXCVYSFJPILZABMU".indexOf(aChar);
            if (-1 != replaceIdx) {
                work.setCharAt(eachChar, (char)(65 + replaceIdx));
            }
            --eachChar;
        }
        return work.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class IdMaker {
        IdMaker() {
        }

        static ID mkID(String s) {
            try {
                return IDFactory.fromURL(IDFactory.jxtaURL("urn", "", "jxta:uuid-" + s));
            }
            catch (MalformedURLException absurd) {
                LOG.fatal((Object)"Hardcoded Spec and Class IDs are malformed.", (Throwable)absurd);
            }
            catch (UnknownServiceException absurd2) {
                LOG.fatal((Object)"Hardcoded Spec and Class IDs are malformed.", (Throwable)absurd2);
            }
            throw new JxtaError("Hardcoded Spec and Class IDs are malformed.");
        }
    }

    public static final class PasswdAuthenticator
    implements Authenticator {
        MembershipService source;
        AuthenticationCredential application;
        String whoami = null;
        String password = null;

        PasswdAuthenticator(MembershipService source, AuthenticationCredential application) {
            this.source = source;
            this.application = application;
        }

        public MembershipService getSourceService() {
            return (MembershipService)this.source.getInterface();
        }

        public synchronized boolean isReadyForJoin() {
            return null != this.password && null != this.whoami;
        }

        public String getMethodName() {
            return "PasswdAuthentication";
        }

        public void setAuth1Identity(String who) {
            this.whoami = who;
        }

        public String getAuth1Identity() {
            return this.whoami;
        }

        public void setAuth2_Password(String secret) {
            this.password = secret;
        }

        private String getAuth2_Password() {
            return this.password;
        }

        public AuthenticationCredential getAuthenticationCredential() {
            return this.application;
        }
    }

    public static final class PasswdCredential
    implements Credential {
        PasswdMembershipService source;
        String whoami;
        ID peerid;
        String signedPeerID;

        protected PasswdCredential(PasswdMembershipService source, String whoami, String signedPeerID) {
            this.source = source;
            this.whoami = whoami;
            this.peerid = source.getPeerGroup().getPeerID();
            this.signedPeerID = signedPeerID;
        }

        protected PasswdCredential(PasswdMembershipService source, Element root) throws PeerGroupException {
            this.source = source;
            this.initialize(root);
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return this.peerid;
        }

        private void setPeerID(PeerID peerid) {
            this.peerid = peerid;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public Object getSubject() {
            return this.whoami;
        }

        private void setSubject(String subject) {
            this.whoami = subject;
        }

        public Service getSourceService() {
            return this.source;
        }

        public StructuredDocument getDocument(MimeMediaType as) throws Exception {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
            if (doc instanceof Attributable) {
                ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
                ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
                ((Attributable)((Object)doc)).addAttribute("type", "jxta:PasswdCred");
            }
            Element e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
            doc.appendChild(e);
            e = doc.createElement("PeerID", this.getPeerID().toString());
            doc.appendChild(e);
            e = doc.createElement("Identity", this.whoami);
            doc.appendChild(e);
            e = doc.createElement("ReallyInsecureSignature", this.signedPeerID);
            doc.appendChild(e);
            return doc;
        }

        protected boolean handleElement(TextElement elem) {
            if (elem.getName().equals("PeerGroupID")) {
                try {
                    URL gID = IDFactory.jxtaURL(elem.getTextValue());
                    ID pgid = IDFactory.fromURL(gID);
                    if (!pgid.equals(this.getPeerGroupID())) {
                        throw new IllegalArgumentException("Operation is from a different group. " + pgid + " != " + this.getPeerGroupID());
                    }
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad PeerGroupID in advertisement: " + elem.getTextValue());
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("PeerID")) {
                try {
                    URL pID = IDFactory.jxtaURL(elem.getTextValue());
                    ID pid = IDFactory.fromURL(pID);
                    this.setPeerID((PeerID)pid);
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad Peer ID in advertisement: " + elem.getTextValue());
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a peer id: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("Identity")) {
                this.setSubject(elem.getTextValue());
                return true;
            }
            if (elem.getName().equals("ReallyInsecureSignature")) {
                this.signedPeerID = elem.getTextValue();
                return true;
            }
            return false;
        }

        protected void initialize(Element root) {
            String doctype;
            Attribute itsType;
            if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = PasswdMembershipService.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
            }
            TextElement doc = (TextElement)root;
            String typedoctype = "";
            if (root instanceof Attributable && null != (itsType = ((Attributable)((Object)root)).getAttribute("type"))) {
                typedoctype = itsType.getValue();
            }
            if (!(doctype = doc.getName()).equals("jxta:PasswdCred") && !typedoctype.equals("jxta:PasswdCred")) {
                throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
            }
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                TextElement elem = (TextElement)elements.nextElement();
                if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Unhandleded element '" + elem.getName() + "' in " + doc.getName()));
            }
            if (null == this.getSubject()) {
                throw new IllegalArgumentException("subject was never initialized.");
            }
            if (null == this.getPeerID()) {
                throw new IllegalArgumentException("peer id was never initialized.");
            }
            if (null == this.signedPeerID) {
                throw new IllegalArgumentException("signed peer id was never initialized.");
            }
        }
    }
}

