/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.impl.membership.pse.PSEConfig;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.membership.InteractiveAuthenticator;
import net.jxta.membership.MembershipService;
import net.jxta.util.AwtUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class DialogAuthenticator
implements InteractiveAuthenticator {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$membership$pse$DialogAuthenticator == null ? (class$net$jxta$impl$membership$pse$DialogAuthenticator = DialogAuthenticator.class$("net.jxta.impl.membership.pse.DialogAuthenticator")) : class$net$jxta$impl$membership$pse$DialogAuthenticator).getName());
    PSEMembershipService source;
    AuthenticationCredential application;
    String whoami = null;
    String password = null;
    static /* synthetic */ Class class$net$jxta$impl$membership$pse$DialogAuthenticator;

    DialogAuthenticator(PSEMembershipService source, AuthenticationCredential application) {
        AwtUtils.initAsDaemon();
        this.source = source;
        this.application = application;
    }

    public MembershipService getSourceService() {
        return (MembershipService)this.source.getInterface();
    }

    public synchronized boolean isReadyForJoin() {
        return null != this.password && null != this.whoami;
    }

    public String getMethodName() {
        return "DialogAuthentication";
    }

    public boolean interact() {
        PasswordDialog p = new PasswordDialog(this.source.pseParams, "", "");
        p.showDialog();
        if (p.wasCanceled()) {
            this.setPrincipal(null);
            this.setPassword(null);
        }
        return !p.wasCanceled();
    }

    public String getPrincipal() {
        return this.whoami;
    }

    public void setPrincipal(String principal) {
        this.whoami = principal;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public AuthenticationCredential getAuthenticationCredential() {
        return this.application;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PasswordDialog
    extends JDialog
    implements ActionListener {
        private JTextField principalField;
        private JPasswordField passwordField;
        private PSEConfig pseParams;
        private boolean canceled = true;

        public PasswordDialog(PSEConfig pseParams, String principal, String password) {
            super(JOptionPane.getRootFrame(), "JXTA Secure Login", true);
            this.pseParams = pseParams;
            JPanel contentPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0);
            contentPane.add((Component)new JLabel("Secure Username:"), c);
            c.gridy = 1;
            contentPane.add((Component)new JLabel("Password:"), c);
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 2;
            this.principalField = new JTextField(principal, 10);
            contentPane.add((Component)this.principalField, c);
            c.gridy = 1;
            this.passwordField = new JPasswordField(password, 10);
            contentPane.add((Component)this.passwordField, c);
            c.gridx = 0;
            c.gridy = 2;
            c.anchor = 13;
            c.gridwidth = 2;
            c.fill = 0;
            JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
            JButton okButton = new JButton("OK");
            this.getRootPane().setDefaultButton(okButton);
            JButton cancelButton = new JButton("Cancel");
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            contentPane.add((Component)buttonPanel, c);
            cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PasswordDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    PasswordDialog.access$002(this.this$1, true);
                    this.this$1.dispose();
                }
            });
            okButton.addActionListener(this);
            this.setContentPane(contentPane);
        }

        public void showDialog() {
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        public boolean wasCanceled() {
            return this.canceled;
        }

        public void actionPerformed(ActionEvent e) {
            String principal = this.principalField.getText();
            String password = new String(this.passwordField.getPassword());
            if (!DialogAuthenticator.this.source.pseParams.principalIsIssuer(principal, null)) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("principal check failed : " + principal));
                }
                JOptionPane.showMessageDialog(this, "Invalid Secure Username. Try again.", "Error Message", 0);
                return;
            }
            if (!DialogAuthenticator.this.source.pseParams.validPasswd(password)) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("password check failed : " + password));
                }
                JOptionPane.showMessageDialog(this, "Invalid Password. Try again.", "Error Message", 0);
                return;
            }
            DialogAuthenticator.this.setPrincipal(principal);
            DialogAuthenticator.this.setPassword(password);
            this.canceled = false;
            this.dispose();
        }

        static /* synthetic */ boolean access$002(PasswordDialog x0, boolean x1) {
            x0.canceled = x1;
            return x0.canceled;
        }
    }
}

