/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import jxta.security.exceptions.CryptoException;
import jxta.security.hash.Hash;
import jxta.security.impl.crypto.JxtaCryptoSuite;
import jxta.security.impl.random.JRandom;
import jxta.security.util.URLBase64;
import net.jxta.id.ID;
import net.jxta.impl.membership.pse.PSEUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PSEConfig {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$membership$pse$PSEConfig == null ? (class$net$jxta$impl$membership$pse$PSEConfig = PSEConfig.class$("net.jxta.impl.membership.pse.PSEConfig")) : class$net$jxta$impl$membership$pse$PSEConfig).getName());
    private static final int NUM_RND_SEED_BYTES = 128;
    private final File homeDir;
    private final File pseDir;
    private final File pseRootDir;
    private final File pseRootClientCertFile;
    private final File pseClientDir;
    private final File pseClientServiceCertFile;
    private final File psePasswordDir;
    private final File psePasswordFile;
    private final File psePassphraseFile;
    private final SecureRandom rng;
    static final int SALTSIZE = 8;
    static final int PASSES = 11;
    static /* synthetic */ Class class$net$jxta$impl$membership$pse$PSEConfig;

    public static boolean isInitialized(File homeDir) {
        if (homeDir != null && homeDir.exists() && !homeDir.isDirectory()) {
            throw new IllegalArgumentException("homeDir must be a directory");
        }
        try {
            File fpce = new File(homeDir, "pse");
            if (!fpce.exists()) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("PSE Dir does not exist at : " + fpce));
                }
                return false;
            }
            if (!fpce.isDirectory()) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("PSE Dir is not a directory : " + fpce));
                }
                return false;
            }
            if (!PSEConfig.allPCEChildrenExist(fpce)) {
                return false;
            }
            boolean principalOK = true;
            if (!principalOK) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Bad Principal or password");
                }
                return false;
            }
        }
        catch (Throwable s) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Exception while checking PSE Dir in : " + homeDir), s);
            }
            return false;
        }
        return true;
    }

    private static boolean allPCEChildrenExist(File pcedir) throws SecurityException {
        File rootcertdir = new File(pcedir, "root");
        File clientdir = new File(pcedir, "client");
        File passworddir = new File(pcedir, "etc");
        if (!(rootcertdir.exists() && clientdir.exists() && passworddir.exists())) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Missing root cert dir, client dir, or password dir.");
            }
            return false;
        }
        if (!(rootcertdir.isDirectory() && clientdir.isDirectory() && passworddir.isDirectory())) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"root cert dir, client dir or password dir is not a directory");
            }
            return false;
        }
        File f = new File(rootcertdir, "peer-root.pem");
        File g = new File(clientdir, "peer-service.pem");
        File h = new File(clientdir, "peer.phrase");
        File i = new File(passworddir, "passwd");
        if (!f.exists() || !f.isFile()) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Missing or invalid client root file : " + f));
            }
            return false;
        }
        if (!g.exists() || !g.isFile()) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Missing or invalid client root file : " + g));
            }
            return false;
        }
        if (!h.exists() || !h.isFile()) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Missing or invalid passphrase file : " + h));
            }
            return false;
        }
        if (!i.exists() || !i.isFile()) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Missing or invalid password file : " + i));
            }
            return false;
        }
        if (!PSEUtils.verifySignedCert(f, g)) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Cert signature not valid! file=" + g.getAbsolutePath()));
            }
            return false;
        }
        return true;
    }

    public PSEConfig(File homeDir) {
        if (homeDir != null && homeDir.exists() && !homeDir.isDirectory()) {
            throw new IllegalArgumentException("homeDir must be a directory");
        }
        this.homeDir = homeDir;
        this.pseDir = new File(homeDir, "pse");
        this.pseRootDir = new File(this.pseDir, "root");
        this.pseRootClientCertFile = new File(this.pseRootDir, "peer-root.pem");
        this.pseClientDir = new File(this.pseDir, "client");
        this.pseClientServiceCertFile = new File(this.pseClientDir, "peer-service.pem");
        this.psePasswordDir = new File(this.pseDir, "etc");
        this.psePasswordFile = new File(this.psePasswordDir, "passwd");
        this.psePassphraseFile = new File(this.pseClientDir, "peer.phrase");
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("PSEConfig : pse home dir = " + homeDir));
        }
        try {
            JRandom jran = new JRandom();
            byte[] seed = new byte[128];
            jran.nextBytes(seed);
            this.rng = new SecureRandom(seed);
        }
        catch (CryptoException cex) {
            throw new IllegalStateException("Could not create random number generator");
        }
    }

    public boolean isInitialized() {
        return PSEConfig.isInitialized(this.homeDir);
    }

    public void initialize(String principal, String password, Certificate cert, PrivateKey privkey) throws IOException {
        if (null == principal || 0 == principal.length()) {
            throw new IllegalArgumentException("principal must be provided");
        }
        if (null == password || 0 == password.length()) {
            throw new IllegalArgumentException("password must be provided");
        }
        if (null == cert) {
            throw new IllegalArgumentException("cert must be provided");
        }
        if (null == privkey) {
            throw new IllegalArgumentException("privkey must be provided");
        }
        PSEConfig.removeDir(this.pseDir);
        this.pseDir.mkdirs();
        this.pseRootDir.mkdirs();
        this.pseClientDir.mkdirs();
        this.psePasswordDir.mkdirs();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Security initialization in progress.\nThis will take 10 or more seconds ...");
        }
        this.createPasswordFile(password);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Creating passphrase file ...");
        }
        String passphrase = this.genPassphrase();
        try {
            this.writePassphrase(passphrase, password);
        }
        catch (CryptoException failed) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Could not create password or passphrase file ", (Throwable)failed);
            }
            throw new IOException("Could not create password or passphrase file " + (Object)((Object)failed));
        }
        PSEUtils.IssuerInfo info = null;
        if (null != cert) {
            info = new PSEUtils.IssuerInfo();
            info.cert = cert;
            info.subjectPkey = privkey;
            info.rootKey = privkey;
            info.passphrase = passphrase;
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Generating new root cert for '" + principal + "'"));
            }
            info = PSEUtils.genCert(principal, null);
            info.passphrase = passphrase;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Writing root cert for '" + principal + "'"));
        }
        PSEUtils.writeCert(this.pseRootClientCertFile, info.cert);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Writing private key for '" + principal + "'"));
        }
        PSEUtils.appendPrivateKey(this.pseRootClientCertFile, info);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Generating service cert for '" + principal + "'"));
        }
        PSEUtils.genCert(this.pseClientServiceCertFile, principal, info, passphrase);
    }

    public void erase() throws IOException {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Removing PSE directory at : " + this.pseDir));
        }
        PSEConfig.removeDir(this.pseDir);
    }

    private static void removeDir(File aDir) throws IOException {
        File[] list = aDir.listFiles();
        int i = 0;
        while (list != null && i < list.length) {
            block5: {
                try {
                    if (list[i].isDirectory()) {
                        PSEConfig.removeDir(list[i]);
                    } else {
                        list[i].delete();
                    }
                }
                catch (IOException badFile) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block5;
                    LOG.debug((Object)("problem working with file : " + list[i]), (Throwable)badFile);
                }
            }
            ++i;
        }
        aDir.delete();
    }

    private boolean passwdExists() {
        try {
            return this.psePasswordDir.exists() && this.psePasswordDir.isDirectory() && this.psePasswordFile.exists() && this.psePasswordFile.isFile();
        }
        catch (SecurityException s) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"passwdExists, exception:", (Throwable)s);
            }
            return false;
        }
    }

    public boolean validPasswd(String passwd) {
        if (!this.passwdExists()) {
            return false;
        }
        try {
            String pwd = this.getPasswordEntry();
            int index = pwd.indexOf(44);
            byte[] salt64 = pwd.substring(0, index).getBytes();
            byte[] salt = URLBase64.decode((byte[])salt64, (int)0, (int)salt64.length);
            String thePwd = pwd.substring(index + 1);
            String generated = null;
            generated = this.makePasswdEntry(passwd, salt);
            int gindex = generated.indexOf(44);
            String genPwd = generated.substring(gindex + 1);
            return genPwd.equals(thePwd);
        }
        catch (Exception failed) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"validPasswd, exception:", (Throwable)failed);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createPasswordFile(String password) throws SecurityException, IOException {
        String pwdentry = this.makePasswdEntry(password, null);
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.psePasswordFile);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(pwdentry, 0, pwdentry.length());
            bw.newLine();
            bw.flush();
            bw.close();
            Object var6_5 = null;
            if (null == fw) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null != fw) {
                fw.close();
            }
            fw = null;
            throw throwable;
        }
        fw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPasswordEntry() throws IOException {
        String string;
        FileReader fr;
        block3: {
            fr = null;
            try {
                String entry;
                fr = new FileReader(this.psePasswordFile);
                BufferedReader br = new BufferedReader(fr);
                string = entry = br.readLine();
                Object var6_5 = null;
                if (null == fr) break block3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (null != fr) {
                    fr.close();
                }
                fr = null;
                throw throwable;
            }
            fr.close();
        }
        fr = null;
        return string;
    }

    String makePasswdEntry(String passwd, byte[] useThisSalt) throws IOException {
        byte[] salt = null;
        if (useThisSalt == null) {
            salt = new byte[8];
            this.rng.nextBytes(salt);
        } else {
            salt = useThisSalt;
        }
        byte[] buf = null;
        try {
            JxtaCryptoSuite suite = new JxtaCryptoSuite(4, null, 0, 0);
            Hash sha1 = suite.getJxtaHash((byte)1);
            int diglen = sha1.getDigestLength();
            byte[] digest = new byte[diglen];
            byte[] pbytes = passwd.getBytes();
            int pwlen = passwd.length() + 8;
            int buflen = pwlen < diglen ? diglen : pwlen;
            buf = new byte[buflen];
            System.arraycopy(salt, 0, buf, 0, 8);
            System.arraycopy(pbytes, 0, buf, 8, pbytes.length);
            int len = pwlen;
            int i = 0;
            while (i <= 11) {
                sha1.doFinal(buf, 0, len, digest, 0);
                System.arraycopy(digest, 0, buf, 0, digest.length);
                len = digest.length;
                ++i;
            }
            String saltStr = new String(URLBase64.encode((byte[])salt));
            String pwdStr = new String(URLBase64.encode((byte[])digest));
            return saltStr + "," + pwdStr;
        }
        catch (CryptoException cex) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"makePasswdEntry: Cannot generate encrypted password", (Throwable)cex);
            }
            throw new IOException("makePasswdEntry: Cannot generate password file :" + cex.getMessage());
        }
    }

    public boolean principalIsIssuer(String principal, ID certID) {
        if (null == principal || 0 == principal.length()) {
            return false;
        }
        try {
            X509Certificate cert = (X509Certificate)this.readRootCert(certID);
            Principal issuer = cert.getIssuerDN();
            String name = issuer.getName();
            int cn = name.indexOf(principal);
            if (cn != -1 && cn >= 3) {
                String fstr;
                String cnstr = name.substring(cn - 3, cn);
                if (cnstr.compareTo("CN=") != 0) {
                    return false;
                }
                int endc = cn + principal.length();
                String endStr = name.substring(endc, endc + 3);
                if (endStr.compareTo("-CA") == 0 && (fstr = name.substring(cn, endc)).compareTo(principal) == 0) {
                    return true;
                }
            }
            return false;
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Exception validating principal:", e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPeerRootCert() throws IOException {
        String string;
        FileReader fr;
        block3: {
            fr = null;
            try {
                fr = new FileReader(this.pseRootClientCertFile);
                BufferedReader br = new BufferedReader(fr);
                string = PSEUtils.loadBase64Object(br, "CERTIFICATE");
                Object var5_4 = null;
                if (null == fr) break block3;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (null != fr) {
                    fr.close();
                }
                fr = null;
                throw throwable;
            }
            fr.close();
        }
        fr = null;
        return string;
    }

    public Certificate readRootCert(ID id) throws IOException {
        if (null == id) {
            return PSEUtils.readCert(this.pseRootClientCertFile);
        }
        return PSEUtils.readCert(new File(this.pseRootDir, id.getUniqueValue().toString() + ".pem"));
    }

    public void writeRootCert(ID id, Certificate cert) throws IOException {
        if (null == id) {
            PSEUtils.writeCert(this.pseRootClientCertFile, cert);
        } else {
            PSEUtils.writeCert(new File(this.pseRootDir, id.getUniqueValue().toString() + ".pem"), cert);
        }
    }

    public File getRootCertFile(ID id) {
        if (null == id) {
            return this.pseRootClientCertFile;
        }
        return new File(this.pseRootDir, id.getUniqueValue().toString() + ".pem");
    }

    public Certificate readClientCert(ID id) throws IOException {
        if (null == id) {
            return PSEUtils.readCert(this.pseRootClientCertFile);
        }
        return PSEUtils.readCert(new File(this.pseClientDir, id.getUniqueValue().toString() + ".pem"));
    }

    public void writeClientCert(ID id, Certificate cert) throws IOException {
        if (null == id) {
            PSEUtils.writeCert(this.pseRootClientCertFile, cert);
        } else {
            PSEUtils.writeCert(new File(this.pseClientDir, id.getUniqueValue().toString() + ".pem"), cert);
        }
    }

    public File getClientCertFile(ID id) {
        if (null == id) {
            return this.pseRootClientCertFile;
        }
        return new File(this.pseClientDir, id.getUniqueValue().toString() + ".pem");
    }

    private String genPassphrase() throws IOException {
        byte[] buf = new byte[128];
        this.rng.nextBytes(buf);
        byte[] digest = null;
        try {
            byte profile = 4;
            JxtaCryptoSuite suite = new JxtaCryptoSuite(profile, null, 0, 0);
            Hash sha1 = suite.getJxtaHash((byte)1);
            digest = new byte[sha1.getDigestLength()];
            int len = 128;
            int i = 0;
            while (i < 127) {
                sha1.doFinal(buf, 0, len, digest, 0);
                System.arraycopy(digest, 0, buf, 0, digest.length);
                len = digest.length;
                ++i;
            }
            return PSEUtils.base64Encode(digest);
        }
        catch (CryptoException cex) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Suite Failure: ", (Throwable)cex);
            }
            throw new IOException("Could not generate passphrase : " + (Object)((Object)cex));
        }
    }

    public String readPassphrase(String password) throws IOException {
        int size = (int)this.psePassphraseFile.length();
        byte[] ciphertext = new byte[size];
        FileInputStream fis = new FileInputStream(this.psePassphraseFile);
        DataInputStream dis = new DataInputStream(fis);
        dis.readFully(ciphertext);
        fis.close();
        byte[] plaintext = null;
        try {
            plaintext = PSEUtils.tlsCipher(ciphertext, password, (byte)2);
        }
        catch (CryptoException e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)("Could not decrypt " + this.psePassphraseFile), (Throwable)e);
            }
            throw new IOException("Could not decrypt :" + this.psePassphraseFile);
        }
        BufferedReader br = new BufferedReader(new StringReader(new String(plaintext)));
        byte[] str64 = PSEUtils.loadObject(br, "PASSPHRASE");
        br.close();
        return new String(str64);
    }

    private void writePassphrase(String str64, String passwd) throws CryptoException, IOException {
        byte[] by64 = str64.getBytes();
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PSEUtils.writeObject(bw, "PASSPHRASE", by64);
        bw.close();
        byte[] ibuf = sw.toString().getBytes();
        byte[] obuf = PSEUtils.tlsCipher(ibuf, passwd, (byte)1);
        FileOutputStream fout = new FileOutputStream(this.psePassphraseFile);
        fout.write(obuf, 0, obuf.length);
        fout.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

