/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import net.jxta.credential.Credential;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PSECredential
implements Credential {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$membership$pse$PSECredential == null ? (class$net$jxta$impl$membership$pse$PSECredential = PSECredential.class$("net.jxta.impl.membership.pse.PSECredential")) : class$net$jxta$impl$membership$pse$PSECredential).getName());
    PSEMembershipService source;
    X509Certificate cert;
    ID peerid;
    PrivateKey privateKey;
    static /* synthetic */ Class class$net$jxta$impl$membership$pse$PSECredential;
    static /* synthetic */ Class class$net$jxta$document$XMLElement;

    protected PSECredential(PSEMembershipService source, X509Certificate cert, PrivateKey privateKey) throws IOException {
        this.source = source;
        this.peerid = source.getPeerGroup().getPeerID();
        this.setCertificate(cert);
        this.setPrivateKey(privateKey);
    }

    protected PSECredential(PSEMembershipService source, Element root) throws PeerGroupException {
        this.source = source;
        this.initialize(root);
    }

    public ID getPeerGroupID() {
        return this.source.getPeerGroup().getPeerGroupID();
    }

    public ID getPeerID() {
        return this.peerid;
    }

    private void setPeerID(PeerID peerid) {
        this.peerid = peerid;
    }

    public boolean isExpired() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public Object getSubject() {
        return this.cert.getSubjectDN();
    }

    public Service getSourceService() {
        return this.source;
    }

    public StructuredDocument getDocument(MimeMediaType as) throws Exception {
        StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
        if (null == this.privateKey) {
            throw new IllegalStateException("This credential is not a local credential and document cannot be created.");
        }
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
            ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
            ((Attributable)((Object)doc)).addAttribute("type", "jxta:PSECred");
        }
        Element e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
        doc.appendChild(e);
        e = doc.createElement("PeerID", this.getPeerID().toString());
        doc.appendChild(e);
        String certBase64 = PSEUtils.base64Encode(this.getCertificate().getEncoded());
        e = doc.createElement("Certificate", certBase64);
        doc.appendChild(e);
        ArrayList<ByteArrayInputStream> someStreams = new ArrayList<ByteArrayInputStream>(3);
        someStreams.add(new ByteArrayInputStream(this.getPeerGroupID().toString().getBytes("UTF-8")));
        someStreams.add(new ByteArrayInputStream(this.getPeerID().toString().getBytes("UTF-8")));
        someStreams.add(new ByteArrayInputStream(this.getCertificate().getEncoded()));
        SequenceInputStream signStream = new SequenceInputStream(Collections.enumeration(someStreams));
        byte[] sig = PSEUtils.computeSignature("SHA1withRSA", this.privateKey, signStream);
        e = doc.createElement("Signature", PSEUtils.base64Encode(sig));
        doc.appendChild(e);
        return doc;
    }

    protected boolean handleElement(XMLElement elem) {
        if (elem.getName().equals("PeerGroupID")) {
            try {
                URL gID = IDFactory.jxtaURL(elem.getTextValue());
                PeerGroupID pgid = (PeerGroupID)IDFactory.fromURL(gID);
                if (!pgid.equals(this.getPeerGroupID())) {
                    throw new IllegalArgumentException("Credential is from a different group. " + pgid + " != " + this.getPeerGroupID());
                }
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad PeerGroupID in advertisement: " + elem.getTextValue());
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a group id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals("PeerID")) {
            try {
                URL pID = IDFactory.jxtaURL(elem.getTextValue());
                ID pid = IDFactory.fromURL(pID);
                this.setPeerID((PeerID)pid);
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad Peer ID in advertisement: " + elem.getTextValue());
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a peer id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals("Certificate")) {
            try {
                byte[] cert_der = PSEUtils.base64Decode(elem.getTextValue());
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert_der));
                this.setCertificate(cert);
            }
            catch (Throwable failed) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Failed to process root cert ", failed);
                }
                throw new IllegalArgumentException("Failed to process root cert " + failed.getMessage());
            }
            return true;
        }
        if (elem.getName().equals("Signature")) {
            ArrayList<ByteArrayInputStream> someStreams = new ArrayList<ByteArrayInputStream>(3);
            try {
                byte[] signatureToCompare = PSEUtils.base64Decode(elem.getTextValue());
                someStreams.add(new ByteArrayInputStream(this.getPeerGroupID().toString().getBytes("UTF-8")));
                someStreams.add(new ByteArrayInputStream(this.getPeerID().toString().getBytes("UTF-8")));
                someStreams.add(new ByteArrayInputStream(this.getCertificate().getEncoded()));
                SequenceInputStream signStream = new SequenceInputStream(Collections.enumeration(someStreams));
                if (!PSEUtils.verifySignature("SHA1withRSA", this.getCertificate(), signatureToCompare, signStream)) {
                    throw new IllegalArgumentException("Certificated did not match");
                }
            }
            catch (Throwable failed) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Failed to validate signature ", failed);
                }
                throw new IllegalArgumentException("Failed to validate signature " + failed.getMessage());
            }
            return true;
        }
        return false;
    }

    protected void initialize(Element root) {
        String doctype;
        if (!(class$net$jxta$document$XMLElement == null ? (class$net$jxta$document$XMLElement = PSECredential.class$("net.jxta.document.XMLElement")) : class$net$jxta$document$XMLElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
        }
        XMLElement doc = (XMLElement)root;
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!(doctype = doc.getName()).equals("jxta:PSECred") && !typedoctype.equals("jxta:PSECred")) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
            LOG.warn((Object)("Unhandleded element '" + elem.getName() + "' in " + doc.getName()));
        }
        if (null == this.getSubject()) {
            throw new IllegalArgumentException("subject was never initialized.");
        }
        if (null == this.getPeerID()) {
            throw new IllegalArgumentException("peer id was never initialized.");
        }
    }

    public Certificate getCertificate() {
        return this.cert;
    }

    private void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public PrivateKey getPrivateKey() {
        if (null == this.privateKey) {
            throw new IllegalStateException("This credential is not a local credential and cannot be used for signing.");
        }
        return this.privateKey;
    }

    private void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

