/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.config.Config;
import net.jxta.impl.membership.pse.DialogAuthenticator;
import net.jxta.impl.membership.pse.PSEConfig;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.membership.pse.StringAuthenticator;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.membership.Authenticator;
import net.jxta.membership.InteractiveAuthenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PSEMembershipService
implements MembershipService {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$membership$pse$PSEMembershipService == null ? (class$net$jxta$impl$membership$pse$PSEMembershipService = PSEMembershipService.class$("net.jxta.impl.membership.pse.PSEMembershipService")) : class$net$jxta$impl$membership$pse$PSEMembershipService).getName());
    public static final ModuleSpecID pseMembershipSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000050306");
    private PeerGroup peergroup = null;
    PSEConfig pseParams = null;
    private String passphrase = null;
    private ID assignedID = null;
    private PSECredential defaultCredential = null;
    private List principals = new ArrayList();
    private List authCredentials = new ArrayList();
    private ModuleImplAdvertisement implAdvertisement = null;
    private HashMap logins = null;
    static /* synthetic */ Class class$net$jxta$impl$membership$pse$PSEMembershipService;

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.assignedID = assignedID;
        this.peergroup = group;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.pseParams = new PSEConfig(new File(Config.JXTA_HOME));
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring PSE Membership Service : " + assignedID);
            configInfo.append("\n\tImplementation :");
            configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tPSE dir : " + new File(Config.JXTA_HOME).getAbsolutePath());
            configInfo.append("\n\t\tPSE state : " + (this.pseParams.isInitialized() ? "inited" : "new"));
            LOG.info((Object)configInfo);
        }
        this.resign();
        if (!this.pseParams.isInitialized()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Creating new PSE directory");
            }
            String principal = System.getProperty("net.jxta.tls.principal");
            String password = System.getProperty("net.jxta.tls.password");
            ConfigParams configAdv = this.peergroup.getConfigAdvertisement();
            StructuredDocument param = configAdv.getServiceParam(assignedID);
            if (null == param) {
                throw new IllegalArgumentException("Could not locate a " + PSEConfigAdv.getAdvertisementType());
            }
            Advertisement paramsAdv = AdvertisementFactory.newAdvertisement((TextElement)((Object)param));
            if (!(paramsAdv instanceof PSEConfigAdv)) {
                throw new IllegalArgumentException("Provided Advertisement was not a " + PSEConfigAdv.getAdvertisementType());
            }
            PSEConfigAdv config = (PSEConfigAdv)paramsAdv;
            try {
                Certificate clientRoot = config.getRootCertificate();
                if (null == clientRoot) {
                    throw new IOException("Could not read root certificate");
                }
                PrivateKey clientPrivKey = config.getPrivateKey(password.toCharArray());
                if (null == clientPrivKey) {
                    throw new IOException("Could not read private key");
                }
                this.pseParams.initialize(principal, password, clientRoot, clientPrivKey);
            }
            catch (IOException failed) {
                LOG.fatal((Object)"Could not create PSE!", (Throwable)failed);
                throw new PeerGroupException("Could not create PSE!" + failed.getMessage(), failed);
            }
        }
    }

    public Service getInterface() {
        return this;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int startApp(String[] arg) {
        String rootCert;
        XMLDocument paramDoc;
        PeerAdvertisement peeradv;
        block21: {
            block20: {
                Credential cred;
                block19: {
                    String principal = System.getProperty("net.jxta.tls.principal");
                    String password = System.getProperty("net.jxta.tls.password");
                    if (password != null) {
                        System.setProperty("net.jxta.tls.password", "");
                        try {
                            AuthenticationCredential authCred = new AuthenticationCredential(this.peergroup, "StringAuthentication", null);
                            StringAuthenticator auth = (StringAuthenticator)this.apply(authCred);
                            auth.setAuth1Principal(principal);
                            auth.setAuth2_Password(password);
                            if (auth.isReadyForJoin()) {
                                this.join(auth);
                            } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"Property based authentication failed.");
                            }
                        }
                        catch (PeerGroupException failed) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"Property based authentication failed.", (Throwable)failed);
                            }
                        }
                        catch (ProtocolNotSupportedException failed) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block19;
                            LOG.warn((Object)"Property based authentication failed.", (Throwable)failed);
                        }
                    }
                }
                if (null == (cred = this.getDefaultCredential())) {
                    try {
                        AuthenticationCredential authCred = new AuthenticationCredential(this.peergroup, "InteractiveAuthentication", null);
                        InteractiveAuthenticator auth = (InteractiveAuthenticator)this.apply(authCred);
                        if (null != auth && auth.interact() && auth.isReadyForJoin()) {
                            this.join(auth);
                        }
                    }
                    catch (PeerGroupException failed) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Interactive authentication failed.", (Throwable)failed);
                        }
                    }
                    catch (ProtocolNotSupportedException failed) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block20;
                        LOG.warn((Object)"Interactive authentication failed.", (Throwable)failed);
                    }
                }
            }
            peeradv = this.peergroup.getPeerAdvertisement();
            paramDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
            rootCert = null;
            try {
                rootCert = this.pseParams.getPeerRootCert();
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block21;
                LOG.warn((Object)"Cannot get root cert", (Throwable)e);
            }
        }
        TextElement e = paramDoc.createElement("RootCert", rootCert);
        paramDoc.appendChild((Element)e);
        peeradv.putServiceParam(PeerGroup.peerGroupClassID, paramDoc);
        try {
            DiscoveryService disco = this.peergroup.getDiscoveryService();
            if (null != disco) {
                disco.publish(peeradv, 0);
                disco.remotePublish((Advertisement)peeradv, 0);
            }
        }
        catch (IOException ignored) {}
        return 0;
    }

    public void stopApp() {
        this.resign();
    }

    public PeerGroup getPeerGroup() {
        return this.peergroup;
    }

    public Authenticator apply(AuthenticationCredential application) throws PeerGroupException, ProtocolNotSupportedException {
        String method = application.getMethod();
        if ("StringAuthentication".equals(method)) {
            return new StringAuthenticator(this, application);
        }
        if ("DialogAuthentication".equals(method) || "InteractiveAuthentication".equals(method) || null == method) {
            return new DialogAuthenticator(this, application);
        }
        throw new ProtocolNotSupportedException("Authentication method not recognized");
    }

    public Credential getDefaultCredential() {
        return this.defaultCredential;
    }

    public synchronized Enumeration getCurrentCredentials() {
        return Collections.enumeration(this.principals);
    }

    public synchronized Enumeration getAuthCredentials() {
        return Collections.enumeration(this.authCredentials);
    }

    public synchronized Credential join(Authenticator authenticated) throws PeerGroupException {
        String passphrase;
        if (this != authenticated.getSourceService()) {
            throw new ClassCastException("This is not my authenticator!");
        }
        if (!authenticated.isReadyForJoin()) {
            throw new PeerGroupException("Not Ready to join!");
        }
        PSECredential newCred = null;
        try {
            String password;
            Authenticator auth;
            if (authenticated instanceof StringAuthenticator) {
                auth = (StringAuthenticator)authenticated;
                String principal = ((StringAuthenticator)auth).getAuth1Principal();
                password = ((StringAuthenticator)auth).getAuth2_Password();
            } else if (authenticated instanceof DialogAuthenticator) {
                auth = (DialogAuthenticator)authenticated;
                String principal = ((DialogAuthenticator)auth).getPrincipal();
                password = ((DialogAuthenticator)auth).getPassword();
            } else {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("I dont know how to deal with this authenticator" + authenticated));
                }
                throw new ClassCastException("I dont know how to deal with this authenticator");
            }
            passphrase = this.pseParams.readPassphrase(password);
            X509Certificate cert = (X509Certificate)this.pseParams.readRootCert(null);
            PrivateKey privateKey = PSEUtils.readPrivateKey(this.pseParams.getRootCertFile(null), passphrase);
            newCred = new PSECredential(this, cert, privateKey);
        }
        catch (IOException failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Could not create credential.", (Throwable)failed);
            }
            throw new PeerGroupException("Could not create credential.", failed);
        }
        this.principals.add(newCred);
        this.authCredentials.add(authenticated.getAuthenticationCredential());
        if (null == this.defaultCredential) {
            this.defaultCredential = newCred;
            this.passphrase = passphrase;
        }
        return newCred;
    }

    public synchronized void resign() {
        this.principals.clear();
        this.authCredentials.clear();
        this.defaultCredential = null;
    }

    public Credential makeCredential(Element element2) throws PeerGroupException, Exception {
        return new PSECredential(this, element2);
    }

    public PSEConfig getPSEConfig() {
        return this.pseParams;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class IdMaker {
        IdMaker() {
        }

        static ID mkID(String s) {
            try {
                return IDFactory.fromURL(IDFactory.jxtaURL("urn", "", "jxta:uuid-" + s));
            }
            catch (MalformedURLException absurd) {
            }
            catch (UnknownServiceException absurd2) {
                // empty catch block
            }
            throw new JxtaError("Hardcoded Spec and Class IDs are malformed.");
        }
    }
}

