/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import COM.claymoresystems.cert.CertVerify;
import COM.claymoresystems.cert.EAYRSAPrivateKey;
import COM.claymoresystems.cert.X509RSAPrivateKey;
import COM.claymoresystems.crypto.EAYEncryptedPrivateKey;
import COM.claymoresystems.ptls.SSLDebug;
import cryptix.provider.Cryptix;
import cryptix.util.mime.Base64InputStream;
import cryptix.util.mime.Base64OutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import jxta.security.cipher.Cipher;
import jxta.security.exceptions.CryptoException;
import jxta.security.impl.cipher.KeyBuilder;
import jxta.security.impl.crypto.JxtaCryptoSuite;
import jxta.security.impl.random.JRandom;
import jxta.security.util.Util;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class PSEUtils {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$membership$pse$PSEUtils == null ? (class$net$jxta$impl$membership$pse$PSEUtils = PSEUtils.class$("net.jxta.impl.membership.pse.PSEUtils")) : class$net$jxta$impl$membership$pse$PSEUtils).getName());
    private static final PSEUtils utils = new PSEUtils();
    private final SecureRandom srng;
    private static final int NUM_BYTES = 128;
    static final String PKCS5_PBSE1_ALGO = "PBEWithMD5AndDES";
    static /* synthetic */ Class class$net$jxta$impl$membership$pse$PSEUtils;
    static /* synthetic */ Class class$cryptix$provider$Cryptix;
    static /* synthetic */ Class class$org$bouncycastle$jce$provider$BouncyCastleProvider;
    static /* synthetic */ Class class$net$jxta$impl$membership$pse$PSEUtils$PSEProvider;
    static /* synthetic */ Class class$javax$crypto$spec$PBEParameterSpec;

    private PSEUtils() {
        block8: {
            try {
                ClassLoader sysloader = ClassLoader.getSystemClassLoader();
                Class<?> loaded = sysloader.loadClass((class$cryptix$provider$Cryptix == null ? (class$cryptix$provider$Cryptix = PSEUtils.class$("cryptix.provider.Cryptix")) : class$cryptix$provider$Cryptix).getName());
                Provider provider = (Provider)loaded.newInstance();
                Security.addProvider(provider);
                loaded = sysloader.loadClass((class$org$bouncycastle$jce$provider$BouncyCastleProvider == null ? (class$org$bouncycastle$jce$provider$BouncyCastleProvider = PSEUtils.class$("org.bouncycastle.jce.provider.BouncyCastleProvider")) : class$org$bouncycastle$jce$provider$BouncyCastleProvider).getName());
                provider = (Provider)loaded.newInstance();
                Security.addProvider(provider);
                loaded = sysloader.loadClass((class$net$jxta$impl$membership$pse$PSEUtils$PSEProvider == null ? (class$net$jxta$impl$membership$pse$PSEUtils$PSEProvider = PSEUtils.class$("net.jxta.impl.membership.pse.PSEUtils$PSEProvider")) : class$net$jxta$impl$membership$pse$PSEUtils$PSEProvider).getName());
                provider = (Provider)loaded.newInstance();
                Security.addProvider(provider);
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"Loaded Security Providers into system class loader");
                }
            }
            catch (Exception disallowed) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Can't load Security Providers into System Class Loader, using local class loader (this may not work)", (Throwable)disallowed);
                }
                Security.addProvider((Provider)new Cryptix());
                Security.addProvider((Provider)new BouncyCastleProvider());
                Security.addProvider(new PSEProvider());
                if (!LOG.isEnabledFor((Priority)Level.INFO)) break block8;
                LOG.info((Object)"Loaded Security Providers into local class loader");
            }
        }
        Level currentLevel = LOG.getEffectiveLevel();
        if (currentLevel.equals((Object)Level.DEBUG)) {
            SSLDebug.setDebug((int)124);
        } else if (currentLevel.equals((Object)Level.INFO)) {
            SSLDebug.setDebug((int)64);
        } else {
            SSLDebug.setDebug((int)0);
        }
        this.srng = PSEUtils.seedSRN();
    }

    public static SecureRandom seedSRN() {
        byte[] seed = new byte[128];
        try {
            JRandom jran = new JRandom();
            jran.nextBytes(seed);
            return new SecureRandom(seed);
        }
        catch (CryptoException failed) {
            return new SecureRandom();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Certificate readCert(File certFile) throws IOException {
        Certificate certificate;
        FileReader fr = null;
        try {
            try {
                fr = new FileReader(certFile);
                BufferedReader br = new BufferedReader(fr);
                byte[] cert_der = PSEUtils.loadObject(br, "CERTIFICATE");
                if (null == cert_der) {
                    throw new IOException("File does not contrain a certificate");
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certificate = cf.generateCertificate(new ByteArrayInputStream(cert_der));
                Object var7_7 = null;
                if (null == fr) return certificate;
            }
            catch (CertificateException badcert) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) throw new IOException("Failed to read cert " + badcert.getMessage());
                LOG.error((Object)"Failed to read cert ", (Throwable)badcert);
                throw new IOException("Failed to read cert " + badcert.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (null == fr) throw throwable;
            try {
                fr.close();
                throw throwable;
            }
            catch (IOException ignored) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignored) {
            // empty catch block
            return certificate;
        }
        fr.close();
        return certificate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeCert(File certFile, Certificate cert) throws IOException {
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(certFile);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(cert.toString());
                bw.write("\n");
                PSEUtils.writeObject(bw, "CERTIFICATE", cert.getEncoded());
            }
            catch (CertificateEncodingException failed) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) throw new IOException("Could not encode certificate " + failed.getMessage());
                LOG.error((Object)"Could not encode certificate ", (Throwable)failed);
                throw new IOException("Could not encode certificate " + failed.getMessage());
            }
            Object var5_5 = null;
            if (null == fw) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (null == fw) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        fw.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeBase64Cert(File certFile, String cert) throws IOException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(certFile);
            BufferedWriter bw = new BufferedWriter(fw);
            PSEUtils.writeBase64Object(bw, "CERTIFICATE", cert);
            Object var5_4 = null;
            if (null == fw) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (null == fw) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fw.close();
            return;
        }
        catch (IOException ignored) {}
    }

    public static boolean verifySignedCert(File root, File cert) {
        try {
            String[] args = new String[]{root.getPath(), cert.getPath()};
            CertVerify.main((String[])args);
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Failure: Could not verify cert : \n\tcert =" + cert + "\n\tRoot = " + root), e);
            }
            return false;
        }
        return true;
    }

    public static IssuerInfo genCert(File certfile, String cn, IssuerInfo issuer, String passphrase) throws IOException {
        IssuerInfo myinfo = PSEUtils.genCert(cn, issuer);
        PSEUtils.writeCert(certfile, myinfo.cert);
        myinfo.passphrase = passphrase;
        PSEUtils.appendPrivateKey(certfile, myinfo);
        return myinfo;
    }

    public static IssuerInfo genCert(String cn, IssuerInfo issuerinfo) throws IOException {
        String useCN;
        if (null == issuerinfo) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Generating Self Signed Cert ...");
            }
            useCN = cn + "-CA";
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Generating Client Cert ...");
            }
            useCN = cn;
        }
        try {
            X509Principal issuer;
            KeyPairGenerator g = KeyPairGenerator.getInstance("RSA");
            g.initialize(1024, PSEUtils.utils.srng);
            KeyPair keypair = g.generateKeyPair();
            Hashtable<DERObjectIdentifier, String> attrs = new Hashtable<DERObjectIdentifier, String>();
            attrs.put(X509Principal.C, "US");
            attrs.put(X509Principal.O, "www.jxta.org");
            attrs.put(X509Principal.L, "SF");
            byte[] ou = new byte[10];
            PSEUtils.utils.srng.nextBytes(ou);
            String ouStr = Util.hexEncode((byte[])ou);
            attrs.put(X509Principal.OU, ouStr);
            attrs.put(X509Principal.CN, useCN);
            Date today = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(today);
            cal.add(1, 10);
            Date after = cal.getTime();
            PrivateKey signer = null;
            X509Principal subject = new X509Principal(attrs);
            if (null == issuerinfo) {
                signer = keypair.getPrivate();
                issuer = subject;
            } else {
                signer = issuerinfo.rootKey;
                Principal issuer_subject = ((X509Certificate)issuerinfo.cert).getSubjectDN();
                issuer = new X509Principal(issuer_subject.getName());
            }
            X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
            certGen.setSerialNumber(BigInteger.valueOf(1L));
            certGen.setIssuerDN((X509Name)issuer);
            certGen.setSubjectDN((X509Name)subject);
            certGen.setNotBefore(today);
            certGen.setNotAfter(after);
            certGen.setPublicKey(keypair.getPublic());
            certGen.setSignatureAlgorithm("SHA1withRSA");
            X509Certificate cert = certGen.generateX509Certificate(signer);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                if (null == issuer) {
                    LOG.debug((Object)("Root Cert : \n" + cert.toString()));
                } else {
                    LOG.debug((Object)("Client Cert : \n" + cert.toString()));
                }
            }
            IssuerInfo info = new IssuerInfo();
            info.cert = cert;
            info.rootKey = signer;
            info.subjectPkey = keypair.getPrivate();
            info.rootAttributes = attrs;
            return info;
        }
        catch (NoSuchAlgorithmException e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.debug((Object)"genCert:", (Throwable)e);
            }
            throw new IOException("Could not generate certificate : " + e);
        }
        catch (SignatureException e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.debug((Object)"genCert:", (Throwable)e);
            }
            throw new IOException("Could not generate certificate : " + e);
        }
        catch (InvalidKeyException e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"genCert:", (Throwable)e);
            }
            throw new IOException("Could not generate certificate : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void appendPrivateKey(File certfile, IssuerInfo info) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("appendPrivateKey  (" + info.passphrase.getBytes() + " ) : " + certfile + "\n" + info.subjectPkey));
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(certfile, true);
            BufferedWriter bw = new BufferedWriter(fw);
            X509RSAPrivateKey convpriv = new X509RSAPrivateKey((RSAPrivateCrtKey)info.subjectPkey);
            EAYEncryptedPrivateKey.writePrivateKey((PrivateKey)convpriv, (byte[])info.passphrase.getBytes(), (BufferedWriter)bw);
            bw.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                fw.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fw.close();
        }
        catch (IOException ignored) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey readPrivateKey(File certfile, String passphrase) throws IOException {
        RSAPrivateKey rSAPrivateKey;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("readPrivateKey (" + passphrase.getBytes() + " ) : " + certfile));
        }
        Certificate cert = PSEUtils.readCert(certfile);
        RSAPublicKey pubKey = (RSAPublicKey)cert.getPublicKey();
        FileReader fr = null;
        try {
            try {
                RSAPrivateKey convkey;
                fr = new FileReader(certfile);
                BufferedReader br = new BufferedReader(fr);
                String objectheader = PSEUtils.findObject(br, " PRIVATE KEY");
                if (null == objectheader) {
                    throw new IOException("failed to load the private key");
                }
                br.readLine();
                String keytype = objectheader.substring(0, objectheader.length() - " PRIVATE KEY".length());
                EAYRSAPrivateKey sk = (EAYRSAPrivateKey)EAYEncryptedPrivateKey.createPrivateKey((BufferedReader)br, (String)keytype, (byte[])passphrase.getBytes());
                BigInteger p1 = sk.getP().subtract(new BigInteger("1"));
                BigInteger q1 = sk.getQ().subtract(new BigInteger("1"));
                BigInteger pub = sk.getExponent().modInverse(p1.multiply(q1));
                BigInteger dmp1 = sk.getExponent().mod(p1);
                BigInteger dmq1 = sk.getExponent().mod(q1);
                RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(sk.getModulus(), pub, sk.getExponent(), sk.getP(), sk.getQ(), dmp1, dmq1, sk.getInverseOfQModP());
                KeyFactory kf = KeyFactory.getInstance("RSA");
                rSAPrivateKey = convkey = (RSAPrivateKey)kf.generatePrivate(spec);
                Object var19_20 = null;
            }
            catch (IOException failed) {
                throw failed;
            }
            catch (Exception failed) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) throw new IOException("Failed to build private key : " + failed.getMessage());
                LOG.error((Object)"readPrivateKey : Failed to build private key : ", (Throwable)failed);
                throw new IOException("Failed to build private key : " + failed.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            try {
                if (null == fr) throw throwable;
                fr.close();
                throw throwable;
            }
            catch (IOException ignored) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignored) {
            // empty catch block
            return rSAPrivateKey;
        }
        if (null == fr) return rSAPrivateKey;
        fr.close();
        return rSAPrivateKey;
    }

    public static byte[] computeSignature(String algorithm, PrivateKey key, InputStream stream) throws InvalidKeyException, SignatureException, IOException {
        int read;
        Signature sign;
        try {
            sign = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException badsigner) {
            throw new IOException("Could not initialize signer with algorithm " + algorithm);
        }
        sign.initSign(key);
        byte[] buffer = new byte[1024];
        while ((read = stream.read(buffer)) >= 0) {
            sign.update(buffer, 0, read);
        }
        return sign.sign();
    }

    public static byte[] hash(String algorithm, byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static boolean verifySignature(String algorithm, Certificate cert, byte[] signature, InputStream stream) throws InvalidKeyException, SignatureException, IOException {
        int read;
        Signature sign;
        try {
            sign = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException badsigner) {
            throw new IOException("Could not initialize signer with algorithm " + algorithm);
        }
        sign.initVerify(cert);
        byte[] buffer = new byte[1024];
        while ((read = stream.read(buffer)) >= 0) {
            sign.update(buffer, 0, read);
        }
        return sign.verify(signature);
    }

    public static byte[] tlsCipher(byte[] data, String password, byte mode) throws CryptoException {
        JxtaCryptoSuite suite = new JxtaCryptoSuite(1, null, 0, 0);
        Cipher rc4 = suite.getJxtaCipher();
        jxta.security.impl.cipher.SecretKey k1 = (jxta.security.impl.cipher.SecretKey)KeyBuilder.buildKey((byte)8, (short)128, (boolean)false);
        byte[] pbytes = password.getBytes();
        byte[] forkey = new byte[16];
        int i = 0;
        int j = 0;
        while (i < forkey.length) {
            forkey[i] = pbytes[j++];
            if (j == pbytes.length) {
                j = 0;
            }
            ++i;
        }
        k1.setKey(forkey, 0);
        byte[] obuf = new byte[data.length];
        rc4.init((jxta.security.cipher.Key)k1, mode);
        rc4.doFinal(data, 0, data.length, obuf, 0);
        return obuf;
    }

    public static EncryptedPrivateKeyInfo pkcs5_Encrypt_pbePrivateKey(char[] password, PrivateKey privkey, int iterations) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("pkcs5_Encrypt_pbePrivateKey: encrypting " + privkey + " with '" + new String(password) + "'"));
        }
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        byte[] salt = new byte[8];
        PSEUtils.utils.srng.nextBytes(salt);
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, iterations);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PKCS5_PBSE1_ALGO);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            javax.crypto.Cipher pbeCipher = javax.crypto.Cipher.getInstance(PKCS5_PBSE1_ALGO);
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            byte[] encryptedPrivKey = pbeCipher.doFinal(privkey.getEncoded());
            AlgorithmParameters algo = AlgorithmParameters.getInstance(PKCS5_PBSE1_ALGO);
            algo.init(pbeParamSpec);
            EncryptedPrivateKeyInfo result = new EncryptedPrivateKeyInfo(algo, encryptedPrivKey);
            return result;
        }
        catch (Exception failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"pkcs5_Encrypt_pbePrivateKey : failed", (Throwable)failed);
            }
            return null;
        }
    }

    public static PrivateKey pkcs5_Decrypt_pbePrivateKey(char[] password, String algorithm, EncryptedPrivateKeyInfo encryptedPrivKey) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("pkcs5_Decrypt_pbePrivateKey: decrypting " + encryptedPrivKey + "/" + algorithm + " with '" + new String(password) + "'"));
        }
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        try {
            AlgorithmParameters algo = encryptedPrivKey.getAlgParameters();
            if (null == algo) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("pkcs5_Decrypt_pbePrivateKey : Could not get algo parameters from " + encryptedPrivKey));
                }
                throw new IllegalStateException("Could not get algo parameters from " + encryptedPrivKey);
            }
            PBEParameterSpec pbeParamSpec = (PBEParameterSpec)algo.getParameterSpec(class$javax$crypto$spec$PBEParameterSpec == null ? (class$javax$crypto$spec$PBEParameterSpec = PSEUtils.class$("javax.crypto.spec.PBEParameterSpec")) : class$javax$crypto$spec$PBEParameterSpec);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PKCS5_PBSE1_ALGO);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            javax.crypto.Cipher pbeCipher = javax.crypto.Cipher.getInstance(PKCS5_PBSE1_ALGO);
            pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
            PKCS8EncodedKeySpec key_spec = encryptedPrivKey.getKeySpec(pbeCipher);
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            return kf.generatePrivate(key_spec);
        }
        catch (Exception failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"pkcs5_Decrypt_pbePrivateKey : failed", (Throwable)failed);
            }
            return null;
        }
    }

    public static String loadBase64Object(BufferedReader rdr, String type) throws IOException {
        if (null != PSEUtils.findObject(rdr, type)) {
            return PSEUtils.readBase64Object(rdr, type);
        }
        return null;
    }

    public static byte[] loadObject(BufferedReader rdr, String type) throws IOException {
        if (null != PSEUtils.findObject(rdr, type)) {
            return PSEUtils.readObject(rdr, type);
        }
        return null;
    }

    public static String findObject(BufferedReader br, String type) throws IOException {
        String line;
        String prefix = "-----BEGIN ";
        String suffix = type == null ? "-----" : type + "-----";
        do {
            br.mark(1024);
            line = br.readLine();
            if (null != line) continue;
            return null;
        } while (!line.startsWith(prefix) || !line.endsWith(suffix));
        br.reset();
        return line.substring(prefix.length(), line.length() - 5);
    }

    public static String readBase64Object(BufferedReader br, String type) throws IOException {
        String suffix;
        String line = br.readLine();
        String prefix = "-----BEGIN ";
        String string = suffix = type == null ? "-----" : type + "-----";
        if (!line.startsWith(prefix) || !line.endsWith(suffix)) {
            throw new IOException("Not at begining of object");
        }
        StringBuffer block = new StringBuffer();
        while (null != (line = br.readLine()) && !line.startsWith("-----END ")) {
            block.append(line);
            block.append('\n');
        }
        return block.toString();
    }

    public static byte[] readObject(BufferedReader br, String type) throws IOException {
        String base64 = PSEUtils.readBase64Object(br, type);
        return PSEUtils.base64Decode(base64);
    }

    public static void writeBase64Object(BufferedWriter bw, String type, String object) throws IOException {
        bw.write("-----BEGIN ");
        bw.write(type);
        bw.write("-----");
        bw.newLine();
        bw.write(object);
        bw.write("-----END ");
        bw.write(type);
        bw.write("-----");
        bw.newLine();
        bw.flush();
    }

    public static void writeObject(BufferedWriter out, String type, byte[] object) throws IOException {
        String base64 = PSEUtils.base64Encode(object);
        PSEUtils.writeBase64Object(out, type, base64);
    }

    public static String base64Encode(byte[] in) {
        try {
            String line;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Base64OutputStream b64os = new Base64OutputStream((OutputStream)bos);
            b64os.write(in);
            b64os.flush();
            b64os.close();
            byte[] enc = bos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(enc);
            InputStreamReader ir = new InputStreamReader(bis);
            BufferedReader r = new BufferedReader(ir);
            StringBuffer sb = new StringBuffer(enc.length);
            while (null != (line = r.readLine())) {
                sb.append(line);
                sb.append('\n');
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("base64Encode : " + in.length + " bytes -> " + sb.length() + " characters"));
            }
            return sb.toString();
        }
        catch (IOException failed) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"base64Encode : failure in encoding", (Throwable)failed);
            }
            return null;
        }
    }

    public static byte[] base64Decode(String in) throws IOException {
        int dlen;
        ByteArrayInputStream bis = new ByteArrayInputStream(in.getBytes());
        Base64InputStream b64is = new Base64InputStream((InputStream)bis);
        byte[] data = new byte[in.length()];
        int offset = 0;
        while ((dlen = b64is.read(data, offset, data.length - offset)) >= 0) {
            offset += dlen;
        }
        byte[] trimmeddata = new byte[offset];
        System.arraycopy(data, 0, trimmeddata, 0, offset);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("base64Decode : " + in.length() + " characters -> " + trimmeddata.length + " bytes"));
        }
        return trimmeddata;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class IssuerInfo {
        public Certificate cert;
        public PrivateKey subjectPkey;
        public String passphrase;
        public PrivateKey rootKey;
        public Hashtable rootAttributes;
    }

    public static class PSEProvider
    extends Provider {
        public PSEProvider() {
            super("JXTAPSE", 2.2, "JXTA PSE Alias Provider");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.1", "PBEWithMD2AndDES");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.3", PSEUtils.PKCS5_PBSE1_ALGO);
            this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.5.3", PSEUtils.PKCS5_PBSE1_ALGO);
            this.put("AlgorithmParameters.1.2.840.113549.1.5.3", "com.sun.crypto.provider.PBEParameters");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.10", "PBEWithSHA1AndDES");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.12", "PBKDF2");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.13", "PBES2");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.14", "PBMAC1");
        }

        public String getProperty(String key) {
            String result = super.getProperty(key);
            return result;
        }

        public String getProperty(String key, String defaultValue) {
            String result = super.getProperty(key, defaultValue);
            return result;
        }
    }
}

