/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.meter;

import net.jxta.endpoint.EndpointAddress;
import net.jxta.exception.JxtaException;
import net.jxta.peer.PeerID;
import net.jxta.util.JxtaUtilities;

public class MetricUtilities {
    private static PeerID unknownPeer;
    private static PeerID badPeer;
    public static final PeerID UNKNOWN_PEERID;
    public static final PeerID BAD_PEERID;

    public static PeerID getPeerIdFromString(String peerIdString) {
        PeerID peerId = null;
        try {
            peerId = (PeerID)JxtaUtilities.getIdFromString(peerIdString);
        }
        catch (Exception e) {
            peerId = BAD_PEERID;
        }
        return peerId;
    }

    public static PeerID getPeerIdFromEndpointAddress(EndpointAddress endpointAddress) {
        PeerID peerId = null;
        try {
            peerId = (PeerID)JxtaUtilities.getIdFromString("urn:" + endpointAddress.getProtocolName() + ":" + endpointAddress.getProtocolAddress());
        }
        catch (Exception e) {
            peerId = BAD_PEERID;
        }
        return peerId;
    }

    static {
        try {
            unknownPeer = (PeerID)JxtaUtilities.getIdFromString("urn:jxta:uuid-DEAF03");
            badPeer = (PeerID)JxtaUtilities.getIdFromString("urn:jxta:uuid-BADBAD03");
        }
        catch (JxtaException e) {
            // empty catch block
        }
        UNKNOWN_PEERID = unknownPeer;
        BAD_PEERID = badPeer;
    }
}

