/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.meter;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import net.jxta.document.Advertisement;
import net.jxta.exception.JxtaException;
import net.jxta.id.ID;
import net.jxta.impl.meter.ServiceMonitorImpl;
import net.jxta.impl.meter.ServiceMonitorPulseInfo;
import net.jxta.meter.MonitorEvent;
import net.jxta.meter.MonitorException;
import net.jxta.meter.MonitorFilter;
import net.jxta.meter.MonitorFilterException;
import net.jxta.meter.MonitorListener;
import net.jxta.meter.MonitorReport;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.PeerMonitorInfo;
import net.jxta.meter.ServiceMetric;
import net.jxta.meter.ServiceMonitor;
import net.jxta.meter.ServiceMonitorFilter;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;
import net.jxta.util.AbstractTimeStampedData;
import net.jxta.util.TimeConstants;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class MonitorManager
implements TimeConstants,
Service {
    public static final int NOT_PULSING = -1;
    private static final int NO_PRIOR_REPORT = 0;
    private static long[] supportedReportRates = new long[]{500L, 1000L, 5000L, 10000L, 15000L, 30000L, 60000L, 300000L, 600000L, 900000L, 1800000L, 3600000L, 10800000L, 21600000L, 43200000L, 86400000L, 604800000L};
    private int[] pulsesPerRate = new int[supportedReportRates.length];
    private long timeZero = AbstractTimeStampedData.getTimeZero();
    private long startTime = System.currentTimeMillis();
    private long reportCycleBaseTime = -1L;
    private LinkedList monitorListenerInfos = new LinkedList();
    private Hashtable serviceMonitorPulseInfos = new Hashtable();
    private int[] filtersPerRate = new int[supportedReportRates.length];
    private long[] previousReportTimes = new long[supportedReportRates.length];
    private PeerGroup peerGroup;
    private Thread reportThread;
    private long pulseRate = -1L;
    private int pulseRateIndex = -1;
    private int pulseNumber = 0;
    private long nextPulseTime = 0L;
    private boolean isRunning = true;
    private ModuleClassID[] supportedModuleClassIDs;
    private Service monitorServiceInterface;
    private ModuleImplAdvertisement implAdvertisement;
    private long lastResetTime = System.currentTimeMillis();
    private static long start = System.currentTimeMillis();
    private static Hashtable monitorManagers = new Hashtable();

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public Service getInterface() {
        return this;
    }

    public void init(PeerGroup peerGroup, ID assignedID, Advertisement implAdvertisement) {
        this.implAdvertisement = (ModuleImplAdvertisement)implAdvertisement;
        this.peerGroup = peerGroup;
        this.createReportThread();
        long currentTime = System.currentTimeMillis();
        int i = 0;
        while (i < this.previousReportTimes.length) {
            this.pulsesPerRate[i] = (int)(supportedReportRates[i] / supportedReportRates[0]);
            ++i;
        }
    }

    public int startApp(String[] args) {
        return 0;
    }

    public void stopApp() {
        this.destroy();
    }

    public static long[] getReportRates() {
        long[] copy = new long[supportedReportRates.length];
        System.arraycopy(supportedReportRates, 0, copy, 0, supportedReportRates.length);
        return copy;
    }

    public boolean isLocalMonitoringAvailable(ModuleClassID moduleClassID) {
        ServiceMonitor serviceMonitor = this.getServiceMonitor(moduleClassID);
        return serviceMonitor != null;
    }

    public PeerGroup getPeerGroup() {
        return this.peerGroup;
    }

    private void setPeerGroup(PeerGroup pg) {
        PeerGroup tmp = this.peerGroup;
        this.peerGroup = pg;
        tmp.unref();
        Object var2_2 = null;
    }

    public PeerMonitorInfo getPeerMonitorInfo() {
        long[] reportRates = MonitorManager.getReportRates();
        ModuleClassID[] moduleClassIDs = this.getMonitorableServiceTypes();
        long runningTime = System.currentTimeMillis() - this.lastResetTime;
        return new PeerMonitorInfo(false, moduleClassIDs, reportRates, this.lastResetTime, runningTime);
    }

    public int getReportRatesCount() {
        return supportedReportRates.length;
    }

    public int getReportRateIndex(long reportRate) {
        int i = 0;
        while (i < supportedReportRates.length) {
            if (supportedReportRates[i] == reportRate) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSupportedReportRate(long reportRate) {
        return this.getReportRateIndex(reportRate) >= 0;
    }

    public long getReportRate(int index) {
        return supportedReportRates[index];
    }

    public long getBestReportRate(long desiredReportRate) {
        int i = 0;
        while (i < supportedReportRates.length) {
            if (desiredReportRate <= supportedReportRates[i]) {
                return supportedReportRates[i];
            }
            ++i;
        }
        return supportedReportRates[supportedReportRates.length - 1];
    }

    public ServiceMonitor getServiceMonitor(ModuleClassID moduleClassID) {
        ServiceMonitorPulseInfo serviceMonitorPulseInfo = (ServiceMonitorPulseInfo)this.serviceMonitorPulseInfos.get(moduleClassID);
        if (serviceMonitorPulseInfo != null) {
            return serviceMonitorPulseInfo.serviceMonitor;
        }
        try {
            ModuleImplAdvertisement moduleImplAdvertisement = MonitorResources.getServiceMonitorImplAdvertisement(moduleClassID, this.implAdvertisement);
            ServiceMonitor serviceMonitor = (ServiceMonitor)this.peerGroup.loadModule(moduleClassID, moduleImplAdvertisement);
            MonitorResources.registerServiceMonitorModuleImplAdvertisement(moduleImplAdvertisement);
            if (serviceMonitor instanceof ServiceMonitorImpl) {
                ((ServiceMonitorImpl)serviceMonitor).init(this);
            }
            serviceMonitorPulseInfo = new ServiceMonitorPulseInfo(this, serviceMonitor);
            this.serviceMonitorPulseInfos.put(moduleClassID, serviceMonitorPulseInfo);
            return serviceMonitor;
        }
        catch (JxtaException e) {
            throw new RuntimeException("Unable to load Service Monitor: " + moduleClassID + "\n\tException: " + e);
        }
    }

    private void resetPulseRate() {
        int oldPulseRateIndex = this.pulseRateIndex;
        this.pulseRateIndex = -1;
        this.pulseRate = -1L;
        int i = 0;
        while (i < this.filtersPerRate.length) {
            if (this.filtersPerRate[i] != 0) {
                this.pulseRateIndex = i;
                this.pulseRate = this.getReportRate(this.pulseRateIndex);
                break;
            }
            ++i;
        }
        if (oldPulseRateIndex == this.pulseRateIndex) {
            return;
        }
        long now = System.currentTimeMillis();
        if (oldPulseRateIndex == -1) {
            int i2 = 0;
            while (i2 < this.filtersPerRate.length) {
                this.previousReportTimes[i2] = this.filtersPerRate[i2] != 0 ? now : 0L;
                ++i2;
            }
            this.pulseNumber = 0;
            this.nextPulseTime = now + this.pulseRate;
        } else if (this.pulseRateIndex != -1) {
            if (this.pulseRateIndex < oldPulseRateIndex) {
                int i3 = this.pulseRateIndex;
                while (i3 < oldPulseRateIndex - 1) {
                    this.previousReportTimes[i3] = this.filtersPerRate[i3] != 0 ? now : 0L;
                    ++i3;
                }
                long timeToNextPulse = this.nextPulseTime - now;
                if (this.pulseRate < timeToNextPulse) {
                    int numPulsesToNow = (int)(timeToNextPulse / this.pulseRate);
                    int numNewToOldPulses = (int)(supportedReportRates[oldPulseRateIndex] / supportedReportRates[this.pulseRateIndex]);
                    this.pulseNumber += (numNewToOldPulses - numPulsesToNow) * this.pulsesPerRate[this.pulseRateIndex];
                    timeToNextPulse = now - (long)numPulsesToNow * this.pulseRate;
                } else {
                    this.pulseNumber += this.pulsesPerRate[oldPulseRateIndex] - this.pulsesPerRate[this.pulseRateIndex];
                }
            } else if (this.pulseRateIndex > oldPulseRateIndex) {
                int nextPulseNumber = this.pulseNumber + this.pulsesPerRate[oldPulseRateIndex];
                this.pulseNumber = (nextPulseNumber - 1) / this.pulsesPerRate[this.pulseRateIndex] * this.pulsesPerRate[this.pulseRateIndex];
                this.nextPulseTime += (long)(nextPulseNumber - this.pulseNumber) * supportedReportRates[0];
                int i4 = 0;
                while (i4 < this.pulseRateIndex) {
                    this.previousReportTimes[i4] = 0L;
                    ++i4;
                }
            }
        }
        this.reportThread.interrupt();
    }

    private MonitorReport getMonitorReport(MonitorFilter monitorFilter, long reportRate, long previousDeltaTime, long beginReportTime) {
        MonitorReport monitorReport = new MonitorReport(previousDeltaTime, beginReportTime, false);
        Iterator i = monitorFilter.getModuleClassIDs();
        while (i.hasNext()) {
            ServiceMetric serviceMetric;
            ModuleClassID moduleClassID = (ModuleClassID)i.next();
            ServiceMonitorFilter serviceMonitorFilter = monitorFilter.getServiceMonitorFilter(moduleClassID);
            ServiceMonitor serviceMonitor = this.getServiceMonitor(moduleClassID);
            if (serviceMonitorFilter == null || (serviceMetric = serviceMonitor.getServiceMetric(serviceMonitorFilter, previousDeltaTime, beginReportTime, this.getReportRateIndex(reportRate), reportRate)) == null) continue;
            monitorReport.addServiceMetric(serviceMetric);
        }
        return monitorReport;
    }

    public void validateCumulativeMonitorFilter(MonitorFilter monitorFilter) throws MonitorFilterException {
        boolean isAnyServiceFilters = false;
        Iterator i = monitorFilter.getServiceMonitorFilters();
        while (i.hasNext()) {
            ServiceMonitorFilter serviceMonitorFilter = (ServiceMonitorFilter)i.next();
            ModuleClassID moduleClassID = serviceMonitorFilter.getModuleClassID();
            ServiceMonitor serviceMonitor = this.getServiceMonitor(moduleClassID);
            if (serviceMonitor == null) {
                throw new MonitorFilterException("Service Not Supported", moduleClassID);
            }
            serviceMonitor.validateCumulativeServiceMonitorFilter(serviceMonitorFilter);
            isAnyServiceFilters = true;
        }
        if (!isAnyServiceFilters) {
            throw new MonitorFilterException("Empty Monitor Filter");
        }
    }

    public void validateMonitorFilter(MonitorFilter monitorFilter, long reportRate) throws MonitorFilterException {
        if (!this.isSupportedReportRate(reportRate)) {
            throw new MonitorFilterException("Report Rate Not Supported", reportRate);
        }
        boolean isAnyServiceFilters = false;
        Iterator i = monitorFilter.getServiceMonitorFilters();
        while (i.hasNext()) {
            ServiceMonitorFilter serviceMonitorFilter = (ServiceMonitorFilter)i.next();
            ModuleClassID moduleClassID = serviceMonitorFilter.getModuleClassID();
            ServiceMonitor serviceMonitor = this.getServiceMonitor(moduleClassID);
            if (serviceMonitor == null) {
                throw new MonitorFilterException("Service Not Supported", moduleClassID);
            }
            serviceMonitor.validateServiceMonitorFilter(serviceMonitorFilter, reportRate);
            isAnyServiceFilters = true;
        }
        if (!isAnyServiceFilters) {
            throw new MonitorFilterException("Empty Monitor Filter");
        }
    }

    public MonitorFilter createSupportedCumulativeMonitorFilter(MonitorFilter monitorFilter) throws MonitorFilterException {
        MonitorFilter newMonitorFilter = new MonitorFilter(monitorFilter.getDescription());
        boolean anythingAdded = false;
        Iterator i = monitorFilter.getServiceMonitorFilters();
        while (i.hasNext()) {
            ServiceMonitorFilter newServiceMonitorFilter;
            ServiceMonitorFilter serviceMonitorFilter = (ServiceMonitorFilter)i.next();
            ModuleClassID moduleClassID = serviceMonitorFilter.getModuleClassID();
            ServiceMonitor serviceMonitor = this.getServiceMonitor(moduleClassID);
            if (serviceMonitor == null || (newServiceMonitorFilter = serviceMonitor.createSupportedCumulativeServiceMonitorFilter(serviceMonitorFilter)) == null) continue;
            newMonitorFilter.addServiceMonitorFilter(newServiceMonitorFilter);
            anythingAdded = true;
        }
        if (anythingAdded) {
            return newMonitorFilter;
        }
        return null;
    }

    public MonitorFilter createSupportedMonitorFilter(MonitorFilter monitorFilter, long reportRate) throws MonitorFilterException {
        MonitorFilter newMonitorFilter = new MonitorFilter(monitorFilter.getDescription());
        boolean anythingAdded = false;
        Iterator i = monitorFilter.getServiceMonitorFilters();
        while (i.hasNext()) {
            ServiceMonitorFilter newServiceMonitorFilter;
            ServiceMonitorFilter serviceMonitorFilter = (ServiceMonitorFilter)i.next();
            ModuleClassID moduleClassID = serviceMonitorFilter.getModuleClassID();
            ServiceMonitor serviceMonitor = this.getServiceMonitor(moduleClassID);
            if (serviceMonitor == null || (newServiceMonitorFilter = serviceMonitor.createSupportedServiceMonitorFilter(serviceMonitorFilter, reportRate)) == null) continue;
            newMonitorFilter.addServiceMonitorFilter(newServiceMonitorFilter);
            anythingAdded = true;
        }
        if (anythingAdded) {
            return newMonitorFilter;
        }
        return null;
    }

    public synchronized long addMonitorListener(MonitorFilter monitorFilter, long reportRate, boolean includeCumulative, MonitorListener monitorListener) throws MonitorException {
        this.validateMonitorFilter(monitorFilter, reportRate);
        if (includeCumulative) {
            this.validateCumulativeMonitorFilter(monitorFilter);
        }
        int reportRateIndex = this.getReportRateIndex(reportRate);
        try {
            monitorFilter = (MonitorFilter)DocumentSerializableUtilities.copyDocumentSerializable(monitorFilter);
        }
        catch (DocumentSerializationException e) {
            throw new MonitorException(MonitorException.SERIALIZATION, "Error trying to copy MonitorFilter");
        }
        MonitorListenerInfo monitorListenerInfo = new MonitorListenerInfo(monitorListener, reportRate, monitorFilter, includeCumulative);
        this.monitorListenerInfos.add(monitorListenerInfo);
        int n = reportRateIndex;
        this.filtersPerRate[n] = this.filtersPerRate[n] + 1;
        if (this.filtersPerRate[reportRateIndex] == 1 && this.pulseRateIndex != -1 && reportRateIndex > this.pulseRateIndex) {
            this.previousReportTimes[reportRateIndex] = this.previousReportTimes[this.pulseRateIndex];
        }
        Iterator i = monitorFilter.getModuleClassIDs();
        while (i.hasNext()) {
            ModuleClassID moduleClassID = (ModuleClassID)i.next();
            ServiceMonitorFilter serviceMonitorFilter = monitorFilter.getServiceMonitorFilter(moduleClassID);
            ServiceMonitorPulseInfo serviceMonitorPulseInfo = (ServiceMonitorPulseInfo)this.serviceMonitorPulseInfos.get(moduleClassID);
            serviceMonitorPulseInfo.registerServiceMonitorFilter(serviceMonitorFilter, reportRateIndex, reportRate);
        }
        this.resetPulseRate();
        return reportRate;
    }

    private MonitorListenerInfo getMonitorListenerInfo(MonitorListener monitorListener) {
        Iterator i = this.monitorListenerInfos.iterator();
        while (i.hasNext()) {
            MonitorListenerInfo monitorListenerInfo = (MonitorListenerInfo)i.next();
            if (monitorListenerInfo.monitorListener != monitorListener) continue;
            return monitorListenerInfo;
        }
        return null;
    }

    public synchronized int removeMonitorListener(MonitorListener monitorListener) {
        MonitorListenerInfo monitorListenerInfo;
        int numRemoved = 0;
        while ((monitorListenerInfo = this.getMonitorListenerInfo(monitorListener)) != null) {
            MonitorFilter monitorFilter = monitorListenerInfo.monitorFilter;
            long reportRate = monitorListenerInfo.reportRate;
            int reportRateIndex = monitorListenerInfo.reportRateIndex;
            this.monitorListenerInfos.remove(monitorListenerInfo);
            ++numRemoved;
            int n = reportRateIndex;
            this.filtersPerRate[n] = this.filtersPerRate[n] - 1;
            Iterator i = monitorFilter.getModuleClassIDs();
            while (i.hasNext()) {
                ModuleClassID moduleClassID = (ModuleClassID)i.next();
                ServiceMonitorFilter serviceMonitorFilter = monitorFilter.getServiceMonitorFilter(moduleClassID);
                ServiceMonitorPulseInfo serviceMonitorPulseInfo = (ServiceMonitorPulseInfo)this.serviceMonitorPulseInfos.get(moduleClassID);
                serviceMonitorPulseInfo.deregisterServiceMonitorFilter(serviceMonitorFilter, reportRateIndex, reportRate);
            }
        }
        this.resetPulseRate();
        return numRemoved;
    }

    public synchronized MonitorReport getCumulativeMonitorReport(MonitorFilter monitorFilter) throws MonitorFilterException, MonitorException {
        this.validateCumulativeMonitorFilter(monitorFilter);
        long beginReportTime = System.currentTimeMillis();
        MonitorReport monitorReport = new MonitorReport(this.startTime, beginReportTime, true);
        Iterator i = monitorFilter.getModuleClassIDs();
        while (i.hasNext()) {
            ModuleClassID moduleClassID = (ModuleClassID)i.next();
            ServiceMonitorFilter serviceMonitorFilter = monitorFilter.getServiceMonitorFilter(moduleClassID);
            ServiceMonitor serviceMonitor = this.getServiceMonitor(moduleClassID);
            ServiceMetric serviceMetric = serviceMonitor.getCumulativeServiceMetric(serviceMonitorFilter, this.timeZero, beginReportTime);
            monitorReport.addServiceMetric(moduleClassID, serviceMetric);
        }
        return monitorReport;
    }

    public ModuleClassID[] getMonitorableServiceTypes() {
        if (this.supportedModuleClassIDs == null) {
            ModuleClassID[] registeredModuleClassIDs = MonitorResources.getRegisteredModuleClassIDs();
            LinkedList<ModuleClassID> supportedModuleClassIDsList = new LinkedList<ModuleClassID>();
            int i = 0;
            while (i < registeredModuleClassIDs.length) {
                ModuleClassID registeredModuleClassID = registeredModuleClassIDs[i];
                if (this.isLocalMonitoringAvailable(registeredModuleClassID)) {
                    supportedModuleClassIDsList.add(registeredModuleClassID);
                }
                ++i;
            }
            this.supportedModuleClassIDs = supportedModuleClassIDsList.toArray(new ModuleClassID[0]);
        }
        return this.supportedModuleClassIDs;
    }

    public long getPulseRate() {
        return this.getReportRate(this.pulseRateIndex);
    }

    public int getPulseRateIndex() {
        return this.pulseRateIndex;
    }

    public long getPulseRate(ServiceMonitor serviceMonitor) {
        ServiceMonitorPulseInfo serviceMonitorPulseInfo = (ServiceMonitorPulseInfo)this.serviceMonitorPulseInfos.get(serviceMonitor.getModuleClassID());
        if (serviceMonitorPulseInfo != null) {
            return serviceMonitorPulseInfo.getPulseRate();
        }
        return -1L;
    }

    public long getPulseRateIndex(ServiceMonitor serviceMonitor) {
        ServiceMonitorPulseInfo serviceMonitorPulseInfo = (ServiceMonitorPulseInfo)this.serviceMonitorPulseInfos.get(serviceMonitor.getModuleClassID());
        if (serviceMonitorPulseInfo != null) {
            return serviceMonitorPulseInfo.getPulseRateIndex();
        }
        return -1L;
    }

    private void generateReports() {
        long beginReportTime = System.currentTimeMillis();
        Enumeration e = this.serviceMonitorPulseInfos.elements();
        while (e.hasMoreElements()) {
            ServiceMonitorPulseInfo serviceMonitorPulseInfo = (ServiceMonitorPulseInfo)e.nextElement();
            int servicePulseRateIndex = serviceMonitorPulseInfo.getPulseRateIndex();
            if (!(serviceMonitorPulseInfo.serviceMonitor instanceof ServiceMonitorImpl) || !this.isEvenPulseForRateIndex(servicePulseRateIndex)) continue;
            ((ServiceMonitorImpl)serviceMonitorPulseInfo.serviceMonitor).beginPulse(serviceMonitorPulseInfo);
        }
        Iterator i = this.monitorListenerInfos.iterator();
        while (i.hasNext()) {
            MonitorListenerInfo monitorListenerInfo = (MonitorListenerInfo)i.next();
            MonitorFilter monitorFilter = monitorListenerInfo.monitorFilter;
            MonitorListener monitorListener = monitorListenerInfo.monitorListener;
            int reportRateIndex = monitorListenerInfo.reportRateIndex;
            long reportRate = monitorListenerInfo.reportRate;
            if (!this.isEvenPulseForRateIndex(reportRateIndex)) continue;
            MonitorReport monitorReport = null;
            try {
                MonitorEvent monitorEvent;
                if (monitorListenerInfo.sendCumulativeFirst && !monitorListenerInfo.wasCumulativeSent) {
                    monitorReport = this.getCumulativeMonitorReport(monitorFilter);
                    monitorEvent = new MonitorEvent(this.peerGroup.getPeerGroupID(), monitorReport);
                    monitorListener.processMonitorReport(monitorEvent);
                    monitorListenerInfo.wasCumulativeSent = true;
                    continue;
                }
                monitorReport = this.getMonitorReport(monitorFilter, reportRate, this.previousReportTimes[reportRateIndex], beginReportTime);
                monitorEvent = new MonitorEvent(this.peerGroup.getPeerGroupID(), monitorReport);
                monitorListener.processMonitorReport(monitorEvent);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
        int rateIndex = 0;
        while (rateIndex < supportedReportRates.length) {
            if (this.isEvenPulseForRateIndex(rateIndex)) {
                this.previousReportTimes[rateIndex] = this.filtersPerRate[rateIndex] != 0 ? beginReportTime : 0L;
            }
            ++rateIndex;
        }
        Enumeration e3 = this.serviceMonitorPulseInfos.elements();
        while (e3.hasMoreElements()) {
            ServiceMonitorPulseInfo serviceMonitorPulseInfo = (ServiceMonitorPulseInfo)e3.nextElement();
            int servicePulseRateIndex = serviceMonitorPulseInfo.getPulseRateIndex();
            if (!(serviceMonitorPulseInfo.serviceMonitor instanceof ServiceMonitorImpl) || !this.isEvenPulseForRateIndex(servicePulseRateIndex)) continue;
            ((ServiceMonitorImpl)serviceMonitorPulseInfo.serviceMonitor).endPulse(serviceMonitorPulseInfo);
        }
    }

    boolean isEvenPulseForRateIndex(int pulseRateIndex) {
        if (pulseRateIndex < 0 || pulseRateIndex > this.pulsesPerRate.length) {
            return false;
        }
        return this.pulseNumber % this.pulsesPerRate[pulseRateIndex] == 0;
    }

    private void createReportThread() {
        this.reportThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block8: while (MonitorManager.this.isRunning) {
                    MonitorManager monitorManager = MonitorManager.this;
                    synchronized (monitorManager) {
                        while (MonitorManager.this.pulseRate == -1L) {
                            try {
                                MonitorManager.this.wait();
                            }
                            catch (InterruptedException e) {
                                continue block8;
                            }
                        }
                        while (MonitorManager.this.pulseRate != -1L) {
                            if (Thread.interrupted()) {
                                continue block8;
                            }
                            long now = System.currentTimeMillis();
                            try {
                                long waitTime = MonitorManager.this.nextPulseTime - now;
                                if (waitTime > 0L) {
                                    MonitorManager.this.wait(MonitorManager.this.nextPulseTime - now);
                                }
                                MonitorManager.this.pulseNumber += MonitorManager.this.pulsesPerRate[MonitorManager.this.pulseRateIndex];
                                MonitorManager.this.generateReports();
                                MonitorManager.this.nextPulseTime += MonitorManager.this.pulseRate;
                            }
                            catch (InterruptedException e) {
                                if (MonitorManager.this.pulseRateIndex != -1) continue;
                                continue block8;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }
        }, "Meter-Monitor-Report");
        this.reportThread.setDaemon(true);
        this.reportThread.start();
    }

    public synchronized void destroy() {
        this.isRunning = false;
        this.reportThread.interrupt();
        Enumeration e = this.serviceMonitorPulseInfos.elements();
        while (e.hasMoreElements()) {
            ServiceMonitorPulseInfo serviceMonitorPulseInfo = (ServiceMonitorPulseInfo)e.nextElement();
            ServiceMonitor serviceMonitor = serviceMonitorPulseInfo.serviceMonitor;
            serviceMonitor.destroy();
        }
    }

    private static MonitorListener createMonitorListener(String label) {
        return new MonitorListener(){

            public void processMonitorReport(MonitorEvent monitorEvent) {
                MonitorReport monitorReport = monitorEvent.getMonitorReport();
            }

            public void monitorReportingCancelled(MonitorEvent monitorEvent) {
            }

            public void monitorRequestFailed(MonitorEvent monitorEvent) {
            }
        };
    }

    public static MonitorManager registerMonitorManager(PeerGroup peerGroup) throws JxtaException {
        PeerGroupID peerGroupID = peerGroup.getPeerGroupID();
        MonitorManager monitorManager = (MonitorManager)monitorManagers.get(peerGroupID);
        if (monitorManager == null) {
            boolean includeTransports = true;
            ModuleImplAdvertisement moduleImplAdvertisement = MonitorResources.getReferenceAllPurposeMonitorServiceImplAdvertisement(includeTransports);
            monitorManager = (MonitorManager)peerGroup.loadModule(MonitorResources.refMonitorServiceSpecID, moduleImplAdvertisement);
            monitorManagers.put(peerGroupID, monitorManager);
            monitorManager.setPeerGroup(peerGroup);
        }
        return monitorManager;
    }

    public static void unregisterMonitorManager(PeerGroup peerGroup) {
        PeerGroupID peerGroupID = peerGroup.getPeerGroupID();
        monitorManagers.remove(peerGroupID);
    }

    public static ServiceMonitor getServiceMonitor(PeerGroup peerGroup, ModuleClassID serviceClassID) {
        try {
            PeerGroupID peerGroupID = peerGroup.getPeerGroupID();
            MonitorManager monitorManager = (MonitorManager)monitorManagers.get(peerGroupID);
            return monitorManager.getServiceMonitor(serviceClassID);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find MonitorManager or MonitorService");
        }
    }

    private class MonitorListenerInfo {
        MonitorListener monitorListener;
        MonitorFilter monitorFilter;
        long reportRate;
        int reportRateIndex;
        boolean sendCumulativeFirst = false;
        boolean wasCumulativeSent = false;

        MonitorListenerInfo(MonitorListener monitorListener, long reportRate, MonitorFilter monitorFilter, boolean cumulativeFirst) {
            this.monitorListener = monitorListener;
            this.monitorFilter = monitorFilter;
            this.reportRate = reportRate;
            this.sendCumulativeFirst = cumulativeFirst;
            this.reportRateIndex = MonitorManager.this.getReportRateIndex(reportRate);
        }
    }
}

