/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peer;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Random;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.JxtaException;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.peer.PeerInfoHandler;
import net.jxta.impl.peer.PeerInfoMessenger;
import net.jxta.impl.peer.PeerInfoServiceInterface;
import net.jxta.impl.peer.RemoteMonitorPeerInfoHandler;
import net.jxta.impl.protocol.PeerInfoQueryMsg;
import net.jxta.impl.protocol.PeerInfoResponseMsg;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.membership.MembershipService;
import net.jxta.meter.MonitorException;
import net.jxta.meter.MonitorFilter;
import net.jxta.meter.MonitorListener;
import net.jxta.meter.MonitorReport;
import net.jxta.meter.PeerMonitorInfo;
import net.jxta.meter.PeerMonitorInfoListener;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerInfoResponseMessage;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import net.jxta.util.DocumentUtilities;
import net.jxta.util.JxtaUtilities;
import net.jxta.util.documentSerializable.DocumentSerializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PeerInfoServiceImpl
implements PeerInfoService {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$peer$PeerInfoServiceImpl == null ? (class$net$jxta$impl$peer$PeerInfoServiceImpl = PeerInfoServiceImpl.class$("net.jxta.impl.peer.PeerInfoServiceImpl")) : class$net$jxta$impl$peer$PeerInfoServiceImpl).getName());
    private long startTime = 0L;
    private ResolverService resolver = null;
    private PeerGroup pg = null;
    private EndpointService endpoint = null;
    private PeerID localPeerId = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private String resolverHandlerName = null;
    private MembershipService membership = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private MonitorManager monitorManager;
    private Hashtable peerInfoHandlers = new Hashtable();
    private PipQueryHandler pipQueryHandler = new PipQueryHandler();
    private RemoteMonitorPeerInfoHandler remoteMonitorPeerInfoHandler;
    private PeerInfoMessenger resolverServicePeerInfoMessenger = new ResolverServicePeerInfoMessenger();
    private int nextQueryId = 1000;
    private static Random rand = new Random();
    static Hashtable peerInfoServices = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$peer$PeerInfoServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNextQueryId() {
        int id = 0;
        Random random = rand;
        synchronized (random) {
            id = rand.nextInt(Integer.MAX_VALUE);
        }
        return id;
    }

    public int startApp(String[] arg) {
        this.remoteMonitorPeerInfoHandler = new RemoteMonitorPeerInfoHandler(this.pg, this);
        this.peerInfoHandlers.put("Monitor", this.remoteMonitorPeerInfoHandler);
        this.resolver = this.pg.getResolverService();
        this.resolver.registerHandler(this.resolverHandlerName, this.pipQueryHandler);
        peerInfoServices.put(this.pg, this);
        return 0;
    }

    public void stopApp() {
        peerInfoServices.remove(this.pg);
        this.peerInfoHandlers.remove("Monitor");
        this.resolver.unregisterHandler(this.resolverHandlerName);
        this.pg = null;
    }

    PeerInfoHandler getPeerInfoHandler(String name) {
        return (PeerInfoHandler)this.peerInfoHandlers.get(name);
    }

    public Service getInterface() {
        return new PeerInfoServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.pg = group;
        this.endpoint = this.pg.getEndpointService();
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.localPeerId = this.pg.getPeerID();
        this.resolverHandlerName = assignedID.toString();
        this.startTime = System.currentTimeMillis();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring PeerInfo Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tImpl Description: " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + this.pg.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + this.pg.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + this.pg.getPeerID());
            LOG.info((Object)configInfo);
        }
    }

    public PeerGroup getGroup() {
        return this.pg;
    }

    private String docToString(StructuredTextDocument doc) {
        StringWriter out = new StringWriter();
        try {
            doc.sendToWriter(out);
            return out.toString();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"docToString failed", (Throwable)e);
            }
            return "";
        }
    }

    public boolean isLocalMonitoringAvailable() {
        return false;
    }

    public boolean isLocalMonitoringAvailable(ModuleClassID moduleClassID) {
        return false;
    }

    public long[] getSupportedReportRates() {
        PeerInfoServiceImpl peerInfoServiceImpl = this;
        return peerInfoServiceImpl.monitorManager.getReportRates();
    }

    public boolean isSupportedReportRate(long reportRate) {
        return this.monitorManager.isSupportedReportRate(reportRate);
    }

    public long getBestReportRate(long desiredReportRate) {
        return this.monitorManager.getBestReportRate(desiredReportRate);
    }

    public PeerMonitorInfo getPeerMonitorInfo() {
        if (this.monitorManager != null) {
            return this.monitorManager.getPeerMonitorInfo();
        }
        return PeerMonitorInfo.NO_PEER_MONITOR_INFO;
    }

    public void getPeerMonitorInfo(PeerID peerID, PeerMonitorInfoListener peerMonitorInfoListener, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.getPeerMonitorInfo(peerID, peerMonitorInfoListener, timeout, this.resolverServicePeerInfoMessenger);
    }

    public MonitorReport getCumulativeMonitorReport(MonitorFilter monitorFilter) throws MonitorException {
        return this.monitorManager.getCumulativeMonitorReport(monitorFilter);
    }

    public void getCumulativeMonitorReport(PeerID peerID, MonitorFilter monitorFilter, MonitorListener monitorListener, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.getCumulativeMonitorReport(peerID, monitorFilter, monitorListener, timeout, this.resolverServicePeerInfoMessenger);
    }

    public long addMonitorListener(MonitorFilter monitorFilter, long reportRate, boolean includeCumulative, MonitorListener monitorListener) throws MonitorException {
        throw new MonitorException(MonitorException.METERING_NOT_SUPPORTED, "Local Monitoring not Available");
    }

    public void addRemoteMonitorListener(PeerID peerID, MonitorFilter monitorFilter, long reportRate, boolean includeCumulative, MonitorListener monitorListener, long lease, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.addRemoteMonitorListener(peerID, monitorFilter, reportRate, includeCumulative, monitorListener, lease, timeout, this.resolverServicePeerInfoMessenger);
    }

    public boolean removeMonitorListener(MonitorListener monitorListener) throws MonitorException {
        int numRemoved = this.monitorManager.removeMonitorListener(monitorListener);
        return numRemoved > 0;
    }

    public void removeRemoteMonitorListener(PeerID peerID, MonitorListener monitorListener, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.removeRemoteMonitorListener(peerID, monitorListener, timeout, this.resolverServicePeerInfoMessenger);
    }

    public void removeRemoteMonitorListener(MonitorListener monitorListener, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.removeRemoteMonitorListener(monitorListener, timeout, this.resolverServicePeerInfoMessenger);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResolverServicePeerInfoMessenger
    implements PeerInfoMessenger {
        private ResolverServicePeerInfoMessenger() {
        }

        public void sendPeerInfoResponse(int queryId, PeerID destinationPeerID, String peerInfoHandler, DocumentSerializable response) {
            block2: {
                try {
                    PeerInfoResponseMsg peerInfoResponseMessage = new PeerInfoResponseMsg();
                    peerInfoResponseMessage.setSourcePid(destinationPeerID);
                    peerInfoResponseMessage.setTargetPid(PeerInfoServiceImpl.this.localPeerId);
                    long now = System.currentTimeMillis();
                    peerInfoResponseMessage.setUptime(now - PeerInfoServiceImpl.this.startTime);
                    peerInfoResponseMessage.setTimestamp(now);
                    StructuredTextDocument responseElement = DocumentUtilities.createStructuredXmlDocument(peerInfoHandler);
                    response.serializeTo(responseElement);
                    peerInfoResponseMessage.setResponse(responseElement);
                    StructuredTextDocument doc = (StructuredTextDocument)((PeerInfoResponseMessage)peerInfoResponseMessage).getDocument(MimeMediaType.XMLUTF8);
                    String peerInfoResponse = PeerInfoServiceImpl.this.docToString(doc);
                    ResolverResponse resolverResponse = new ResolverResponse(PeerInfoServiceImpl.this.resolverHandlerName, PeerInfoServiceImpl.this.credentialDoc, queryId, peerInfoResponse);
                    PeerInfoServiceImpl.this.resolver.sendResponse(destinationPeerID.toString(), resolverResponse);
                }
                catch (JxtaException e) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                    LOG.debug((Object)e);
                }
            }
        }

        public void sendPeerInfoRequest(int queryID, PeerID destinationPeerID, String peerInfoHandler, DocumentSerializable request) {
            block2: {
                try {
                    PeerInfoQueryMsg peerInfoQueryMsg = new PeerInfoQueryMsg();
                    peerInfoQueryMsg.setSourcePid(PeerInfoServiceImpl.this.localPeerId);
                    peerInfoQueryMsg.setTargetPid(destinationPeerID);
                    StructuredTextDocument requestElement = DocumentUtilities.createStructuredXmlDocument(peerInfoHandler);
                    request.serializeTo(requestElement);
                    peerInfoQueryMsg.setRequest(requestElement);
                    StructuredTextDocument doc = (StructuredTextDocument)peerInfoQueryMsg.getDocument(MimeMediaType.XMLUTF8);
                    String peerInfoRequest = PeerInfoServiceImpl.this.docToString(doc);
                    ResolverQuery resolverQuery = new ResolverQuery(PeerInfoServiceImpl.this.resolverHandlerName, PeerInfoServiceImpl.this.credentialDoc, PeerInfoServiceImpl.this.localPeerId.toString(), peerInfoRequest, queryID);
                    PeerInfoServiceImpl.this.resolver.sendQuery(destinationPeerID.toString(), resolverQuery);
                }
                catch (JxtaException e) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                    LOG.debug((Object)e);
                }
            }
        }
    }

    class PipQueryHandler
    implements QueryHandler {
        PipQueryHandler() {
        }

        public int processQuery(ResolverQueryMsg query) {
            int queryId = query.getQueryId();
            PeerID requestSourceID = null;
            try {
                requestSourceID = (PeerID)JxtaUtilities.getIdFromString(query.getSrc());
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"PeerInfoService.processQuery got a bad query, not valid src", (Throwable)e);
                }
                return 0;
            }
            StructuredTextDocument doc = null;
            try {
                doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(query.getQuery()));
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"PeerInfoService.processQuery got a bad adv", (Throwable)e);
                }
                return 0;
            }
            PeerInfoQueryMsg pipquery = new PeerInfoQueryMsg(doc);
            Element requestElement = pipquery.getRequest();
            String queryType = (String)requestElement.getKey();
            if (queryType != null) {
                PeerInfoHandler peerInfoHandler = PeerInfoServiceImpl.this.getPeerInfoHandler(queryType);
                if (peerInfoHandler != null) {
                    peerInfoHandler.processRequest(queryId, requestSourceID, pipquery, requestElement, PeerInfoServiceImpl.this.resolverServicePeerInfoMessenger);
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"No registered PeerInfoHandler for this type of request");
                }
            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"No request PeerInfoQueryMessage Request Element found");
            }
            return 0;
        }

        public void processResponse(ResolverResponseMsg response) {
            int queryId = response.getQueryId();
            PeerInfoResponseMsg resp = null;
            try {
                StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(response.getResponse()));
                resp = new PeerInfoResponseMsg(doc);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"PeerInfoService.processResponse got a bad adv", (Throwable)e);
                }
                return;
            }
            Element responseElement = resp.getResponse();
            String responseType = (String)responseElement.getKey();
            if (responseType != null) {
                PeerInfoHandler peerInfoHandler = PeerInfoServiceImpl.this.getPeerInfoHandler(responseType);
                if (peerInfoHandler != null) {
                    peerInfoHandler.processResponse(queryId, resp, responseElement, PeerInfoServiceImpl.this.resolverServicePeerInfoMessenger);
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"No registered PeerInfoHandler for this type of response");
                }
            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"No request PeerInfoResponseMessage Response Element found");
            }
        }
    }
}

